/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.adapter;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionRolledBackException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.transaction.xa.XAResource;
import weblogic.common.internal.PeerInfo;
import weblogic.connector.exception.NoEnlistXAResourceException;
import weblogic.jms.adapter.AdapterConnectionMetaDataImpl;
import weblogic.jms.adapter.AdapterLocalTransactionImpl;
import weblogic.jms.adapter.IsolatingClassLoader;
import weblogic.jms.adapter.JMSManagedConnection;
import weblogic.jms.adapter.JMSManagedConnectionFactory;
import weblogic.jms.bridge.AdapterConnectionMetaData;
import weblogic.jms.bridge.GenericMessage;
import weblogic.jms.bridge.LocalTransaction;
import weblogic.jms.bridge.NotificationListener;
import weblogic.jms.bridge.ResourceTransactionRolledBackException;
import weblogic.jms.bridge.SourceConnection;
import weblogic.jms.bridge.TargetConnection;
import weblogic.jms.bridge.TemporaryResourceException;
import weblogic.jms.bridge.internal.BridgeDebug;
import weblogic.jms.client.ConnectionInternal;
import weblogic.jms.client.XASessionInternal;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.extensions.JMSForwardHelper;
import weblogic.jms.extensions.MDBTransaction;
import weblogic.jms.extensions.WLMessageProducer;
import weblogic.security.SubjectUtils;
import weblogic.security.WLSPrincipals;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.transaction.internal.IgnoreXAResource;
import weblogic.work.WorkAdapter;
import weblogic.work.WorkManagerFactory;

public class JMSBaseConnection
implements SourceConnection,
TargetConnection,
MessageListener,
ExceptionListener {
    private JMSManagedConnectionFactory mcf;
    private JMSManagedConnection mc;
    protected ConnectionFactory cf;
    protected XAConnectionFactory xcf;
    protected Connection connection;
    protected XASession xaSession;
    protected Session session;
    protected Destination destination;
    private MessageProducer messageProducer;
    private MessageConsumer messageConsumer;
    private MessageListener mlistener;
    private ExceptionListener elistener;
    private String name;
    private String userName;
    private String password;
    private String destJNDI;
    private int destType;
    private String cfJNDI;
    private String url;
    private String icFactory;
    private String selector;
    private AdapterConnectionMetaData metaData;
    private boolean transacted;
    private boolean durable;
    private boolean isXA;
    private int ackMode = 1;
    private boolean ignoreXA = false;
    static final int QUEUE = 0;
    static final int TOPIC = 1;
    private boolean closed = true;
    private ClassLoader classLoader;
    private static AuthenticatedSubject kernelId;
    private AuthenticatedSubject subject;
    private boolean forwardMethodAvailable = false;
    private boolean preserveMsgProperty = false;
    private int logCount = 0;
    private static final boolean DEBUG = false;
    private static final String[] ISOLATING_PACKAGES;
    Object onExceptionLock = new Object();

    JMSBaseConnection(String string, String string2, JMSManagedConnectionFactory jMSManagedConnectionFactory, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, String string10, boolean bl2) throws Exception {
        this.userName = string;
        this.password = string2;
        this.mcf = jMSManagedConnectionFactory;
        this.name = string3;
        this.url = string4;
        this.icFactory = string5;
        this.destJNDI = string7;
        if (string8 != null) {
            if (string8.equalsIgnoreCase("Queue")) {
                this.destType = 0;
            } else if (string8.equalsIgnoreCase("Topic")) {
                this.destType = 1;
            }
        } else {
            this.destType = 0;
        }
        this.cfJNDI = string6;
        this.selector = string9;
        this.durable = bl;
        this.preserveMsgProperty = bl2;
        if (string10 != null && string10.length() > 0) {
            this.classLoader = new IsolatingClassLoader("JMS Interop Adapter Class Loader", JMSBaseConnection.getClassPath(string10), ISOLATING_PACKAGES, true);
        }
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private static URL[] getClassPath(String string) throws MalformedURLException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() <= 0) continue;
            arrayList.add(new File(string2).toURL());
        }
        return arrayList.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                this.startInternal();
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            this.startInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void startInternal() throws ResourceException {
        AuthenticatedSubject authenticatedSubject;
        block66: {
            if (this.connection != null && !this.closed) {
                return;
            }
            Object object = null;
            Object object2 = null;
            Context context = null;
            try {
                Context context2;
                String string;
                authenticatedSubject = SubjectUtils.getAnonymousSubject();
                authenticatedSubject.setQOS((byte)101);
                try {
                    context = (Context)authenticatedSubject.doAs((AbstractSubject)kernelId, new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return JMSBaseConnection.this.getInitialContext();
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getCause() instanceof NamingException) {
                        throw (NamingException)privilegedActionException.getCause();
                    }
                    throw new AssertionError((Object)privilegedActionException);
                }
                try {
                    string = this.cfJNDI;
                    context2 = context;
                    object = this.subject.doAs((AbstractSubject)kernelId, new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return context2.lookup(string);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getCause() instanceof NamingException) {
                        throw (NamingException)privilegedActionException.getCause();
                    }
                    throw new AssertionError((Object)privilegedActionException);
                }
                try {
                    string = this.destJNDI;
                    context2 = context;
                    object2 = this.subject.doAs((AbstractSubject)kernelId, new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return context2.lookup(string);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getCause() instanceof NamingException) {
                        throw (NamingException)privilegedActionException.getCause();
                    }
                    throw new AssertionError((Object)privilegedActionException);
                }
                if (object instanceof XAConnectionFactory) {
                    this.xcf = (XAConnectionFactory)object;
                    this.isXA = true;
                } else if (object instanceof ConnectionFactory) {
                    this.cf = (ConnectionFactory)object;
                } else {
                    throw new ResourceException("Adapter internal error -- connectionFactory object is not instanceof ConnectionFactory");
                }
                if (this.ignoreXA) {
                    this.isXA = false;
                }
                if (object2 instanceof Queue && !(object2 instanceof Topic)) {
                    this.destType = 0;
                } else if (!(object2 instanceof Queue) && object2 instanceof Topic) {
                    this.destType = 1;
                }
                if (this.destType == 0) {
                    this.destination = (Queue)object2;
                    if (this.isXA) {
                        if (this.userName != null) {
                            if (this.xcf instanceof XAQueueConnectionFactory) {
                                this.connection = ((XAQueueConnectionFactory)this.xcf).createXAQueueConnection(this.userName, this.password);
                            } else if (this.xcf instanceof XAConnectionFactory) {
                                this.connection = this.xcf.createXAConnection(this.userName, this.password);
                            }
                        } else if (this.xcf instanceof XAQueueConnectionFactory) {
                            this.connection = ((XAQueueConnectionFactory)this.xcf).createXAQueueConnection();
                        } else if (this.xcf instanceof XAConnectionFactory) {
                            this.connection = this.xcf.createXAConnection();
                        }
                        if (this.connection instanceof XAQueueConnection) {
                            this.xaSession = ((XAQueueConnection)this.connection).createXAQueueSession();
                            this.session = ((XAQueueSession)this.xaSession).getQueueSession();
                        } else {
                            this.xaSession = ((XAConnection)this.connection).createXASession();
                            this.session = this.xaSession.getSession();
                        }
                    } else {
                        this.connection = this.userName != null ? (this.cf instanceof QueueConnectionFactory ? ((QueueConnectionFactory)this.cf).createQueueConnection(this.userName, this.password) : this.cf.createConnection(this.userName, this.password)) : (this.cf instanceof QueueConnectionFactory ? ((QueueConnectionFactory)this.cf).createQueueConnection() : this.cf.createConnection());
                        this.session = this.connection instanceof QueueConnection ? ((QueueConnection)this.connection).createQueueSession(this.transacted, this.ackMode) : this.connection.createSession(this.transacted, this.ackMode);
                    }
                    break block66;
                }
                if (this.destType == 1) {
                    this.destination = (Topic)object2;
                    string = null;
                    if (this.durable) {
                        string = "MessagingBridge." + this.name;
                    }
                    if (this.isXA) {
                        this.connection = this.userName != null ? (this.xcf instanceof XATopicConnectionFactory ? ((XATopicConnectionFactory)this.xcf).createXATopicConnection(this.userName, this.password) : this.xcf.createXAConnection(this.userName, this.password)) : (this.xcf instanceof XATopicConnectionFactory ? ((XATopicConnectionFactory)this.xcf).createXATopicConnection() : this.xcf.createXAConnection());
                        if (this.durable && (this.connection.getClientID() == null || this.connection.getClientID().length() == 0)) {
                            this.connection.setClientID(string);
                        }
                        if (this.connection instanceof XATopicConnection) {
                            this.xaSession = ((XATopicConnection)this.connection).createXATopicSession();
                            this.session = ((XATopicSession)this.xaSession).getTopicSession();
                        } else {
                            this.xaSession = ((XAConnection)this.connection).createXASession();
                            this.session = this.xaSession.getSession();
                        }
                    } else {
                        this.connection = this.userName != null ? (this.cf instanceof TopicConnectionFactory ? ((TopicConnectionFactory)this.cf).createTopicConnection(this.userName, this.password) : this.cf.createConnection(this.userName, this.password)) : (this.cf instanceof TopicConnectionFactory ? ((TopicConnectionFactory)this.cf).createTopicConnection() : this.cf.createConnection());
                        if (this.durable && (this.connection.getClientID() == null || this.connection.getClientID().length() == 0)) {
                            this.connection.setClientID(string);
                        }
                        this.session = this.connection instanceof TopicConnection ? ((TopicConnection)this.connection).createTopicSession(this.transacted, this.ackMode) : this.connection.createSession(this.transacted, this.ackMode);
                    }
                    break block66;
                }
                throw new ResourceException("Adapter internal error -- Found non-JMS objcts");
            }
            catch (NamingException namingException) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", (Throwable)namingException);
                }
                if (context == null) {
                    this.throwResourceException("ConnectionFactory: failed to get initial context (InitialContextFactory =" + this.icFactory + ", url = " + this.url + ", user name = " + this.userName + ")", namingException);
                }
                if (object == null) {
                    if (this.logCount++ >= 2) {
                        this.throwResourceException("ConnectionFactory: " + this.cfJNDI + " not found", namingException);
                    } else {
                        this.throwTempResourceException();
                    }
                }
                if (object2 == null) {
                    if (this.logCount++ >= 2) {
                        this.throwResourceException("Destination: " + this.destJNDI + " not found", namingException);
                    } else {
                        this.throwTempResourceException();
                    }
                }
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                    Exception exception = null;
                    if (throwable instanceof JMSException && (exception = ((JMSException)throwable).getLinkedException()) != null) {
                        BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", (Throwable)exception);
                    }
                }
                this.throwResourceException("Failed to start the connection", throwable);
            }
            finally {
                try {
                    if (context != null) {
                        context.close();
                    }
                    context = null;
                    object = null;
                    object2 = null;
                }
                catch (NamingException namingException) {}
            }
        }
        this.closed = false;
        if (this.connection instanceof ConnectionInternal && (authenticatedSubject = ((ConnectionInternal)this.connection).getFEPeerInfo()).compareTo((Object)PeerInfo.VERSION_DIABLO) >= 0) {
            this.forwardMethodAvailable = true;
        }
        JMSManagedConnectionFactory.printInfo(this.mcf.getLogWriter(), this.name, "Connection started to " + this.destJNDI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ResourceException {
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                return;
            }
        }
        if (this.classLoader != null) {
            object = Thread.currentThread();
            ClassLoader classLoader = ((Thread)object).getContextClassLoader();
            try {
                ((Thread)object).setContextClassLoader(this.classLoader);
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        JMSBaseConnection.this.closeInternal();
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error closing connection", privilegedActionException.getException());
            }
            finally {
                ((Thread)object).setContextClassLoader(classLoader);
            }
        } else {
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        JMSBaseConnection.this.closeInternal();
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error closing connection", privilegedActionException.getException());
            }
        }
    }

    private synchronized void closeInternal() throws ResourceException {
        JMSException jMSException;
        block10: {
            jMSException = null;
            this.closed = true;
            try {
                this.connection.stop();
            }
            catch (JMSException jMSException2) {
                if (jMSException == null) {
                    jMSException = jMSException2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.closeSession();
            }
            catch (JMSException jMSException3) {
                if (jMSException != null) break block10;
                jMSException = jMSException3;
            }
        }
        if (this.connection != null) {
            block11: {
                try {
                    this.connection.close();
                }
                catch (JMSException jMSException4) {
                    if (jMSException != null) break block11;
                    jMSException = jMSException4;
                }
            }
            this.connection = null;
        }
        JMSManagedConnectionFactory.printInfo(this.mcf.getLogWriter(), this.name, "Connection closed to " + this.destJNDI);
        if (jMSException != null) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() throws JMSException, ResourceException {
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                return;
            }
        }
        if (this.classLoader != null) {
            object = Thread.currentThread();
            ClassLoader classLoader = ((Thread)object).getContextClassLoader();
            try {
                ((Thread)object).setContextClassLoader(this.classLoader);
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws JMSException {
                        JMSBaseConnection.this.cleanupInternal();
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error cleanup connection", privilegedActionException.getException());
            }
            finally {
                ((Thread)object).setContextClassLoader(classLoader);
            }
        } else {
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws JMSException {
                        JMSBaseConnection.this.cleanupInternal();
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error cleanup connection", privilegedActionException.getException());
            }
        }
    }

    private synchronized void cleanupInternal() throws JMSException {
        JMSException jMSException = null;
        if (this.messageProducer != null) {
            block7: {
                try {
                    this.messageProducer.close();
                }
                catch (JMSException jMSException2) {
                    if (jMSException != null) break block7;
                    jMSException = jMSException2;
                }
            }
            this.messageProducer = null;
        }
        if (this.messageConsumer != null) {
            block8: {
                try {
                    this.messageConsumer.close();
                }
                catch (JMSException jMSException3) {
                    if (jMSException != null) break block8;
                    jMSException = jMSException3;
                }
            }
            this.messageConsumer = null;
            this.mlistener = null;
        }
        if (jMSException != null) {
            throw jMSException;
        }
    }

    private synchronized void closeSession() throws JMSException {
        JMSException jMSException = null;
        if (this.messageProducer != null) {
            block14: {
                try {
                    this.messageProducer.close();
                }
                catch (JMSException jMSException2) {
                    if (jMSException != null) break block14;
                    jMSException = jMSException2;
                }
            }
            this.messageProducer = null;
        }
        if (this.messageConsumer != null) {
            block15: {
                try {
                    this.messageConsumer.close();
                }
                catch (JMSException jMSException3) {
                    if (jMSException != null) break block15;
                    jMSException = jMSException3;
                }
            }
            this.messageConsumer = null;
            this.mlistener = null;
        }
        if (this.xaSession != null) {
            block16: {
                try {
                    this.xaSession.close();
                }
                catch (JMSException jMSException4) {
                    if (jMSException != null) break block16;
                    jMSException = jMSException4;
                }
            }
            this.xaSession = null;
            this.session = null;
        } else if (this.session != null) {
            block17: {
                try {
                    this.session.close();
                }
                catch (JMSException jMSException5) {
                    if (jMSException != null) break block17;
                    jMSException = jMSException5;
                }
            }
            this.session = null;
        }
        if (jMSException != null) {
            throw jMSException;
        }
    }

    public void pause() throws ResourceException {
        throw new NotSupportedException("pause() -- Not supported!");
    }

    public void resume() throws ResourceException {
        throw new NotSupportedException("resume() -- Not supported!");
    }

    public synchronized LocalTransaction getLocalTransaction() throws ResourceException {
        return new AdapterLocalTransactionImpl(this.mc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                final Message message2 = message;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        JMSBaseConnection.this.sendInternal(message2);
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error sending message", privilegedActionException.getException(), false);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            final Message message3 = message;
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        JMSBaseConnection.this.sendInternal(message3);
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error sending message", privilegedActionException.getException(), false);
            }
        }
    }

    private synchronized void sendInternal(Message message) throws ResourceException {
        try {
            if (this.messageProducer == null) {
                this.ensureStarted();
                if (this.session != null && this.destination != null) {
                    this.messageProducer = this.destType == 0 && this.session instanceof QueueSession ? ((QueueSession)this.session).createSender((Queue)this.destination) : (this.destType == 1 && this.session instanceof TopicSession ? ((TopicSession)this.session).createPublisher((Topic)this.destination) : this.session.createProducer(this.destination));
                    this.connection.start();
                } else {
                    JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Internal error -- invalid state!");
                    throw new ResourceAdapterInternalException("Bridge Adapter internal error -- invalid state!");
                }
            }
            if (this.preserveMsgProperty) {
                if (this.forwardMethodAvailable && message instanceof MessageImpl) {
                    ((MessageImpl)message).setJMSXUserID(null);
                    ((MessageImpl)message).requestJMSXUserID(false);
                    JMSForwardHelper.ForwardFromMessage((WLMessageProducer)this.messageProducer, message, false);
                } else {
                    long l = JMSForwardHelper.getRelativeTimeToLive(message);
                    if (l < 0L) {
                        l = 1L;
                    }
                    if (this.destType == 0) {
                        ((QueueSender)this.messageProducer).send(message, message.getJMSDeliveryMode(), message.getJMSPriority(), l);
                    } else if (this.destType == 1) {
                        ((TopicPublisher)this.messageProducer).publish(message, message.getJMSDeliveryMode(), message.getJMSPriority(), l);
                    }
                }
            } else {
                if (message instanceof MessageImpl) {
                    ((MessageImpl)message).setDeliveryCount(0);
                }
                if (this.destType == 0) {
                    if (this.messageProducer instanceof QueueSender) {
                        ((QueueSender)this.messageProducer).send(message);
                    } else {
                        this.messageProducer.send(message);
                    }
                } else if (this.destType == 1) {
                    if (this.messageProducer instanceof TopicPublisher) {
                        ((TopicPublisher)this.messageProducer).publish(message);
                    } else {
                        this.messageProducer.send(message);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                Exception exception = null;
                if (throwable instanceof JMSException && (exception = ((JMSException)throwable).getLinkedException()) != null) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", (Throwable)exception);
                }
            }
            JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Failed to send a message");
            this.throwResourceException("Error creating producer or sending message", throwable, false);
        }
    }

    public synchronized void send(GenericMessage genericMessage) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    private Message receiveFromQueue(QueueReceiver queueReceiver, long l) throws JMSException {
        if (l < 0L) {
            return queueReceiver.receive();
        }
        if (l == 0L) {
            return queueReceiver.receiveNoWait();
        }
        return queueReceiver.receive(l);
    }

    private Message receiveFromTopic(TopicSubscriber topicSubscriber, long l) throws JMSException {
        if (l < 0L) {
            return topicSubscriber.receive();
        }
        if (l == 0L) {
            return topicSubscriber.receiveNoWait();
        }
        return topicSubscriber.receive(l);
    }

    private Message receiveFromDestination(MessageConsumer messageConsumer, long l) throws JMSException {
        if (l < 0L) {
            return messageConsumer.receive();
        }
        if (l == 0L) {
            return messageConsumer.receiveNoWait();
        }
        return messageConsumer.receive(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveCommon(long l) throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                final long l2 = l;
                Message message = (Message)SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        return JMSBaseConnection.this.receiveInternal(l2);
                    }
                });
                return message;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error receiving message", privilegedActionException.getException());
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            final long l3 = l;
            try {
                return (Message)SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        return JMSBaseConnection.this.receiveInternal(l3);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error receiving message", privilegedActionException.getException());
            }
        }
        return null;
    }

    private synchronized Message receiveInternal(long l) throws ResourceException {
        Exception exception;
        if (this.messageConsumer != null) {
            try {
                if (this.destType == 0) {
                    if (this.messageConsumer instanceof QueueReceiver) {
                        return this.receiveFromQueue((QueueReceiver)this.messageConsumer, l);
                    }
                    return this.receiveFromDestination(this.messageConsumer, l);
                }
                if (this.destType == 1) {
                    if (this.messageConsumer instanceof TopicSubscriber) {
                        return this.receiveFromTopic((TopicSubscriber)this.messageConsumer, l);
                    }
                    return this.receiveFromDestination(this.messageConsumer, l);
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Internal error -- invalid state!");
                throw new ResourceException("Adapter internal error:  detect non-JMS objects in creating consumer or receiving message");
            }
            catch (Throwable throwable) {
                this.messageConsumer = null;
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                    exception = null;
                    if (throwable instanceof JMSException && (exception = ((JMSException)throwable).getLinkedException()) != null) {
                        BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", (Throwable)exception);
                    }
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Failed to receive a message!");
                this.throwResourceException("Error receiving message", throwable);
            }
        }
        this.ensureStarted();
        if (this.session != null && this.destination != null) {
            try {
                if (this.destType == 0) {
                    this.messageConsumer = this.selector != null && this.selector.trim().length() > 0 ? (this.session instanceof QueueSession ? ((QueueSession)this.session).createReceiver((Queue)this.destination, this.selector) : this.session.createConsumer(this.destination, this.selector)) : (this.session instanceof QueueSession ? ((QueueSession)this.session).createReceiver((Queue)this.destination) : this.session.createConsumer(this.destination));
                    this.connection.start();
                    if (this.messageConsumer instanceof QueueReceiver) {
                        return this.receiveFromQueue((QueueReceiver)this.messageConsumer, l);
                    }
                    return this.receiveFromDestination(this.messageConsumer, l);
                }
                if (this.destType == 1) {
                    this.messageConsumer = this.selector != null && this.selector.trim().length() > 0 ? (this.durable ? (this.session instanceof TopicSession ? ((TopicSession)this.session).createDurableSubscriber((Topic)this.destination, this.name, this.selector, true) : this.session.createDurableSubscriber((Topic)this.destination, this.name, this.selector, true)) : (this.session instanceof TopicSession ? ((TopicSession)this.session).createSubscriber((Topic)this.destination, this.selector, true) : this.session.createConsumer(this.destination, this.selector, true))) : (this.durable ? (this.session instanceof TopicSession ? ((TopicSession)this.session).createDurableSubscriber((Topic)this.destination, this.name) : this.session.createDurableSubscriber((Topic)this.destination, this.name)) : (this.session instanceof TopicSession ? ((TopicSession)this.session).createSubscriber((Topic)this.destination) : this.session.createConsumer(this.destination)));
                    this.connection.start();
                    if (this.messageConsumer instanceof TopicSubscriber) {
                        return this.receiveFromTopic((TopicSubscriber)this.messageConsumer, l);
                    }
                    return this.receiveFromDestination(this.messageConsumer, l);
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Internal error -- invalid state!");
                throw new ResourceException("Error creating consumer or receiving message -- internal error");
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                    exception = null;
                    if (throwable instanceof JMSException && (exception = ((JMSException)throwable).getLinkedException()) != null) {
                        BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", (Throwable)exception);
                    }
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Failed to receive a messag");
                this.throwResourceException("Error creating consumer or receiving message", throwable);
            }
        }
        JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Internal error -- invalid state!");
        throw new ResourceException("Error receiving message -- internal error");
    }

    public GenericMessage receiveGenericMessage() throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    public Message receive() throws ResourceException {
        return this.receiveCommon(-1L);
    }

    public Message receive(long l) throws ResourceException {
        return this.receiveCommon(l);
    }

    public GenericMessage receiveGenericMessage(long l) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    public synchronized Message createMessage(Message message) throws ResourceException {
        return message;
    }

    public Message createMessage(GenericMessage genericMessage) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    public GenericMessage createGenericMessage(Message message) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    public GenericMessage createGenericMessage(GenericMessage genericMessage) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener messageListener) throws ResourceException {
        this.mlistener = messageListener;
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                if (this.messageConsumer == null) {
                    SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws ResourceException {
                            JMSBaseConnection.this.createConsumer();
                            return null;
                        }
                    });
                }
                final MessageListener messageListener2 = messageListener;
                final JMSBaseConnection jMSBaseConnection = this;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        if (messageListener2 == null) {
                            JMSBaseConnection.this.setMessageListenerInternal(null);
                        } else {
                            JMSBaseConnection.this.setMessageListenerInternal(jMSBaseConnection);
                        }
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error setting message listener", privilegedActionException.getException());
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            final MessageListener messageListener3 = messageListener;
            final JMSBaseConnection jMSBaseConnection = this;
            try {
                if (this.messageConsumer == null) {
                    SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws ResourceException {
                            JMSBaseConnection.this.createConsumer();
                            return null;
                        }
                    });
                }
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        if (messageListener3 == null) {
                            JMSBaseConnection.this.setMessageListenerInternal(null);
                        } else {
                            JMSBaseConnection.this.setMessageListenerInternal(jMSBaseConnection);
                        }
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error setting message listener", privilegedActionException.getException());
            }
        }
    }

    private synchronized void setMessageListenerInternal(MessageListener messageListener) throws ResourceException {
        if (this.messageConsumer != null) {
            try {
                this.messageConsumer.setMessageListener(messageListener);
                JMSManagedConnectionFactory.printInfo(this.mcf.getLogWriter(), this.name, "MessageListener is set on " + this.destJNDI);
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Failed to set a message listener on " + this.destJNDI);
                this.throwResourceException("Error setting message listener", throwable);
            }
        }
    }

    private synchronized void createConsumer() throws ResourceException {
        this.ensureStarted();
        if (this.session != null && this.destination != null) {
            try {
                if (this.destType == 0) {
                    this.messageConsumer = this.selector != null && this.selector.trim().length() > 0 ? (this.session instanceof QueueSession ? ((QueueSession)this.session).createReceiver((Queue)this.destination, this.selector) : this.session.createConsumer(this.destination, this.selector)) : (this.session instanceof QueueSession ? ((QueueSession)this.session).createReceiver((Queue)this.destination) : this.session.createConsumer(this.destination));
                } else if (this.destType == 1) {
                    this.messageConsumer = this.selector != null && this.selector.trim().length() > 0 ? (this.durable ? (this.session instanceof TopicSession ? ((TopicSession)this.session).createDurableSubscriber((Topic)this.destination, this.name, this.selector, true) : this.session.createDurableSubscriber((Topic)this.destination, this.name, this.selector, true)) : (this.session instanceof TopicSession ? ((TopicSession)this.session).createSubscriber((Topic)this.destination, this.selector, true) : this.session.createConsumer(this.destination, this.selector, true))) : (this.durable ? (this.session instanceof TopicSession ? ((TopicSession)this.session).createDurableSubscriber((Topic)this.destination, this.name) : this.session.createDurableSubscriber((Topic)this.destination, this.name)) : (this.session instanceof TopicSession ? ((TopicSession)this.session).createSubscriber((Topic)this.destination) : this.session.createConsumer(this.destination)));
                }
                this.connection.start();
                JMSManagedConnectionFactory.printInfo(this.mcf.getLogWriter(), this.name, "Consumer created on " + this.destJNDI);
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Failed to create consumer " + this.destJNDI);
                this.throwResourceException("Error creating asynchronous consumer ", throwable);
            }
        }
        JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Internal error -- invalid state!");
        throw new ResourceAdapterInternalException("Bridge Adapter internal error -- invalid state!");
    }

    public void addNotificationListener(NotificationListener notificationListener, int n) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    public void removeNotificationListener(NotificationListener notificationListener, int n) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateTransaction(Message message) throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                final Message message2 = message;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        JMSBaseConnection.this.associateTransactionInternal(message2);
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error associating message with current transaction", privilegedActionException.getException(), false);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            try {
                final Message message3 = message;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        JMSBaseConnection.this.associateTransactionInternal(message3);
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error associating message with current transaction", privilegedActionException.getException(), false);
            }
        }
    }

    private synchronized void associateTransactionInternal(Message message) throws ResourceException {
        if (this.session instanceof MDBTransaction) {
            try {
                ((MDBTransaction)this.session).associateTransaction(message);
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Failed to associate a message with the current transaction", throwable, false);
            }
        } else {
            throw new NotSupportedException("Not implemented");
        }
    }

    public void associateTransaction(GenericMessage genericMessage) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    private void throwTempResourceException() throws ResourceException {
        this.mc.sendEvent(5, null);
        throw new TemporaryResourceException();
    }

    private void throwResourceException(String string, Throwable throwable) throws ResourceException {
        this.throwResourceException(string, throwable, true);
    }

    private void throwResourceException(String string, Throwable throwable, boolean bl) throws ResourceException {
        if (bl) {
            this.mc.sendEvent(5, null);
        }
        ResourceException resourceException = null;
        resourceException = throwable != null && throwable instanceof TransactionRolledBackException ? new ResourceTransactionRolledBackException("Transaction rolled back") : new ResourceException(string);
        if (throwable != null && throwable instanceof Exception) {
            resourceException.setLinkedException((Exception)throwable);
        }
        throw resourceException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResource getXAResource() throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                XAResource xAResource = (XAResource)SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        return JMSBaseConnection.this.getXAResourceInternal();
                    }
                });
                return xAResource;
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof NoEnlistXAResourceException) {
                    throw (NoEnlistXAResourceException)((Object)privilegedActionException.getException());
                }
                this.throwResourceException("Error getting XA resource", privilegedActionException.getException());
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            try {
                return (XAResource)SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        return JMSBaseConnection.this.getXAResourceInternal();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getException() instanceof NoEnlistXAResourceException) {
                    throw (NoEnlistXAResourceException)((Object)privilegedActionException.getException());
                }
                this.throwResourceException("Error getting XA resource", privilegedActionException.getException());
            }
        }
        return null;
    }

    private synchronized XAResource getXAResourceInternal() throws ResourceException {
        if (this.xaSession != null && !(this.xaSession instanceof XASessionInternal)) {
            XAResource xAResource = this.xaSession.getXAResource();
            if (xAResource instanceof IgnoreXAResource) {
                throw new NoEnlistXAResourceException("No need to enlist this resource");
            }
            return xAResource;
        }
        throw new NoEnlistXAResourceException("No need to enlist this resource");
    }

    public synchronized boolean implementsMDBTransaction() throws ResourceException {
        return this.session != null && this.session instanceof MDBTransaction;
    }

    public synchronized boolean isXAConnection() throws ResourceException {
        return this.xcf != null && this.xcf instanceof XAConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionListener(ExceptionListener exceptionListener) throws ResourceException {
        this.elistener = exceptionListener;
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                final ExceptionListener exceptionListener2 = exceptionListener;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        JMSBaseConnection.this.setExceptionListenerInternal(exceptionListener2);
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error setting exception listener", privilegedActionException.getException());
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            final ExceptionListener exceptionListener3 = exceptionListener;
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        JMSBaseConnection.this.setExceptionListenerInternal(exceptionListener3);
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error setting exception listener", privilegedActionException.getException());
            }
        }
    }

    private synchronized void setExceptionListenerInternal(ExceptionListener exceptionListener) throws ResourceException {
        if (this.connection != null) {
            try {
                this.connection.setExceptionListener(exceptionListener);
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error setting exception listener", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcknowledgeMode(int n) throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                final int n2 = n;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        JMSBaseConnection.this.setAcknowledgeModeInternal(n2);
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error setting acknowledge mode", privilegedActionException.getException());
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            final int n3 = n;
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        JMSBaseConnection.this.setAcknowledgeModeInternal(n3);
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error setting acknowledge mode", privilegedActionException.getException());
            }
        }
    }

    private synchronized void setAcknowledgeModeInternal(int n) throws ResourceException {
        if (n == this.ackMode) {
            return;
        }
        this.ignoreXA = false;
        switch (n) {
            case 2: {
                this.ackMode = 2;
                break;
            }
            case 1: {
                this.ackMode = 1;
                break;
            }
            case 3: {
                this.ackMode = 3;
                break;
            }
            default: {
                this.ackMode = 1;
                this.ignoreXA = true;
            }
        }
        if (this.connection == null) {
            return;
        }
        try {
            this.closeSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session = this.destType == 0 && this.connection instanceof QueueConnection ? ((QueueConnection)this.connection).createQueueSession(this.transacted, this.ackMode) : (this.destType == 1 && this.connection instanceof TopicConnection ? ((TopicConnection)this.connection).createTopicSession(this.transacted, this.ackMode) : this.connection.createSession(this.transacted, this.ackMode));
        }
        catch (Throwable throwable) {
            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
            }
            this.throwResourceException("Error starting a transaction", throwable);
        }
    }

    public AdapterConnectionMetaData getMetaData() throws ResourceException {
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws ResourceException {
        try {
            if (this.session.getTransacted()) {
                return;
            }
        }
        catch (JMSException jMSException) {
            this.throwResourceException("Error recovering messages", jMSException, false);
        }
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                final Session session = this.session;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        try {
                            session.recover();
                        }
                        catch (Throwable throwable) {
                            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                            }
                            JMSBaseConnection.this.throwResourceException("Error recovering messages", throwable, false);
                        }
                        return null;
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error recovering messages", throwable, false);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            try {
                final Session session = this.session;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        try {
                            session.recover();
                        }
                        catch (Throwable throwable) {
                            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                            }
                            JMSBaseConnection.this.throwResourceException("Error recovering messages", throwable, false);
                        }
                        return null;
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error recovering messages", throwable, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTransactedSession() throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        JMSBaseConnection.this.createTransactedSessionInternal();
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error creating transacted session", privilegedActionException.getException());
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        JMSBaseConnection.this.createTransactedSessionInternal();
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.throwResourceException("Error creating transacted session", privilegedActionException.getException());
            }
        }
    }

    private synchronized void createTransactedSessionInternal() throws ResourceException {
        if (this.transacted) {
            return;
        }
        if (this.connection == null) {
            this.transacted = true;
            return;
        }
        MessageListener messageListener = null;
        if (this.messageConsumer != null) {
            try {
                messageListener = this.messageConsumer.getMessageListener();
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error restore message listener", throwable);
            }
        }
        try {
            this.closeSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session = this.destType == 0 && this.connection instanceof QueueConnection ? ((QueueConnection)this.connection).createQueueSession(true, this.ackMode) : (this.destType == 1 && this.connection instanceof TopicConnection ? ((TopicConnection)this.connection).createTopicSession(true, this.ackMode) : this.connection.createSession(true, this.ackMode));
            if (this.mlistener != null) {
                this.setMessageListener(this.mlistener);
            }
        }
        catch (Throwable throwable) {
            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
            }
            this.throwResourceException("Error beginning a transaction", throwable);
        }
        this.transacted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() throws ResourceException {
        if (!this.transacted) {
            this.throwResourceException("Error committing a transaction -- not transacted", null);
        }
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                final Session session = this.session;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        try {
                            session.commit();
                        }
                        catch (Throwable throwable) {
                            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                            }
                            JMSBaseConnection.this.throwResourceException("Error committing a transaction", throwable);
                        }
                        return null;
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error committing a transaction", throwable);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            try {
                final Session session = this.session;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        try {
                            session.commit();
                        }
                        catch (Throwable throwable) {
                            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                            }
                            JMSBaseConnection.this.throwResourceException("Error committing a transaction", throwable);
                        }
                        return null;
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error committing a transaction", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback() throws ResourceException {
        if (!this.transacted) {
            this.throwResourceException("Error rolling back a transaction -- not transacted", null);
        }
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                final Session session = this.session;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        try {
                            session.rollback();
                        }
                        catch (Throwable throwable) {
                            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                            }
                            JMSBaseConnection.this.throwResourceException("Error committing a transaction", throwable);
                        }
                        return null;
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error rolling back a transaction", throwable);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            try {
                final Session session = this.session;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        try {
                            session.rollback();
                        }
                        catch (Throwable throwable) {
                            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                            }
                            JMSBaseConnection.this.throwResourceException("Error committing a transaction", throwable);
                        }
                        return null;
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error rolling back a  transaction", throwable);
            }
        }
    }

    void setManagedConnection(JMSManagedConnection jMSManagedConnection) {
        this.mc = jMSManagedConnection;
        this.metaData = new AdapterConnectionMetaDataImpl(jMSManagedConnection, this.mcf);
    }

    private InitialContext getInitialContext() throws NamingException {
        Object object;
        InitialContext initialContext = null;
        if (this.url == null && (this.userName == null || this.password == null)) {
            initialContext = new InitialContext();
        } else {
            object = new Hashtable<String, String>();
            if (this.userName != null && this.password != null) {
                ((Hashtable)object).put("java.naming.security.principal", this.userName);
                ((Hashtable)object).put("java.naming.security.credentials", this.password);
            }
            ((Hashtable)object).put("java.naming.factory.initial", this.icFactory);
            if (this.url != null) {
                ((Hashtable)object).put("java.naming.provider.url", this.url);
            }
            initialContext = new InitialContext((Hashtable<?, ?>)object);
        }
        this.subject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        object = SubjectUtils.getUsername((AuthenticatedSubject)this.subject);
        if (WLSPrincipals.isKernelUsername((String)object)) {
            this.subject = SubjectUtils.getAnonymousSubject();
            this.subject.setQOS((byte)101);
        }
        return initialContext;
    }

    private void ensureStarted() throws ResourceException {
        if (this.closed) {
            this.startInternal();
            this.closed = false;
        }
    }

    public void onMessage(Message message) {
        try {
            final Session session = this.session;
            final Message message2 = message;
            final MessageListener messageListener = this.mlistener;
            SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() {
                    block4: {
                        if (messageListener != null) {
                            messageListener.onMessage(message2);
                            return null;
                        }
                        if (session != null) {
                            try {
                                session.recover();
                            }
                            catch (Throwable throwable) {
                                if (!BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) break block4;
                                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
            }
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new WorkAdapter(){

                public void run() {
                    JMSBaseConnection.this.onException(new weblogic.jms.common.JMSException("Fail to call runAs()", throwable));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onException(JMSException jMSException) {
        Object object = this.onExceptionLock;
        synchronized (object) {
            if (this.elistener != null) {
                this.elistener.onException(jMSException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge(Message message) throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                final Message message2 = message;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        try {
                            message2.acknowledge();
                        }
                        catch (Throwable throwable) {
                            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                            }
                            JMSBaseConnection.this.throwResourceException("Error acknowledging messages", throwable, false);
                        }
                        return null;
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error acknowledge messages", throwable, false);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            try {
                final Message message3 = message;
                SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)this.subject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws ResourceException {
                        try {
                            message3.acknowledge();
                        }
                        catch (Throwable throwable) {
                            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                            }
                            JMSBaseConnection.this.throwResourceException("Error acknowledging messages", throwable, false);
                        }
                        return null;
                    }
                });
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error acknowledging messages", throwable, false);
            }
        }
    }

    static {
        ISOLATING_PACKAGES = new String[]{"weblogic.*", "COM.rsa.*"};
    }
}

