/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.adapter;

import javax.jms.ExceptionListener;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.ResourceException;
import javax.resource.spi.IllegalStateException;
import javax.transaction.xa.XAResource;
import weblogic.jms.adapter.JMSBaseConnection;
import weblogic.jms.adapter.JMSManagedConnection;
import weblogic.jms.bridge.AdapterConnection;
import weblogic.jms.bridge.AdapterConnectionMetaData;
import weblogic.jms.bridge.GenericMessage;
import weblogic.jms.bridge.LocalTransaction;
import weblogic.jms.bridge.NotificationListener;
import weblogic.jms.bridge.SourceConnection;
import weblogic.jms.bridge.TargetConnection;

public class JMSConnectionHandle
implements SourceConnection,
TargetConnection {
    private JMSManagedConnection managedCon;

    public JMSConnectionHandle(JMSManagedConnection jMSManagedConnection) {
        this.managedCon = jMSManagedConnection;
    }

    public void start() throws ResourceException {
        AdapterConnection adapterConnection = this.getJMSBaseConnection();
        adapterConnection.start();
    }

    public void close() throws ResourceException {
        if (this.managedCon == null) {
            return;
        }
        if (this.managedCon.isDestroyed()) {
            return;
        }
        this.managedCon.sendEvent(5, null, this);
        this.managedCon = null;
    }

    public void pause() throws ResourceException {
        AdapterConnection adapterConnection = this.getJMSBaseConnection();
        adapterConnection.pause();
    }

    public void resume() throws ResourceException {
        AdapterConnection adapterConnection = this.getJMSBaseConnection();
        adapterConnection.resume();
    }

    public boolean isClosed() {
        return this.managedCon == null;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        AdapterConnection adapterConnection = this.getJMSBaseConnection();
        return adapterConnection.getLocalTransaction();
    }

    public void addNotificationListener(NotificationListener notificationListener, int n) throws ResourceException {
        AdapterConnection adapterConnection = this.getJMSBaseConnection();
        adapterConnection.addNotificationListener(notificationListener, n);
    }

    public void removeNotificationListener(NotificationListener notificationListener, int n) throws ResourceException {
        AdapterConnection adapterConnection = this.getJMSBaseConnection();
        adapterConnection.removeNotificationListener(notificationListener, n);
    }

    public void associateTransaction(Message message) throws ResourceException {
        AdapterConnection adapterConnection = this.getJMSBaseConnection();
        adapterConnection.associateTransaction(message);
    }

    public void associateTransaction(GenericMessage genericMessage) throws ResourceException {
        AdapterConnection adapterConnection = this.getJMSBaseConnection();
        adapterConnection.associateTransaction(genericMessage);
    }

    public Message receive() throws ResourceException {
        SourceConnection sourceConnection = (SourceConnection)this.getJMSBaseConnection();
        return sourceConnection.receive();
    }

    public GenericMessage receiveGenericMessage() throws ResourceException {
        SourceConnection sourceConnection = (SourceConnection)this.getJMSBaseConnection();
        return sourceConnection.receiveGenericMessage();
    }

    public Message receive(long l) throws ResourceException {
        SourceConnection sourceConnection = (SourceConnection)this.getJMSBaseConnection();
        return sourceConnection.receive(l);
    }

    public GenericMessage receiveGenericMessage(long l) throws ResourceException {
        SourceConnection sourceConnection = (SourceConnection)this.getJMSBaseConnection();
        return sourceConnection.receiveGenericMessage(l);
    }

    public void setMessageListener(MessageListener messageListener) throws ResourceException {
        SourceConnection sourceConnection = (SourceConnection)this.getJMSBaseConnection();
        sourceConnection.setMessageListener(messageListener);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws ResourceException {
        SourceConnection sourceConnection = (SourceConnection)this.getJMSBaseConnection();
        sourceConnection.setExceptionListener(exceptionListener);
    }

    public void send(Message message) throws ResourceException {
        TargetConnection targetConnection = (TargetConnection)this.getJMSBaseConnection();
        targetConnection.send(message);
    }

    public void send(GenericMessage genericMessage) throws ResourceException {
        TargetConnection targetConnection = (TargetConnection)this.getJMSBaseConnection();
        targetConnection.send(genericMessage);
    }

    public Message createMessage(Message message) throws ResourceException {
        TargetConnection targetConnection = (TargetConnection)this.getJMSBaseConnection();
        return targetConnection.createMessage(message);
    }

    public Message createMessage(GenericMessage genericMessage) throws ResourceException {
        TargetConnection targetConnection = (TargetConnection)this.getJMSBaseConnection();
        return targetConnection.createMessage(genericMessage);
    }

    public GenericMessage createGenericMessage(Message message) throws ResourceException {
        TargetConnection targetConnection = (TargetConnection)this.getJMSBaseConnection();
        return targetConnection.createGenericMessage(message);
    }

    public GenericMessage createGenericMessage(GenericMessage genericMessage) throws ResourceException {
        TargetConnection targetConnection = (TargetConnection)this.getJMSBaseConnection();
        return targetConnection.createGenericMessage(genericMessage);
    }

    public XAResource getXAResource() throws ResourceException {
        AdapterConnection adapterConnection = this.getJMSBaseConnection();
        return adapterConnection.getXAResource();
    }

    public boolean implementsMDBTransaction() throws ResourceException {
        SourceConnection sourceConnection = (SourceConnection)this.getJMSBaseConnection();
        return ((JMSBaseConnection)sourceConnection).implementsMDBTransaction();
    }

    public void setAcknowledgeMode(int n) throws ResourceException {
        SourceConnection sourceConnection = (SourceConnection)this.getJMSBaseConnection();
        sourceConnection.setAcknowledgeMode(n);
    }

    public void recover() throws ResourceException {
        SourceConnection sourceConnection = (SourceConnection)this.getJMSBaseConnection();
        sourceConnection.recover();
    }

    public void acknowledge(Message message) throws ResourceException {
        SourceConnection sourceConnection = (SourceConnection)this.getJMSBaseConnection();
        sourceConnection.acknowledge(message);
    }

    public AdapterConnectionMetaData getMetaData() throws ResourceException {
        SourceConnection sourceConnection = (SourceConnection)this.getJMSBaseConnection();
        return sourceConnection.getMetaData();
    }

    void associateConnection(JMSManagedConnection jMSManagedConnection) throws ResourceException {
        this.checkIfValid();
        this.managedCon.removeJMSConnectionHandle(this);
        jMSManagedConnection.addJMSConnectionHandle(this);
        this.managedCon = jMSManagedConnection;
    }

    void checkIfValid() throws ResourceException {
        if (this.managedCon == null) {
            throw new IllegalStateException("Connection is invalid");
        }
    }

    AdapterConnection getJMSBaseConnection() throws ResourceException {
        this.checkIfValid();
        return this.managedCon.getJMSBaseConnection();
    }

    void invalidate() {
        this.managedCon = null;
    }
}

