/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.adapter;

import javax.resource.ResourceException;
import javax.resource.spi.EISSystemException;
import weblogic.jms.JMSLogger;
import weblogic.jms.adapter.JMSBaseConnection;
import weblogic.jms.adapter.JMSManagedConnection;
import weblogic.jms.bridge.AdapterConnection;

public class LocalTransactionImpl {
    private JMSManagedConnection mc;

    public LocalTransactionImpl(JMSManagedConnection jMSManagedConnection) {
        this.mc = jMSManagedConnection;
    }

    public void begin() throws ResourceException {
        try {
            AdapterConnection adapterConnection = this.mc.getJMSBaseConnection();
            ((JMSBaseConnection)adapterConnection).createTransactedSession();
            this.mc.sendEvent(2, null);
        }
        catch (Exception exception) {
            JMSLogger.logStackTrace((Throwable)exception);
            EISSystemException eISSystemException = new EISSystemException("Failed to begin a local transaction");
            eISSystemException.setLinkedException(exception);
            throw eISSystemException;
        }
    }

    public void commit() throws ResourceException {
        AdapterConnection adapterConnection = null;
        try {
            adapterConnection = this.mc.getJMSBaseConnection();
            ((JMSBaseConnection)adapterConnection).commit();
            this.mc.sendEvent(3, null);
        }
        catch (Exception exception) {
            EISSystemException eISSystemException = new EISSystemException("Failed to commit a local transaction");
            eISSystemException.setLinkedException(exception);
            throw eISSystemException;
        }
    }

    public void rollback() throws ResourceException {
        AdapterConnection adapterConnection = null;
        try {
            adapterConnection = this.mc.getJMSBaseConnection();
            ((JMSBaseConnection)adapterConnection).rollback();
            this.mc.sendEvent(4, null);
        }
        catch (Exception exception) {
            EISSystemException eISSystemException = new EISSystemException("Failed to roll back a local transaction");
            eISSystemException.setLinkedException(exception);
            throw eISSystemException;
        }
    }
}

