/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.adapter;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import weblogic.jms.adapter.JMSConnectionRequestInfo;

public class Util {
    public static PasswordCredential getPasswordCredential(ManagedConnectionFactory managedConnectionFactory, final Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        JMSConnectionRequestInfo jMSConnectionRequestInfo = (JMSConnectionRequestInfo)connectionRequestInfo;
        if (connectionRequestInfo == null || jMSConnectionRequestInfo.getUser() == null || jMSConnectionRequestInfo.getPassword() == null) {
            if (subject == null) {
                return null;
            }
            Set set = (Set)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return subject.getPrivateCredentials(PasswordCredential.class);
                }
            });
            PasswordCredential passwordCredential = null;
            for (PasswordCredential passwordCredential2 : set) {
                if (!passwordCredential2.getManagedConnectionFactory().equals(managedConnectionFactory)) continue;
                passwordCredential = passwordCredential2;
                break;
            }
            if (passwordCredential == null) {
                throw new SecurityException("No PasswordCredential found");
            }
            return passwordCredential;
        }
        PasswordCredential passwordCredential = new PasswordCredential(jMSConnectionRequestInfo.getUser(), jMSConnectionRequestInfo.getPassword().toCharArray());
        passwordCredential.setManagedConnectionFactory(managedConnectionFactory);
        return passwordCredential;
    }

    public static boolean isEqual(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }
}

