/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.adapter51;

import com.bea.interop.jms101_jms110.TopicConnectionFactoryFrom110;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionRolledBackException;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.jms.XATopicSession;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.transaction.xa.XAResource;
import weblogic.connector.exception.NoEnlistXAResourceException;
import weblogic.jms.adapter51.AdapterConnectionMetaDataImpl;
import weblogic.jms.adapter51.AdapterLocalTransactionImpl;
import weblogic.jms.adapter51.JMSManagedConnection;
import weblogic.jms.adapter51.JMSManagedConnectionFactory;
import weblogic.jms.bridge.AdapterConnectionMetaData;
import weblogic.jms.bridge.GenericMessage;
import weblogic.jms.bridge.LocalTransaction;
import weblogic.jms.bridge.NotificationListener;
import weblogic.jms.bridge.ResourceTransactionRolledBackException;
import weblogic.jms.bridge.SourceConnection;
import weblogic.jms.bridge.TargetConnection;
import weblogic.jms.bridge.internal.BridgeDebug;
import weblogic.jms.client.JMSXASession;
import weblogic.jms.extensions.MDBTransaction;
import weblogic.transaction.internal.IgnoreXAResource;

public class JMSBaseConnection
implements SourceConnection,
TargetConnection,
MessageListener,
ExceptionListener {
    private JMSManagedConnectionFactory mcf;
    private JMSManagedConnection mc;
    protected ConnectionFactory cf;
    protected Connection connection;
    protected XASession xaSession;
    protected Session session;
    protected Destination destination;
    private MessageProducer messageProducer;
    private MessageConsumer messageConsumer;
    private MessageListener mlistener;
    private ExceptionListener elistener;
    private String name;
    private String userName;
    private String password;
    private String destJNDI;
    private int destType;
    private String cfJNDI;
    private String url;
    private String icFactory;
    private String selector;
    private AdapterConnectionMetaData metaData;
    private boolean transacted;
    private boolean durable;
    private boolean isXA;
    private int ackMode = 1;
    private boolean ignoreXA = false;
    static final int QUEUE = 0;
    static final int TOPIC = 1;
    private boolean closed = true;
    private ClassLoader classLoader;
    private static final boolean DEBUG = false;
    private static final String TOPIC_CONNECTION_TO_101_CLASSNAME = "com.bea.interop.jms101_jms110.TopicConnectionTo101";
    private static final String TOPIC_CONNECTION_FACTORY_TO_101_CLASSNAME = "com.bea.interop.jms101_jms110.TopicConnectionFactoryTo101";
    private static final String WLS_5_1_TOPIC_CONNECTION_FACTORY = "weblogic.jms.adapter51.wls51TopicConnectionFactory";

    JMSBaseConnection(String string, String string2, JMSManagedConnectionFactory jMSManagedConnectionFactory, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, ClassLoader classLoader) throws Exception {
        this.userName = string;
        this.password = string2;
        this.mcf = jMSManagedConnectionFactory;
        this.name = string3;
        this.url = string4;
        this.icFactory = string5;
        this.destJNDI = string7;
        if (string8 != null) {
            if (string8.equalsIgnoreCase("Queue")) {
                this.destType = 0;
            } else if (string8.equalsIgnoreCase("Topic")) {
                this.destType = 1;
            }
        } else {
            this.destType = 0;
        }
        this.cfJNDI = string6;
        this.selector = string9;
        this.durable = bl;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                this.startInternal();
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            this.startInternal();
        }
    }

    private synchronized void startInternal() throws ResourceException {
        block29: {
            if (this.connection != null && !this.closed) {
                return;
            }
            Object object = null;
            Object object2 = null;
            InitialContext initialContext = null;
            try {
                initialContext = this.getInitialContext();
                if (this.classLoader == null || this.destType == 0) {
                    object = initialContext.lookup(this.cfJNDI);
                } else {
                    try {
                        object = initialContext.lookup(WLS_5_1_TOPIC_CONNECTION_FACTORY);
                    }
                    catch (NameNotFoundException nameNotFoundException) {
                        Class<?> clazz = this.classLoader.loadClass(TOPIC_CONNECTION_TO_101_CLASSNAME);
                        Class<?> clazz2 = this.classLoader.loadClass(TOPIC_CONNECTION_FACTORY_TO_101_CLASSNAME);
                        Constructor<?> constructor = clazz2.getConstructors()[0];
                        Object[] objectArray = new Object[]{initialContext.lookup(this.cfJNDI)};
                        com.bea.interop.jms101_jms110.TopicConnectionFactory topicConnectionFactory = (com.bea.interop.jms101_jms110.TopicConnectionFactory)constructor.newInstance(objectArray);
                        Hashtable<String, String> hashtable = new Hashtable<String, String>();
                        hashtable.put("weblogic.jndi.createIntermediateContexts", "true");
                        TopicConnectionFactoryFrom110 topicConnectionFactoryFrom110 = new TopicConnectionFactoryFrom110(topicConnectionFactory);
                        try {
                            InitialContext initialContext2 = new InitialContext(hashtable);
                            initialContext2.unbind(WLS_5_1_TOPIC_CONNECTION_FACTORY);
                            initialContext2.bind(WLS_5_1_TOPIC_CONNECTION_FACTORY, (Object)topicConnectionFactoryFrom110);
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                        object = topicConnectionFactoryFrom110;
                    }
                }
                object2 = initialContext.lookup(this.destJNDI);
                this.cf = (ConnectionFactory)object;
                this.isXA = this.cf instanceof XAConnectionFactory;
                if (this.ignoreXA) {
                    this.isXA = false;
                }
                if (object2 instanceof Queue && !(object2 instanceof Topic)) {
                    this.destType = 0;
                } else if (!(object2 instanceof Queue) && object2 instanceof Topic) {
                    this.destType = 1;
                }
                if (this.destType == 0) {
                    this.destination = (Queue)object2;
                    if (this.isXA) {
                        this.connection = this.userName != null ? ((XAQueueConnectionFactory)this.cf).createXAQueueConnection(this.userName, this.password) : ((XAQueueConnectionFactory)this.cf).createXAQueueConnection();
                        this.xaSession = ((XAQueueConnection)this.connection).createXAQueueSession();
                        this.session = ((XAQueueSession)this.xaSession).getQueueSession();
                    } else {
                        this.connection = this.userName != null ? ((QueueConnectionFactory)this.cf).createQueueConnection(this.userName, this.password) : ((QueueConnectionFactory)this.cf).createQueueConnection();
                        this.session = ((QueueConnection)this.connection).createQueueSession(this.transacted, this.ackMode);
                    }
                    break block29;
                }
                if (this.destType == 1) {
                    this.destination = (Topic)object2;
                    String string = null;
                    if (this.durable) {
                        string = "MessagingBridge." + this.name;
                    }
                    if (this.isXA) {
                        this.connection = this.userName != null ? ((XATopicConnectionFactory)this.cf).createXATopicConnection(this.userName, this.password) : ((XATopicConnectionFactory)this.cf).createXATopicConnection();
                        if (this.durable && (this.connection.getClientID() == null || this.connection.getClientID().length() == 0)) {
                            this.connection.setClientID(string);
                        }
                        this.xaSession = ((XATopicConnection)this.connection).createXATopicSession();
                        this.session = ((XATopicSession)this.xaSession).getTopicSession();
                    } else {
                        this.connection = this.userName != null ? ((TopicConnectionFactory)this.cf).createTopicConnection(this.userName, this.password) : ((TopicConnectionFactory)this.cf).createTopicConnection();
                        if (this.durable && (this.connection.getClientID() == null || this.connection.getClientID().length() == 0)) {
                            this.connection.setClientID(string);
                        }
                        this.session = ((TopicConnection)this.connection).createTopicSession(this.transacted, this.ackMode);
                    }
                    break block29;
                }
                throw new ResourceException("Adapter internal error -- Found non-JMS objcts");
            }
            catch (NamingException namingException) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", (Throwable)namingException);
                }
                if (initialContext == null) {
                    this.throwResourceException("ConnectionFactory: failed to get initial context (InitialContextFactory =" + this.icFactory + ", url = " + this.url + ", user name = " + this.userName + ")", namingException);
                }
                if (object == null) {
                    this.throwResourceException("ConnectionFactory: " + this.cfJNDI + " not found", namingException);
                }
                if (object2 == null) {
                    this.throwResourceException("Destination: " + this.destJNDI + " not found", namingException);
                }
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                    Exception exception = null;
                    if (throwable instanceof JMSException && (exception = ((JMSException)throwable).getLinkedException()) != null) {
                        BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", (Throwable)exception);
                    }
                }
                this.throwResourceException("Failed to start the connection", throwable);
            }
        }
        this.closed = false;
        JMSManagedConnectionFactory.printInfo(this.mcf.getLogWriter(), this.name, "Connection started to " + this.destJNDI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws ResourceException {
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                return;
            }
        }
        if (this.classLoader != null) {
            object = Thread.currentThread();
            ClassLoader classLoader = ((Thread)object).getContextClassLoader();
            try {
                ((Thread)object).setContextClassLoader(this.classLoader);
                this.closeInternal();
            }
            finally {
                ((Thread)object).setContextClassLoader(classLoader);
                this.classLoader = null;
            }
        } else {
            this.closeInternal();
        }
    }

    private synchronized void closeInternal() throws ResourceException {
        JMSException jMSException;
        block11: {
            jMSException = null;
            this.closed = true;
            try {
                this.connection.stop();
            }
            catch (JMSException jMSException2) {
                if (jMSException == null) {
                    jMSException = jMSException2;
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.closeSession();
            }
            catch (JMSException jMSException3) {
                if (jMSException != null) break block11;
                jMSException = jMSException3;
            }
        }
        if (this.connection != null) {
            block12: {
                try {
                    this.connection.close();
                }
                catch (JMSException jMSException4) {
                    if (jMSException != null) break block12;
                    jMSException = jMSException4;
                }
            }
            this.connection = null;
        }
        JMSManagedConnectionFactory.printInfo(this.mcf.getLogWriter(), this.name, "Connection closed to " + this.destJNDI);
        if (jMSException != null) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() throws JMSException {
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                return;
            }
        }
        if (this.classLoader != null) {
            object = Thread.currentThread();
            ClassLoader classLoader = ((Thread)object).getContextClassLoader();
            try {
                ((Thread)object).setContextClassLoader(this.classLoader);
                this.cleanupInternal();
            }
            finally {
                ((Thread)object).setContextClassLoader(classLoader);
            }
        } else {
            this.cleanupInternal();
        }
    }

    private synchronized void cleanupInternal() throws JMSException {
        JMSException jMSException = null;
        if (this.messageProducer != null) {
            block7: {
                try {
                    this.messageProducer.close();
                }
                catch (JMSException jMSException2) {
                    if (jMSException != null) break block7;
                    jMSException = jMSException2;
                }
            }
            this.messageProducer = null;
        }
        if (this.messageConsumer != null) {
            block8: {
                try {
                    this.messageConsumer.close();
                }
                catch (JMSException jMSException3) {
                    if (jMSException != null) break block8;
                    jMSException = jMSException3;
                }
            }
            this.messageConsumer = null;
            this.mlistener = null;
        }
        if (jMSException != null) {
            throw jMSException;
        }
    }

    private synchronized void closeSession() throws JMSException {
        JMSException jMSException = null;
        if (this.messageProducer != null) {
            block14: {
                try {
                    this.messageProducer.close();
                }
                catch (JMSException jMSException2) {
                    if (jMSException != null) break block14;
                    jMSException = jMSException2;
                }
            }
            this.messageProducer = null;
        }
        if (this.messageConsumer != null) {
            block15: {
                try {
                    this.messageConsumer.close();
                }
                catch (JMSException jMSException3) {
                    if (jMSException != null) break block15;
                    jMSException = jMSException3;
                }
            }
            this.messageConsumer = null;
            this.mlistener = null;
        }
        if (this.xaSession != null) {
            block16: {
                try {
                    this.xaSession.close();
                }
                catch (JMSException jMSException4) {
                    if (jMSException != null) break block16;
                    jMSException = jMSException4;
                }
            }
            this.xaSession = null;
            this.session = null;
        } else if (this.session != null) {
            block17: {
                try {
                    this.session.close();
                }
                catch (JMSException jMSException5) {
                    if (jMSException != null) break block17;
                    jMSException = jMSException5;
                }
            }
            this.session = null;
        }
        if (jMSException != null) {
            throw jMSException;
        }
    }

    public void pause() throws ResourceException {
        throw new NotSupportedException("pause() -- Not supported!");
    }

    public void resume() throws ResourceException {
        throw new NotSupportedException("resume() -- Not supported!");
    }

    public synchronized LocalTransaction getLocalTransaction() throws ResourceException {
        return new AdapterLocalTransactionImpl(this.mc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                this.sendInternal(message);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            this.sendInternal(message);
        }
    }

    private synchronized void sendInternal(Message message) throws ResourceException {
        if (this.messageProducer != null) {
            try {
                if (this.destType == 0) {
                    ((QueueSender)this.messageProducer).send(message);
                } else if (this.destType == 1) {
                    ((TopicPublisher)this.messageProducer).publish(message);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                    Exception exception = null;
                    if (throwable instanceof JMSException && (exception = ((JMSException)throwable).getLinkedException()) != null) {
                        BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", (Throwable)exception);
                    }
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Failed to send a message");
                this.throwResourceException("Error sending message", throwable, false);
            }
        }
        this.ensureStarted();
        if (this.session != null && this.destination != null) {
            try {
                if (this.destType == 0) {
                    this.messageProducer = ((QueueSession)this.session).createSender((Queue)this.destination);
                    this.connection.start();
                    ((QueueSender)this.messageProducer).send(message);
                } else if (this.destType == 1) {
                    this.messageProducer = ((TopicSession)this.session).createPublisher((Topic)this.destination);
                    this.connection.start();
                    ((TopicPublisher)this.messageProducer).publish(message);
                }
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Failed to send a message");
                this.throwResourceException("Error creating producer or sending message", throwable, false);
            }
        }
        JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Internal error -- invalid state!");
        throw new ResourceAdapterInternalException("Bridge Adapter internal error -- invalid state!");
    }

    public void send(GenericMessage genericMessage) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    private Message receiveFromQueue(QueueReceiver queueReceiver, long l) throws JMSException {
        if (l < 0L) {
            return queueReceiver.receive();
        }
        if (l == 0L) {
            return queueReceiver.receiveNoWait();
        }
        return queueReceiver.receive(l);
    }

    private Message receiveFromTopic(TopicSubscriber topicSubscriber, long l) throws JMSException {
        if (l < 0L) {
            return topicSubscriber.receive();
        }
        if (l == 0L) {
            return topicSubscriber.receiveNoWait();
        }
        return topicSubscriber.receive(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message receiveCommon(long l) throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                Message message = this.receiveInternal(l);
                return message;
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        }
        return this.receiveInternal(l);
    }

    private synchronized Message receiveInternal(long l) throws ResourceException {
        Exception exception;
        if (this.messageConsumer != null) {
            try {
                if (this.destType == 0) {
                    return this.receiveFromQueue((QueueReceiver)this.messageConsumer, l);
                }
                if (this.destType == 1) {
                    return this.receiveFromTopic((TopicSubscriber)this.messageConsumer, l);
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Internal error -- invalid state!");
                throw new ResourceException("Adapter internal error: detect non-JMS objects in creating consumer or receiving message");
            }
            catch (Throwable throwable) {
                this.messageConsumer = null;
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                    exception = null;
                    if (throwable instanceof JMSException && (exception = ((JMSException)throwable).getLinkedException()) != null) {
                        BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", (Throwable)exception);
                    }
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Failed to receive a message!");
                this.throwResourceException("Error receiving message", throwable);
            }
        }
        this.ensureStarted();
        if (this.session != null && this.destination != null) {
            try {
                if (this.destType == 0) {
                    this.messageConsumer = this.selector != null && this.selector.trim().length() > 0 ? ((QueueSession)this.session).createReceiver((Queue)this.destination, this.selector) : ((QueueSession)this.session).createReceiver((Queue)this.destination);
                    this.connection.start();
                    return this.receiveFromQueue((QueueReceiver)this.messageConsumer, l);
                }
                if (this.destType == 1) {
                    this.messageConsumer = this.selector != null && this.selector.trim().length() > 0 ? (this.durable ? ((TopicSession)this.session).createDurableSubscriber((Topic)this.destination, this.name, this.selector, true) : ((TopicSession)this.session).createSubscriber((Topic)this.destination, this.selector, true)) : (this.durable ? ((TopicSession)this.session).createDurableSubscriber((Topic)this.destination, this.name) : ((TopicSession)this.session).createSubscriber((Topic)this.destination));
                    this.connection.start();
                    return this.receiveFromTopic((TopicSubscriber)this.messageConsumer, l);
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Internal error -- invalid state!");
                throw new ResourceException("Error creating consumer or receiving message -- internal error");
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                    exception = null;
                    if (throwable instanceof JMSException && (exception = ((JMSException)throwable).getLinkedException()) != null) {
                        BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", (Throwable)exception);
                    }
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Failed to receive a messag");
                this.throwResourceException("Error creating consumer or receiving message", throwable);
            }
        }
        JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Internal error -- invalid state!");
        throw new ResourceException("Error receiving message -- internal error");
    }

    public GenericMessage receiveGenericMessage() throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    public Message receive() throws ResourceException {
        return this.receiveCommon(-1L);
    }

    public Message receive(long l) throws ResourceException {
        return this.receiveCommon(l);
    }

    public GenericMessage receiveGenericMessage(long l) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    public synchronized Message createMessage(Message message) throws ResourceException {
        return message;
    }

    public Message createMessage(GenericMessage genericMessage) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    public GenericMessage createGenericMessage(Message message) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    public GenericMessage createGenericMessage(GenericMessage genericMessage) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener messageListener) throws ResourceException {
        this.mlistener = messageListener;
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                if (this.mlistener == null) {
                    this.setMessageListenerInternal(null);
                }
                this.setMessageListenerInternal(this);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else if (this.mlistener == null) {
            this.setMessageListenerInternal(null);
        } else {
            this.setMessageListenerInternal(this);
        }
    }

    private synchronized void setMessageListenerInternal(MessageListener messageListener) throws ResourceException {
        if (this.messageConsumer != null) {
            try {
                this.messageConsumer.setMessageListener(messageListener);
                JMSManagedConnectionFactory.printInfo(this.mcf.getLogWriter(), this.name, "MessageListener is set on " + this.destJNDI);
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Failed to set a message listener on " + this.destJNDI);
                this.throwResourceException("Error setting message listener", throwable);
            }
        }
        this.ensureStarted();
        if (this.session != null && this.destination != null) {
            try {
                if (this.destType == 0) {
                    this.messageConsumer = this.selector != null && this.selector.trim().length() > 0 ? ((QueueSession)this.session).createReceiver((Queue)this.destination, this.selector) : ((QueueSession)this.session).createReceiver((Queue)this.destination);
                } else if (this.destType == 1) {
                    this.messageConsumer = this.selector != null && this.selector.trim().length() > 0 ? (this.durable ? ((TopicSession)this.session).createDurableSubscriber((Topic)this.destination, this.name, this.selector, true) : ((TopicSession)this.session).createSubscriber((Topic)this.destination, this.selector, true)) : (this.durable ? ((TopicSession)this.session).createDurableSubscriber((Topic)this.destination, this.name) : ((TopicSession)this.session).createSubscriber((Topic)this.destination));
                }
                if (messageListener == null) {
                    this.messageConsumer.setMessageListener(null);
                } else {
                    this.messageConsumer.setMessageListener((MessageListener)this);
                }
                this.connection.start();
                JMSManagedConnectionFactory.printInfo(this.mcf.getLogWriter(), this.name, "MessageListener is set on " + this.destJNDI);
                return;
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Failed to set a message listener on " + this.destJNDI);
                this.throwResourceException("Error creating asynchronous consumer or setting message lisenter", throwable);
            }
        }
        JMSManagedConnectionFactory.printError(this.mcf.getLogWriter(), this.name, "Internal error -- invalid state!");
        throw new ResourceAdapterInternalException("Bridge Adapter internal error -- invalid state!");
    }

    public void addNotificationListener(NotificationListener notificationListener, int n) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    public void removeNotificationListener(NotificationListener notificationListener, int n) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateTransaction(Message message) throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                this.associateTransactionInternal(message);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            this.associateTransactionInternal(message);
        }
    }

    private synchronized void associateTransactionInternal(Message message) throws ResourceException {
        if (this.session instanceof MDBTransaction) {
            try {
                ((MDBTransaction)this.session).associateTransaction(message);
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Failed to associate a message with the current transaction", throwable, false);
            }
        } else {
            throw new NotSupportedException("Not implemented");
        }
    }

    public void associateTransaction(GenericMessage genericMessage) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    private void throwResourceException(String string, Throwable throwable) throws ResourceException {
        this.throwResourceException(string, throwable, true);
    }

    private void throwResourceException(String string, Throwable throwable, boolean bl) throws ResourceException {
        if (bl) {
            this.mc.sendEvent(5, null);
        }
        ResourceException resourceException = null;
        resourceException = throwable != null && throwable instanceof TransactionRolledBackException ? new ResourceTransactionRolledBackException("Transaction rolled back") : new ResourceException(string);
        if (throwable != null && throwable instanceof Exception) {
            resourceException.setLinkedException((Exception)throwable);
        }
        throw resourceException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResource getXAResource() throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                XAResource xAResource = this.getXAResourceInternal();
                return xAResource;
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        }
        return this.getXAResourceInternal();
    }

    private synchronized XAResource getXAResourceInternal() throws ResourceException {
        if (this.xaSession != null && !(this.xaSession instanceof JMSXASession)) {
            XAResource xAResource = this.xaSession.getXAResource();
            if (xAResource instanceof IgnoreXAResource) {
                throw new NoEnlistXAResourceException("No need to enlist this resource");
            }
            return xAResource;
        }
        throw new NoEnlistXAResourceException("No need to enlist this resource");
    }

    public synchronized boolean implementsMDBTransaction() throws ResourceException {
        return this.session != null && this.session instanceof MDBTransaction;
    }

    public synchronized boolean isXAConnection() throws ResourceException {
        return this.cf != null && this.cf instanceof XAConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExceptionListener(ExceptionListener exceptionListener) throws ResourceException {
        this.elistener = exceptionListener;
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                this.setExceptionListenerInternal(this);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            this.setExceptionListenerInternal(this);
        }
    }

    private synchronized void setExceptionListenerInternal(ExceptionListener exceptionListener) throws ResourceException {
        if (this.connection != null) {
            try {
                this.connection.setExceptionListener(exceptionListener);
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error setting exception listener", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcknowledgeMode(int n) throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                this.setAcknowledgeModeInternal(n);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            this.setAcknowledgeModeInternal(n);
        }
    }

    private synchronized void setAcknowledgeModeInternal(int n) throws ResourceException {
        if (n == this.ackMode) {
            return;
        }
        this.ignoreXA = false;
        switch (n) {
            case 2: {
                this.ackMode = 2;
                break;
            }
            case 1: {
                this.ackMode = 1;
                break;
            }
            case 3: {
                this.ackMode = 3;
                break;
            }
            default: {
                this.ackMode = 1;
                this.ignoreXA = true;
            }
        }
        if (this.connection == null) {
            return;
        }
        try {
            this.closeSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.destType == 0) {
                this.session = ((QueueConnection)this.connection).createQueueSession(this.transacted, this.ackMode);
            } else if (this.destType == 1) {
                this.session = ((TopicConnection)this.connection).createTopicSession(this.transacted, this.ackMode);
            }
        }
        catch (Throwable throwable) {
            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
            }
            this.throwResourceException("Error starting a local transaction", throwable);
        }
    }

    public AdapterConnectionMetaData getMetaData() throws ResourceException {
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws ResourceException {
        try {
            if (this.session.getTransacted()) {
                return;
            }
        }
        catch (JMSException jMSException) {
            this.throwResourceException("Error recovering messages", jMSException, false);
        }
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                this.session.recover();
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error recovering messages", throwable, false);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            try {
                this.session.recover();
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error recovering messages", throwable, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTransactedSession() throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                this.createTransactedSessionInternal();
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            this.createTransactedSessionInternal();
        }
    }

    private synchronized void createTransactedSessionInternal() throws ResourceException {
        if (this.transacted) {
            return;
        }
        if (this.connection == null) {
            this.transacted = true;
            return;
        }
        MessageListener messageListener = null;
        if (this.messageConsumer != null) {
            try {
                messageListener = this.messageConsumer.getMessageListener();
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error restore message listener", throwable);
            }
        }
        try {
            this.closeSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.destType == 0) {
                this.session = ((QueueConnection)this.connection).createQueueSession(true, this.ackMode);
            } else if (this.destType == 1) {
                this.session = ((TopicConnection)this.connection).createTopicSession(true, this.ackMode);
            }
            if (this.mlistener != null) {
                this.setMessageListener(this.mlistener);
            }
        }
        catch (Throwable throwable) {
            if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
            }
            this.throwResourceException("Error beginning a local transaction", throwable);
        }
        this.transacted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() throws ResourceException {
        if (!this.transacted) {
            this.throwResourceException("Error committing a local transaction -- not transacted", null);
        }
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                this.session.commit();
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error committing a local transaction", throwable);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            try {
                this.session.commit();
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error committing a local transaction", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback() throws ResourceException {
        if (!this.transacted) {
            this.throwResourceException("Error rolling back a local transaction -- not transacted", null);
        }
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                this.session.rollback();
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error rolling back a local transaction", throwable);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            try {
                this.session.rollback();
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error rolling back a local transaction", throwable);
            }
        }
    }

    void setManagedConnection(JMSManagedConnection jMSManagedConnection) {
        this.mc = jMSManagedConnection;
        this.metaData = new AdapterConnectionMetaDataImpl(jMSManagedConnection, this.mcf);
    }

    private InitialContext getInitialContext() throws NamingException {
        if (this.url == null) {
            return new InitialContext();
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.userName != null && this.password != null) {
            hashtable.put("java.naming.security.principal", this.userName);
            hashtable.put("java.naming.security.credentials", this.password);
        }
        hashtable.put("java.naming.factory.initial", this.icFactory);
        hashtable.put("java.naming.provider.url", this.url);
        return new InitialContext(hashtable);
    }

    private void ensureStarted() throws ResourceException {
        if (this.closed) {
            this.startInternal();
            this.closed = false;
        }
    }

    public void onMessage(Message message) {
        if (this.mlistener != null) {
            this.mlistener.onMessage(message);
            return;
        }
        if (this.session != null) {
            try {
                this.session.recover();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    public void onException(JMSException jMSException) {
        if (this.elistener != null) {
            this.elistener.onException(jMSException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge(Message message) throws ResourceException {
        if (this.classLoader != null) {
            Thread thread2 = Thread.currentThread();
            ClassLoader classLoader = thread2.getContextClassLoader();
            try {
                thread2.setContextClassLoader(this.classLoader);
                message.acknowledge();
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error acknowledging messages", throwable, false);
            }
            finally {
                thread2.setContextClassLoader(classLoader);
            }
        } else {
            try {
                message.acknowledge();
            }
            catch (Throwable throwable) {
                if (BridgeDebug.MessagingBridgeRuntimeVerbose.isDebugEnabled()) {
                    BridgeDebug.MessagingBridgeRuntimeVerbose.debug("Exception:", throwable);
                }
                this.throwResourceException("Error acknowledging messages", throwable, false);
            }
        }
    }
}

