/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.adapter51;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Reference;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import weblogic.jms.adapter51.AdapterMetaDataImpl;
import weblogic.jms.adapter51.JMSConnectionManager;
import weblogic.jms.adapter51.JMSConnectionRequestInfo;
import weblogic.jms.adapter51.JMSConnectionSpec;
import weblogic.jms.adapter51.JMSManagedConnectionFactory;
import weblogic.jms.bridge.AdapterConnectionFactory;
import weblogic.jms.bridge.AdapterMetaData;
import weblogic.jms.bridge.ConnectionSpec;
import weblogic.jms.bridge.SourceConnection;
import weblogic.jms.bridge.TargetConnection;

public class JMSBaseConnectionFactory
implements AdapterConnectionFactory {
    static final long serialVersionUID = 2366460655498131081L;
    public static final String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    private JMSManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;
    private AdapterMetaData metaData;
    private transient PrintWriter logWriter;
    private boolean initialized;
    private Hashtable props = new Hashtable();

    public JMSBaseConnectionFactory(ManagedConnectionFactory managedConnectionFactory, ConnectionManager connectionManager) throws ResourceException {
        this.mcf = (JMSManagedConnectionFactory)managedConnectionFactory;
        this.cm = connectionManager == null ? new JMSConnectionManager() : connectionManager;
        this.metaData = new AdapterMetaDataImpl(managedConnectionFactory);
        if (managedConnectionFactory.getLogWriter() != null) {
            this.logWriter = managedConnectionFactory.getLogWriter();
        }
    }

    public SourceConnection getSourceConnection() throws ResourceException {
        JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(null, null, 1);
        return (SourceConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)jMSConnectionRequestInfo);
    }

    public SourceConnection getSourceConnection(ConnectionSpec connectionSpec) throws ResourceException {
        JMSConnectionSpec jMSConnectionSpec = (JMSConnectionSpec)connectionSpec;
        JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(jMSConnectionSpec.getUser(), jMSConnectionSpec.getPassword(), 1, jMSConnectionSpec.getUrl(), jMSConnectionSpec.getInitialContextFactory(), jMSConnectionSpec.getSelector(), jMSConnectionSpec.getFactoryJndi(), jMSConnectionSpec.getDestJndi(), jMSConnectionSpec.getDestType(), jMSConnectionSpec.getName(), jMSConnectionSpec.getDurability(), jMSConnectionSpec.getClasspath());
        return (SourceConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)jMSConnectionRequestInfo);
    }

    public TargetConnection getTargetConnection() throws ResourceException {
        JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(null, null, 2);
        return (TargetConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)jMSConnectionRequestInfo);
    }

    public TargetConnection getTargetConnection(ConnectionSpec connectionSpec) throws ResourceException {
        JMSConnectionSpec jMSConnectionSpec = (JMSConnectionSpec)connectionSpec;
        JMSConnectionRequestInfo jMSConnectionRequestInfo = new JMSConnectionRequestInfo(jMSConnectionSpec.getUser(), jMSConnectionSpec.getPassword(), 2, jMSConnectionSpec.getUrl(), jMSConnectionSpec.getInitialContextFactory(), null, jMSConnectionSpec.getFactoryJndi(), jMSConnectionSpec.getDestJndi(), jMSConnectionSpec.getDestType(), jMSConnectionSpec.getClasspath());
        return (TargetConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)jMSConnectionRequestInfo);
    }

    public ConnectionSpec createConnectionSpec(Properties properties) throws ResourceException {
        return new JMSConnectionSpec(properties);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public AdapterMetaData getMetaData() throws ResourceException {
        return this.metaData;
    }

    public long getTimeout() throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.logWriter = printWriter;
    }

    public void setTimeout(long l) throws ResourceException {
        throw new NotSupportedException("Not implemented");
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }

    public String getTransactionSupport() throws ResourceException {
        return this.mcf.getAdapterType();
    }
}

