/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.adapter51;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import weblogic.jms.adapter51.ConnectionMetaDataImpl;
import weblogic.jms.adapter51.EventListenerManager;
import weblogic.jms.adapter51.JMSBaseConnection;
import weblogic.jms.adapter51.JMSConnectionHandle;
import weblogic.jms.adapter51.JMSConnectionRequestInfo;
import weblogic.jms.adapter51.SpiLocalTransactionImpl;
import weblogic.jms.adapter51.Util;
import weblogic.jms.bridge.AdapterConnection;
import weblogic.jms.bridge.AdapterConnectionMetaData;

public class JMSManagedConnection
implements ManagedConnection {
    private AdapterConnection con;
    private JMSConnectionRequestInfo connRequestInfo;
    private String user;
    private EventListenerManager listenerMgr;
    private ManagedConnectionFactory mcf;
    private transient PrintWriter logWriter;
    private boolean supportsXA;
    private boolean supportsLocalTx;
    private ManagedConnectionMetaData conMetaData;
    private boolean destroyed;
    private Set connectionSet;
    private AdapterConnectionMetaData metaData;

    JMSManagedConnection(ManagedConnectionFactory managedConnectionFactory, String string, AdapterConnection adapterConnection, JMSConnectionRequestInfo jMSConnectionRequestInfo, boolean bl, boolean bl2) {
        this.mcf = managedConnectionFactory;
        this.user = string;
        this.con = adapterConnection;
        this.connRequestInfo = jMSConnectionRequestInfo;
        this.supportsXA = bl;
        this.supportsLocalTx = bl2;
        this.connectionSet = new HashSet();
        this.listenerMgr = new EventListenerManager(this);
        try {
            this.metaData = ((JMSBaseConnection)adapterConnection).getMetaData();
        }
        catch (ResourceException resourceException) {
            // empty catch block
        }
        this.conMetaData = new ConnectionMetaDataImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        PasswordCredential passwordCredential = Util.getPasswordCredential(this.mcf, subject, connectionRequestInfo);
        if (passwordCredential == null ? this.user != null : !passwordCredential.getUserName().equals(this.user)) {
            throw new SecurityException("Principal does not match. Reauthentication not supported");
        }
        JMSManagedConnection jMSManagedConnection = this;
        synchronized (jMSManagedConnection) {
            this.checkIfDestroyed();
            JMSConnectionHandle jMSConnectionHandle = new JMSConnectionHandle(this);
            this.addJMSConnectionHandle(jMSConnectionHandle);
            return jMSConnectionHandle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws ResourceException {
        Iterator iterator = null;
        Object object = this;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            iterator = this.connectionSet.iterator();
        }
        this.con.close();
        while (iterator.hasNext()) {
            object = (JMSConnectionHandle)iterator.next();
            ((JMSConnectionHandle)object).invalidate();
        }
        object = this;
        synchronized (object) {
            this.connectionSet.clear();
            this.destroyed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ResourceException {
        Iterator iterator = null;
        Object object = this;
        synchronized (object) {
            if (this.isDestroyed()) {
                return;
            }
            iterator = this.connectionSet.iterator();
        }
        this.con.close();
        while (iterator.hasNext()) {
            object = (JMSConnectionHandle)iterator.next();
            ((JMSConnectionHandle)object).invalidate();
        }
        object = this;
        synchronized (object) {
            this.connectionSet.clear();
        }
    }

    public void associateConnection(Object object) throws ResourceException {
        this.checkIfDestroyed();
        if (!(object instanceof JMSConnectionHandle)) {
            throw new IllegalStateException("Invalid connection object: " + object);
        }
        JMSConnectionHandle jMSConnectionHandle = (JMSConnectionHandle)object;
        jMSConnectionHandle.associateConnection(this);
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listenerMgr.addConnectorListener(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.listenerMgr.removeConnectorListener(connectionEventListener);
    }

    public XAResource getXAResource() throws ResourceException {
        if (!this.supportsXA) {
            throw new NotSupportedException("XA transaction not supported");
        }
        this.checkIfDestroyed();
        return this.con.getXAResource();
    }

    public synchronized LocalTransaction getLocalTransaction() throws ResourceException {
        if (!this.supportsLocalTx) {
            throw new NotSupportedException("Local transaction not supported");
        }
        this.checkIfDestroyed();
        return new SpiLocalTransactionImpl(this);
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.checkIfDestroyed();
        return this.conMetaData;
    }

    public synchronized void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.checkIfDestroyed();
        this.logWriter = printWriter;
    }

    public synchronized PrintWriter getLogWriter() throws ResourceException {
        this.checkIfDestroyed();
        return this.logWriter;
    }

    AdapterConnection getJMSBaseConnection() throws ResourceException {
        this.checkIfDestroyed();
        return this.con;
    }

    synchronized boolean isDestroyed() {
        return this.destroyed;
    }

    String getUserName() throws ResourceException {
        this.checkIfDestroyed();
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEvent(int n, Exception exception) throws ResourceException {
        if (n != 1) {
            JMSManagedConnection jMSManagedConnection = this;
            synchronized (jMSManagedConnection) {
                if (this.destroyed) {
                    return;
                }
            }
        }
        this.listenerMgr.sendEvent(n, exception, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEvent(int n, Exception exception, Object object) throws ResourceException {
        if (n != 1) {
            JMSManagedConnection jMSManagedConnection = this;
            synchronized (jMSManagedConnection) {
                if (this.destroyed) {
                    return;
                }
            }
        }
        this.listenerMgr.sendEvent(n, exception, object);
    }

    synchronized void removeJMSConnectionHandle(JMSConnectionHandle jMSConnectionHandle) throws ResourceException {
        if (this.destroyed) {
            return;
        }
        this.connectionSet.remove(jMSConnectionHandle);
    }

    synchronized void addJMSConnectionHandle(JMSConnectionHandle jMSConnectionHandle) throws ResourceException {
        this.checkIfDestroyed();
        this.connectionSet.add(jMSConnectionHandle);
    }

    private synchronized void checkIfDestroyed() throws ResourceException {
        if (this.isDestroyed()) {
            throw new IllegalStateException("Managed connection is destroyed");
        }
    }

    ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    JMSConnectionRequestInfo getConnectionRequestInfo() {
        return this.connRequestInfo;
    }

    synchronized int getMaxConnections() throws ResourceException {
        this.checkIfDestroyed();
        return this.connectionSet.size();
    }
}

