/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.adapter51;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import weblogic.jms.JMSLogger;
import weblogic.jms.adapter51.IsolatingClassLoader;
import weblogic.jms.adapter51.JMSBaseConnection;
import weblogic.jms.adapter51.JMSBaseConnectionFactory;
import weblogic.jms.adapter51.JMSConnectionRequestInfo;
import weblogic.jms.adapter51.JMSConnectionSpec;
import weblogic.jms.adapter51.JMSManagedConnection;
import weblogic.jms.adapter51.Util;
import weblogic.jms.bridge.AdapterConnection;
import weblogic.jms.bridge.AdapterConnectionFactory;
import weblogic.jms.bridge.ConnectionSpec;
import weblogic.jms.bridge.SourceConnection;
import weblogic.jms.bridge.TargetConnection;

public class JMSManagedConnectionFactory
implements ManagedConnectionFactory,
Serializable {
    static final long serialVersionUID = -8319737096410419555L;
    private static final String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    private static final String TOPIC_CONNECTION_TO_101_CLASSNAME = "com.bea.interop.jms101_jms110.TopicConnectionTo101";
    private static final String TOPIC_CONNECTION_FACTORY_TO_101_CLASSNAME = "com.bea.interop.jms101_jms110.TopicConnectionFactoryTo101";
    private static final String[] ISOLATING_PACKAGES = new String[]{"weblogic.*", "COM.rsa.*", "javax.jms.TopicConnection", "javax.jms.TopicConnectionFactory", "com.bea.interop.jms101_jms110.TopicConnectionTo101", "com.bea.interop.jms101_jms110.TopicConnectionFactoryTo101"};
    private String clientName;
    private String url;
    private String icFactory;
    private String cfJNDI;
    private String destJNDI;
    private String destType;
    private String adapterType;
    private HashMap classLoaders = new HashMap();
    private AdapterConnectionFactory factory;
    private boolean isXA;
    private transient PrintWriter logWriter;
    private static transient DateFormat dformat;
    public static final transient Locale MY_LOCALE;

    public JMSManagedConnectionFactory() {
        dformat = DateFormat.getDateTimeInstance(2, 1, MY_LOCALE);
    }

    public Object createConnectionFactory() throws ResourceException {
        this.factory = new JMSBaseConnectionFactory(this, null);
        return this.factory;
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        this.factory = new JMSBaseConnectionFactory(this, connectionManager);
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        try {
            Object object;
            Object object2;
            JMSConnectionSpec jMSConnectionSpec;
            AdapterConnection adapterConnection = null;
            String string = null;
            int n = 0;
            PasswordCredential passwordCredential = Util.getPasswordCredential(this, subject, connectionRequestInfo);
            JMSConnectionRequestInfo jMSConnectionRequestInfo = (JMSConnectionRequestInfo)connectionRequestInfo;
            if (passwordCredential == null) {
                if (connectionRequestInfo == null) {
                    jMSConnectionSpec = null;
                } else {
                    jMSConnectionSpec = new JMSConnectionSpec(null, null, jMSConnectionRequestInfo.getUrl(), jMSConnectionRequestInfo.getInitialContextFactory(), jMSConnectionRequestInfo.getSelector(), jMSConnectionRequestInfo.getFactoryJndi(), jMSConnectionRequestInfo.getDestJndi(), jMSConnectionRequestInfo.getDestType(), jMSConnectionRequestInfo.getName(), jMSConnectionRequestInfo.getDurability(), jMSConnectionRequestInfo.getClasspath());
                    n = jMSConnectionRequestInfo.getType();
                }
            } else {
                string = passwordCredential.getUserName();
                object2 = passwordCredential.getPassword();
                object = new String((char[])object2);
                if (connectionRequestInfo == null) {
                    jMSConnectionSpec = new JMSConnectionSpec(string, (String)object);
                } else {
                    jMSConnectionSpec = new JMSConnectionSpec(string, (String)object, jMSConnectionRequestInfo.getUrl(), jMSConnectionRequestInfo.getInitialContextFactory(), jMSConnectionRequestInfo.getSelector(), jMSConnectionRequestInfo.getFactoryJndi(), jMSConnectionRequestInfo.getDestJndi(), jMSConnectionRequestInfo.getDestType(), jMSConnectionRequestInfo.getName(), jMSConnectionRequestInfo.getDurability(), jMSConnectionRequestInfo.getClasspath());
                    n = jMSConnectionRequestInfo.getType();
                }
            }
            adapterConnection = n == 1 ? this.createSourceConnection(jMSConnectionSpec) : (n == 2 ? this.createTargetConnection(jMSConnectionSpec) : this.createConnection(jMSConnectionSpec));
            object2 = new JMSManagedConnection(this, string, adapterConnection, jMSConnectionRequestInfo, true, true);
            ((JMSBaseConnection)adapterConnection).setManagedConnection((JMSManagedConnection)object2);
            if (this.logWriter != null) {
                ((JMSManagedConnection)object2).setLogWriter(this.logWriter);
            }
            if (n == 1) {
                if (jMSConnectionRequestInfo.getDestJndi() == null) {
                    JMSManagedConnectionFactory.printInfo(this.logWriter, this.clientName, "Source connection created to " + this.destJNDI);
                } else {
                    JMSManagedConnectionFactory.printInfo(this.logWriter, this.clientName, "Source connection created to " + jMSConnectionRequestInfo.getDestJndi());
                }
            } else if (n == 2) {
                if (jMSConnectionRequestInfo.getDestJndi() == null) {
                    JMSManagedConnectionFactory.printInfo(this.logWriter, this.clientName, "Target connection created to " + this.destJNDI);
                } else {
                    JMSManagedConnectionFactory.printInfo(this.logWriter, this.clientName, "Target connection created to " + jMSConnectionRequestInfo.getDestJndi());
                }
            }
            object = adapterConnection;
            synchronized (object) {
                adapterConnection.start();
            }
            return object2;
        }
        catch (JMSException jMSException) {
            EISSystemException eISSystemException = new EISSystemException("JMSException: " + jMSException.getMessage());
            eISSystemException.setLinkedException((Exception)((Object)jMSException));
            throw eISSystemException;
        }
    }

    public synchronized ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        PasswordCredential passwordCredential = Util.getPasswordCredential(this, subject, connectionRequestInfo);
        String string = null;
        if (passwordCredential != null) {
            string = passwordCredential.getUserName();
        }
        for (Object e : set) {
            if (!(e instanceof JMSManagedConnection)) continue;
            JMSManagedConnection jMSManagedConnection = (JMSManagedConnection)e;
            ManagedConnectionFactory managedConnectionFactory = jMSManagedConnection.getManagedConnectionFactory();
            if (!Util.isEqual(jMSManagedConnection.getUserName(), string) || !managedConnectionFactory.equals(this) || !jMSManagedConnection.getConnectionRequestInfo().equals(connectionRequestInfo)) continue;
            JMSManagedConnectionFactory.printInfo(this.logWriter, this.clientName, "(ManagedConnectionFactory) Found a matched managed connection");
            return jMSManagedConnection;
        }
        return null;
    }

    public synchronized void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.logWriter = printWriter;
        try {
            if (this.factory != null) {
                this.factory.setLogWriter(printWriter);
            }
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException("Failed to set ManagedConnectionFactory's log writer");
            resourceException.setLinkedException(exception);
            throw resourceException;
        }
    }

    public synchronized PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public synchronized String getConnectionURL() {
        return this.url;
    }

    public synchronized void setConnectionURL(String string) {
        if (string != null && string.length() != 0) {
            this.url = string;
        }
    }

    public synchronized String getInitialContextFactory() {
        return this.icFactory;
    }

    public synchronized void setInitialContextFactory(String string) {
        this.icFactory = string;
    }

    public synchronized String getConnectionFactoryJNDI() {
        return this.cfJNDI;
    }

    public synchronized void setConnectionFactoryJNDI(String string) {
        if (this.cfJNDI == null) {
            this.cfJNDI = string;
        }
    }

    public synchronized String getConnectionFactoryJNDIName() {
        return this.cfJNDI;
    }

    public synchronized void setConnectionFactoryJNDIName(String string) {
        this.cfJNDI = string;
    }

    public synchronized String getDestinationJNDI() {
        return this.destJNDI;
    }

    public synchronized void setDestinationJNDI(String string) {
        if (this.destJNDI == null) {
            this.destJNDI = string;
        }
    }

    public synchronized String getDestinationJNDIName() {
        return this.destJNDI;
    }

    public synchronized void setDestinationJNDIName(String string) {
        this.destJNDI = string;
    }

    public synchronized String getDestinationType() {
        return this.destType;
    }

    public synchronized void setDestinationType(String string) {
        this.destType = string;
    }

    public synchronized String getAdapterType() {
        return this.adapterType;
    }

    public synchronized void setAdapterType(String string) {
        this.adapterType = string;
    }

    private AdapterConnection createConnectionInternal(ConnectionSpec connectionSpec, int n) throws JMSException {
        JMSBaseConnection jMSBaseConnection = null;
        try {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            boolean bl = false;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            ClassLoader classLoader = null;
            if (connectionSpec == null) {
                string4 = this.destJNDI;
                string = this.cfJNDI;
                string3 = this.url;
                string2 = this.icFactory;
                string5 = this.destType;
            } else if (connectionSpec instanceof JMSConnectionSpec) {
                JMSConnectionSpec jMSConnectionSpec = (JMSConnectionSpec)connectionSpec;
                string4 = jMSConnectionSpec.getDestJndi();
                if (string4 == null) {
                    string4 = this.destJNDI;
                }
                if ((string5 = jMSConnectionSpec.getDestType()) == null) {
                    string5 = this.destType;
                }
                if ((string3 = jMSConnectionSpec.getUrl()) == null) {
                    string3 = this.url;
                }
                if ((string2 = jMSConnectionSpec.getInitialContextFactory()) == null) {
                    string2 = this.icFactory;
                }
                if ((string = jMSConnectionSpec.getFactoryJndi()) == null) {
                    string = this.cfJNDI;
                }
                if ((string = jMSConnectionSpec.getFactoryJndi()) == null) {
                    string = this.cfJNDI;
                }
                string6 = jMSConnectionSpec.getSelector();
                this.clientName = jMSConnectionSpec.getName();
                bl = jMSConnectionSpec.getDurability();
                string7 = jMSConnectionSpec.getUser();
                string8 = jMSConnectionSpec.getPassword();
                string9 = jMSConnectionSpec.getClasspath();
            } else {
                throw new JMSException("Illegal ConnectionSpec format");
            }
            classLoader = (ClassLoader)this.classLoaders.get(string9);
            if (classLoader == null) {
                classLoader = new IsolatingClassLoader("JMS Interop Adapter Class Loader", JMSManagedConnectionFactory.getClassPath(string9), ISOLATING_PACKAGES, true);
                this.classLoaders.put(string9, classLoader);
            }
            jMSBaseConnection = new JMSBaseConnection(string7, string8, this, this.clientName, string3, string2, string, string4, string5, string6, bl, classLoader);
        }
        catch (JMSException jMSException) {
            Exception exception = jMSException.getLinkedException();
            JMSLogger.logStackTrace((Throwable)jMSException);
            if (exception != null) {
                JMSLogger.logStackTraceLinked((Throwable)exception);
            }
            throw jMSException;
        }
        catch (Throwable throwable) {
            JMSLogger.logStackTrace((Throwable)throwable);
            this.throwJMSException("Failed to get connection to an adapter", null);
        }
        return jMSBaseConnection;
    }

    private static URL[] getClassPath(String string) throws MalformedURLException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() <= 0) continue;
            arrayList.add(new File(string2).toURL());
        }
        return arrayList.toArray(new URL[0]);
    }

    private AdapterConnection createConnection(ConnectionSpec connectionSpec) throws JMSException {
        return this.createConnectionInternal(connectionSpec, 0);
    }

    private SourceConnection createSourceConnection(ConnectionSpec connectionSpec) throws JMSException {
        return (SourceConnection)this.createConnectionInternal(connectionSpec, 1);
    }

    private TargetConnection createTargetConnection(ConnectionSpec connectionSpec) throws JMSException {
        return (TargetConnection)this.createConnectionInternal(connectionSpec, 2);
    }

    synchronized boolean isWLSAdapter() {
        return this.icFactory.equals(JNDI_FACTORY);
    }

    private void throwJMSException(String string, Exception exception) throws JMSException {
        JMSException jMSException = new JMSException(string);
        if (exception != null) {
            jMSException.setLinkedException(exception);
        }
        throw jMSException;
    }

    public static synchronized void printInfo(PrintWriter printWriter, String string, String string2) {
        if (printWriter != null) {
            printWriter.checkError();
            long l = System.currentTimeMillis();
            Date date = new Date(l);
            printWriter.println("<" + dformat.format(date) + "> Info: " + string + " : " + string2);
        }
    }

    public static synchronized void printError(PrintWriter printWriter, String string, String string2) {
        if (printWriter != null) {
            printWriter.checkError();
            long l = System.currentTimeMillis();
            Date date = new Date(l);
            printWriter.println("<" + dformat.format(date) + "> Error: " + string + " : " + string2);
        }
    }

    public synchronized boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof JMSManagedConnectionFactory) {
            String string = ((JMSManagedConnectionFactory)object).url;
            String string2 = this.url;
            String string3 = ((JMSManagedConnectionFactory)object).icFactory;
            String string4 = this.icFactory;
            String string5 = ((JMSManagedConnectionFactory)object).cfJNDI;
            String string6 = this.cfJNDI;
            String string7 = ((JMSManagedConnectionFactory)object).destJNDI;
            String string8 = this.destJNDI;
            String string9 = ((JMSManagedConnectionFactory)object).destType;
            String string10 = this.destType;
            String string11 = ((JMSManagedConnectionFactory)object).adapterType;
            String string12 = this.adapterType;
            return (string == null ? string2 == null : string.equals(string2)) && (string3 == null ? string4 == null : string3.equals(string4)) && (string5 == null ? string6 == null : string5.equals(string6)) && (string7 == null ? string8 == null : string7.equals(string8)) && (string9 == null ? string10 == null : string9.equals(string10)) && (string11 == null ? string12 == null : string11.equals(string12));
        }
        return false;
    }

    public synchronized int hashCode() {
        String string = "";
        if (this.url != null) {
            string = string + this.url;
        }
        if (this.icFactory != null) {
            string = string + this.icFactory;
        }
        if (this.cfJNDI != null) {
            string = string + this.cfJNDI;
        }
        if (this.destJNDI != null) {
            string = string + this.destJNDI;
        }
        if (this.destType != null) {
            string = string + this.destType;
        }
        if (this.adapterType != null) {
            string = string + this.adapterType;
        }
        return string.hashCode();
    }

    static {
        MY_LOCALE = Locale.getDefault();
    }
}

