/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSBrowserCreateResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public final class BEBrowserCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 7172028677958484592L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int SELECTOR_MASK = 256;
    private JMSID destinationId;
    private String selector;

    public BEBrowserCreateRequest(JMSID jMSID, JMSID jMSID2, String string) {
        super(jMSID, 8464);
        this.destinationId = jMSID2;
        this.selector = string;
    }

    public final JMSID getDestinationId() {
        return this.destinationId;
    }

    public final String getSelector() {
        return this.selector;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return new JMSBrowserCreateResponse();
    }

    public BEBrowserCreateRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.selector != null) {
            n |= 0x100;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        this.destinationId.writeExternal(objectOutput);
        if (this.selector != null) {
            objectOutput.writeUTF(this.selector);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.destinationId = new JMSID();
        this.destinationId.readExternal(objectInput);
        if ((n & 0x100) != 0) {
            this.selector = objectInput.readUTF();
        }
    }
}

