/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEBrowser;
import weblogic.jms.backend.BEBrowserGetEnumerationRequest;
import weblogic.jms.backend.BEConnection;
import weblogic.jms.backend.BEEnumerationImpl;
import weblogic.jms.backend.BEQueueImpl;
import weblogic.jms.backend.BESession;
import weblogic.jms.common.JMSBrowserGetEnumerationResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.common.JMSSQLExpression;
import weblogic.jms.common.JMSSecurityException;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.TimedSecurityParticipant;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.jms.extensions.ConsumerClosedException;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.kernel.Expression;
import weblogic.messaging.kernel.InvalidExpressionException;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.Queue;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.work.WorkManagerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BEBrowserImpl
implements BEBrowser,
TimedSecurityParticipant {
    private final JMSID browserId;
    private final BESession session;
    private BEQueueImpl destination;
    private Queue queue;
    private Expression expression;
    private InvocableMonitor invocableMonitor;
    private boolean isClosed;
    private AuthenticatedSubject authenticatedSubject;
    private static final boolean debug = false;
    private final Map<JMSID, BEEnumerationImpl> enumerations = new HashMap<JMSID, BEEnumerationImpl>();

    BEBrowserImpl(BESession bESession, BEQueueImpl bEQueueImpl, Queue queue, String string) throws JMSException {
        bEQueueImpl.getJMSDestinationSecurity().checkBrowsePermission();
        this.session = bESession;
        this.browserId = JMSService.getJMSService().getNextId();
        this.destination = bEQueueImpl;
        this.queue = queue;
        this.authenticatedSubject = JMSSecurityHelper.getCurrentSubject();
        this.invocableMonitor = bESession == null ? bEQueueImpl.getBackEnd().getInvocableMonitor() : bESession.getInvocableMonitor();
        try {
            JMSSQLExpression jMSSQLExpression = new JMSSQLExpression(string);
            this.expression = queue.getFilter().createExpression((Object)jMSSQLExpression);
        }
        catch (InvalidExpressionException invalidExpressionException) {
            throw new InvalidSelectorException(invalidExpressionException.toString());
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }

    @Override
    public JMSID getJMSID() {
        return this.browserId;
    }

    @Override
    public ID getId() {
        return this.getJMSID();
    }

    BESession getSession() {
        return this.session;
    }

    @Override
    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    private int close(Request request) {
        this.close();
        request.setResult(VoidResponse.THE_ONE);
        request.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<BEEnumerationImpl> arrayList;
        Object object = this;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            arrayList = new ArrayList<BEEnumerationImpl>(this.enumerations.values());
            this.enumerations.clear();
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            ((BEEnumerationImpl)object.next()).close();
        }
        if (this.session == null) {
            InvocableManagerDelegate.delegate.invocableRemove(18, this.browserId);
        } else {
            this.session.browserRemove(this.browserId);
        }
        this.destination.removeBrowser(this.getJMSID());
    }

    private int enumerate(BEBrowserGetEnumerationRequest bEBrowserGetEnumerationRequest) throws JMSException {
        this.checkShutdownOrSuspended("enumerate browser");
        this.checkPermission();
        JMSID jMSID = JMSService.getJMSService().getNextId();
        BEEnumerationImpl bEEnumerationImpl = new BEEnumerationImpl(this, jMSID, this.queue, this.expression);
        this.enumerationAdd(bEEnumerationImpl);
        bEBrowserGetEnumerationRequest.setState(Integer.MAX_VALUE);
        bEBrowserGetEnumerationRequest.setResult(new JMSBrowserGetEnumerationResponse(jMSID));
        return Integer.MAX_VALUE;
    }

    private synchronized void enumerationAdd(BEEnumerationImpl bEEnumerationImpl) throws JMSException {
        InvocableManagerDelegate.delegate.invocableAdd(19, bEEnumerationImpl);
        this.enumerations.put(bEEnumerationImpl.getJMSID(), bEEnumerationImpl);
    }

    synchronized void enumerationRemove(JMSID jMSID) {
        this.enumerations.remove(jMSID);
        InvocableManagerDelegate.delegate.invocableRemove(19, jMSID);
    }

    void checkShutdownOrSuspended(String string) throws JMSException {
        if (this.isClosed()) {
            throw new weblogic.jms.common.JMSException("The browser is closed");
        }
        this.destination.checkShutdownOrSuspendedNeedLock(string);
    }

    @Override
    public void securityLapsed() {
        BEConnection bEConnection;
        BESession bESession = this.getSession();
        this.close();
        if (bESession != null && (bEConnection = bESession.getConnection()) != null) {
            try {
                JMSServerUtilities.anonDispatchNoReply(new JMSPushExceptionRequest(11, this.browserId, new ConsumerClosedException(null, "ERROR: Security has lapsed for this consumer")), bEConnection.getDispatcher());
            }
            catch (JMSException jMSException) {
                System.out.println("ERROR: Could not push security exception to queue browser: " + (Object)((Object)jMSException));
            }
        }
    }

    @Override
    public HashSet<?> getAcceptedDestinations() {
        return null;
    }

    private void checkPermission() throws JMSSecurityException {
        AuthenticatedSubject authenticatedSubject = JMSSecurityHelper.getCurrentSubject();
        if (!JMSService.getJMSService().isSecurityCheckerStop()) {
            if (!(this.authenticatedSubject == authenticatedSubject || this.authenticatedSubject != null && this.authenticatedSubject.equals((Object)authenticatedSubject))) {
                this.destination.getJMSDestinationSecurity().checkBrowsePermission(authenticatedSubject);
                this.setSubject(authenticatedSubject);
            }
        } else {
            try {
                this.destination.getJMSDestinationSecurity().checkBrowsePermission(this.authenticatedSubject);
            }
            catch (JMSSecurityException jMSSecurityException) {
                WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new BrowserCloseThread());
                throw jMSSecurityException;
            }
        }
    }

    private void checkPermission(boolean bl) throws JMSSecurityException {
        this.checkPermission();
        if (bl) {
            WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new BrowserCloseThread());
            throw new JMSSecurityException("security check simulation negative result");
        }
    }

    @Override
    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 8210: {
                return this.close(request);
            }
            case 8722: {
                return this.enumerate((BEBrowserGetEnumerationRequest)request);
            }
        }
        throw new weblogic.jms.common.JMSException("No such method " + this.getClass().getName() + "." + request.getMethodId());
    }

    private synchronized void setSubject(AuthenticatedSubject authenticatedSubject) {
        if (authenticatedSubject != null) {
            this.authenticatedSubject = authenticatedSubject;
        }
    }

    @Override
    public synchronized AuthenticatedSubject getSubject() {
        return this.authenticatedSubject;
    }

    private class BrowserCloseThread
    implements Runnable {
        private BrowserCloseThread() {
        }

        public void run() {
            BEBrowserImpl.this.securityLapsed();
        }
    }
}

