/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import javax.management.InvalidAttributeValueException;
import weblogic.jms.JMSLogger;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.FileStoreMBean;
import weblogic.management.configuration.JDBCStoreMBean;
import weblogic.management.configuration.JMSFileStoreMBean;
import weblogic.management.configuration.JMSJDBCStoreMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.JMSStoreMBean;
import weblogic.management.configuration.PersistentStoreMBean;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.UpdateException;

public class BEConfigUpdater
implements ConfigurationProcessor {
    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        try {
            int n;
            JMSServerMBean[] jMSServerMBeanArray = domainMBean.getJMSServers();
            for (n = 0; jMSServerMBeanArray != null && n < jMSServerMBeanArray.length; ++n) {
                this.updateJMSServer(domainMBean, jMSServerMBeanArray[n]);
            }
            JMSStoreMBean[] jMSStoreMBeanArray = domainMBean.getJMSStores();
            for (n = 0; jMSStoreMBeanArray != null && n < jMSStoreMBeanArray.length; ++n) {
                if (jMSStoreMBeanArray[n] instanceof JMSFileStoreMBean) {
                    this.updateFileStore(domainMBean, (JMSFileStoreMBean)jMSStoreMBeanArray[n]);
                    continue;
                }
                if (jMSStoreMBeanArray[n] instanceof JMSJDBCStoreMBean) {
                    this.updateJDBCStore(domainMBean, (JMSJDBCStoreMBean)jMSStoreMBeanArray[n]);
                    continue;
                }
                throw new AssertionError((Object)"Unknown JMSStoreMBean type");
            }
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new UpdateException(invalidAttributeValueException);
        }
        catch (ManagementException managementException) {
            throw new UpdateException(managementException);
        }
    }

    private void updateJMSServer(DomainMBean domainMBean, JMSServerMBean jMSServerMBean) throws InvalidAttributeValueException, ManagementException {
        ConfigurationMBean configurationMBean;
        ConfigurationMBean configurationMBean2;
        JMSStoreMBean jMSStoreMBean = jMSServerMBean.getStore();
        if (jMSStoreMBean != null) {
            jMSServerMBean.setStore(null);
            if (jMSStoreMBean instanceof JMSFileStoreMBean) {
                configurationMBean2 = (JMSFileStoreMBean)jMSStoreMBean;
                configurationMBean = this.updateFileStore(domainMBean, (JMSFileStoreMBean)configurationMBean2);
            } else if (jMSStoreMBean instanceof JMSJDBCStoreMBean) {
                configurationMBean2 = (JMSJDBCStoreMBean)jMSStoreMBean;
                configurationMBean = this.updateJDBCStore(domainMBean, (JMSJDBCStoreMBean)configurationMBean2);
            } else {
                throw new AssertionError((Object)"Unknown JMSStoreMBean type");
            }
            configurationMBean.setTargets(jMSServerMBean.getTargets());
            jMSServerMBean.setPersistentStore((PersistentStoreMBean)configurationMBean);
        } else if (jMSServerMBean.getPersistentStore() == null) {
            jMSServerMBean.setStoreEnabled(false);
        }
        configurationMBean = jMSServerMBean.getPagingStore();
        if (configurationMBean != null) {
            jMSServerMBean.setPagingStore(null);
            if (configurationMBean instanceof JMSFileStoreMBean) {
                JMSLogger.logReplacingJMSPagingStore((String)jMSServerMBean.getName());
                configurationMBean2 = (JMSFileStoreMBean)configurationMBean;
                jMSServerMBean.setPagingDirectory(configurationMBean2.getDirectory());
                domainMBean.destroyJMSFileStore((JMSFileStoreMBean)configurationMBean2);
            } else if (configurationMBean instanceof JMSJDBCStoreMBean) {
                JMSLogger.logReplacingJMSJDBCPagingStore((String)jMSServerMBean.getName());
            } else {
                throw new AssertionError((Object)"Unknown JMSStoreMBean type");
            }
        }
        if ((configurationMBean2 = jMSServerMBean.getTemporaryTemplate()) != null) {
            jMSServerMBean.setHostingTemporaryDestinations(true);
            jMSServerMBean.setTemporaryTemplateResource("interop-jms");
            jMSServerMBean.setTemporaryTemplateName(configurationMBean2.getName());
        } else if (jMSServerMBean.getTemporaryTemplateResource() == null && jMSServerMBean.getTemporaryTemplateName() == null) {
            jMSServerMBean.setHostingTemporaryDestinations(false);
        }
        if (!jMSServerMBean.isSet("AllowsPersistentDowngrade")) {
            jMSServerMBean.setAllowsPersistentDowngrade(true);
        }
    }

    private FileStoreMBean updateFileStore(DomainMBean domainMBean, JMSFileStoreMBean jMSFileStoreMBean) throws InvalidAttributeValueException, ManagementException {
        JMSLogger.logReplacingJMSFileStoreMBean((String)jMSFileStoreMBean.getName());
        FileStoreMBean fileStoreMBean = domainMBean.createFileStore(jMSFileStoreMBean.getName());
        if (jMSFileStoreMBean.getDirectory() != null) {
            fileStoreMBean.setDirectory(jMSFileStoreMBean.getDirectory());
        }
        if (jMSFileStoreMBean.getSynchronousWritePolicy() != null) {
            fileStoreMBean.setSynchronousWritePolicy(jMSFileStoreMBean.getSynchronousWritePolicy());
        } else {
            fileStoreMBean.setSynchronousWritePolicy("Direct-Write");
        }
        domainMBean.destroyJMSFileStore(jMSFileStoreMBean);
        return fileStoreMBean;
    }

    private JDBCStoreMBean updateJDBCStore(DomainMBean domainMBean, JMSJDBCStoreMBean jMSJDBCStoreMBean) throws InvalidAttributeValueException {
        JMSLogger.logReplacingJMSJDBCStoreMBean((String)jMSJDBCStoreMBean.getName());
        JDBCStoreMBean jDBCStoreMBean = domainMBean.createJDBCStore(jMSJDBCStoreMBean.getName());
        jDBCStoreMBean.setConnectionPool(jMSJDBCStoreMBean.getConnectionPool());
        if (jMSJDBCStoreMBean.getPrefixName() != null) {
            jDBCStoreMBean.setPrefixName(jMSJDBCStoreMBean.getPrefixName());
        }
        domainMBean.destroyJMSJDBCStore(jMSJDBCStoreMBean);
        return jDBCStoreMBean;
    }
}

