/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEConnectionConsumerCloseRequest;
import weblogic.jms.backend.BEConnectionConsumerCommon;
import weblogic.jms.backend.BEConnectionStartRequest;
import weblogic.jms.backend.BEConnectionStopRequest;
import weblogic.jms.backend.BEDestinationCommon;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BESession;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;

public final class BEConnection
implements Invocable,
JMSPeerGoneListener {
    private final HashMap connectionConsumers = new HashMap();
    private final HashMap sessions = new HashMap();
    private final HashMap tempDestinations = new HashMap();
    private long startStopSequenceNumber;
    private final JMSID connectionId;
    private JMSDispatcher feDispatcher;
    private final InvocableMonitor invocableMonitor;
    private boolean stopped = true;
    private int state = 0;
    private String connectionAddress = null;
    private transient int refCount;

    BEConnection(JMSDispatcher jMSDispatcher, JMSID jMSID, boolean bl, String string) {
        this.feDispatcher = jMSDispatcher;
        this.connectionId = jMSID;
        this.stopped = bl;
        this.connectionAddress = string;
        this.feDispatcher.addDispatcherPeerGoneListener(this);
        this.invocableMonitor = JMSService.getJMSService().getInvocableMonitor();
    }

    public synchronized long getStartStopSequenceNumber() {
        return this.startStopSequenceNumber;
    }

    public void setStartStopSequenceNumber(long l) {
        this.startStopSequenceNumber = l;
    }

    void setDispatcher(JMSDispatcher jMSDispatcher) {
        this.feDispatcher.removeDispatcherPeerGoneListener(this);
        this.feDispatcher = jMSDispatcher;
        jMSDispatcher.addDispatcherPeerGoneListener(this);
    }

    public JMSDispatcher getDispatcher() {
        return this.feDispatcher;
    }

    public String getAddress() {
        return this.connectionAddress;
    }

    public synchronized void tempDestinationAdd(BEDestinationImpl bEDestinationImpl) throws JMSException {
        this.checkShutdownOrSuspended("create temporary destiantion");
        JMSID jMSID = bEDestinationImpl.getJMSID();
        if (this.tempDestinations.get(jMSID) != null) {
            throw new weblogic.jms.common.JMSException("Temporary destination exists, " + jMSID);
        }
        this.tempDestinations.put(jMSID, bEDestinationImpl);
    }

    public synchronized void tempDestinationRemove(JMSID jMSID) throws JMSException {
        BEDestinationImpl bEDestinationImpl = (BEDestinationImpl)this.tempDestinations.remove(jMSID);
        if (bEDestinationImpl == null) {
            throw new weblogic.jms.common.JMSException("Temporary destination not found, " + jMSID);
        }
        if (this.needToClose()) {
            this.close();
        }
    }

    public synchronized void sessionAdd(BESession bESession) throws JMSException {
        this.checkShutdownOrSuspended("create session");
        this.sessions.put(bESession.getJMSID(), bESession);
        InvocableManagerDelegate.delegate.invocableAdd(16, bESession);
    }

    public synchronized void sessionRemove(JMSID jMSID) {
        this.sessions.remove(jMSID);
        InvocableManagerDelegate.delegate.invocableRemove(16, jMSID);
        if (this.needToClose()) {
            this.close();
        }
    }

    public synchronized void connectionConsumerAdd(BEConnectionConsumerCommon bEConnectionConsumerCommon) throws JMSException {
        this.checkShutdownOrSuspended("create connection consumer");
        this.connectionConsumers.put(bEConnectionConsumerCommon.getJMSID(), bEConnectionConsumerCommon);
        InvocableManagerDelegate.delegate.invocableAdd(17, bEConnectionConsumerCommon);
    }

    private void connectionConsumerClose(BEConnectionConsumerCloseRequest bEConnectionConsumerCloseRequest) throws JMSException {
        JMSID jMSID = bEConnectionConsumerCloseRequest.getConnectionConsumerId();
        BEConnectionConsumerCommon bEConnectionConsumerCommon = (BEConnectionConsumerCommon)InvocableManagerDelegate.delegate.invocableFind(17, jMSID);
        bEConnectionConsumerCommon.close();
        this.connectionConsumerRemove(jMSID);
    }

    private synchronized void connectionConsumerRemove(JMSID jMSID) {
        this.connectionConsumers.remove(jMSID);
        InvocableManagerDelegate.delegate.invocableRemove(17, jMSID);
        if (this.needToClose()) {
            this.close();
        }
    }

    private synchronized boolean needToClose() {
        return this.sessions.isEmpty() && this.tempDestinations.isEmpty() && this.connectionConsumers.isEmpty();
    }

    synchronized boolean isStopped() {
        return this.stopped;
    }

    synchronized void stop(long l, boolean bl) {
        if (this.startStopSequenceNumber >= l) {
            return;
        }
        this.startStopSequenceNumber = l;
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (bl) {
            this.state = 2;
        }
        for (Invocable invocable : this.sessions.values()) {
            invocable.stop();
        }
        for (Invocable invocable : this.connectionConsumers.values()) {
            invocable.stop();
        }
    }

    private void checkShutdownOrSuspended(String string) throws JMSException {
        if ((this.state & 0x1B) != 0) {
            throw new weblogic.jms.common.JMSException("Failed to " + string + " because JMS server shutdown or suspended");
        }
    }

    synchronized void checkShutdownOrSuspendedNeedLock(String string) throws JMSException {
        if ((this.state & 0x1B) != 0) {
            throw new weblogic.jms.common.JMSException("Failed to " + string + " bacause JMS server shutdown or suspended");
        }
    }

    public int incrementRefCount() {
        return ++this.refCount;
    }

    public int decrementRefCount() {
        return --this.refCount;
    }

    public void dispatcherPeerGone(Exception exception, Dispatcher dispatcher) {
        if (JMSDebug.JMSDispatcher.isDebugEnabled()) {
            JMSDebug.JMSDispatcher.debug("BEConnection.jmsPeerGone()");
        }
        this.peerGone();
    }

    private synchronized void peerGone() {
        JMSException jMSException = null;
        InvocableManagerDelegate.delegate.invocableRemove(15, this.connectionId);
        this.feDispatcher.removeDispatcherPeerGoneListener(this);
        Iterator iterator = ((HashMap)this.sessions.clone()).values().iterator();
        while (iterator.hasNext()) {
            try {
                ((BESession)iterator.next()).peerGone();
            }
            catch (JMSException jMSException2) {
                if (jMSException != null) continue;
                jMSException = jMSException2;
            }
        }
        for (Invocable invocable : ((HashMap)this.tempDestinations.clone()).values()) {
            try {
                ((BEDestinationImpl)invocable).deleteTempDestination();
                ((BEDestinationCommon)invocable).getBackEnd().removeDestination((BEDestinationImpl)invocable);
            }
            catch (JMSException jMSException3) {
                if (jMSException != null) continue;
                jMSException = jMSException3;
            }
        }
        iterator = ((HashMap)this.connectionConsumers.clone()).values().iterator();
        while (iterator.hasNext()) {
            try {
                Invocable invocable;
                invocable = (BEConnectionConsumerCommon)iterator.next();
                invocable.close();
                this.connectionConsumerRemove(invocable.getJMSID());
            }
            catch (JMSException jMSException4) {
                if (jMSException != null) continue;
                jMSException = jMSException4;
            }
        }
        if (jMSException != null) {
            JMSLogger.logJMSServerShutdownError((String)this.getDispatcher().getId().getName(), (String)jMSException.getMessage(), (Throwable)jMSException);
        }
    }

    private synchronized void close() {
        if (!this.needToClose()) {
            return;
        }
        InvocableManagerDelegate.delegate.invocableRemove(15, this.connectionId);
        this.feDispatcher.removeDispatcherPeerGoneListener(this);
    }

    synchronized void start(long l) throws JMSException {
        this.checkShutdownOrSuspended("start connection");
        if (this.startStopSequenceNumber >= l) {
            return;
        }
        this.startStopSequenceNumber = l;
        if (!this.stopped) {
            return;
        }
        this.stopped = false;
        for (Invocable invocable : this.sessions.values()) {
            invocable.start();
        }
        for (Invocable invocable : this.connectionConsumers.values()) {
            invocable.start();
        }
    }

    public JMSID getJMSID() {
        return this.connectionId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 9487: {
                this.start(((BEConnectionStartRequest)request).getStartStopSequenceNumber());
                break;
            }
            case 9743: {
                this.stop(((BEConnectionStopRequest)request).getStartStopSequenceNumber(), ((BEConnectionStopRequest)request).isStopForSuspend());
                break;
            }
            case 8975: {
                this.connectionConsumerClose((BEConnectionConsumerCloseRequest)request);
                break;
            }
            default: {
                throw new weblogic.jms.common.JMSException("No such method " + request.getMethodId());
            }
        }
        request.setResult(new VoidResponse());
        request.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("Connection");
        xMLStreamWriter.writeAttribute("id", this.connectionId != null ? this.connectionId.toString() : "");
        xMLStreamWriter.writeAttribute("state", JMSService.getStateName(this.state));
        xMLStreamWriter.writeAttribute("connectionAddress", this.connectionAddress != null ? this.connectionAddress : "");
        xMLStreamWriter.writeStartElement("Sessions");
        HashMap hashMap = (HashMap)this.sessions.clone();
        xMLStreamWriter.writeAttribute("currentCount", String.valueOf(hashMap.size()));
        for (BESession bESession : hashMap.values()) {
            bESession.dump(jMSDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }
}

