/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.ServerSessionPool;
import weblogic.jms.client.JMSServerSessionPool;
import weblogic.jms.common.JMSConnectionConsumerCreateResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.frontend.FEConnection;
import weblogic.messaging.dispatcher.Response;

public final class BEConnectionConsumerCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 7853725251347530328L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int ISDURABLE_MASK = 256;
    private static final int SELECTOR_MASK = 512;
    private static final int STOPPED_MASK = 1024;
    private JMSServerId backEndId;
    private JMSID connectionId;
    private FEConnection connection;
    private JMSID destinationId;
    private ServerSessionPool serverSessionPool;
    private boolean isDurable;
    private String messageSelector;
    private int messagesMaximum;
    private boolean stopped;
    private long startStopSequenceNumber;

    public BEConnectionConsumerCreateRequest(JMSServerId jMSServerId, JMSID jMSID, ServerSessionPool serverSessionPool, FEConnection fEConnection, JMSID jMSID2, boolean bl, String string, int n, boolean bl2, long l) {
        super(null, 9218);
        this.backEndId = jMSServerId;
        this.connectionId = jMSID;
        this.serverSessionPool = serverSessionPool;
        this.connection = fEConnection;
        this.destinationId = jMSID2;
        this.isDurable = bl;
        this.messageSelector = string;
        this.messagesMaximum = n;
        this.stopped = bl2;
        this.startStopSequenceNumber = l;
    }

    public final JMSServerId getBackEndId() {
        return this.backEndId;
    }

    public final JMSID getConnectionId() {
        return this.connectionId;
    }

    public final ServerSessionPool getServerSessionPool() {
        return this.serverSessionPool;
    }

    public final FEConnection getConnection() {
        return this.connection;
    }

    public final JMSID getDestinationId() {
        return this.destinationId;
    }

    public final boolean isDurable() {
        return this.isDurable;
    }

    public final String getMessageSelector() {
        return this.messageSelector;
    }

    public final int getMessagesMaximum() {
        return this.messagesMaximum;
    }

    public final boolean isStopped() {
        return this.stopped;
    }

    public final long getStartStopSequenceNumber() {
        return this.startStopSequenceNumber;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return new JMSConnectionConsumerCreateResponse();
    }

    public BEConnectionConsumerCreateRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.isDurable) {
            n |= 0x100;
        }
        if (this.stopped) {
            n |= 0x400;
        }
        if (this.messageSelector != null) {
            n |= 0x200;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        this.backEndId.writeExternal(objectOutput);
        this.connectionId.writeExternal(objectOutput);
        ((JMSServerSessionPool)this.serverSessionPool).writeExternal(objectOutput);
        this.destinationId.writeExternal(objectOutput);
        if (this.messageSelector != null) {
            objectOutput.writeUTF(this.messageSelector);
        }
        objectOutput.writeInt(this.messagesMaximum);
        objectOutput.writeLong(this.startStopSequenceNumber);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.backEndId = new JMSServerId();
        this.backEndId.readExternal(objectInput);
        this.connectionId = new JMSID();
        this.connectionId.readExternal(objectInput);
        this.serverSessionPool = new JMSServerSessionPool();
        ((JMSServerSessionPool)this.serverSessionPool).readExternal(objectInput);
        this.destinationId = new JMSID();
        this.destinationId.readExternal(objectInput);
        if ((n & 0x200) != 0) {
            this.messageSelector = objectInput.readUTF();
        }
        this.messagesMaximum = objectInput.readInt();
        this.startStopSequenceNumber = objectInput.readLong();
        this.isDurable = (n & 0x100) != 0;
        this.stopped = (n & 0x400) != 0;
    }
}

