/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.jms.backend.BEConnectionConsumerCommon;
import weblogic.jms.backend.BEConnectionConsumerRuntimeDelegate;
import weblogic.jms.backend.BEConsumerCreateRequest;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BEServerSession;
import weblogic.jms.backend.BESessionImpl;
import weblogic.jms.client.JMSServerSessionPool;
import weblogic.jms.client.SessionInternal;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.frontend.FESession;
import weblogic.management.configuration.JMSConnectionConsumerMBean;
import weblogic.messaging.kernel.Expression;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.ListenRequest;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;

public final class BEConnectionConsumerImpl
extends BEConsumerImpl
implements BEConnectionConsumerCommon {
    private ServerSessionPool sessionPool;
    private BEConnectionConsumerRuntimeDelegate delegate;

    BEConnectionConsumerImpl(JMSID jMSID, BEDestinationImpl bEDestinationImpl, ServerSessionPool serverSessionPool, Queue queue, Expression expression, String string, int n, long l, int n2) throws JMSException {
        super(bEDestinationImpl.getBackEnd());
        this.init(serverSessionPool);
        BEConsumerCreateRequest bEConsumerCreateRequest = new BEConsumerCreateRequest(null, null, jMSID, null, null, null, string, false, n, n2, l, null, null);
        super.init(null, bEDestinationImpl, queue, expression, n2, false, bEConsumerCreateRequest);
    }

    BEConnectionConsumerImpl(JMSID jMSID, BEDestinationImpl bEDestinationImpl, ServerSessionPool serverSessionPool, Queue queue, String string, boolean bl, String string2, String string3, int n, long l, int n2) throws JMSException {
        super(bEDestinationImpl.getBackEnd());
        this.init(serverSessionPool);
        BEConsumerCreateRequest bEConsumerCreateRequest = new BEConsumerCreateRequest(null, null, jMSID, string2, string3, null, string, bl, n, n2, l, null, null);
        super.init(null, bEDestinationImpl, queue, null, n2, false, bEConsumerCreateRequest);
    }

    private void init(ServerSessionPool serverSessionPool) {
        this.sessionPool = serverSessionPool;
        this.setStateFlag(4);
    }

    public void initialize(JMSConnectionConsumerMBean jMSConnectionConsumerMBean) throws JMSException {
        this.delegate = new BEConnectionConsumerRuntimeDelegate(this, jMSConnectionConsumerMBean);
    }

    public void close() throws JMSException {
        this.sessionPool = null;
        if (this.delegate != null) {
            this.delegate.close();
        }
        super.close(0L);
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        if (this.sessionPool == null) {
            throw new weblogic.jms.common.JMSException("ConnectionConsumer closed");
        }
        return this.sessionPool;
    }

    public synchronized int getMessagesMaximum() {
        return this.windowSize;
    }

    public synchronized void setMessagesMaximum(int n) {
        this.windowSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushMessages(List list) {
        ServerSession serverSession = null;
        ArrayList<MessageElement> arrayList = new ArrayList<MessageElement>(list.size());
        try {
            try {
                serverSession = this.getServerSessionPool().getServerSession();
                SessionInternal sessionInternal = (SessionInternal)serverSession.getSession();
                FESession fESession = (FESession)InvocableManagerDelegate.delegate.invocableFind(8, sessionInternal.getJMSID());
                fESession.setUpBackEndSession(this.destination.getDestinationImpl().getDispatcherId());
                BESessionImpl bESessionImpl = (BESessionImpl)InvocableManagerDelegate.delegate.invocableFind(16, sessionInternal.getJMSID());
                JMSDispatcher jMSDispatcher = JMSDispatcherManager.getLocalDispatcher();
                BESessionImpl bESessionImpl2 = bESessionImpl;
                synchronized (bESessionImpl2) {
                    for (MessageElement messageElement : list) {
                        boolean bl;
                        long l = bESessionImpl.getNextSequenceNumber();
                        messageElement.setUserSequenceNum(l);
                        messageElement.setUserData((Object)this);
                        arrayList.add(messageElement);
                        boolean bl2 = bl = this.allowsImplicitAcknowledge();
                        if (!bl2) {
                            bESessionImpl.addPendingMessage(messageElement, this);
                        }
                        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                            JMSDebug.JMSBackEnd.debug("Pushing " + messageElement.getMessage() + " as seq number " + l + ". implicitAcknowledge = " + bl2);
                        }
                        JMSPushEntry jMSPushEntry = new JMSPushEntry(null, this.id, l, 0L, messageElement.getDeliveryCount(), 0);
                        jMSPushEntry.setDispatcher(jMSDispatcher);
                        jMSPushEntry.setClientResponsibleForAcknowledge(bl);
                        MessageImpl messageImpl = (MessageImpl)messageElement.getMessage();
                        fESession.pushMessage(messageImpl, jMSPushEntry);
                        sessionInternal.setPipelineGeneration(0);
                        sessionInternal.pushMessage(messageImpl, jMSPushEntry);
                        this.adjustUnackedCount(1);
                        if (!bl2 || this.isKernelAutoAcknowledge()) continue;
                        try {
                            KernelRequest kernelRequest = this.queue.acknowledge(messageElement);
                            if (kernelRequest == null) continue;
                            kernelRequest.getResult();
                        }
                        catch (KernelException kernelException) {
                            if (!JMSDebug.JMSBackEnd.isDebugEnabled()) continue;
                            JMSDebug.JMSBackEnd.debug("Unexpected exception while implicitly acknowledging: " + (Object)((Object)kernelException), (Throwable)kernelException);
                        }
                    }
                    if (!arrayList.isEmpty()) {
                        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                            JMSDebug.JMSBackEnd.debug("Starting server session with " + arrayList.size() + " messages");
                        }
                        serverSession.start();
                    }
                    serverSession = null;
                }
                Object var20_22 = null;
                if (serverSession != null) {
                    ((BEServerSession)serverSession).goBackInPool();
                }
            }
            catch (JMSException jMSException) {
                block21: {
                    if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                        JMSDebug.JMSBackEnd.debug("Error pushing messages: " + (Object)((Object)jMSException), (Throwable)jMSException);
                    }
                    try {
                        KernelRequest kernelRequest = new KernelRequest();
                        this.listenRequest.getQueue().negativeAcknowledge(arrayList, this.getRedeliveryDelay(), kernelRequest);
                        kernelRequest.getResult();
                    }
                    catch (KernelException kernelException) {
                        if (!JMSDebug.JMSBackEnd.isDebugEnabled()) break block21;
                        JMSDebug.JMSBackEnd.debug("Error nacking kernel messages that were delivered", (Throwable)kernelException);
                    }
                }
                Object var20_23 = null;
                if (serverSession != null) {
                    ((BEServerSession)serverSession).goBackInPool();
                }
            }
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            if (serverSession != null) {
                ((BEServerSession)serverSession).goBackInPool();
            }
            throw throwable;
        }
    }

    public Runnable deliver(ListenRequest listenRequest, List list) {
        return this.deliver(list);
    }

    public Runnable deliver(ListenRequest listenRequest, MessageElement messageElement) {
        return this.deliver(messageElement);
    }

    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        JMSID jMSID;
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("ConnectionConsumer");
        this.dumpCommon(xMLStreamWriter);
        String string = "";
        if (this.sessionPool != null && this.sessionPool instanceof JMSServerSessionPool && (jMSID = ((JMSServerSessionPool)this.sessionPool).getServerSessionPoolId()) != null) {
            string = jMSID.toString();
        }
        xMLStreamWriter.writeAttribute("serverSessionPoolID", string);
        xMLStreamWriter.writeEndElement();
    }
}

