/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class BEConnectionStopRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -908887813148387129L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int STOP_FOR_SUSPEND = 256;
    private long startStopSequenceNumber;
    private boolean stopForSuspend;

    public BEConnectionStopRequest(JMSID jMSID, long l, boolean bl) {
        super(jMSID, 9743);
        this.startStopSequenceNumber = l;
        this.stopForSuspend = bl;
    }

    public final long getStartStopSequenceNumber() {
        return this.startStopSequenceNumber;
    }

    public final boolean isStopForSuspend() {
        return this.stopForSuspend;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public BEConnectionStopRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.stopForSuspend) {
            n |= 0x100;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.startStopSequenceNumber);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.startStopSequenceNumber = objectInput.readLong();
        if ((n & 0x100) != 0) {
            this.stopForSuspend = true;
        }
    }
}

