/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class BEConsumerCloseRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -785311104852028751L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private long lastSequenceNumber;

    public BEConsumerCloseRequest(JMSID jMSID, long l) {
        super(jMSID, 10001);
        this.lastSequenceNumber = l;
    }

    public final long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public BEConsumerCloseRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.lastSequenceNumber);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.lastSequenceNumber = objectInput.readLong();
    }
}

