/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.backend.BEConsumerCreateResponse;
import weblogic.jms.common.ConsumerReconnectInfo;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.store.PersistentHandle;

public final class BEConsumerCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 3890402952967020905L;
    private static final int EXTVERSION61 = 1;
    private static final int EXTVERSION92 = 2;
    private static final int EXTVERSION1033 = 3;
    private static final int EXTVERSION = 3;
    private static final int VERSION_MASK = 255;
    private static final int CLIENT_ID_MASK = 256;
    private static final int NAME_MASK = 512;
    private static final int SELECTOR_MASK = 1024;
    private static final int SUBJECT_MASK = 2048;
    private static final int RECONNECT_MASK = 4096;
    private JMSID beConnId;
    private JMSID consumerId;
    private String clientId;
    private String name;
    private JMSID destinationId;
    private String selector;
    private boolean noLocal;
    private int messagesMaximum;
    private int flag;
    private long redeliveryDelay;
    private String subject;
    private ConsumerReconnectInfo consumerReconnectInfo;
    private int clientIdPolicy = 0;
    private int subscriptionSharingPolicy = 0;
    private transient PersistentHandle persistentHandle;

    public BEConsumerCreateRequest(JMSID jMSID, JMSID jMSID2, JMSID jMSID3, String string, String string2, JMSID jMSID4, String string3, boolean bl, int n, int n2, long l, String string4, ConsumerReconnectInfo consumerReconnectInfo) {
        this(jMSID, jMSID2, jMSID3, string, 0, string2, jMSID4, string3, bl, n, n2, l, string4, consumerReconnectInfo, 0);
    }

    public BEConsumerCreateRequest(JMSID jMSID, JMSID jMSID2, JMSID jMSID3, String string, int n, String string2, JMSID jMSID4, String string3, boolean bl, int n2, int n3, long l, String string4, ConsumerReconnectInfo consumerReconnectInfo, int n4) {
        super(jMSID2, 10256);
        this.beConnId = jMSID;
        this.consumerId = jMSID3;
        this.clientId = string;
        this.name = string2;
        this.destinationId = jMSID4;
        this.selector = string3;
        this.noLocal = bl;
        this.messagesMaximum = n2;
        this.flag = n3;
        this.redeliveryDelay = l;
        this.subject = string4;
        this.consumerReconnectInfo = consumerReconnectInfo;
        this.clientIdPolicy = n;
        this.subscriptionSharingPolicy = n4;
    }

    public final JMSID getConsumerId() {
        return this.consumerId;
    }

    public final String getClientId() {
        return this.clientId;
    }

    final void setClientId(String string) {
        this.clientId = string;
    }

    public final String getName() {
        return this.name;
    }

    final void setName(String string) {
        this.name = string;
    }

    public final JMSID getDestinationId() {
        return this.destinationId;
    }

    final String getSelector() {
        return this.selector;
    }

    public final boolean getNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean bl) {
        this.noLocal = bl;
    }

    public final int getMessagesMaximum() {
        return this.messagesMaximum;
    }

    public final String getSubject() {
        return this.subject;
    }

    public final int getFlag() {
        return this.flag;
    }

    public final long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    final PersistentHandle getPersistentHandle() {
        return this.persistentHandle;
    }

    final void setPersistentHandle(PersistentHandle persistentHandle) {
        this.persistentHandle = persistentHandle;
    }

    public ConsumerReconnectInfo getConsumerReconnectInfo() {
        return this.consumerReconnectInfo;
    }

    void setClientIdPolicy(int n) {
        this.clientIdPolicy = n;
    }

    public final int getClientIdPolicy() {
        return this.clientIdPolicy;
    }

    void setSubscriptionSharingPolicy(int n) {
        this.subscriptionSharingPolicy = n;
    }

    public final int getSubscriptionSharingPolicy() {
        return this.subscriptionSharingPolicy;
    }

    public final void setConsumerReconnectInfo(ConsumerReconnectInfo consumerReconnectInfo) {
        this.consumerReconnectInfo = consumerReconnectInfo;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return new BEConsumerCreateResponse();
    }

    public BEConsumerCreateRequest() {
    }

    private byte getVersion(Object object) throws IOException {
        if (object instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)object).getPeerInfo();
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_61) < 0) {
                throw JMSUtilities.versionIOException(0, 1, 2);
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_920) < 0) {
                return 1;
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_1033) < 0) {
                return 3;
            }
        }
        return 3;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.getVersion(objectOutput = this.getVersionedStream(objectOutput));
        int n2 = n >= 2 && this.consumerReconnectInfo != null ? n | 0x1000 : n;
        if (this.clientId != null) {
            n2 |= 0x100;
        }
        if (this.name != null) {
            n2 |= 0x200;
        }
        if (this.selector != null) {
            n2 |= 0x400;
        }
        if (this.subject != null) {
            n2 |= 0x800;
        }
        objectOutput.writeInt(n2);
        super.writeExternal(objectOutput);
        this.beConnId.writeExternal(objectOutput);
        this.consumerId.writeExternal(objectOutput);
        this.destinationId.writeExternal(objectOutput);
        if (this.clientId != null) {
            objectOutput.writeUTF(this.clientId);
        }
        if (this.name != null) {
            objectOutput.writeUTF(this.name);
        }
        if (this.selector != null) {
            objectOutput.writeUTF(this.selector);
        }
        objectOutput.writeBoolean(this.noLocal);
        objectOutput.writeInt(this.messagesMaximum);
        objectOutput.writeInt(this.flag);
        objectOutput.writeLong(this.redeliveryDelay);
        if (this.subject != null) {
            objectOutput.writeUTF(this.subject);
        }
        if ((n2 & 0x1000) != 0) {
            this.consumerReconnectInfo.writeExternal(objectOutput);
        }
        if (n >= 3) {
            objectOutput.writeInt(this.clientIdPolicy);
            objectOutput.writeInt(this.subscriptionSharingPolicy);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1 && 2 != n2 && n2 != 3) {
            throw JMSUtilities.versionIOException(n2, 1, 3);
        }
        super.readExternal(objectInput);
        this.beConnId = new JMSID();
        this.beConnId.readExternal(objectInput);
        this.consumerId = new JMSID();
        this.consumerId.readExternal(objectInput);
        this.destinationId = new JMSID();
        this.destinationId.readExternal(objectInput);
        if ((n & 0x100) != 0) {
            this.clientId = objectInput.readUTF();
        }
        if ((n & 0x200) != 0) {
            this.name = objectInput.readUTF();
        }
        if ((n & 0x400) != 0) {
            this.selector = objectInput.readUTF();
        }
        this.noLocal = objectInput.readBoolean();
        this.messagesMaximum = objectInput.readInt();
        this.flag = objectInput.readInt();
        this.redeliveryDelay = objectInput.readLong();
        if ((n & 0x800) != 0) {
            this.subject = objectInput.readUTF();
        }
        if ((n & 0x1000) != 0) {
            this.consumerReconnectInfo = new ConsumerReconnectInfo();
            this.consumerReconnectInfo.readExternal(objectInput);
        }
        if (n2 >= 3) {
            this.clientIdPolicy = objectInput.readInt();
            this.subscriptionSharingPolicy = objectInput.readInt();
        }
    }
}

