/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.security.AccessController;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEConnection;
import weblogic.jms.backend.BEConsumerCloseRequest;
import weblogic.jms.backend.BEConsumerCommon;
import weblogic.jms.backend.BEConsumerCreateRequest;
import weblogic.jms.backend.BEConsumerIncrementWindowCurrentRequest;
import weblogic.jms.backend.BEConsumerIsActiveResponse;
import weblogic.jms.backend.BEConsumerReceiveRequest;
import weblogic.jms.backend.BEConsumerSetListenerRequest;
import weblogic.jms.backend.BEDeliveryList;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BEDurableSubscriberRuntimeMBeanImpl;
import weblogic.jms.backend.BEMessageManagementImpl;
import weblogic.jms.backend.BEQueueImpl;
import weblogic.jms.backend.BESessionAcknowledgeRequest;
import weblogic.jms.backend.BESessionImpl;
import weblogic.jms.backend.BETopicImpl;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.backend.MessageConsumerCreationEventImpl;
import weblogic.jms.backend.MessageConsumerDestroyEventImpl;
import weblogic.jms.common.ConsumerReconnectInfo;
import weblogic.jms.common.DispatcherCompletionListener;
import weblogic.jms.common.DurableSubscription;
import weblogic.jms.common.JMSConsumerReceiveResponse;
import weblogic.jms.common.JMSConsumerSetListenerResponse;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageEventLogListener;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSMessageLogHelper;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSSQLExpression;
import weblogic.jms.common.JMSSecurityException;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.NonDurableSubscription;
import weblogic.jms.common.SingularAggregatableManager;
import weblogic.jms.common.Subscription;
import weblogic.jms.common.TimedSecurityParticipant;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.jms.extensions.ConsumerClosedException;
import weblogic.jms.extensions.ConsumerInfo;
import weblogic.logging.jms.JMSMessageLogger;
import weblogic.management.ManagementException;
import weblogic.messaging.ID;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.kernel.Destination;
import weblogic.messaging.kernel.Event;
import weblogic.messaging.kernel.EventListener;
import weblogic.messaging.kernel.Expression;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelListener;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.ListenRequest;
import weblogic.messaging.kernel.Listener;
import weblogic.messaging.kernel.MessageAddEvent;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.MessageEvent;
import weblogic.messaging.kernel.MessageExpirationEvent;
import weblogic.messaging.kernel.MessageReceiveEvent;
import weblogic.messaging.kernel.MessageRedeliveryLimitEvent;
import weblogic.messaging.kernel.MessageRemoveEvent;
import weblogic.messaging.kernel.MessageSendEvent;
import weblogic.messaging.kernel.MultiListener;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.ReceiveRequest;
import weblogic.messaging.kernel.RedeliveryParameters;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.security.WLSPrincipals;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.PersistentHandle;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.internal.TransactionImpl;
import weblogic.work.WorkManager;
import weblogic.work.WorkManagerFactory;

public class BEConsumerImpl
extends BEDeliveryList
implements Listener,
BEConsumerCommon,
TimedSecurityParticipant,
RedeliveryParameters,
EventListener,
JMSMessageEventLogListener {
    protected JMSID id;
    private InvocableMonitor invocableMonitor;
    private static final AuthenticatedSubject KERNEL_ID;
    private static final int LOG_CONSUMERCREATE = 1;
    private static final int LOG_CONSUMERDESTROY = 2;
    private String name;
    private String clientId;
    private String subscriptionName;
    private boolean durableSubscriber;
    private boolean multicastSubscriber;
    private boolean supportsClientResponsible;
    private boolean kernelAutoAcknowledge;
    private BESessionImpl session;
    protected BEDestinationImpl destination;
    protected Queue queue;
    volatile Queue unsubscribeQueue;
    protected ListenRequest listenRequest;
    private ReceiveRequest receiveRequest;
    private Expression filterExpression;
    private String selector;
    private boolean noLocal;
    private PersistentHandle persistentHandle;
    private long redeliveryDelay;
    private BEDurableSubscriberRuntimeMBeanImpl runtimeMBean;
    private int state = 1;
    protected int windowSize;
    private int pendingWindowSpace;
    private int unackedMessageCount;
    private final Object stateLock = new Object();
    private String subscriberUserInfo = null;
    private static final String CLIENTID_DELIMITER = "cid_";
    private static final String SUBSCRIPTION_DELIMITER = "_sid_";
    private static final int BLOCKING_RECV_PENDING = 101;
    private static final int BLOCKING_RECV_COMPLETE = 102;
    protected static final int STATE_STOPPED = 1;
    protected static final int STATE_HAS_LISTENER = 4;
    protected static final int STATE_BLOCKING_RECV = 8;
    protected static final int STATE_CLOSED = 16;
    protected static final int STATE_READY_FOR_PUSH = 4;
    protected static final int FLAG_CLIENT_MAY_BE_RESPONSIBLE = 4;
    protected static final int FLAG_DURABLE = 8;
    protected static final int FLAG_MULTICAST_CONSUMER = 16;
    public int messageAddEventLogCount;
    public int messageSendEventLogCount;
    public int messageRemoveEventLogCount;
    public int messageReceiveEventLogCount;
    public int messageExpirationEventLogCount;
    public int messageRedeliveryLimitEventLogCount;
    private boolean isRegisteredForSecurity = false;
    private AuthenticatedSubject authenticatedSubject = null;
    private static final boolean debug = false;
    private ConsumerReconnectInfo consumerReconnectInfo;
    private int clientIdPolicy = 0;
    private int subscriptionSharingPolicy = 0;
    private Subscription subscription;
    static final long serialVersionUID = 6093048509284814987L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_JMS_Diagnostic_Volume_Before_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    protected BEConsumerImpl(BackEnd backEnd) {
        super(backEnd);
    }

    BEConsumerImpl(BESessionImpl bESessionImpl, BEDestinationImpl bEDestinationImpl, Queue queue, Expression expression, int n, boolean bl, BEConsumerCreateRequest bEConsumerCreateRequest) throws JMSException {
        super(bEDestinationImpl.getBackEnd());
        bEConsumerCreateRequest.setName(null);
        bEConsumerCreateRequest.setClientId(null);
        bEConsumerCreateRequest.setNoLocal(false);
        this.init(bESessionImpl, bEDestinationImpl, queue, expression, n, bl, bEConsumerCreateRequest);
    }

    BEConsumerImpl(BESessionImpl bESessionImpl, BEDestinationImpl bEDestinationImpl, Queue queue, int n, boolean bl, BEConsumerCreateRequest bEConsumerCreateRequest) throws JMSException {
        super(bEDestinationImpl.getBackEnd());
        this.init(bESessionImpl, bEDestinationImpl, queue, null, n, bl, bEConsumerCreateRequest);
    }

    private boolean isWlsKernelId() {
        return WLSPrincipals.isKernelUsername((String)JMSSecurityHelper.getSimpleAuthenticatedName());
    }

    protected void init(BESessionImpl bESessionImpl, BEDestinationImpl bEDestinationImpl, Queue queue, Expression expression, int n, boolean bl, BEConsumerCreateRequest bEConsumerCreateRequest) throws JMSException {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Initialize BEConsumer: destination=" + bEDestinationImpl + " subqueue = " + queue.getName() + " clientId =" + bEConsumerCreateRequest.getClientId() + " client Id policy = " + bEConsumerCreateRequest.getClientIdPolicy() + " selector=" + this.selector + " noLocal = " + this.noLocal);
        }
        this.authenticatedSubject = JMSSecurityHelper.getCurrentSubject();
        if (!this.isWlsKernelId()) {
            bEDestinationImpl.getJMSDestinationSecurity().checkReceivePermission(JMSSecurityHelper.getCurrentSubject());
            this.checkSecurityRegistration(bEDestinationImpl);
        }
        this.destination = bEDestinationImpl;
        this.unsubscribeQueue = this.queue = queue;
        this.closeStaleConsumerSession(bEConsumerCreateRequest);
        this.id = bEConsumerCreateRequest.getConsumerId();
        this.session = bESessionImpl;
        this.invocableMonitor = JMSService.getJMSService().getInvocableMonitor();
        this.setRedeliveryDelay(bEConsumerCreateRequest.getRedeliveryDelay());
        this.filterExpression = expression;
        this.selector = bEConsumerCreateRequest.getSelector();
        this.noLocal = bEConsumerCreateRequest.getNoLocal();
        this.subscriptionSharingPolicy = bEConsumerCreateRequest.getSubscriptionSharingPolicy();
        this.supportsClientResponsible = (n & 4) != 0;
        this.setWindowSize(bEConsumerCreateRequest.getMessagesMaximum());
        this.clientId = bEConsumerCreateRequest.getClientId();
        this.clientIdPolicy = bEConsumerCreateRequest.getClientIdPolicy();
        if (this.clientId != null && bEConsumerCreateRequest.getName() != null) {
            this.durableSubscriber = true;
            this.subscriptionName = bEConsumerCreateRequest.getName();
            this.name = BEConsumerImpl.clientIdPlusName(this.clientId, bEConsumerCreateRequest.getName(), this.clientIdPolicy, bEDestinationImpl.getName(), bEDestinationImpl.getBackEnd().getName());
            this.registerDurableSubscription(bl);
        } else if (this.clientId != null) {
            this.name = this.clientId;
            this.addNonDurableSubscription();
        } else {
            this.name = null;
            this.subscriptionName = bEConsumerCreateRequest.getName();
        }
        if ((n & 0x10) != 0) {
            this.multicastSubscriber = true;
        }
        this.subscriberUserInfo = JMSMessageLogHelper.addSubscriberInfo(this) + "#" + (bEConsumerCreateRequest.getSubject() != null ? bEConsumerCreateRequest.getSubject() : JMSSecurityHelper.getSimpleAuthenticatedName());
        if (!bl) {
            this.logEvent(1);
        }
    }

    private void closeStaleConsumerSession(BEConsumerCreateRequest bEConsumerCreateRequest) throws JMSException {
        long l;
        BEConsumerImpl bEConsumerImpl;
        if (bEConsumerCreateRequest.getConsumerReconnectInfo() == null || bEConsumerCreateRequest.getConsumerReconnectInfo().getInvokableID() == null) {
            return;
        }
        try {
            bEConsumerImpl = (BEConsumerImpl)InvocableManagerDelegate.delegate.invocableFind(17, bEConsumerCreateRequest.getConsumerReconnectInfo().getInvokableID());
        }
        catch (JMSException jMSException) {
            return;
        }
        if (bEConsumerImpl == null || bEConsumerImpl.invalidateReconnectingConsumer(bEConsumerCreateRequest)) {
            return;
        }
        JMSMessageId jMSMessageId = bEConsumerCreateRequest.getConsumerReconnectInfo().getLastAckMsgId();
        if (jMSMessageId != null && (l = bEConsumerImpl.getSession().sequenceFromMsgId(jMSMessageId)) != Long.MAX_VALUE) {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("refreshed consumer ack stale " + l);
            }
            JMSDispatcherManager.getLocalDispatcher().dispatchSyncNoTran(new BESessionAcknowledgeRequest(bEConsumerImpl.getSession().getJMSID(), l));
        }
        if (this.destination instanceof BETopicImpl && bEConsumerCreateRequest.getPersistentHandle() == null && bEConsumerCreateRequest.getName() == null) {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("transplant stale non-durable " + bEConsumerImpl);
            }
            bEConsumerImpl.unsubscribeQueue = this.queue;
            this.queue = bEConsumerImpl.queue;
            return;
        }
        if (bEConsumerCreateRequest.getConsumerReconnectInfo().getLastExposedMsgId() != null) {
            bEConsumerImpl.getSession().close(bEConsumerCreateRequest.getConsumerReconnectInfo().getLastExposedMsgId());
        } else {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("closing stale session " + bEConsumerImpl.getSession().getJMSID());
            }
            bEConsumerImpl.getSession().close();
        }
    }

    synchronized ConsumerReconnectInfo registerConsumerReconnectInfo(ConsumerReconnectInfo consumerReconnectInfo) {
        if (consumerReconnectInfo == null) {
            this.consumerReconnectInfo = null;
            return null;
        }
        consumerReconnectInfo = consumerReconnectInfo.getClone();
        consumerReconnectInfo.setInvokableID(this.getJMSID());
        consumerReconnectInfo.setServerDestId(this.destination.getJMSID());
        consumerReconnectInfo.setServerDispatcherId(JMSDispatcherManager.getLocalDispatcher().getId());
        this.consumerReconnectInfo = consumerReconnectInfo;
        return consumerReconnectInfo.getClone();
    }

    private boolean invalidateReconnectingConsumer(BEConsumerCreateRequest bEConsumerCreateRequest) {
        ConsumerReconnectInfo consumerReconnectInfo = bEConsumerCreateRequest.getConsumerReconnectInfo();
        if (this.consumerReconnectInfo == null) {
            return true;
        }
        return !this.consumerReconnectInfo.getClientJMSID().equals(consumerReconnectInfo.getClientJMSID()) || !this.destination.getJMSID().equals(consumerReconnectInfo.getServerDestId()) || !this.consumerReconnectInfo.getClientDispatcherId().equals(consumerReconnectInfo.getClientDispatcherId()) || !JMSDispatcherManager.getLocalDispatcher().getId().equals(consumerReconnectInfo.getServerDispatcherId());
    }

    synchronized long getDelayServerClose() {
        if (this.consumerReconnectInfo == null) {
            return 0L;
        }
        return this.consumerReconnectInfo.getDelayServerClose();
    }

    private void logEvent(int n) {
        if (_WLDF$INST_FLD_JMS_Diagnostic_Volume_Before_Medium.isEnabledAndNotDyeFiltered()) {
            Object[] objectArray = null;
            if (_WLDF$INST_FLD_JMS_Diagnostic_Volume_Before_Medium.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, InstrumentationSupport.convertToObject((int)n)};
            }
            DynamicJoinPoint dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JMS_Diagnostic_Volume_Before_Medium;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (n == 1) {
            if (this.destination.isMessageLoggingEnabled() && (this.destination instanceof BEQueueImpl || this.isDurable() || JMSService.getJMSService().shouldMessageLogNonDurableSubscriber())) {
                JMSMessageLogHelper.logMessageEvent(this, (Event)new MessageConsumerCreationEventImpl(null, (Destination)this.queue, this.selector, this.subscriberUserInfo));
            }
        } else if (n == 2 && this.destination.isMessageLoggingEnabled() && (this.destination instanceof BEQueueImpl || this.isDurable() || JMSService.getJMSService().shouldMessageLogNonDurableSubscriber())) {
            JMSMessageLogHelper.logMessageEvent(this, (Event)new MessageConsumerDestroyEventImpl(null, (Destination)this.queue, this.subscriberUserInfo));
        }
    }

    public static String clientIdPlusName(String string, String string2) {
        return BEConsumerImpl.clientIdPlusName(string, string2, 0, null, null);
    }

    public static String clientIdPlusName(String string, String string2, int n, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CLIENTID_DELIMITER);
        stringBuffer.append(string);
        stringBuffer.append(SUBSCRIPTION_DELIMITER);
        stringBuffer.append(string2);
        if (n == 1 && string3 != null) {
            stringBuffer.append("@" + string3 + "@" + string4);
        }
        return stringBuffer.toString();
    }

    public static String JNDINameForSubscription(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("weblogic.jms.internal.subscription");
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    Queue getKernelQueue() {
        return this.queue;
    }

    public Queue getUnsubscribeQueue() {
        return this.unsubscribeQueue;
    }

    synchronized Subscription getSubscription() {
        return this.subscription;
    }

    synchronized void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public String getClientID() {
        return this.clientId;
    }

    public int getClientIdPolicy() {
        return this.clientIdPolicy;
    }

    public BEDestinationImpl getDestination() {
        return this.destination;
    }

    public String getSelector() {
        return this.selector;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    PersistentHandle getPersistentHandle() {
        return this.persistentHandle;
    }

    void setPersistentHandle(PersistentHandle persistentHandle) {
        this.persistentHandle = persistentHandle;
    }

    boolean isKernelAutoAcknowledge() {
        return this.kernelAutoAcknowledge;
    }

    public int getSubscriptionSharingPolicy() {
        return this.subscriptionSharingPolicy;
    }

    public long getMessagesUnackedCount() {
        return this.queue == null ? 0L : (long)this.queue.getStatistics().getMessagesPending();
    }

    public long getMessagesReceivedCount() {
        return this.queue == null ? 0L : (long)this.queue.getStatistics().getMessagesReceived();
    }

    public long getBytesUnackedCount() {
        return this.queue == null ? 0L : this.queue.getStatistics().getBytesPending();
    }

    public long getBytesCurrentCount() {
        if (this.queue == null) {
            return 0L;
        }
        return this.queue.getStatistics().getBytesCurrent() - this.queue.getStatistics().getBytesPending();
    }

    public long getLastMessagesReceivedTime() {
        return this.queue == null ? 0L : this.queue.getLastMessagesReceivedTime();
    }

    public int getSize() {
        if (this.queue == null) {
            return 0;
        }
        return this.queue.getStatistics().getMessagesCurrent() - this.queue.getStatistics().getMessagesPending();
    }

    public int getHighSize() {
        return this.queue == null ? 0 : this.queue.getStatistics().getMessagesHigh();
    }

    private void setWindowSize(int n) {
        this.windowSize = n < 0 ? Integer.MAX_VALUE : n;
    }

    public void close(long l) throws JMSException {
        if (!this.checkStateFlag(16)) {
            this.stop();
            if (this.session != null) {
                this.session.removeConsumer(this, l);
            }
            this.closeInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeWithError(String string) throws JMSException {
        if (!this.checkStateFlag(16)) {
            this.stop();
            try {
                if (this.session != null) {
                    ConsumerClosedException consumerClosedException = new ConsumerClosedException(null, string);
                    this.session.removeConsumerWithError(this, 0L, consumerClosedException);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.closeInternal();
                throw throwable;
            }
            this.closeInternal();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal() throws JMSException {
        if (this.checkStateFlag(8) && this.receiveRequest != null) {
            this.receiveRequest.cancel();
        }
        if (!this.durableSubscriber) {
            this.removeConsumer(false);
            this.logEvent(2);
        } else {
            DurableSubscription durableSubscription = this.destination.getBackEnd().getDurableSubscription(this.name);
            if (durableSubscription != null) {
                boolean bl = false;
                DurableSubscription durableSubscription2 = durableSubscription;
                synchronized (durableSubscription2) {
                    durableSubscription.removeSubscriber(this.getJMSID());
                    if (durableSubscription.getSubscribersCount() > 0) {
                        bl = true;
                    }
                }
                if (bl) {
                    ((BETopicImpl)this.destination).removeConsumer(this, false, true);
                }
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.clearStateFlag(12);
                this.setStateFlag(16);
            }
        }
    }

    private void removeConsumer(boolean bl) throws JMSException {
        this.setStateFlag(16);
        this.destination.removeConsumer(this, bl);
    }

    public JMSID getJMSID() {
        return this.id;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public BESessionImpl getSession() {
        return this.session;
    }

    public boolean isDurable() {
        return this.durableSubscriber;
    }

    boolean isMulticastSubscriber() {
        return this.multicastSubscriber;
    }

    public boolean isActive() {
        return this.checkStateFlag(12);
    }

    public boolean isUsed() {
        return !this.checkStateFlag(16);
    }

    public BEDurableSubscriberRuntimeMBeanImpl getDurableSubscriberMbean() {
        return this.runtimeMBean;
    }

    public long getRedeliveryDelay() {
        long l = this.destination.getDirtyRedeliveryDelayOverride();
        return l >= 0L ? l : this.redeliveryDelay;
    }

    synchronized void setRedeliveryDelay(long l) {
        this.redeliveryDelay = l < 0L ? 0L : l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStateFlag(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            this.state |= n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasListener() {
        Object object = this.stateLock;
        synchronized (object) {
            return (this.state & 4) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearStateFlag(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            this.state &= ~n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkStateFlag(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            return (this.state & n) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReadyForPush() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustUnackedCount(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            this.unackedMessageCount += n;
        }
    }

    private void adjustUnackedCountTransactionally(Transaction transaction, int n) throws JMSException {
        CountAdjuster countAdjuster = new CountAdjuster(-n, false, false);
        try {
            transaction.registerSynchronization((Synchronization)countAdjuster);
        }
        catch (RollbackException rollbackException) {
            countAdjuster.afterCompletion(1);
        }
        catch (IllegalStateException illegalStateException) {
            countAdjuster.afterCompletion(1);
        }
        catch (SystemException systemException) {
            throw new weblogic.jms.common.JMSException(systemException);
        }
    }

    private void addNonDurableSubscription() {
        NonDurableSubscription nonDurableSubscription = new NonDurableSubscription(this.clientId, this.destination.getDestinationImpl(), this.selector, this.noLocal, this.clientIdPolicy, this.subscriptionSharingPolicy, this.queue.getName());
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Adding non-durable sub: clientId = " + this.clientId + " destination = " + this.destination.getDestinationImpl() + " selector = " + this.selector + " noLocal =  " + this.noLocal + " clientIdPolicy = " + this.clientIdPolicy + " subscriptionSharingPolicy = " + this.subscriptionSharingPolicy + " subQueueName = " + this.queue.getName());
        }
        this.setSubscription(((BETopicImpl)this.destination).addSharableNonDurableSubscriber(nonDurableSubscription));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerDurableSubscription(boolean bl) throws JMSException {
        DurableSubscription durableSubscription = null;
        boolean bl2 = false;
        while (true) {
            Object object = this.destination.getBackEnd().getDurableSubscriptionsMap();
            synchronized (object) {
                durableSubscription = this.destination.getBackEnd().getDurableSubscription(this.name);
                if (durableSubscription == null) {
                    durableSubscription = new DurableSubscription(this.name, this.destination.getDestinationImpl(), this.selector, this.noLocal, this.clientIdPolicy, this.subscriptionSharingPolicy);
                    bl2 = true;
                    this.destination.getBackEnd().addDurableSubscription(this.name, durableSubscription);
                }
            }
            object = durableSubscription;
            synchronized (object) {
                if (bl2) {
                    this.setSubscription(durableSubscription);
                    this.createDurableSubscription(durableSubscription, bl);
                    durableSubscription.addSubscriber(this);
                    return;
                }
                if (durableSubscription.isPending()) {
                    durableSubscription.incrementWaits();
                    try {
                        durableSubscription.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    durableSubscription.decrementWaits();
                }
                if (!durableSubscription.isStale()) break;
            }
        }
        {
            if (this.subscriptionSharingPolicy == 0) {
                throw new JMSException("Durable subscription " + this.subscriptionName + " is in use and cannot be shared");
            }
            this.persistentHandle = durableSubscription.getConsumer().getPersistentHandle();
            durableSubscription.addSubscriber(this);
            this.runtimeMBean = durableSubscription.getConsumer().getDurableSubscriberMbean();
            this.setSubscription(durableSubscription);
            return;
        }
    }

    private void createDurableSubscription(DurableSubscription durableSubscription, boolean bl) throws JMSException {
        boolean bl2 = false;
        boolean bl3 = false;
        JMSSQLExpression jMSSQLExpression = null;
        jMSSQLExpression = new JMSSQLExpression(this.selector, this.noLocal, this.session == null ? null : this.session.getConnection().getJMSID(), this.clientId, this.clientIdPolicy);
        if (!bl && this.backEnd.isStoreEnabled()) {
            this.persistentHandle = this.backEnd.getDurableSubscriptionStore().createSubscription(this.destination.getName(), this.clientId, this.clientIdPolicy, this.subscriptionName, jMSSQLExpression);
        }
        if (this.clientIdPolicy == 0) {
            try {
                SingularAggregatableManager singularAggregatableManager = SingularAggregatableManager.findOrCreate();
                String string = singularAggregatableManager.singularBind(BEConsumerImpl.JNDINameForSubscription(this.name), durableSubscription);
                if (string != null) {
                    throw new NameAlreadyBoundException(string);
                }
                bl2 = true;
            }
            catch (NamingException namingException) {
                throw new weblogic.jms.common.JMSException("Error creating durable subscriber", (Throwable)namingException);
            }
        }
        SecurityServiceManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID);
        try {
            try {
                this.runtimeMBean = new BEDurableSubscriberRuntimeMBeanImpl(this.getDurableSubscriptionRuntimeMBeanName(this.clientId, this.subscriptionName, this.destination), this.destination, this);
            }
            catch (ManagementException managementException) {
                throw new weblogic.jms.common.JMSException("Error registering durable subscriber RuntimeMBean", (Throwable)managementException);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
            throw throwable;
        }
        SecurityServiceManager.popSubject((AuthenticatedSubject)KERNEL_ID);
        this.runtimeMBean.setMessageManagementDelegate(new BEMessageManagementImpl(this.name, this.queue, this.destination, this.runtimeMBean));
    }

    synchronized void restore(BEConsumerCreateRequest bEConsumerCreateRequest, BESessionImpl bESessionImpl, boolean bl) throws JMSException {
        if (!this.checkStateFlag(1)) {
            throw new AssertionError((Object)"Restarting a consumer that was not stopped");
        }
        this.id = bEConsumerCreateRequest.getConsumerId();
        this.session = bESessionImpl;
        this.subscriptionSharingPolicy = bEConsumerCreateRequest.getSubscriptionSharingPolicy();
        this.checkSecurityRegistration(this.destination);
        this.checkPermission(this.destination, true, true);
        this.clearStateFlag(16);
        DurableSubscription durableSubscription = this.destination.getBackEnd().getDurableSubscription(this.name);
        if (durableSubscription != null) {
            durableSubscription.addSubscriber(this);
        }
        this.setWindowSize(bEConsumerCreateRequest.getMessagesMaximum());
        this.subscriberUserInfo = JMSMessageLogHelper.addSubscriberInfo(this) + "#" + (bEConsumerCreateRequest.getSubject() != null ? bEConsumerCreateRequest.getSubject() : JMSSecurityHelper.getSimpleAuthenticatedName());
        if (bl) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSecurityRegistration(BEDestinationImpl bEDestinationImpl) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isRegisteredForSecurity || this.isWlsKernelId()) {
                return;
            }
            this.isRegisteredForSecurity = true;
        }
        JMSService.getJMSService().registerSecurityParticipant(bEDestinationImpl.getJMSDestinationSecurity().getJMSResourceForReceive(), this);
    }

    public void delete(boolean bl, boolean bl2) throws JMSException {
        this.delete(bl, bl2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(boolean bl, boolean bl2, boolean bl3) throws JMSException {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Deleting a durable subiscriber " + this);
        }
        if (this.checkStateFlag(12)) {
            throw new weblogic.jms.common.JMSException("Active topicSubscriber is using this subscription right now");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (bl2 && this.unackedMessageCount > 0) {
                throw new weblogic.jms.common.JMSException("Subscription " + this.name + " in use, uncommitted/unacknowleged messages " + this.unackedMessageCount);
            }
        }
        this.cleanupDurableSubscription(true, bl, true, false, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDurableSubscription() throws JMSException {
        try {
            this.close(0L);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.cleanupDurableSubscription(true, false, false, false, true);
            throw throwable;
        }
        this.cleanupDurableSubscription(true, false, false, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanupDurableSubscription(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws JMSException {
        if (!this.durableSubscriber) {
            throw new weblogic.jms.common.JMSException("Not a durable subscription");
        }
        DurableSubscription durableSubscription = null;
        Map map = this.destination.getBackEnd().getDurableSubscriptionsMap();
        synchronized (map) {
            if (!bl5) {
                durableSubscription = this.destination.getBackEnd().getDurableSubscription(this.name);
                if (durableSubscription == null) {
                    throw new weblogic.jms.common.JMSException("Subscription not found");
                }
                DurableSubscription durableSubscription2 = durableSubscription;
                synchronized (durableSubscription2) {
                    if (durableSubscription.isPending() || durableSubscription.getSubscribersCount() > 0) {
                        throw new weblogic.jms.common.JMSException("Subscription " + this.name + " is in use");
                    }
                    if (durableSubscription.isStale()) {
                        throw new weblogic.jms.common.JMSException("Subscription " + this.name + " is not found");
                    }
                    durableSubscription.setPending(true);
                }
            } else {
                while (true) {
                    if ((durableSubscription = this.destination.getBackEnd().getDurableSubscription(this.name)) == null) {
                        return;
                    }
                    DurableSubscription durableSubscription3 = durableSubscription;
                    synchronized (durableSubscription3) {
                        if (durableSubscription.isStale()) {
                            return;
                        }
                        if (!durableSubscription.isPending()) break;
                        durableSubscription.incrementWaits();
                        try {
                            durableSubscription.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        durableSubscription.decrementWaits();
                    }
                }
                {
                    if (durableSubscription.isStale()) {
                        return;
                    }
                    durableSubscription.setPending(true);
                }
            }
        }
        this.doDurableSubscriptionCleanup(durableSubscription, bl, bl2, bl3, bl4);
        this.logEvent(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void doDurableSubscriptionCleanup(DurableSubscription durableSubscription, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws JMSException {
        Object v1;
        Object v0;
        block35: {
            if (bl2 || this.runtimeMBean == null) break block35;
            BEDurableSubscriberRuntimeMBeanImpl bEDurableSubscriberRuntimeMBeanImpl = this.runtimeMBean;
            this.runtimeMBean = null;
            PrivilegedActionUtilities.unregister(bEDurableSubscriberRuntimeMBeanImpl, KERNEL_ID);
        }
        Object var9_8 = null;
        try {
            if (bl3) {
                this.removeConsumer(bl4);
            }
            v0 = null;
        }
        catch (Throwable throwable) {
            v0 = null;
        }
        Object var12_14 = v0;
        try {
            if (bl && this.clientIdPolicy == 0) {
                SingularAggregatableManager singularAggregatableManager = SingularAggregatableManager.findOrCreate();
                singularAggregatableManager.singularUnbind(BEConsumerImpl.JNDINameForSubscription(this.name));
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            v1 = null;
        }
        Object var15_22 = v1;
        Map map = this.destination.getBackEnd().getDurableSubscriptionsMap();
        synchronized (map) {
            this.destination.getBackEnd().removeDurableSubscription(this.name);
            DurableSubscription durableSubscription2 = durableSubscription;
            synchronized (durableSubscription2) {
                durableSubscription.setStale(true);
                if (durableSubscription.isPending()) {
                    durableSubscription.setPending(false);
                    if (durableSubscription.hasWaits()) {
                        durableSubscription.notifyAll();
                    }
                }
            }
        }
        {
            catch (ManagementException managementException) {
                Throwable throwable = managementException.getNestedException();
                if (throwable == null) {
                    throwable = managementException;
                }
                throw new weblogic.jms.common.JMSException("Error closing durable subscription. " + throwable.getMessage(), (Throwable)managementException);
            }
        }
        catch (Throwable throwable) {
            Object v3;
            Object v2;
            Object var9_9 = null;
            try {
                if (bl3) {
                    this.removeConsumer(bl4);
                }
                v2 = null;
            }
            catch (Throwable throwable2) {
                v2 = null;
            }
            Object var12_15 = v2;
            try {
                if (bl && this.clientIdPolicy == 0) {
                    SingularAggregatableManager singularAggregatableManager = SingularAggregatableManager.findOrCreate();
                    singularAggregatableManager.singularUnbind(BEConsumerImpl.JNDINameForSubscription(this.name));
                }
                v3 = null;
            }
            catch (Throwable throwable3) {
                v3 = null;
            }
            Object var15_23 = v3;
            Map map2 = this.destination.getBackEnd().getDurableSubscriptionsMap();
            synchronized (map2) {
                this.destination.getBackEnd().removeDurableSubscription(this.name);
                DurableSubscription durableSubscription3 = durableSubscription;
                synchronized (durableSubscription3) {
                    durableSubscription.setStale(true);
                    if (durableSubscription.isPending()) {
                        durableSubscription.setPending(false);
                        if (durableSubscription.hasWaits()) {
                            durableSubscription.notifyAll();
                        }
                    }
                }
            }
            throw throwable;
        }
    }

    protected boolean allowsImplicitAcknowledge() {
        if (this.session == null) {
            return false;
        }
        if (!this.supportsClientResponsible) {
            return false;
        }
        if (!this.session.allowsImplicitAcknowledge()) {
            return false;
        }
        if (this.getRedeliveryDelay() != 0L) {
            return false;
        }
        if (this.destination.getDirtyRedeliveryLimit() >= 0 && this.destination.getDirtyRedeliveryLimit() != Integer.MAX_VALUE) {
            return false;
        }
        return this.subscriptionSharingPolicy != 1 || this.clientId == null;
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 11025: {
                this.destination.checkShutdownOrSuspendedNeedLock("receive message");
                return this.receive((BEConsumerReceiveRequest)request);
            }
            case 10001: {
                this.close(((BEConsumerCloseRequest)request).getLastSequenceNumber());
                break;
            }
            case 11281: {
                return this.setListener((BEConsumerSetListenerRequest)request);
            }
            case 10513: {
                this.destination.checkShutdownOrSuspendedNeedLock("increment consumer window");
                this.incrementWindowCurrent((BEConsumerIncrementWindowCurrentRequest)request);
                break;
            }
            case 10769: {
                request.setResult(new BEConsumerIsActiveResponse(this.isActive()));
                request.setState(Integer.MAX_VALUE);
                return Integer.MAX_VALUE;
            }
            case 17169: {
                throw new AssertionError((Object)"Not implemented");
            }
            default: {
                throw new AssertionError((Object)("No such method " + request.getMethodId()));
            }
        }
        request.setResult(VoidResponse.THE_ONE);
        request.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean blockingReceiveStart(BEConsumerReceiveRequest bEConsumerReceiveRequest) throws JMSException {
        boolean bl;
        bEConsumerReceiveRequest.setTransaction((TransactionImpl)TransactionHelper.getTransactionHelper().getTransaction());
        Object object = this.stateLock;
        synchronized (object) {
            if (this.checkStateFlag(12)) {
                throw new weblogic.jms.common.JMSException("Invalid blocking receive when another receive is in progress");
            }
            this.setStateFlag(8);
            bl = !this.checkStateFlag(1);
        }
        long l = bEConsumerReceiveRequest.getTimeout() == 0x7FFFFFFFFFFFFFFEL ? 0L : (bEConsumerReceiveRequest.getTimeout() == Long.MAX_VALUE ? Long.MAX_VALUE : bEConsumerReceiveRequest.getTimeout());
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Starting blocking receive for consumer");
        }
        try {
            this.receiveRequest = this.queue.receive(this.filterExpression, 1, this.allowsImplicitAcknowledge(), this.recoveryUnit(bEConsumerReceiveRequest.getTransaction()), l, bl, this.subscriberUserInfo);
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
        bEConsumerReceiveRequest.setState(101);
        bEConsumerReceiveRequest.setKernelRequest((KernelRequest)this.receiveRequest);
        ReceiveRequest receiveRequest = this.receiveRequest;
        synchronized (receiveRequest) {
            if (!this.receiveRequest.hasResult()) {
                bEConsumerReceiveRequest.needOutsideResult();
                bEConsumerReceiveRequest.setWorkManager(this.getBackEnd().getWorkManager());
                this.receiveRequest.addListener((KernelListener)new DispatcherCompletionListener(bEConsumerReceiveRequest), this.getBackEnd().getWorkManager());
                return true;
            }
            return false;
        }
    }

    private Object recoveryUnit(TransactionImpl transactionImpl) {
        if (transactionImpl != null) {
            return transactionImpl;
        }
        if (this.session == null) {
            return this;
        }
        return this.session.getRecoveryUnit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean blockingReceiveProcessMessage(BEConsumerReceiveRequest bEConsumerReceiveRequest) throws JMSException {
        List list;
        try {
            list = (List)bEConsumerReceiveRequest.getKernelRequest().getResult();
        }
        catch (KernelException kernelException) {
            this.clearStateFlag(8);
            throw new weblogic.jms.common.JMSException("Error in blocking receive", (Throwable)kernelException);
        }
        bEConsumerReceiveRequest.setState(102);
        bEConsumerReceiveRequest.setKernelRequest(null);
        if (list == null || list.isEmpty()) {
            bEConsumerReceiveRequest.setResult(new JMSConsumerReceiveResponse(null, 0L, bEConsumerReceiveRequest.isTransactional()));
            return false;
        }
        assert (list.size() == 1);
        MessageElement messageElement = (MessageElement)list.get(0);
        MessageImpl messageImpl = (MessageImpl)messageElement.getMessage();
        messageElement.setUserData((Object)this);
        boolean bl = this.allowsImplicitAcknowledge();
        boolean bl2 = bl || bEConsumerReceiveRequest.isTransactional() || this.session.getAcknowledgeMode() == 4;
        long l = this.session.getNextSequenceNumber();
        messageElement.setUserSequenceNum(l);
        if (!bl2) {
            this.session.addPendingMessage(messageElement, this);
        }
        if (messageElement.getDeliveryCount() > 0 || bl) {
            messageImpl = messageImpl.cloneit();
            messageImpl.setDeliveryCount(messageElement.getDeliveryCount());
            messageImpl.setClientResponsibleForAcknowledge(bl);
        }
        bEConsumerReceiveRequest.setResult(new JMSConsumerReceiveResponse(messageImpl, l, bEConsumerReceiveRequest.isTransactional()));
        if (bEConsumerReceiveRequest.isTransactional()) {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Associating message with transaction");
            }
            try {
                this.queue.associate(messageElement, (RedeliveryParameters)this);
                this.adjustUnackedCount(1);
                this.adjustUnackedCountTransactionally((Transaction)bEConsumerReceiveRequest.getTransaction(), -1);
                return false;
            }
            catch (KernelException kernelException) {
                this.clearStateFlag(8);
                throw new weblogic.jms.common.JMSException(kernelException);
            }
        } else if (bl2) {
            if (bl) return false;
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Acknowledging message");
            }
            try {
                KernelRequest kernelRequest = this.queue.acknowledge(messageElement);
                if (kernelRequest == null) return false;
                KernelRequest kernelRequest2 = kernelRequest;
                synchronized (kernelRequest2) {
                    if (kernelRequest.hasResult()) return false;
                    bEConsumerReceiveRequest.setKernelRequest(kernelRequest);
                    bEConsumerReceiveRequest.needOutsideResult();
                    kernelRequest.addListener((KernelListener)new DispatcherCompletionListener(bEConsumerReceiveRequest), this.getBackEnd().getWorkManager());
                    return true;
                }
            }
            catch (KernelException kernelException) {
                this.clearStateFlag(8);
                throw new weblogic.jms.common.JMSException(kernelException);
            }
        } else {
            this.adjustUnackedCount(1);
        }
        return false;
    }

    private void blockingReceiveComplete(BEConsumerReceiveRequest bEConsumerReceiveRequest) throws JMSException {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Blocking receive for consumer complete");
        }
        if (bEConsumerReceiveRequest.getKernelRequest() != null) {
            try {
                bEConsumerReceiveRequest.getKernelRequest().getResult();
            }
            catch (KernelException kernelException) {
                this.clearStateFlag(8);
                throw new weblogic.jms.common.JMSException(kernelException);
            }
        }
        this.clearStateFlag(8);
        this.receiveRequest = null;
        bEConsumerReceiveRequest.setState(Integer.MAX_VALUE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int receive(BEConsumerReceiveRequest bEConsumerReceiveRequest) throws JMSException {
        this.checkSecurityRegistration(this.destination);
        this.checkPermission(this.destination, true, true);
        block5: while (true) {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Blocking receive request: state = " + bEConsumerReceiveRequest.getState());
            }
            switch (bEConsumerReceiveRequest.getState()) {
                case 0: {
                    if (!this.blockingReceiveStart(bEConsumerReceiveRequest)) continue block5;
                    return bEConsumerReceiveRequest.getState();
                }
                case 101: {
                    if (this.blockingReceiveProcessMessage(bEConsumerReceiveRequest)) return bEConsumerReceiveRequest.getState();
                    continue block5;
                }
                case 102: {
                    this.blockingReceiveComplete(bEConsumerReceiveRequest);
                    this.checkPermission(this.destination, true, true);
                    return Integer.MAX_VALUE;
                }
            }
            break;
        }
        throw new AssertionError((Object)"Invalid request state");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setListener(BEConsumerSetListenerRequest bEConsumerSetListenerRequest) throws JMSException {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Consumer got a setListener request: " + bEConsumerSetListenerRequest.getHasListener());
        }
        if (!WLSPrincipals.isAnonymousUsername((String)JMSSecurityHelper.getSimpleAuthenticatedName())) {
            this.checkSecurityRegistration(this.destination);
        }
        bEConsumerSetListenerRequest.setResult(new JMSConsumerSetListenerResponse(this.session.getSequenceNumber()));
        BEConsumerImpl bEConsumerImpl = this;
        synchronized (bEConsumerImpl) {
            if (!(bEConsumerSetListenerRequest.getHasListener() ^ this.checkStateFlag(4))) {
                return Integer.MAX_VALUE;
            }
            if (bEConsumerSetListenerRequest.getHasListener()) {
                this.setStateFlag(4);
                if (this.isReadyForPush()) {
                    this.startListening();
                }
            } else {
                this.clearStateFlag(4);
                this.stopListening();
            }
        }
        bEConsumerSetListenerRequest.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    private void incrementWindowCurrent(BEConsumerIncrementWindowCurrentRequest bEConsumerIncrementWindowCurrentRequest) throws JMSException {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Consumer got incrementWindowCurrent. Increment = " + bEConsumerIncrementWindowCurrentRequest.getWindowIncrement());
        }
        this.makeWindowSpace(bEConsumerIncrementWindowCurrentRequest.getWindowIncrement(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeWindowSpace(int n, boolean bl) throws JMSException {
        int n2 = 0;
        ListenRequest listenRequest = null;
        BEConsumerImpl bEConsumerImpl = this;
        synchronized (bEConsumerImpl) {
            if (this.isReadyForPush() && this.listenRequest != null) {
                int n3 = this.windowSize - this.listenRequest.getCount();
                this.pendingWindowSpace += n;
                if (bl || this.pendingWindowSpace >= this.windowSize / 2) {
                    n2 = Math.min(this.pendingWindowSpace, n3);
                    if (n2 > 0) {
                        listenRequest = this.listenRequest;
                    }
                    this.pendingWindowSpace = 0;
                }
            }
        }
        if (listenRequest != null) {
            try {
                listenRequest.incrementCount(n2);
            }
            catch (KernelException kernelException) {
                throw new weblogic.jms.common.JMSException(kernelException);
            }
        }
    }

    void incrementPendingCount(int n, boolean bl) throws JMSException {
        this.adjustUnackedCount(-n);
        this.makeWindowSpace(n, bl);
    }

    void incrementPendingCountTransactionally(Transaction transaction, int n, boolean bl) throws JMSException {
        CountAdjuster countAdjuster = new CountAdjuster(n, true, bl);
        try {
            transaction.registerSynchronization((Synchronization)countAdjuster);
        }
        catch (RollbackException rollbackException) {
            countAdjuster.afterCompletion(1);
        }
        catch (IllegalStateException illegalStateException) {
            countAdjuster.afterCompletion(1);
        }
        catch (SystemException systemException) {
            throw new weblogic.jms.common.JMSException(systemException);
        }
    }

    JMSPushEntry createPushEntry(MessageElement messageElement, boolean bl, boolean bl2) {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Pushing " + messageElement.getMessage() + ". implicitAcknowledge = " + bl2);
        }
        JMSPushEntry jMSPushEntry = new JMSPushEntry(this.session.getSequencerId(), this.id, messageElement.getUserSequenceNum(), 0L, messageElement.getDeliveryCount(), this.session.getPipelineGeneration());
        jMSPushEntry.setClientResponsibleForAcknowledge(bl);
        return jMSPushEntry;
    }

    void checkPermission(boolean bl) throws JMSSecurityException {
        this.checkPermission(this.destination, bl);
    }

    void checkPermission(boolean bl, boolean bl2) throws JMSSecurityException {
        this.checkPermission(this.destination, bl, bl2);
    }

    void checkPermission(BEDestinationImpl bEDestinationImpl, boolean bl) throws JMSSecurityException {
        this.checkPermission(bEDestinationImpl, bl, true);
    }

    void checkPermission(BEDestinationImpl bEDestinationImpl, boolean bl, boolean bl2) throws JMSSecurityException {
        if (this.isWlsKernelId()) {
            return;
        }
        AuthenticatedSubject authenticatedSubject = this.getSubject();
        AuthenticatedSubject authenticatedSubject2 = JMSSecurityHelper.getCurrentSubject();
        if (!JMSService.getJMSService().isSecurityCheckerStop()) {
            if (bl2 && authenticatedSubject != authenticatedSubject2 && (authenticatedSubject == null || !authenticatedSubject.equals((Object)authenticatedSubject2))) {
                bEDestinationImpl.getJMSDestinationSecurity().checkReceivePermission(authenticatedSubject2);
                this.setSubject(authenticatedSubject2);
            }
        } else {
            try {
                bEDestinationImpl.getJMSDestinationSecurity().checkReceivePermission(authenticatedSubject);
            }
            catch (JMSSecurityException jMSSecurityException) {
                if (bl) {
                    WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new ConsumerCloseThread());
                }
                throw jMSSecurityException;
            }
        }
    }

    void checkPermission(boolean bl, MessageImpl messageImpl) throws JMSSecurityException {
        this.checkPermission(this.destination, bl, false, messageImpl);
    }

    void checkPermission(boolean bl, boolean bl2, MessageImpl messageImpl) throws JMSSecurityException {
        this.checkPermission(this.destination, bl, false, messageImpl);
    }

    void checkPermission(BEDestinationImpl bEDestinationImpl, boolean bl, boolean bl2, MessageImpl messageImpl) throws JMSSecurityException {
        this.checkPermission(bEDestinationImpl, bl, bl2);
        if (messageImpl != null && messageImpl.getJMSType() != null && messageImpl.getJMSType().equals("abcXXX")) {
            if (bl) {
                WorkManagerFactory.getInstance().getSystem().schedule((Runnable)new ConsumerCloseThread());
            }
            throw new JMSSecurityException("security check simulation negative result");
        }
    }

    public Runnable deliver(ListenRequest listenRequest, List list) {
        try {
            this.checkPermission(this.destination, true, false);
        }
        catch (JMSSecurityException jMSSecurityException) {
            return null;
        }
        for (MessageElement messageElement : list) {
            messageElement.setUserData((Object)this);
            messageElement.setUserSequenceNum(this.session.getNextSequenceNumber());
        }
        return this.session.deliver(listenRequest, list);
    }

    public Runnable deliver(ListenRequest listenRequest, MessageElement messageElement) {
        try {
            this.checkPermission(this.destination, true, false);
        }
        catch (JMSSecurityException jMSSecurityException) {
            return null;
        }
        messageElement.setUserData((Object)this);
        messageElement.setUserSequenceNum(this.session.getNextSequenceNumber());
        return this.session.deliver(listenRequest, messageElement);
    }

    protected void pushMessages(List list) {
        assert (false);
    }

    private WorkManager findPushWorkManager() {
        WorkManager workManager = null;
        if (this.session != null && this.session.getPushWorkManager() != null) {
            workManager = WorkManagerFactory.getInstance().find(this.session.getPushWorkManager());
        }
        if (workManager == null) {
            workManager = this.getBackEnd().getAsyncPushWorkManager();
        }
        return workManager;
    }

    synchronized void startListening() throws JMSException {
        if (this.multicastSubscriber) {
            return;
        }
        WorkManager workManager = this.findPushWorkManager();
        try {
            if (this.session != null) {
                this.session.setBackEnd(this.destination.getBackEnd());
                this.session.adjustWindowSize(this.windowSize);
                this.session.setWorkManager(workManager);
            }
            this.kernelAutoAcknowledge = this.allowsImplicitAcknowledge();
            this.setWorkManager(workManager);
            this.listenRequest = this.queue.listen(this.filterExpression, this.windowSize, this.kernelAutoAcknowledge, this.recoveryUnit(null), (Listener)this, (MultiListener)this.destination.getBackEnd().getMultiSender(), this.subscriberUserInfo, workManager);
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }

    synchronized boolean stopListening() {
        if (this.listenRequest != null) {
            if (this.session != null) {
                this.session.adjustWindowSize(-this.windowSize);
            }
            this.listenRequest.stop();
            this.listenRequest = null;
            return true;
        }
        return false;
    }

    private synchronized void startInternal(int n) throws JMSException {
        boolean bl = this.isReadyForPush();
        this.clearStateFlag(n);
        if (this.isReadyForPush() && !bl) {
            this.startListening();
        } else if (this.checkStateFlag(8) && this.receiveRequest != null) {
            try {
                this.receiveRequest.start();
            }
            catch (KernelException kernelException) {
                throw new weblogic.jms.common.JMSException(kernelException);
            }
        }
    }

    public void start() throws JMSException {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Got a start request on the consumer");
        }
        this.startInternal(1);
    }

    private synchronized void stopInternal(int n) {
        this.setStateFlag(n);
        if (this.checkStateFlag(8) && this.receiveRequest != null) {
            this.receiveRequest.stop();
        } else if (this.listenRequest != null) {
            this.stopListening();
        }
    }

    public void stop() {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Got a stop request on the consumer");
        }
        this.stopInternal(1);
    }

    public void securityLapsed() {
        try {
            this.closeWithError("ERROR: Security has lapsed for this consumer");
        }
        catch (JMSException jMSException) {
            System.out.println("ERROR: Could not push security exception to consumer: " + (Object)((Object)jMSException));
        }
    }

    public boolean isClosed() {
        return this.checkStateFlag(16);
    }

    public HashSet getAcceptedDestinations() {
        return null;
    }

    public void onEvent(Event event) {
        if (event instanceof MessageSendEvent) {
            this.onMessageEvent((MessageEvent)event);
        } else if (event instanceof MessageAddEvent) {
            this.onMessageEvent((MessageEvent)event);
        } else if (event instanceof MessageReceiveEvent) {
            this.onMessageEvent((MessageEvent)event);
        } else if (event instanceof MessageExpirationEvent) {
            this.onMessageEvent((MessageEvent)event);
        } else if (event instanceof MessageRedeliveryLimitEvent) {
            this.onMessageEvent((MessageEvent)event);
        } else if (event instanceof MessageRemoveEvent) {
            this.onMessageEvent((MessageEvent)event);
        }
    }

    private final void onMessageEvent(MessageEvent messageEvent) {
        JMSMessageLogHelper.logMessageEvent(this, (Event)messageEvent);
    }

    public JMSMessageLogger getJMSMessageLogger() {
        return this.destination.getBackEnd().getJMSMessageLogger();
    }

    public final List getMessageLoggingJMSHeaders() {
        return this.destination.getMessageLoggingJMSHeaders();
    }

    public final List getMessageLoggingUserProperties() {
        return this.destination.getMessageLoggingUserProperties();
    }

    public final String getListenerName() {
        return this.destination.getName();
    }

    private String getDurableSubscriptionRuntimeMBeanName(String string, String string2, BEDestinationImpl bEDestinationImpl) {
        String string3 = string + "_" + string2;
        if (this.clientIdPolicy == 1) {
            string3 = string3 + "@" + bEDestinationImpl.getName() + "@" + bEDestinationImpl.getBackEnd().getName();
        }
        return string3;
    }

    public void dumpRef(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeAttribute("id", this.id != null ? this.id.toString() : "");
        String string = "";
        String string2 = "";
        if (this.session != null) {
            ID iD;
            BEConnection bEConnection;
            ID iD2 = this.session.getId();
            if (iD2 != null) {
                string = iD2.toString();
            }
            if ((bEConnection = this.session.getConnection()) != null && (iD = bEConnection.getId()) != null) {
                string2 = iD.toString();
            }
        }
        xMLStreamWriter.writeAttribute("sessionID", string);
        xMLStreamWriter.writeAttribute("connectionID", string2);
    }

    protected void dumpCommon(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeAttribute("name", this.name != null ? this.name : "");
        xMLStreamWriter.writeAttribute("id", this.id != null ? this.id.toString() : "");
        xMLStreamWriter.writeAttribute("state", String.valueOf(this.state));
        xMLStreamWriter.writeAttribute("subscriptionName", this.subscriptionName != null ? this.subscriptionName : "");
        xMLStreamWriter.writeAttribute("isDurable", String.valueOf(this.durableSubscriber));
        xMLStreamWriter.writeAttribute("isActive", String.valueOf(this.isActive()));
        xMLStreamWriter.writeAttribute("isUsed", String.valueOf(this.isUsed()));
        xMLStreamWriter.writeAttribute("selector", this.selector != null ? this.selector : "");
        xMLStreamWriter.writeAttribute("clientID", this.clientId != null ? this.clientId : "");
        xMLStreamWriter.writeAttribute("noLocal", String.valueOf(this.noLocal));
        if (this.queue != null) {
            xMLStreamWriter.writeAttribute("queueName", this.queue.getName());
        }
        if (this.persistentHandle != null) {
            xMLStreamWriter.writeAttribute("persistentStoreHandle", this.persistentHandle.toString());
        }
        xMLStreamWriter.writeAttribute("isMulticast", String.valueOf(this.isMulticastSubscriber()));
        xMLStreamWriter.writeAttribute("supportsClientResponsible", String.valueOf(this.supportsClientResponsible));
        xMLStreamWriter.writeAttribute("unackedMessageCount", String.valueOf(this.unackedMessageCount));
        xMLStreamWriter.writeStartElement("Session");
        xMLStreamWriter.writeAttribute("sessionID", this.session.getId().toString());
        xMLStreamWriter.writeAttribute("connectionID", this.session.getConnection().getId().toString());
        xMLStreamWriter.writeEndElement();
    }

    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("Consumer");
        this.dumpCommon(xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }

    public CompositeData getCompositeData() throws OpenDataException {
        Object object;
        String string = null;
        BESessionImpl bESessionImpl = this.getSession();
        if (bESessionImpl != null && (object = bESessionImpl.getConnection()) != null) {
            string = ((BEConnection)object).getAddress();
        }
        object = new ConsumerInfo(this.getSubscriptionName(), this.isDurable(), this.getSelector(), this.getClientID(), this.getNoLocal(), string);
        return ((ConsumerInfo)object).toCompositeData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSubject(AuthenticatedSubject authenticatedSubject) {
        if (authenticatedSubject != null) {
            Object object = this.stateLock;
            synchronized (object) {
                this.authenticatedSubject = authenticatedSubject;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticatedSubject getSubject() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.authenticatedSubject;
        }
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.jms.backend.BEConsumerImpl");
        _WLDF$INST_FLD_JMS_Diagnostic_Volume_Before_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"JMS_Diagnostic_Volume_Before_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"BEConsumerImpl.java", (String)"weblogic.jms.backend.BEConsumerImpl", (String)"logEvent", (String)"(I)V", (int)520, (Map)InstrumentationSupport.makeMap((String[])new String[]{"JMS_Diagnostic_Volume_Before_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo((ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"this", (String)"weblogic.diagnostics.instrumentation.gathering.JMSConsumerImplRenderer", (boolean)false, (boolean)true), null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"eventType", (String)"weblogic.diagnostics.instrumentation.gathering.JMSEventTypeStringRenderer", (boolean)false, (boolean)true)})}), (boolean)false);
        KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private class ConsumerCloseThread
    implements Runnable {
        private ConsumerCloseThread() {
        }

        public void run() {
            BEConsumerImpl.this.securityLapsed();
        }
    }

    private final class CountAdjuster
    implements Synchronization {
        private int count;
        private boolean incrementWindow;
        private boolean force;

        CountAdjuster(int n, boolean bl, boolean bl2) {
            this.count = n;
            this.incrementWindow = bl;
            this.force = bl2;
        }

        public void afterCompletion(int n) {
            block3: {
                BEConsumerImpl.this.adjustUnackedCount(-this.count);
                if (this.incrementWindow) {
                    try {
                        BEConsumerImpl.this.makeWindowSpace(this.count, this.force);
                    }
                    catch (JMSException jMSException) {
                        if (!JMSDebug.JMSBackEnd.isDebugEnabled()) break block3;
                        JMSDebug.JMSBackEnd.debug("cannot make window space ", (Throwable)jMSException);
                    }
                }
            }
        }

        public void beforeCompletion() {
        }
    }
}

