/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSConsumerReceiveResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.transaction.internal.TransactionImpl;

public final class BEConsumerReceiveRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -4180296985320716407L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    static final int START = 0;
    static final int CONTINUE = 1;
    static final int PAGEIN = 2;
    private long timeout;
    private transient TransactionImpl transaction;
    private transient KernelRequest kernelRequest;

    public BEConsumerReceiveRequest(JMSID jMSID, long l) {
        super(jMSID, 11025);
        this.timeout = l;
    }

    long getTimeout() {
        return this.timeout;
    }

    void setTransaction(TransactionImpl transactionImpl) {
        this.transaction = transactionImpl;
    }

    TransactionImpl getTransaction() {
        return this.transaction;
    }

    boolean isTransactional() {
        return this.transaction != null;
    }

    public int remoteSignature() {
        return 35;
    }

    public Response createResponse() {
        return new JMSConsumerReceiveResponse();
    }

    public BEConsumerReceiveRequest() {
    }

    void setKernelRequest(KernelRequest kernelRequest) {
        this.kernelRequest = kernelRequest;
    }

    KernelRequest getKernelRequest() {
        return this.kernelRequest;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.timeout);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.timeout = objectInput.readLong();
    }
}

