/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSConsumerSetListenerResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public final class BEConsumerSetListenerRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 3829823272672918810L;
    private boolean hasListener;
    private long lastSequenceNumber;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int HAS_LISTENER_MASK = 256;

    public BEConsumerSetListenerRequest(JMSID jMSID, boolean bl, long l) {
        super(jMSID, 11281);
        this.hasListener = bl;
        this.lastSequenceNumber = l;
    }

    boolean getHasListener() {
        return this.hasListener;
    }

    long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public int remoteSignature() {
        return 34;
    }

    public Response createResponse() {
        return new JMSConsumerSetListenerResponse();
    }

    public BEConsumerSetListenerRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.hasListener) {
            n |= 0x100;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.lastSequenceNumber);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.lastSequenceNumber = objectInput.readLong();
        this.hasListener = (n & 0x100) != 0;
    }
}

