/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import weblogic.application.ModuleException;
import weblogic.j2ee.descriptor.wl.DestinationKeyBean;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BEDestinationKey;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.extensions.JMSMessageInfo;
import weblogic.messaging.kernel.MessageElement;

public class BECursorDestinationKey
extends BEDestinationKey {
    protected static final int KEY_TYPE_JMS_BEA_XID = 101;
    protected static final int KEY_TYPE_JMS_BEA_STATE = 102;
    protected static final int KEY_TYPE_JMS_BEA_SEQUENCE_NUMBER = 103;

    public BECursorDestinationKey(BEDestinationImpl bEDestinationImpl, DestinationKeyBean destinationKeyBean) throws ModuleException {
        super(bEDestinationImpl, destinationKeyBean);
        if (this.property.equalsIgnoreCase("JMS_BEA_Xid")) {
            this.keyType = 101;
        } else if (this.property.equalsIgnoreCase("JMS_BEA_State")) {
            this.keyType = 102;
        } else if (this.property.equalsIgnoreCase("JMS_BEA_SequenceNumber")) {
            this.keyType = 103;
        }
    }

    long compareKey(MessageElement messageElement, MessageElement messageElement2, boolean bl) {
        long l = 0L;
        switch (this.keyType) {
            case 101: {
                if (messageElement.getXid() != null && messageElement2.getXid() != null) {
                    l = messageElement.getXid().toString().compareTo(messageElement2.getXid().toString());
                    break;
                }
                if (messageElement.getXid() != null) {
                    l = 1L;
                    break;
                }
                if (messageElement2.getXid() != null) {
                    l = -1L;
                    break;
                }
                l = 0L;
                break;
            }
            case 102: {
                l = JMSMessageInfo.getStateString(messageElement.getState()).compareTo(JMSMessageInfo.getStateString(messageElement2.getState()));
                break;
            }
            case 103: {
                l = messageElement.getInternalSequenceNumber() - messageElement2.getInternalSequenceNumber();
                break;
            }
            default: {
                if (l != 0L) break;
                return super.compareKey((MessageImpl)messageElement.getMessage(), (MessageImpl)messageElement2.getMessage(), bl);
            }
        }
        if (bl) {
            if (this.direction == 0) {
                return -l;
            }
            return l;
        }
        if (this.direction == 0) {
            return l;
        }
        return -l;
    }
}

