/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.security.AccessController;
import java.text.ParseException;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.ActiveMessageExpiration;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BEDestinationRuntimeMBeanImpl;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.EntityName;
import weblogic.jms.common.JMSDestinationSecurity;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageExpirationHelper;
import weblogic.jms.common.JMSMessageLogHelper;
import weblogic.jms.common.JMSProducerSendResponse;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.MessageStatisticsLogger;
import weblogic.jms.common.WrappedDestinationImpl;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.extensions.Schedule;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.JMSDestinationRuntimeMBean;
import weblogic.messaging.ID;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public abstract class BEDestinationCommon
implements Invocable,
MessageStatisticsLogger,
ActiveMessageExpiration {
    public static final int NOT_TEMPORARY = 1;
    public static final int TEMPORARY = 0;
    public static final int SUPPORTS = 0;
    public static final int NEVER = 1;
    public static final int AUTH_PRINS = 2;
    public static final String DEFAULT_TIME_TO_DELIVER_OVERRIDE = "-1";
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    protected final BackEnd backEnd;
    protected final String name;
    protected String moduleName;
    protected BEDestinationRuntimeMBeanImpl runtimeMBean;
    private final InvocableMonitor invocableMonitor;
    private long creationTime = 1L;
    protected int expirationPolicy = 1;
    private List expirationLoggingJMSHeaders = null;
    private List expirationLoggingUserProperties = null;
    protected int maximumMessageSize = Integer.MAX_VALUE;
    private boolean messageLoggingEnabled = false;
    private String messageLoggingFormat = null;
    private List messageLoggingJMSHeaders = null;
    private List messageLoggingUserProperties = null;
    protected List destinationKeysList;
    private boolean bound;
    private boolean localBound;
    private boolean applicationBound;
    protected boolean ddBound;
    protected String jndiName;
    private String localJNDIName;
    private boolean advertised = false;
    protected DestinationImpl destinationImpl;
    protected String internalDistributedJNDIName;
    protected final JMSID id;
    private JMSID connectionId;
    protected int deliveryModeOverride = -1;
    protected int duration;
    private int priorityOverride;
    protected final Object configurationLock = new Object();
    private long redeliveryDelayOverride;
    private int redeliveryLimit;
    private boolean foundBEErrorDestination;
    private BEDestinationImpl errorDestination;
    private EntityName errorDestinationName;
    private String timeToDeliverOverride;
    private long timeToLiveOverride;
    protected int attachSenderMode = 0;
    protected String safExportPolicy = "All";
    protected boolean defaultTargetingEnabled;
    protected boolean productionPausedAtStartup;
    protected boolean insertionPausedAtStartup;
    protected boolean consumptionPausedAtStartup;
    private String jmsCreateDestinationIdentifier;
    private String expirationLoggingPolicy;
    private String defaultUnitOfOrder;
    private String applicationJNDIName;
    private Context applicationContext;
    private JMSDestinationSecurity jmsDestinationSecurity;
    private final String DEFAULT_UOO_NAME;

    protected BEDestinationCommon(BackEnd backEnd, String string, boolean bl, JMSDestinationSecurity jMSDestinationSecurity) {
        this.backEnd = backEnd;
        this.name = string;
        this.duration = bl ? 0 : 1;
        this.id = JMSService.getJMSService().getNextId();
        this.invocableMonitor = backEnd.getInvocableMonitor();
        this.creationTime = System.currentTimeMillis();
        this.jmsDestinationSecurity = jMSDestinationSecurity;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        String string2 = runtimeAccess.getDomainName();
        this.DEFAULT_UOO_NAME = "UOO-" + string2 + ":" + string;
    }

    public abstract void setStateFlag(int var1);

    public abstract void clearStateFlag(int var1);

    public abstract void checkShutdown(String var1) throws JMSException;

    public final BackEnd getBackEnd() {
        return this.backEnd;
    }

    final void setRuntimeMBean(BEDestinationRuntimeMBeanImpl bEDestinationRuntimeMBeanImpl) {
        this.runtimeMBean = bEDestinationRuntimeMBeanImpl;
    }

    public final JMSDestinationRuntimeMBean getRuntimeMBean() {
        return this.runtimeMBean;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final void setProductionPausedAtStartup(boolean bl) {
        this.productionPausedAtStartup = bl;
    }

    public final void setInsertionPausedAtStartup(boolean bl) {
        this.insertionPausedAtStartup = bl;
    }

    public final void setConsumptionPausedAtStartup(boolean bl) {
        this.consumptionPausedAtStartup = bl;
    }

    public void setMaximumMessageSize(int n) {
        this.maximumMessageSize = n;
    }

    public final DestinationImpl getDestinationImpl() {
        return this.destinationImpl;
    }

    public final void setDestinationImpl(DestinationImpl destinationImpl) {
        this.destinationImpl = destinationImpl;
    }

    private final void internalValJndiName(String string, boolean bl) throws BeanUpdateRejectedException {
        Object object;
        if ((string = JMSServerUtilities.transformJNDIName(string)) == null) {
            return;
        }
        if (this.advertised && (object = !bl ? this.jndiName : this.localJNDIName) != null && ((String)object).equals(string)) {
            return;
        }
        object = JMSService.getContext(!bl);
        Object object2 = null;
        for (int i = 0; i < 40; ++i) {
            try {
                object2 = object.lookup(string);
            }
            catch (NameNotFoundException nameNotFoundException) {
                return;
            }
            catch (NamingException namingException) {
                throw new BeanUpdateRejectedException(namingException.getMessage(), (Throwable)namingException);
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        throw new BeanUpdateRejectedException("The proposed " + (bl ? "Local" : "") + " JNDI name " + string + " for destination " + this.name + " is already bound by another object of type " + (object2 == null ? "null" : object2.getClass().getName()));
    }

    public final void valJNDIName(String string) throws BeanUpdateRejectedException {
        this.internalValJndiName(string, false);
    }

    public final void setJNDIName(String string) throws IllegalArgumentException {
        String string2;
        String string3 = (string = JMSServerUtilities.transformJNDIName(string)) == null ? "" : string;
        String string4 = string2 = this.jndiName == null ? "" : this.jndiName;
        if (this.advertised && !string3.equals(string2)) {
            boolean bl = false;
            if (string != null) {
                try {
                    PrivilegedActionUtilities.bindAsSU(JMSService.getContext(true), string, new WrappedDestinationImpl(this.destinationImpl), kernelId);
                    bl = true;
                }
                catch (NamingException namingException) {
                    if (namingException instanceof NameAlreadyBoundException) {
                        JMSLogger.logNameConflictChangingGlobalJNDIName((String)this.jndiName, (String)string, (String)this.name, (String)this.moduleName);
                    }
                    throw new IllegalArgumentException("Error binding destination to JNDI (jndi name = " + string + ")");
                }
            }
            if (this.bound) {
                try {
                    PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(true), this.jndiName, kernelId);
                }
                catch (NamingException namingException) {
                    JMSLogger.logCouldNotUnbindGlobalJNDIName((String)this.jndiName, (String)this.name, (String)this.moduleName);
                }
            }
            this.bound = bl;
            if (this.bound) {
                this.setStateFlag(131072);
            } else {
                this.clearStateFlag(131072);
            }
        }
        this.jndiName = string;
    }

    public final void valLocalJNDIName(String string) throws BeanUpdateRejectedException {
        this.internalValJndiName(string, true);
    }

    public final String getJNDIName() {
        return this.jndiName;
    }

    public final String getLocalJNDIName() {
        return this.localJNDIName;
    }

    public final void setLocalJNDIName(String string) throws IllegalArgumentException {
        String string2;
        String string3 = (string = JMSServerUtilities.transformJNDIName(string)) == null ? "" : string;
        String string4 = string2 = this.localJNDIName == null ? "" : this.localJNDIName;
        if (this.advertised && !string3.equals(string2)) {
            boolean bl = false;
            if (string != null) {
                try {
                    PrivilegedActionUtilities.bindAsSU(JMSService.getContext(false), string, this.destinationImpl, kernelId);
                    bl = true;
                }
                catch (NamingException namingException) {
                    if (namingException instanceof NameAlreadyBoundException) {
                        JMSLogger.logNameConflictChangingLocalJNDIName((String)this.localJNDIName, (String)string, (String)this.name, (String)this.moduleName);
                    }
                    throw new IllegalArgumentException("Error binding destination to local JNDI (jndi name = " + string + ")");
                }
            }
            if (this.localBound) {
                try {
                    PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(false), this.localJNDIName, kernelId);
                }
                catch (NamingException namingException) {
                    JMSLogger.logCouldNotUnbindLocalJNDIName((String)this.localJNDIName, (String)this.name, (String)this.moduleName);
                }
            }
            this.localBound = bl;
            if (this.localBound) {
                this.setStateFlag(262144);
            } else {
                this.clearStateFlag(262144);
            }
        }
        this.localJNDIName = string;
    }

    void setApplicationJNDIName(String string) {
        this.applicationJNDIName = string = JMSServerUtilities.transformJNDIName(string);
    }

    void setApplicationContext(Context context) {
        this.applicationContext = context;
    }

    public final int getDestType() {
        return this.destinationImpl.getType();
    }

    public final void logMessagesThresholdHigh() {
        JMSLogger.logMessagesThresholdHighDestination((String)this.backEnd.getName(), (String)this.name);
    }

    public final void logMessagesThresholdLow() {
        JMSLogger.logMessagesThresholdLowDestination((String)this.backEnd.getName(), (String)this.name);
    }

    public final void logBytesThresholdHigh() {
        JMSLogger.logBytesThresholdHighDestination((String)this.backEnd.getName(), (String)this.name);
    }

    public final void logBytesThresholdLow() {
        JMSLogger.logBytesThresholdLowDestination((String)this.backEnd.getName(), (String)this.name);
    }

    public final void setPriority(int n) {
        this.priorityOverride = n;
    }

    public final Object getConfigurationLock() {
        return this.configurationLock;
    }

    public final long getDirtyRedeliveryDelayOverride() {
        return this.redeliveryDelayOverride;
    }

    public final int getDirtyRedeliveryLimit() {
        return this.redeliveryLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getRedeliveryDelay() {
        Object object = this.configurationLock;
        synchronized (object) {
            return this.redeliveryDelayOverride;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRedeliveryDelay(long l) {
        Object object = this.configurationLock;
        synchronized (object) {
            this.redeliveryDelayOverride = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRedeliveryLimit(int n) {
        Object object = this.configurationLock;
        synchronized (object) {
            this.redeliveryLimit = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BEDestinationImpl getBEErrorDestination() {
        Object object = this.configurationLock;
        synchronized (object) {
            if (this.foundBEErrorDestination) {
                return this.errorDestination;
            }
            this.errorDestination = this.errorDestinationName == null ? null : this.backEnd.findDestination(this.errorDestinationName.toString());
            this.foundBEErrorDestination = true;
            return this.errorDestination;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getTimeToDeliver() {
        Object object = this.configurationLock;
        synchronized (object) {
            return this.timeToDeliverOverride;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTimeToDeliver(String string) {
        Object object = this.configurationLock;
        synchronized (object) {
            this.timeToDeliverOverride = string;
        }
    }

    public final long getTimeToDeliverOverrideInMillisRelative() {
        String string = this.getTimeToDeliver();
        if (string == null || string == DEFAULT_TIME_TO_DELIVER_OVERRIDE || string.trim().length() == 0) {
            return -1L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Schedule.nextScheduledTimeInMillisRelative(string, System.currentTimeMillis());
            }
            catch (ParseException parseException) {
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getTimeToLive() {
        Object object = this.configurationLock;
        synchronized (object) {
            return this.timeToLiveOverride;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTimeToLive(long l) {
        Object object = this.configurationLock;
        synchronized (object) {
            this.timeToLiveOverride = l;
        }
    }

    public final void setDeliveryMode(String string) {
        if (string == null) {
            this.deliveryModeOverride = -1;
            return;
        }
        this.deliveryModeOverride = string.equalsIgnoreCase("Non-Persistent") ? 1 : (string.equalsIgnoreCase("Persistent") ? 2 : -1);
    }

    public void setDestinationKeysList(List list) {
        this.destinationKeysList = list;
    }

    public final boolean isTemporary() {
        return this.duration == 0;
    }

    public final void setDuration(int n) {
        this.duration = n;
    }

    public void setDestinationKeys(String[] stringArray) {
    }

    public final String getName() {
        return this.name;
    }

    public final Destination getDestination() {
        return this.getDestinationImpl();
    }

    public final String getDestinationType() {
        int n = this.getDestType();
        if (n == 1 || n == 4) {
            return "Queue";
        }
        return "Topic";
    }

    public abstract int getDestinationTypeIndicator();

    public final void setConnectionId(JMSID jMSID) {
        this.connectionId = jMSID;
    }

    public final JMSID getConnectionId() {
        return this.connectionId;
    }

    public final void setExpirationPolicy(String string) {
        this.expirationPolicy = BEDestinationCommon.expirationPolicyIntFromString(string);
    }

    public static final int expirationPolicyIntFromString(String string) {
        if (string == null) {
            return 1;
        }
        if (string.equalsIgnoreCase("Log")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Redirect")) {
            return 4;
        }
        return 1;
    }

    public final List getExpirationLoggingJMSHeaders() {
        return this.expirationLoggingJMSHeaders;
    }

    private final void setExpirationLoggingJMSHeaders(List list) {
        this.expirationLoggingJMSHeaders = list;
    }

    public final List getExpirationLoggingUserProperties() {
        return this.expirationLoggingUserProperties;
    }

    private final void setExpirationLoggingUserProperties(List list) {
        this.expirationLoggingUserProperties = list;
    }

    public final InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public final JMSID getJMSID() {
        return this.id;
    }

    public ID getId() {
        return this.getJMSID();
    }

    private static int attachStringToAttachMode(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase("supports")) {
            return 0;
        }
        if (string.equalsIgnoreCase("never")) {
            return 1;
        }
        if (string.equalsIgnoreCase("always")) {
            return 2;
        }
        return 0;
    }

    public final void setAttachSender(String string) {
        this.attachSenderMode = BEDestinationCommon.attachStringToAttachMode(string);
    }

    public String getSAFExportPolicy() {
        return this.safExportPolicy;
    }

    public void setSAFExportPolicy(String string) {
        this.safExportPolicy = string == null ? "All" : string;
    }

    public boolean isDefaultTargetingEnabled() {
        return this.defaultTargetingEnabled;
    }

    public void setDefaultTargetingEnabled(boolean bl) {
        this.defaultTargetingEnabled = bl;
    }

    protected void applyOverrides(MessageImpl messageImpl, JMSProducerSendResponse jMSProducerSendResponse) throws JMSException {
        long l = this.deliveryModeOverride;
        if (l != -1L) {
            messageImpl.setJMSDeliveryMode((int)l);
            if (jMSProducerSendResponse != null) {
                jMSProducerSendResponse.setDeliveryMode((int)l);
            }
        }
        if ((l = (long)this.priorityOverride) != -1L) {
            messageImpl.setJMSPriority((int)l);
            if (jMSProducerSendResponse != null) {
                jMSProducerSendResponse.setPriority((int)l);
            }
        }
        if (!messageImpl.getDDForwarded()) {
            l = this.getTimeToLive();
            if (l >= 0L) {
                if (l > 0L) {
                    long l2 = System.currentTimeMillis() + l;
                    if (l2 <= 0L) {
                        l2 = Long.MAX_VALUE;
                    }
                    messageImpl.setJMSExpiration(l2);
                } else {
                    messageImpl.setJMSExpiration(0L);
                }
                if (jMSProducerSendResponse != null) {
                    jMSProducerSendResponse.setTimeToLive(l);
                }
            }
            if ((l = this.getTimeToDeliverOverrideInMillisRelative()) >= 0L) {
                if (l > 0L) {
                    messageImpl.setDeliveryTime(System.currentTimeMillis() + l);
                } else {
                    messageImpl.setDeliveryTime(0L);
                }
                if (jMSProducerSendResponse != null) {
                    jMSProducerSendResponse.setTimeToDeliver(l);
                }
            }
        }
        if ((l = (long)this.redeliveryLimit) != -1L) {
            messageImpl.setJMSRedeliveryLimit((int)l);
            if (jMSProducerSendResponse != null) {
                jMSProducerSendResponse.setRedeliveryLimit((int)l);
            }
        }
    }

    protected void advertise() throws JMSException {
        this.advertiseDestinationImpl();
        this.advertised = true;
    }

    private void advertiseDestinationImpl() throws JMSException {
        this.checkShutdown("start destination");
        if (this.duration == 0) {
            return;
        }
        if (!this.bound && this.jndiName != null) {
            try {
                PrivilegedActionUtilities.bindAsSU(JMSService.getContext(true), this.jndiName, new WrappedDestinationImpl(this.destinationImpl), kernelId);
                this.bound = true;
                this.setStateFlag(131072);
            }
            catch (NamingException namingException) {
                if (namingException instanceof NameAlreadyBoundException) {
                    JMSLogger.logNameConflictBindingGlobalJNDIName((String)this.jndiName, (String)this.name, (String)this.moduleName);
                }
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logBindNamingExceptionLoggable((String)this.name, (String)this.jndiName), (Throwable)namingException);
            }
        }
        if (!this.localBound && this.getLocalJNDIName() != null) {
            try {
                PrivilegedActionUtilities.bindAsSU(JMSService.getContext(false), this.getLocalJNDIName(), this.destinationImpl, kernelId);
                this.localBound = true;
                this.setStateFlag(262144);
            }
            catch (NamingException namingException) {
                if (namingException instanceof NameAlreadyBoundException) {
                    JMSLogger.logNameConflictBindingLocalJNDIName((String)this.localJNDIName, (String)this.name, (String)this.moduleName);
                }
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logLocalBindNamingExceptionLoggable((String)this.name, (String)this.localJNDIName), (Throwable)namingException);
            }
        }
        if (this.applicationJNDIName != null && this.applicationContext != null) {
            try {
                PrivilegedActionUtilities.bindAsSU(this.applicationContext, this.applicationJNDIName, this.destinationImpl, kernelId);
                this.applicationBound = true;
            }
            catch (NamingException namingException) {
                throw new weblogic.jms.common.JMSException(JMSExceptionLogger.logAppBindNamingExceptionLoggable((String)this.name, (String)this.applicationJNDIName), (Throwable)namingException);
            }
        }
    }

    public void unAdvertise() {
        this.advertised = false;
        this.unAdvertiseDestinationImpl();
    }

    private void unAdvertiseDestinationImpl() {
        if (!this.isTemporary()) {
            if (this.jndiName != null && this.bound) {
                try {
                    PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(true), this.jndiName, kernelId);
                    this.bound = false;
                    this.clearStateFlag(131072);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            if (this.getLocalJNDIName() != null && this.localBound) {
                try {
                    PrivilegedActionUtilities.unbindAsSU(JMSService.getContext(false), this.getLocalJNDIName(), kernelId);
                    this.localBound = false;
                    this.clearStateFlag(262144);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            if (this.applicationBound && this.applicationContext != null && this.applicationJNDIName != null) {
                try {
                    PrivilegedActionUtilities.unbindAsSU(this.applicationContext, this.applicationJNDIName, kernelId);
                    this.applicationBound = false;
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setErrorDestination(EntityName entityName) {
        Object object = this.configurationLock;
        synchronized (object) {
            this.errorDestinationName = entityName;
            this.foundBEErrorDestination = false;
        }
    }

    public void setExpirationLoggingPolicy(String string) {
        this.expirationLoggingPolicy = string;
        StringBuffer stringBuffer = new StringBuffer(256);
        List list = JMSMessageExpirationHelper.extractJMSHeaderAndProperty(this.expirationLoggingPolicy, stringBuffer);
        List list2 = JMSMessageExpirationHelper.convertStringToLinkedList(stringBuffer.toString());
        this.setExpirationLoggingJMSHeaders(list);
        this.setExpirationLoggingUserProperties(list2);
    }

    public final String getJMSCreateDestinationIdentifier() {
        return this.jmsCreateDestinationIdentifier;
    }

    public final void setJMSCreateDestinationIdentifier(String string) {
        this.jmsCreateDestinationIdentifier = string;
    }

    public void setMessageLoggingEnabled(boolean bl) {
        this.messageLoggingEnabled = bl;
    }

    public boolean isMessageLoggingEnabled() {
        if (JMSService.getJMSService().shouldMessageLogAll()) {
            return true;
        }
        return this.messageLoggingEnabled;
    }

    public final List getMessageLoggingJMSHeaders() {
        return this.messageLoggingJMSHeaders;
    }

    private final void setMessageLoggingJMSHeaders(List list) {
        this.messageLoggingJMSHeaders = list;
    }

    public final List getMessageLoggingUserProperties() {
        return this.messageLoggingUserProperties;
    }

    private final void setMessageLoggingUserProperties(List list) {
        this.messageLoggingUserProperties = list;
    }

    public void setMessageLoggingFormat(String string) {
        this.messageLoggingFormat = string;
        StringBuffer stringBuffer = new StringBuffer(256);
        List list = JMSMessageLogHelper.extractJMSHeaderAndProperty(this.messageLoggingFormat, stringBuffer);
        List list2 = JMSMessageLogHelper.convertStringToLinkedList(stringBuffer.toString());
        this.setMessageLoggingJMSHeaders(list);
        this.setMessageLoggingUserProperties(list2);
    }

    public void setDefaultUnitOfOrder(boolean bl) throws IllegalArgumentException {
        this.defaultUnitOfOrder = bl ? this.DEFAULT_UOO_NAME : null;
    }

    public String getDefaultUnitOfOrder() {
        return this.defaultUnitOfOrder;
    }

    public final String getListenerName() {
        return this.getName();
    }

    public final JMSDestinationSecurity getJMSDestinationSecurity() {
        return this.jmsDestinationSecurity;
    }

    public boolean isAvailableForCreateDestination() {
        if (this.destinationImpl == null || this.jmsCreateDestinationIdentifier != null || this.destinationImpl.getModuleName() == null) {
            return true;
        }
        return this.jndiName != null || this.localJNDIName != null;
    }
}

