/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.common.JMSDestinationCreateResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public final class BEDestinationCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 2406860847787652474L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int JMS_CREATE_IDENTIFIER = 256;
    private String destinationName;
    private int destType;
    private boolean forCreateDestination;

    public BEDestinationCreateRequest(JMSID jMSID, String string, int n, boolean bl) {
        super(jMSID, 11534);
        this.destinationName = string;
        this.destType = n;
        this.forCreateDestination = bl;
    }

    public final String getDestinationName() {
        return this.destinationName;
    }

    public final int getDestType() {
        return this.destType;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return new JMSDestinationCreateResponse();
    }

    public BEDestinationCreateRequest() {
    }

    boolean isForCreateDestination() {
        return this.forCreateDestination;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.forCreateDestination) {
            n |= 0x100;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        objectOutput.writeUTF(this.destinationName);
        objectOutput.writeInt(this.destType);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        this.forCreateDestination = (n & 0x100) != 0;
        super.readExternal(objectInput);
        this.destinationName = objectInput.readUTF();
        this.destType = objectInput.readInt();
    }
}

