/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEBrowser;
import weblogic.jms.backend.BEConnectionConsumerImpl;
import weblogic.jms.backend.BEConsumerCommon;
import weblogic.jms.backend.BEConsumerCreateRequest;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.backend.BEDestinationCommon;
import weblogic.jms.backend.BEExtension;
import weblogic.jms.backend.BEForwardRequest;
import weblogic.jms.backend.BEForwardingConsumer;
import weblogic.jms.backend.BEMessageComparator;
import weblogic.jms.backend.BEOrderUpdateRequest;
import weblogic.jms.backend.BEProducerSecurityParticipantImpl;
import weblogic.jms.backend.BEProducerSendRequest;
import weblogic.jms.backend.BEQueueImpl;
import weblogic.jms.backend.BESession;
import weblogic.jms.backend.BESessionImpl;
import weblogic.jms.backend.BEThresholdHandler;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.backend.NewDestinationListener;
import weblogic.jms.common.BadSequenceNumberException;
import weblogic.jms.common.DispatcherCompletionListener;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDestinationSecurity;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageExpirationHelper;
import weblogic.jms.common.JMSProducerSendResponse;
import weblogic.jms.common.JMSSecurityException;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.common.ResourceAllocationException;
import weblogic.jms.dd.DDManager;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.jms.extensions.WLMessage;
import weblogic.jms.server.DestinationStatus;
import weblogic.jms.server.DestinationStatusListener;
import weblogic.jms.utils.tracing.MessageTimeStamp;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.messaging.Message;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.kernel.Destination;
import weblogic.messaging.kernel.IllegalStateException;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelListener;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.Quota;
import weblogic.messaging.kernel.QuotaException;
import weblogic.messaging.kernel.RedirectionListener;
import weblogic.messaging.kernel.SendOptions;
import weblogic.messaging.kernel.Sequence;
import weblogic.messaging.kernel.Statistics;
import weblogic.messaging.path.helper.PathHelper;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.security.WLSPrincipals;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.TransactionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BEDestinationImpl
extends BEDestinationCommon
implements RedirectionListener,
DestinationStatus {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    protected static final String QUOTA_PROP = "Quota";
    protected Destination destination;
    private Statistics statistics;
    protected BEMessageComparator comparator;
    static final int SEND_ISSUE_MESSAGE = 1102;
    private static final int SEND_COMPLETE = 1103;
    private static final int SEND_UNKNOWN = 1104;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final char NAME_DELIMITER = '@';
    protected String fullyQualifiedDestinationName;
    public static final int LOG_MESSAGE_ALL = 15;
    private volatile int state = 0;
    protected boolean deleted;
    protected final Set<BEConsumerCommon> consumers = new HashSet<BEConsumerCommon>();
    protected final HashMap<JMSID, BEProducerSecurityParticipantImpl> producers = new HashMap();
    private int consumersHigh;
    private long consumersTotal;
    private BEThresholdHandler thresholdHandler;
    private LinkedList<DestinationStatusListener> statusListeners = new LinkedList();
    private static LinkedList<NewDestinationListener> newDestinationListeners = new LinkedList();
    private boolean isUp = false;
    private BEExtension destExtension;
    private boolean ifReorder;
    private int throughputEmphasis = 25;
    private boolean isUOWDestination = false;
    private int incompleteWorkExpirationTime = 0;
    private byte[] signatureSecret;
    int count = 0;

    protected BEDestinationImpl(BackEnd backEnd, String string, boolean bl, JMSDestinationSecurity jMSDestinationSecurity) {
        super(backEnd, string, bl, jMSDestinationSecurity);
        this.fullyQualifiedDestinationName = this.getFullyQualifiedServerName() + '@' + string;
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Creating destination: " + string + " on " + backEnd.getName());
        }
        this.thresholdHandler = new BEThresholdHandler(backEnd.getName(), string);
    }

    private String getFullyQualifiedServerName() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        String string = runtimeAccess.getDomainName();
        String string2 = runtimeAccess.getServer().getCluster() != null ? runtimeAccess.getServer().getCluster().getName() : null;
        String string3 = runtimeAccess.getServerName();
        return string + '@' + string2 + '@' + string3;
    }

    public abstract void suspendMessageLogging() throws JMSException;

    public abstract void resumeMessageLogging() throws JMSException;

    public abstract boolean isMessageLogging();

    public abstract void setQuota(Quota var1) throws BeanUpdateFailedException;

    public void setModuleName(String string) {
        this.moduleName = string;
    }

    public synchronized void addStatusListener(DestinationStatusListener destinationStatusListener) {
        LinkedList<DestinationStatusListener> linkedList = new LinkedList<DestinationStatusListener>();
        linkedList.add(destinationStatusListener);
        ListIterator listIterator = this.statusListeners.listIterator();
        while (listIterator.hasNext()) {
            linkedList.add((DestinationStatusListener)listIterator.next());
        }
        this.statusListeners = linkedList;
    }

    public synchronized void removeStatusListener(DestinationStatusListener destinationStatusListener) {
        LinkedList linkedList = new LinkedList();
        ListIterator listIterator = this.statusListeners.listIterator();
        while (listIterator.hasNext()) {
            linkedList.add(listIterator.next());
        }
        linkedList.remove(destinationStatusListener);
        this.statusListeners = linkedList;
    }

    public static void addNewDestinationListener(NewDestinationListener newDestinationListener) {
        LinkedList<NewDestinationListener> linkedList = new LinkedList<NewDestinationListener>();
        linkedList.add(newDestinationListener);
        ListIterator listIterator = newDestinationListeners.listIterator();
        while (listIterator.hasNext()) {
            linkedList.add((NewDestinationListener)listIterator.next());
        }
        newDestinationListeners = linkedList;
    }

    public static void removeNewDestinationListener(NewDestinationListener newDestinationListener) {
        LinkedList linkedList = new LinkedList();
        ListIterator listIterator = newDestinationListeners.listIterator();
        while (listIterator.hasNext()) {
            linkedList.add(listIterator.next());
        }
        linkedList.remove(newDestinationListener);
        newDestinationListeners = linkedList;
    }

    protected void setKernel(Destination destination) throws JMSException {
        this.destination = destination;
        try {
            destination.setProperty("Durable", (Object)new Boolean(!this.isTemporary() && this.backEnd.isStoreEnabled()));
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }

    public void open() throws JMSException {
        try {
            this.destination.setProperty("MaximumMessageSize", (Object)new Integer(this.maximumMessageSize));
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
        this.statistics = this.destination.getStatistics();
        this.thresholdHandler.setTarget(this.destination);
        ListIterator listIterator = newDestinationListeners.listIterator();
        while (listIterator.hasNext()) {
            ((NewDestinationListener)listIterator.next()).newDestination(this);
        }
    }

    @Override
    public synchronized void setStateFlag(int n) {
        this.state |= n;
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("New state for " + this.name + ": " + JMSService.getStateName(this.state));
        }
    }

    @Override
    public synchronized void clearStateFlag(int n) {
        this.state &= ~n;
    }

    private synchronized boolean checkStateFlag(int n) {
        return (this.state & n) != 0;
    }

    private boolean checkStateFlagFast(int n) {
        return (this.state & n) != 0;
    }

    public synchronized void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    public Destination getKernelDestination() {
        return this.destination;
    }

    public void setExtension(BEExtension bEExtension) {
        this.destExtension = bEExtension;
    }

    public BEExtension getExtension() {
        return this.destExtension;
    }

    public void setMessagingPerformancePreference(int n) {
        this.throughputEmphasis = n;
    }

    public int getMessagingPerformancePreference() {
        return this.throughputEmphasis;
    }

    @Override
    public void setMaximumMessageSize(int n) {
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Destination " + this.name + " maximum message size " + n);
        }
        super.setMaximumMessageSize(n);
        if (this.destination != null) {
            try {
                this.destination.setProperty("MaximumMessageSize", (Object)new Integer(n));
            }
            catch (KernelException kernelException) {
                // empty catch block
            }
        }
    }

    protected int getAdjustedExpirationPolicy(boolean bl) {
        return this.expirationPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expirationTimeReached(RedirectionListener.Info info, boolean bl) {
        int n = this.getAdjustedExpirationPolicy(bl);
        switch (n) {
            case 2: {
                Object object = this.configurationLock;
                synchronized (object) {
                    MessageImpl messageImpl = (MessageImpl)info.getMessage();
                    messageImpl.setJMSDestinationImpl(this.destinationImpl);
                    JMSMessageExpirationHelper.logExpiredMessage(messageImpl, this.getExpirationLoggingJMSHeaders(), this.getExpirationLoggingUserProperties());
                    break;
                }
            }
            case 4: {
                BEDestinationImpl bEDestinationImpl = this.getBEErrorDestination();
                MessageImpl messageImpl = null;
                Object object = this.configurationLock;
                synchronized (object) {
                    messageImpl = (MessageImpl)info.getMessageElement().getMessage();
                    try {
                        if (!messageImpl.propertyExists("JMS_BEA_DeliveryFailureReason")) {
                            if (JMSDebug.JMSModule.isDebugEnabled()) {
                                if (messageImpl instanceof TextMessage) {
                                    try {
                                        ((TextMessage)messageImpl).getText();
                                    }
                                    catch (JMSException jMSException) {
                                        // empty catch block
                                    }
                                }
                                JMSDebug.JMSModule.debug("Setting delivery failure reason for " + messageImpl + " on " + this.name + " to EXPIRATION_TIME_REACHED");
                            }
                            messageImpl.setPropertiesWritable(true);
                            messageImpl.setIntProperty("JMS_BEA_DeliveryFailureReason", 0);
                            messageImpl.setPropertiesWritable(false);
                            messageImpl.setSAFSequenceName(null);
                            messageImpl.setSAFSeqNumber(0L);
                        }
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
                this.applyRedirectOverrides(bEDestinationImpl, messageImpl, true);
                object = this.configurationLock;
                synchronized (object) {
                    info.setSendOptions(this.createSendOptions(0L, null, messageImpl));
                    info.setRedirectDestination(bEDestinationImpl.getKernelDestination());
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliveryLimitReached(RedirectionListener.Info info) {
        BEDestinationImpl bEDestinationImpl = this.getBEErrorDestination();
        if (bEDestinationImpl != null) {
            MessageImpl messageImpl = null;
            Object object = this.configurationLock;
            synchronized (object) {
                block13: {
                    messageImpl = (MessageImpl)info.getMessageElement().getMessage();
                    try {
                        if (messageImpl.propertyExists("JMS_BEA_DeliveryFailureReason")) break block13;
                        if (JMSDebug.JMSModule.isDebugEnabled()) {
                            if (messageImpl instanceof TextMessage) {
                                try {
                                    ((TextMessage)messageImpl).getText();
                                }
                                catch (JMSException jMSException) {
                                    // empty catch block
                                }
                            }
                            JMSDebug.JMSModule.debug("Setting delivery failure reason for " + messageImpl + " on " + this.name + " to DELIVERY_LIMIT_REACHED");
                        }
                        messageImpl.setPropertiesWritable(true);
                        messageImpl.setIntProperty("JMS_BEA_DeliveryFailureReason", 2);
                        messageImpl.setPropertiesWritable(false);
                        messageImpl.setSAFSequenceName(null);
                        messageImpl.setSAFSeqNumber(0L);
                    }
                    catch (JMSException jMSException) {
                        // empty catch block
                    }
                }
            }
            this.applyRedirectOverrides(bEDestinationImpl, messageImpl, true);
            object = this.configurationLock;
            synchronized (object) {
                info.setSendOptions(this.createSendOptions(0L, null, messageImpl));
                info.setRedirectDestination(bEDestinationImpl.getKernelDestination());
            }
        }
    }

    private void applyRedirectOverrides(BEDestinationImpl bEDestinationImpl, MessageImpl messageImpl, boolean bl) {
        messageImpl.setDeliveryTime(0L);
        messageImpl._setJMSRedeliveryLimit(-1);
        if (bl) {
            messageImpl._setJMSExpiration(0L);
        }
        try {
            bEDestinationImpl.applyOverrides(messageImpl, null);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private boolean isFlowControlRequired() {
        return this.thresholdHandler.isArmed() || this.backEnd.needsFlowControl();
    }

    public long getBytesHigh() {
        return this.thresholdHandler.getBytesThresholdHigh();
    }

    public long getBytesLow() {
        return this.thresholdHandler.getBytesThresholdLow();
    }

    public long getMessagesHigh() {
        return this.thresholdHandler.getMessagesThresholdHigh();
    }

    public long getMessagesLow() {
        return this.thresholdHandler.getMessagesThresholdLow();
    }

    public long getMessagesThresholdTime() {
        return this.thresholdHandler.getMessagesThresholdTime();
    }

    public long getBytesThresholdTime() {
        return this.thresholdHandler.getBytesThresholdTime();
    }

    public void setBytesMaximum(long l) {
        if (l <= 0L) {
            l = Integer.MAX_VALUE;
        }
        if (this.destination != null) {
            Quota quota = (Quota)this.destination.getProperty(QUOTA_PROP);
            quota.setBytesMaximum(l);
        }
    }

    public void setBytesHigh(long l) {
        this.thresholdHandler.setBytesThresholdHigh(l);
    }

    public void setBytesLow(long l) {
        this.thresholdHandler.setBytesThresholdLow(l);
    }

    public void setMessagesMaximum(long l) {
        if (l <= 0L || l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        if (this.destination != null) {
            Quota quota = (Quota)this.destination.getProperty(QUOTA_PROP);
            quota.setMessagesMaximum((int)l);
        }
    }

    public void setMessagesHigh(long l) {
        this.thresholdHandler.setMessagesThresholdHigh(l);
    }

    public void setMessagesLow(long l) {
        this.thresholdHandler.setMessagesThresholdLow(l);
    }

    public long getMessagesPendingCount() {
        return this.statistics.getMessagesPending();
    }

    public long getMessagesCurrentCount() {
        return this.statistics.getMessagesCurrent() - this.statistics.getMessagesPending();
    }

    public long getMessagesHighCount() {
        return this.statistics.getMessagesHigh();
    }

    public long getMessagesReceivedCount() {
        return this.statistics.getMessagesReceived();
    }

    public long getBytesCurrentCount() {
        return this.statistics.getBytesCurrent() - this.statistics.getBytesPending();
    }

    public long getBytesPendingCount() {
        return this.statistics.getBytesPending();
    }

    public long getBytesHighCount() {
        return this.statistics.getBytesHigh();
    }

    public long getBytesReceivedCount() {
        return this.statistics.getBytesReceived();
    }

    public final void resetStatistics() {
    }

    @Override
    public synchronized void setDestinationKeysList(List list) {
        this.destinationKeysList = list;
        if (list != null && !list.isEmpty()) {
            this.comparator = new BEMessageComparator(list);
            if (this.comparator.isDefault()) {
                this.comparator = null;
            }
        } else {
            this.comparator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws JMSException {
        try {
            this.destination.setProperty("Durable", (Object)new Boolean(!this.isTemporary() && this.backEnd.isStoreEnabled()));
            this.destination.resume(16384);
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
        if (this.runtimeMBean != null) {
            try {
                if (JMSDebug.JMSModule.isDebugEnabled()) {
                    JMSDebug.JMSModule.debug("Registering runtimeMBean " + this.runtimeMBean + " on " + this.backEnd.getName());
                }
                PrivilegedActionUtilities.register(this.runtimeMBean, kernelId);
            }
            catch (ManagementException managementException) {
                JMSException jMSException = new JMSException("Failed to register the JMSServerRuntimeMBean " + this.name);
                jMSException.setLinkedException((Exception)((Object)managementException));
                throw jMSException;
            }
        }
        this.advertise();
        this.prepareSignature();
        Object object = this;
        synchronized (object) {
            this.state = 4 | this.state & 0x60000;
            if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                JMSDebug.JMSPauseResume.debug(this.name + " During destination start(): " + " this.ProductionPausedAtStartup=" + this.productionPausedAtStartup + ", this.InsertionPausedAtStartup= " + this.insertionPausedAtStartup + ", this.ConsumptionPausedAtStartup=" + this.consumptionPausedAtStartup);
                JMSDebug.JMSPauseResume.debug(this.name + " During destination start(): " + " backEnd.getProductionPausedAtStartup()=" + this.backEnd.getProductionPausedAtStartup() + ", backEnd.getInsertionPausedAtStartup()= " + this.backEnd.getInsertionPausedAtStartup() + ", backEnd.getConsumptionPausedAtStartup()=" + this.backEnd.getConsumptionPausedAtStartup());
            }
            if (this.backEnd.getProductionPausedAtStartup().equals("default")) {
                if (!this.productionPausedAtStartup) {
                    if (this.isProductionPaused()) {
                        if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                            JMSDebug.JMSPauseResume.debug("Resuming new message production on destination(" + this.name + "), because the destination has ProductionPausedAtStartup " + "parameter is either not set or set to true and the hosting JMSServer " + this.backEnd.getName() + " has the ProductionPausedAtStartup parameter set to default");
                        }
                        this.resumeProduction();
                    }
                } else if (!this.isProductionPaused()) {
                    if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                        JMSDebug.JMSPauseResume.debug("Pausing new message production on destination(" + this.name + "), because the destination has ProductionPausedAtStartup " + "parameter set to true and the hosting JMSServer " + this.backEnd.getName() + " has the ProductionPausedAtStartup parameter set to default");
                    }
                    this.pauseProduction();
                }
            } else if (this.backEnd.getProductionPausedAtStartup().equals("true")) {
                if (!this.isProductionPaused()) {
                    if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                        JMSDebug.JMSPauseResume.debug("Pausing new message production on destination(" + this.name + "), because the hosting JMSServer(" + this.backEnd.getName() + ") has ProductionPausedAtStartup parameter set to true");
                    }
                    this.pauseProduction();
                }
            } else if (this.backEnd.getProductionPausedAtStartup().equals("false") && this.isProductionPaused()) {
                if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                    JMSDebug.JMSPauseResume.debug("Resuming new message production on destination(" + this.name + "), because the hosting JMSServer(" + this.backEnd.getName() + ") has ProductionPausedAtStartup parameter set to false");
                }
                this.resumeProduction();
            }
            if (this.backEnd.getInsertionPausedAtStartup().equals("default")) {
                if (!this.insertionPausedAtStartup) {
                    if (this.isInsertionPaused()) {
                        if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                            JMSDebug.JMSPauseResume.debug("Resuming message insertion (in-flight message insertion) on destination(" + this.name + "), because the destination has InsertionPausedAtStartup " + "parameter is either not set or set to true and the hosting JMSServer " + this.backEnd.getName() + " has the InsertionPausedAtStartup parameter set to default");
                        }
                        this.resumeInsertion();
                    }
                } else if (!this.isInsertionPaused()) {
                    if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                        JMSDebug.JMSPauseResume.debug("Pausing message insertion (in-flight message insertion) on destination(" + this.name + "), because the destination has InsertionPausedAtStartup " + "parameter set to true and the hosting JMSServer " + this.backEnd.getName() + " has the InsertionPausedAtStartup parameter set to default");
                    }
                    this.pauseInsertion();
                }
            } else if (this.backEnd.getInsertionPausedAtStartup().equals("true")) {
                if (!this.isInsertionPaused()) {
                    if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                        JMSDebug.JMSPauseResume.debug("Pausing message insertion (in-flight message insertion) on destination(" + this.name + "), because the hosting JMSServer(" + this.backEnd.getName() + ") has InsertionPausedAtStartup parameter set to true");
                    }
                    this.pauseInsertion();
                }
            } else if (this.backEnd.getInsertionPausedAtStartup().equals("false") && this.isInsertionPaused()) {
                if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                    JMSDebug.JMSPauseResume.debug("Resuming message insertion (in-flight message insertion) on destination(" + this.name + "), because the hosting JMSServer(" + this.backEnd.getName() + ") has InsertionPausedAtStartup parameter set to false");
                }
                this.resumeInsertion();
            }
            if (this.backEnd.getConsumptionPausedAtStartup().equals("default")) {
                if (!this.consumptionPausedAtStartup) {
                    if (this.isConsumptionPaused()) {
                        if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                            JMSDebug.JMSPauseResume.debug("Resuming new message consumption on destination(" + this.name + "), because the destination has ConsumptionPausedAtStartup " + "parameter is either not set or set to true and the hosting JMSServer " + this.backEnd.getName() + " has the ConsumptionPausedAtStartup parameter set to default");
                        }
                        this.resumeConsumption();
                    }
                } else if (!this.isConsumptionPaused()) {
                    if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                        JMSDebug.JMSPauseResume.debug("Pausing new message consumption on destination(" + this.name + "), because the destination has ConsumptionPausedAtStartup " + "parameter set to true and the hosting JMSServer " + this.backEnd.getName() + " has the ConsumptionPausedAtStartup parameter set to default");
                    }
                    this.pauseConsumption();
                }
            } else if (this.backEnd.getConsumptionPausedAtStartup().equals("true")) {
                if (!this.isConsumptionPaused()) {
                    if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                        JMSDebug.JMSPauseResume.debug("Pausing new message consumption on destination(" + this.name + "), because the hosting JMSServer(" + this.backEnd.getName() + ") has ConsumptionPausedAtStartup parameter set to true");
                    }
                    this.pauseConsumption();
                }
            } else if (this.backEnd.getConsumptionPausedAtStartup().equals("false") && this.isConsumptionPaused()) {
                if (JMSDebug.JMSPauseResume.isDebugEnabled()) {
                    JMSDebug.JMSPauseResume.debug("Resuming new message consumption on destination(" + this.name + "), because the hosting JMSServer(" + this.backEnd.getName() + ") has ConsumptionPausedAtStartup parameter set to false");
                }
                this.resumeConsumption();
            }
        }
        this.isUp = true;
        object = this.statusListeners.listIterator();
        while (object.hasNext()) {
            ((DestinationStatusListener)object.next()).onUpStatusChange(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suspend() {
        BEDestinationImpl bEDestinationImpl = this;
        synchronized (bEDestinationImpl) {
            if (this.checkStateFlag(25)) {
                return;
            }
            this.state = 1;
        }
        this.shutdownInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        BEDestinationImpl bEDestinationImpl = this;
        synchronized (bEDestinationImpl) {
            if (this.checkStateFlag(16)) {
                return;
            }
            if (this.checkStateFlag(8)) {
                this.state = 16;
            }
        }
        this.shutdownInternal();
    }

    private void shutdownInternal() {
        Object object;
        this.isUp = false;
        String string = this.deleted ? "Consumer destination was deleted" : "Consumer destination was closed";
        if (this.runtimeMBean != null) {
            try {
                if (JMSDebug.JMSModule.isDebugEnabled()) {
                    JMSDebug.JMSModule.debug("Unregistering runtimeMBean " + this.runtimeMBean + " on " + this.backEnd.getName());
                }
                PrivilegedActionUtilities.unregister(this.runtimeMBean, kernelId);
            }
            catch (ManagementException managementException) {
                managementException.printStackTrace();
            }
        }
        this.closeAllConsumers(string);
        this.closeAllBrowsers(string);
        this.unAdvertise();
        if (this.deleted) {
            try {
                object = new KernelRequest();
                this.destination.delete((KernelRequest)object);
            }
            catch (KernelException kernelException) {
                JMSLogger.logErrorUnregisteringBackEndDestination((String)this.backEnd.getName(), (Object)this, (Throwable)kernelException);
            }
        } else {
            try {
                this.destination.suspend(16384);
            }
            catch (KernelException kernelException) {
                JMSLogger.logErrorUnregisteringBackEndDestination((String)this.backEnd.getName(), (Object)this, (Throwable)kernelException);
            }
        }
        object = this.statusListeners.listIterator();
        while (object.hasNext()) {
            ((DestinationStatusListener)object.next()).onUpStatusChange(this);
        }
    }

    protected abstract BEConsumerImpl createConsumer(BESessionImpl var1, boolean var2, BEConsumerCreateRequest var3) throws JMSException;

    abstract BEConnectionConsumerImpl createConnectionConsumer(JMSID var1, ServerSessionPool var2, String var3, String var4, String var5, boolean var6, int var7, long var8, boolean var10, boolean var11) throws JMSException;

    @Override
    public boolean hasConsumers() {
        return !this.consumers.isEmpty();
    }

    @Override
    public boolean isUp() {
        return this.isUp;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isPersistent() {
        int n;
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain();
        JMSServerMBean jMSServerMBean = null;
        String string = this.getBackEnd().getName();
        for (n = 0; n < domainMBean.getJMSServers().length; ++n) {
            if (!domainMBean.getJMSServers()[n].getName().equals(string)) continue;
            jMSServerMBean = domainMBean.getJMSServers()[n];
            break;
        }
        n = 0;
        if (jMSServerMBean != null) {
            n = jMSServerMBean.getStoreEnabled() ? 1 : 0;
        }
        return n != 0 && this.deliveryModeOverride != 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(BEConsumerCommon bEConsumerCommon) throws JMSException {
        boolean bl = false;
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("New consumer for " + this.name);
        }
        Object object = this;
        synchronized (object) {
            if (this.consumers.isEmpty()) {
                bl = true;
            }
            if (!this.consumers.add(bEConsumerCommon)) {
                throw new AssertionError((Object)"Duplicate consumer");
            }
            if (this.consumers.size() > this.consumersHigh) {
                this.consumersHigh = this.consumers.size();
            }
            ++this.consumersTotal;
        }
        if (bl) {
            object = this.statusListeners.listIterator();
            while (object.hasNext()) {
                ((DestinationStatusListener)object.next()).onHasConsumersStatusChange(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(BEConsumerImpl bEConsumerImpl, boolean bl) throws JMSException {
        boolean bl2 = false;
        Object object = this;
        synchronized (object) {
            this.consumers.remove(bEConsumerImpl);
            if (this.consumers.size() == 0) {
                bl2 = true;
            }
        }
        if (bl2) {
            object = this.statusListeners.listIterator();
            while (object.hasNext()) {
                ((DestinationStatusListener)object.next()).onHasConsumersStatusChange(this);
            }
        }
    }

    public synchronized long getConsumersCurrentCount() {
        return this.consumers.size();
    }

    public synchronized long getConsumersHighCount() {
        return this.consumersHigh;
    }

    public synchronized long getConsumersTotalCount() {
        return this.consumersTotal;
    }

    public BEBrowser createBrowser(BESession bESession, String string) throws JMSException {
        throw new weblogic.jms.common.JMSException("Not implemented");
    }

    public synchronized Map<Object, Object> getConsumersClone() {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(this.consumers.size());
        for (BEConsumerCommon bEConsumerCommon : this.consumers) {
            hashMap.put(bEConsumerCommon, bEConsumerCommon);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllConsumers(String string) {
        ArrayList<BEConsumerCommon> arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList<BEConsumerCommon>(this.consumers);
            this.consumers.clear();
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                BEConsumerImpl bEConsumerImpl = (BEConsumerImpl)object.next();
                bEConsumerImpl.closeWithError(string);
            }
            catch (JMSException jMSException) {}
        }
    }

    protected void closeAllBrowsers(String string) {
    }

    public final boolean isStarted() {
        return this.checkStateFlag(4);
    }

    public final boolean isShutdown() {
        return this.checkStateFlag(120);
    }

    public final synchronized boolean isShutdownOrSuspended() {
        return this.state == 0 || this.checkStateFlagFast(123);
    }

    public final synchronized boolean isShutdownOrSuspending() {
        return this.state == 0 || this.checkStateFlag(106);
    }

    @Override
    public final void checkShutdown(String string) throws JMSException {
        if (this.isShutdown()) {
            throw new weblogic.jms.common.IllegalStateException(this.getOfflineStateMessage(string));
        }
    }

    public final void checkShutdownOrSuspended(String string) throws JMSException {
        if (this.isShutdownOrSuspended()) {
            throw new weblogic.jms.common.IllegalStateException(this.getOfflineStateMessage(string));
        }
    }

    public final void checkShutdownOrSuspendedNeedLock(String string) throws JMSException {
        if (this.state == 0 || this.checkStateFlagFast(123)) {
            throw new weblogic.jms.common.IllegalStateException(this.getOfflineStateMessage(string));
        }
    }

    public final synchronized void markSuspending() {
        if (!this.checkStateFlag(121)) {
            this.state = 2;
        }
    }

    public final int getStateValue() {
        return this.state;
    }

    public final void setStateValue(int n) {
        this.state = n;
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("New state for " + this.name + ": " + JMSService.getStateName(n));
        }
    }

    public final synchronized String getState() {
        int n = this.state;
        if ((n & 4) != 0 && (n &= 0xFFFFFFFB) == 0) {
            n = 4;
        }
        return JMSService.getStateName(n);
    }

    private String getOfflineStateMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer(256);
        if (string != null) {
            stringBuffer.append("Failed to " + string + "because destination " + this.name);
        } else {
            stringBuffer.append("Destination " + this.name);
        }
        if (this.deleted) {
            stringBuffer.append(" is deleted.");
        } else if (this.isShutdown()) {
            stringBuffer.append(" is shutdown.");
        } else if (this.isProductionPaused()) {
            stringBuffer.append(" is being paused for production.");
        } else if (this.isInsertionPaused()) {
            stringBuffer.append(" is being paused for insertion.");
        } else if (this.isConsumptionPaused()) {
            stringBuffer.append(" is being paused for consumption.");
        } else {
            stringBuffer.append(" is suspended.");
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTempDestination() throws JMSException {
        BEDestinationImpl bEDestinationImpl = this;
        synchronized (bEDestinationImpl) {
            if (!this.consumers.isEmpty()) {
                throw new weblogic.jms.common.JMSException("Temporary destination cannot be deleted, it still has consumers");
            }
            this.setDeleted(true);
        }
        if (this.runtimeMBean != null) {
            try {
                PrivilegedActionUtilities.unregister(this.runtimeMBean, kernelId);
            }
            catch (ManagementException managementException) {
                JMSLogger.logErrorUnregisteringBackEndDestination((String)this.backEnd.getName(), (Object)this, (Throwable)managementException);
                throw new weblogic.jms.common.JMSException("Error deleting temporary destination", (Throwable)managementException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markShuttingDown() {
        boolean bl = false;
        BEDestinationImpl bEDestinationImpl = this;
        synchronized (bEDestinationImpl) {
            if ((this.runtimeMBean != null && this.runtimeMBean.isRegistered() || !this.isTemporary()) && (this.getStateValue() & 3) == 0) {
                bl = true;
                this.setStateValue(8);
            }
        }
        if (this.runtimeMBean != null && bl) {
            try {
                PrivilegedActionUtilities.unregister(this.runtimeMBean, kernelId);
            }
            catch (ManagementException managementException) {
                // empty catch block
            }
        }
        bEDestinationImpl = this;
        synchronized (bEDestinationImpl) {
            if (!this.isShutdownOrSuspended()) {
                this.setStateValue(8);
            }
        }
    }

    public synchronized boolean isDeleted() {
        return this.deleted;
    }

    public void expireReadersAtShutdown() {
    }

    protected void suspendKernelDestination(int n) throws JMSException {
        try {
            this.destination.suspend(n);
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }

    protected void resumeKernelDestination(int n) throws JMSException {
        try {
            this.destination.resume(n);
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }

    public void pause() {
        block2: {
            try {
                this.pauseProduction();
            }
            catch (JMSException jMSException) {
                if (!JMSDebug.JMSBackEnd.isDebugEnabled()) break block2;
                JMSDebug.JMSBackEnd.debug("Error pausing destination: " + (Object)((Object)jMSException));
            }
        }
    }

    public void resume() {
        block2: {
            try {
                this.resumeProduction();
            }
            catch (JMSException jMSException) {
                if (!JMSDebug.JMSBackEnd.isDebugEnabled()) break block2;
                JMSDebug.JMSBackEnd.debug("Error resuming destination: " + (Object)((Object)jMSException));
            }
        }
    }

    public boolean isPaused() {
        return this.isProductionPaused();
    }

    public void pauseProduction() throws JMSException {
        this.pauseProduction(true);
    }

    public void pauseProduction(boolean bl) throws JMSException {
        if (!this.isProductionPaused()) {
            String string = "Destination " + this.name + " has paused all send requests";
            this.checkShutdownOrSuspended(string);
            this.setStateFlag(512);
            ListIterator listIterator = this.statusListeners.listIterator();
            while (listIterator.hasNext()) {
                ((DestinationStatusListener)listIterator.next()).onProductionPauseChange(this);
            }
            if (bl) {
                JMSLogger.logProductionPauseOfDestination((String)this.name);
            }
        }
    }

    public void resumeProduction() throws JMSException {
        this.resumeProduction(true);
    }

    public void resumeProduction(boolean bl) throws JMSException {
        if (this.isProductionPaused()) {
            String string = "Destination " + this.name + " is resuming all send requests";
            this.checkShutdownOrSuspended(string);
            this.setStateFlag(1024);
            this.clearStateFlag(1536);
            ListIterator listIterator = this.statusListeners.listIterator();
            while (listIterator.hasNext()) {
                ((DestinationStatusListener)listIterator.next()).onProductionPauseChange(this);
            }
            if (bl) {
                JMSLogger.logProductionResumeOfDestination((String)this.name);
            }
        }
    }

    @Override
    public boolean isProductionPaused() {
        return this.checkStateFlag(512);
    }

    public String getProductionPausedState() {
        if (this.checkStateFlag(512)) {
            return "Production-Paused";
        }
        return "Production-Enabled";
    }

    public void pauseInsertion() throws JMSException {
        if (!this.isInsertionPaused()) {
            String string = "Destination " + this.name + " has paused message insertion";
            this.checkShutdownOrSuspended(string);
            this.setStateFlag(2048);
            this.suspendKernelDestination(4);
            this.clearStateFlag(2048);
            this.setStateFlag(4096);
            ListIterator listIterator = this.statusListeners.listIterator();
            while (listIterator.hasNext()) {
                ((DestinationStatusListener)listIterator.next()).onInsertionPauseChange(this);
            }
            JMSLogger.logInsertionPauseOfDestination((String)this.name);
        }
    }

    public void resumeInsertion() throws JMSException {
        if (this.isInsertionPaused()) {
            String string = "Destination " + this.name + " is resuming all message insertion";
            this.checkShutdownOrSuspended(string);
            this.setStateFlag(8192);
            this.resumeKernelDestination(4);
            this.clearStateFlag(12288);
            ListIterator listIterator = this.statusListeners.listIterator();
            while (listIterator.hasNext()) {
                ((DestinationStatusListener)listIterator.next()).onInsertionPauseChange(this);
            }
            JMSLogger.logInsertionResumeOfDestination((String)this.name);
        }
    }

    @Override
    public boolean isInsertionPaused() {
        return this.checkStateFlag(6144);
    }

    public String getInsertionPausedState() {
        if (this.checkStateFlag(2048)) {
            return "Insertion-Pausing";
        }
        if (this.checkStateFlag(4096)) {
            return "Insertion-Paused";
        }
        return "Insertion-Enabled";
    }

    public void pauseConsumption() throws JMSException {
        this.pauseConsumption(true);
    }

    public void pauseConsumption(boolean bl) throws JMSException {
        if (!this.isConsumptionPaused()) {
            String string = "Destination " + this.name + " is paused for consumption";
            this.checkShutdownOrSuspended(string);
            this.setStateFlag(16384);
            this.suspendKernelDestination(2);
            this.clearStateFlag(16384);
            this.setStateFlag(32768);
            ListIterator listIterator = this.statusListeners.listIterator();
            while (listIterator.hasNext()) {
                ((DestinationStatusListener)listIterator.next()).onConsumptionPauseChange(this);
            }
            if (bl) {
                JMSLogger.logConsumptionPauseOfDestination((String)this.name);
            }
        }
    }

    public void resumeConsumption() throws JMSException {
        this.resumeConsumption(true);
    }

    public void resumeConsumption(boolean bl) throws JMSException {
        if (this.isConsumptionPaused()) {
            String string = "Destination " + this.name + " is resuming for consumption";
            this.checkShutdownOrSuspended(string);
            this.setStateFlag(65536);
            this.resumeKernelDestination(2);
            this.clearStateFlag(98304);
            ListIterator listIterator = this.statusListeners.listIterator();
            while (listIterator.hasNext()) {
                ((DestinationStatusListener)listIterator.next()).onConsumptionPauseChange(this);
            }
            if (bl) {
                JMSLogger.logConsumptionResumeOfDestination((String)this.name);
            }
        }
    }

    @Override
    public boolean isConsumptionPaused() {
        return this.checkStateFlag(49152);
    }

    public String getConsumptionPausedState() {
        if (this.checkStateFlag(16384)) {
            return "Consumption-Pausing";
        }
        if (this.checkStateFlag(32768)) {
            return "Consumption-Paused";
        }
        return "Consumption-Enabled";
    }

    @Override
    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 12052: {
                return this.wrappedSend((BEProducerSendRequest)request);
            }
            case 17684: {
                return this.tranForward((BEForwardRequest)request);
            }
            case 17940: {
                return BEDestinationImpl.uooUpdate(request);
            }
        }
        throw new weblogic.jms.common.JMSException("No such method " + this.getClass().getName() + ".<" + request.getMethodId() + ">");
    }

    private void sendInitialize(BEProducerSendRequest bEProducerSendRequest) throws JMSException {
        String string;
        MessageTimeStamp.record(2, bEProducerSendRequest.getMessage());
        if ((this.state & 0x200) != 0) {
            throw new weblogic.jms.common.IllegalStateException("Destination " + this.name + " is paused for new message production");
        }
        this.checkPermission(bEProducerSendRequest);
        this.checkShutdownOrSuspendedNeedLock("send message");
        MessageImpl messageImpl = bEProducerSendRequest.getMessage();
        bEProducerSendRequest.setWorkManager(this.getBackEnd().getWorkManager());
        if (!messageImpl.isForwardable() && (this.attachSenderMode == 2 || messageImpl.isJMSXUserIDRequested() && this.attachSenderMode != 1)) {
            messageImpl.setJMSXUserID(JMSSecurityHelper.getSimpleAuthenticatedName());
        } else if (this.attachSenderMode == 1) {
            messageImpl.setJMSXUserID(null);
        }
        messageImpl.setJMSDestinationImpl(this.destinationImpl);
        assert (bEProducerSendRequest.getSequence() == null) : "START state with SEQUENCE";
        bEProducerSendRequest.setSequence(this.findOrCreateKernelSequence(bEProducerSendRequest.getMessage()));
        if (bEProducerSendRequest.getMessage().getUnitOfOrder() == null && (string = this.getDefaultUnitOfOrder()) != null) {
            bEProducerSendRequest.getMessage().setUnitOfOrderName(string);
        }
    }

    protected boolean clientSendResumeNeedsNewThread() {
        return false;
    }

    public Sequence findOrCreateKernelSequence(MessageImpl messageImpl) throws JMSException {
        if (this.hasNoSequence(messageImpl)) {
            return null;
        }
        String string = this.getSequenceName(messageImpl);
        int n = this.getSequenceMode(messageImpl);
        try {
            if (this.releasingSequence(messageImpl.getControlOpcode())) {
                return this.destination.findSequence(string);
            }
            return this.destination.findOrCreateSequence(string, n);
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }

    private boolean hasNoSequence(MessageImpl messageImpl) throws JMSException {
        return this.getSequenceMode(messageImpl) == 0;
    }

    private boolean releasingSequence(int n) {
        return n != 0 && 131072 >= n;
    }

    protected String getSequenceName(WLMessage wLMessage) throws JMSException {
        String string = this.getSequenceMode(wLMessage) == 8 ? wLMessage.getStringProperty("JMS_BEA_UnitOfWork") : wLMessage.getSAFSequenceName();
        assert (string != null);
        return string;
    }

    public boolean isUOWDestination() {
        return this.isUOWDestination;
    }

    public void setUnitOfWorkHandlingPolicy(String string) {
        this.isUOWDestination = string.equals("SingleMessageDelivery");
    }

    public void setIncompleteWorkExpirationTime(int n) {
        this.incompleteWorkExpirationTime = n;
    }

    public int getIncompleteWorkExpirationTime() {
        return this.incompleteWorkExpirationTime;
    }

    protected int getSequenceMode(WLMessage wLMessage) throws JMSException {
        if (this.isUOWDestination && wLMessage.propertyExists("JMS_BEA_UnitOfWork") && wLMessage.getStringProperty("JMS_BEA_UnitOfWork") != null) {
            if (!wLMessage.propertyExists("JMS_BEA_UnitOfWorkSequenceNumber")) {
                throw new BadSequenceNumberException("A JMS Unit of Work message must have a sequence number");
            }
            return 8;
        }
        boolean bl = wLMessage.getSAFSeqNumber() != 0L;
        return this.getSequenceMode(bl, this.checkForwarded(wLMessage), ((MessageImpl)wLMessage).isSAFNeedReorder());
    }

    protected int getSequenceMode(boolean bl, boolean bl2) {
        return this.getSequenceMode(bl, bl2, false);
    }

    protected int getSequenceMode(boolean bl, boolean bl2, boolean bl3) {
        if (!bl || !bl2 && !bl3) {
            return 0;
        }
        if (bl2 && !bl3) {
            return 2;
        }
        return 4;
    }

    protected boolean checkForwarded(WLMessage wLMessage) {
        boolean bl = ((MessageImpl)wLMessage).isForwarded();
        if (wLMessage.getDDForwarded() && !bl) {
            throw new AssertionError((Object)"DD Forwarded msg is not marked as forwarded");
        }
        return bl;
    }

    protected boolean isReorderNeeded(WLMessage wLMessage) {
        return ((MessageImpl)wLMessage).isSAFNeedReorder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendIssueMessage(BEProducerSendRequest bEProducerSendRequest) throws JMSException {
        MessageImpl messageImpl = bEProducerSendRequest.getMessage();
        JMSProducerSendResponse jMSProducerSendResponse = bEProducerSendRequest.setupSendResponse();
        if (!messageImpl.isOldMessage() && jMSProducerSendResponse != null) {
            jMSProducerSendResponse.set90StyleMessageId();
        }
        this.applyOverrides(messageImpl, jMSProducerSendResponse);
        messageImpl.setConnectionId(bEProducerSendRequest.getConnectionId());
        messageImpl.setJMSDestinationImpl(null);
        if (messageImpl.getAdjustedDeliveryMode() == 2 && !this.backEnd.isStoreEnabled()) {
            if (this.backEnd.isAllowsPersistentDowngrade()) {
                messageImpl.setAdjustedDeliveryMode(1);
                messageImpl.setJMSDeliveryMode(1);
                if (jMSProducerSendResponse != null) {
                    jMSProducerSendResponse.setDeliveryMode(1);
                }
            } else {
                throw new JMSException(JMSExceptionLogger.logNoPersistentMessages((String)this.name, (String)this.backEnd.getName()));
            }
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Putting new message " + messageImpl.getId() + " on " + this.name);
        }
        bEProducerSendRequest.setState(1103);
        BEExtension bEExtension = this.destExtension;
        int n = bEProducerSendRequest.getMessage().getControlOpcode();
        if (n != 0) {
            assert (bEExtension == null || n == 196608) : "opcode value is " + Integer.toHexString(n);
            return false;
        }
        try {
            KernelRequest kernelRequest = this.destination.send((Message)messageImpl, this.createSendOptions(bEProducerSendRequest.getSendTimeout(), bEProducerSendRequest.getSequence(), bEProducerSendRequest.getMessage()));
            if (kernelRequest == null) {
                MessageTimeStamp.record(8, messageImpl);
                return false;
            }
            bEProducerSendRequest.setKernelRequest(kernelRequest);
            KernelRequest kernelRequest2 = kernelRequest;
            synchronized (kernelRequest2) {
                if (kernelRequest.hasResult()) {
                    MessageTimeStamp.record(8, messageImpl);
                    return false;
                }
                bEProducerSendRequest.needOutsideResult();
                kernelRequest.addListener((KernelListener)new DispatcherCompletionListener(bEProducerSendRequest), this.backEnd.getWorkManager());
                MessageTimeStamp.record(8, messageImpl);
                return true;
            }
        }
        catch (QuotaException quotaException) {
            throw new ResourceAllocationException(quotaException.toString(), quotaException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new weblogic.jms.common.IllegalStateException("Failed to send message to the destination " + this.name + ": " + illegalStateException.getMessage(), (Throwable)illegalStateException);
        }
        catch (KernelException kernelException) {
            if (kernelException.getCause() != null && kernelException.getCause() instanceof JMSException) {
                throw (JMSException)kernelException.getCause();
            }
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }

    public SendOptions createSendOptions(long l, Sequence sequence, MessageImpl messageImpl) {
        SendOptions sendOptions = this.createSendOptionsInternal(l, sequence, messageImpl);
        sendOptions.setDeliveryTime(messageImpl.getDeliveryTime());
        return sendOptions;
    }

    protected SendOptions createSendOptionsInternal(long l, Sequence sequence, MessageImpl messageImpl) {
        SendOptions sendOptions = new SendOptions();
        sendOptions.setPersistent(messageImpl.getAdjustedDeliveryMode() == 2);
        try {
            if (this.isUOWDestination && messageImpl.propertyExists("JMS_BEA_UnitOfWork")) {
                if (this.getSequenceMode(messageImpl) == 8 && messageImpl.getExpirationTime() == 0L) {
                    sendOptions.setExpirationTime(Long.MAX_VALUE);
                } else {
                    sendOptions.setExpirationTime(messageImpl.getExpirationTime());
                }
            } else {
                sendOptions.setExpirationTime(messageImpl.getExpirationTime());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sendOptions.setRedeliveryLimit(messageImpl.getRedeliveryLimit());
        sendOptions.setGroup(messageImpl.getGroup());
        if (l != 0L) {
            sendOptions.setTimeout(l);
        }
        if (sequence != null) {
            sendOptions.setSequence(sequence);
            if (sequence.getMode() != 1) {
                sendOptions.setSequenceNum(messageImpl.getSAFSeqNumber());
            }
        }
        return sendOptions;
    }

    private void sendComplete(BEProducerSendRequest bEProducerSendRequest) throws JMSException {
        bEProducerSendRequest.restoreResources(true);
        try {
            if (bEProducerSendRequest.getKernelRequest() != null) {
                bEProducerSendRequest.getKernelRequest().getResult();
            }
        }
        catch (QuotaException quotaException) {
            throw new ResourceAllocationException(quotaException.toString(), quotaException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new weblogic.jms.common.IllegalStateException("Destination " + this.name + " is paused for new message production", (Throwable)illegalStateException);
        }
        catch (KernelException kernelException) {
            if (kernelException.getCause() != null && kernelException.getCause() instanceof JMSException) {
                throw (JMSException)kernelException.getCause();
            }
            throw new weblogic.jms.common.JMSException(kernelException);
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Message " + bEProducerSendRequest.getMessage().getId() + " successfully enqueued");
        }
        JMSProducerSendResponse jMSProducerSendResponse = null;
        jMSProducerSendResponse = (JMSProducerSendResponse)bEProducerSendRequest.getResult();
        if (this.isFlowControlRequired()) {
            jMSProducerSendResponse.setNeedsFlowControl(true);
            jMSProducerSendResponse.setFlowControlTime(-1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int wrappedSend(BEProducerSendRequest bEProducerSendRequest) throws JMSException {
        boolean bl = true;
        int n = 1104;
        try {
            n = this.send(bEProducerSendRequest);
            bl = false;
            Object var5_4 = null;
            if (bl) {
                bEProducerSendRequest.restoreResources(false);
            } else if (n == Integer.MAX_VALUE) {
                bEProducerSendRequest.restoreResources(true);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bl) {
                bEProducerSendRequest.restoreResources(false);
            } else if (n == Integer.MAX_VALUE) {
                bEProducerSendRequest.restoreResources(true);
            }
            throw throwable;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int send(BEProducerSendRequest bEProducerSendRequest) throws JMSException {
        block10: while (true) {
            switch (bEProducerSendRequest.getState()) {
                case 0: {
                    bEProducerSendRequest.setState(1102);
                    this.sendInitialize(bEProducerSendRequest);
                    BEExtension bEExtension = this.destExtension;
                    if (bEExtension == null) continue block10;
                    bEExtension.sendExtension(bEProducerSendRequest);
                    Object object = bEProducerSendRequest;
                    synchronized (object) {
                        int n = bEProducerSendRequest.getState();
                        if (n != 1102) {
                            return n;
                        }
                        break;
                    }
                }
                case 1101: {
                    Object object = new JMSException("BEDestinationImpl BEExtension.SEND_WAIT_FOR_COMPLETE");
                    if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                        JMSDebug.JMSBackEnd.debug(object.getMessage(), (Throwable)object);
                    }
                    throw object;
                }
                case 1102: {
                    if (!this.sendIssueMessage(bEProducerSendRequest)) continue block10;
                    return 1103;
                }
                case 1103: {
                    this.sendComplete(bEProducerSendRequest);
                    bEProducerSendRequest.setState(Integer.MAX_VALUE);
                    return Integer.MAX_VALUE;
                }
                case 0x7FFFFFFF: {
                    return Integer.MAX_VALUE;
                }
                default: {
                    throw new AssertionError((Object)("Invalid state " + bEProducerSendRequest.getState()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tranForward(BEForwardRequest bEForwardRequest) throws JMSException {
        MessageImpl messageImpl;
        Transaction transaction;
        this.checkPermission(bEForwardRequest);
        this.checkShutdownOrSuspendedNeedLock("forward message");
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Received a tranForward request for " + bEForwardRequest.getSize() + " messages on " + this.name);
        }
        if ((transaction = TransactionHelper.getTransactionHelper().getTransaction()) == null) {
            throw new weblogic.jms.common.JMSException("tranForward was invoked without a transaction");
        }
        do {
            messageImpl = bEForwardRequest.getCurrentRequest().getMessage();
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("BEDestinationImpl.tranForward() message " + messageImpl + " deliveryCount " + messageImpl.getDeliveryCount());
            }
            bEForwardRequest.incrementPosition();
            if (!(this instanceof BEQueueImpl)) {
                messageImpl.setDDForwarded(true);
            }
            this.applyOverrides(messageImpl, null);
            try {
                KernelRequest kernelRequest;
                SendOptions sendOptions = this.createSendOptions(0L, null, messageImpl);
                if (messageImpl.getDeliveryCount() > 0) {
                    sendOptions.setDeliveryCount(messageImpl.getDeliveryCount());
                }
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    JMSDebug.JMSBackEnd.debug("BEDestinationImpl.tranForward, got message " + messageImpl + " with deliverycount " + messageImpl.getDeliveryCount() + " send options " + sendOptions.getDeliveryCount());
                }
                if ((kernelRequest = this.destination.send((Message)messageImpl, sendOptions)) == null) continue;
                KernelRequest kernelRequest2 = kernelRequest;
                synchronized (kernelRequest2) {
                    if (!kernelRequest.hasResult()) {
                        bEForwardRequest.needOutsideResult();
                        kernelRequest.addListener((KernelListener)new DispatcherCompletionListener(bEForwardRequest), this.backEnd.getWorkManager());
                        return bEForwardRequest.getState();
                    }
                    kernelRequest.getResult();
                }
            }
            catch (KernelException kernelException) {
                throw new weblogic.jms.common.JMSException(kernelException);
            }
        } while (bEForwardRequest.getPosition() < bEForwardRequest.getSize());
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Processed all forwarded messages on " + this.name);
        }
        bEForwardRequest.setResult(new JMSProducerSendResponse(messageImpl.getId()));
        bEForwardRequest.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    private static int uooUpdate(Request request) throws JMSException {
        BEOrderUpdateRequest bEOrderUpdateRequest = (BEOrderUpdateRequest)request;
        try {
            PathHelper.manager().cachedRemove(PathHelper.DEFAULT_PATH_SERVICE_JNDI, bEOrderUpdateRequest.getKey(), bEOrderUpdateRequest.getOldMember(), 584);
        }
        catch (PathHelper.PathServiceException pathServiceException) {
            PathHelper.PathSvc.debug(pathServiceException.getMessage(), (Throwable)pathServiceException);
            throw new weblogic.jms.common.JMSException(pathServiceException);
        }
        catch (NamingException namingException) {
            PathHelper.PathSvc.debug(namingException.getMessage(), (Throwable)namingException);
            throw new weblogic.jms.common.JMSException(namingException);
        }
        request.setResult(VoidResponse.THE_ONE);
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPropertyFlags(Destination destination, String string, int n) throws JMSException {
        Destination destination2 = destination;
        synchronized (destination2) {
            Integer n2 = (Integer)destination.getProperty(string);
            if (n2 == null) {
                n2 = new Integer(n);
            } else {
                if ((n2 & n) == n) {
                    return;
                }
                n2 = new Integer(n2 | n);
            }
            try {
                destination.setProperty(string, (Object)n2);
            }
            catch (KernelException kernelException) {
                throw new weblogic.jms.common.JMSException(kernelException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removePropertyFlags(Destination destination, String string, int n) throws JMSException {
        Destination destination2 = destination;
        synchronized (destination2) {
            Integer n2 = (Integer)destination.getProperty(string);
            if (n2 == null || (n2 & n) == 0) {
                return;
            }
            n2 = new Integer(n2 & ~n);
            try {
                destination.setProperty(string, (Object)n2);
            }
            catch (KernelException kernelException) {
                throw new weblogic.jms.common.JMSException(kernelException);
            }
        }
    }

    public void lowMemory() throws JMSException {
        this.suspendMessageLogging();
    }

    public void normalMemory() throws JMSException {
        this.resumeMessageLogging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void adminDeletion() {
        BackEnd backEnd = this.getBackEnd();
        Object object = backEnd.getDestinationDeletionLock();
        synchronized (object) {
            Object object2 = this.getConfigurationLock();
            synchronized (object2) {
                BEDestinationImpl bEDestinationImpl = this;
                synchronized (bEDestinationImpl) {
                    try {
                        JMSService.getJMSService().checkShutdownOrSuspended("delete Destination");
                        backEnd.checkShutdownOrSuspended("delete Destination");
                    }
                    catch (JMSException jMSException) {
                        return;
                    }
                    this.setDeleted(true);
                    Map<Object, Object> map = this.getConsumersClone();
                    backEnd.removeDestination(this);
                    Iterator<Object> iterator = map.values().iterator();
                    while (iterator.hasNext()) {
                        try {
                            BEConsumerCommon bEConsumerCommon = (BEConsumerCommon)iterator.next();
                            if (!bEConsumerCommon.isDurable() || bEConsumerCommon.isActive()) continue;
                            bEConsumerCommon.delete(false, false);
                        }
                        catch (JMSException jMSException) {}
                    }
                    map.clear();
                }
            }
        }
    }

    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        jMSDiagnosticImageSource.checkTimeout();
        JMSDiagnosticImageSource.dumpDestinationImpl(xMLStreamWriter, this.destinationImpl);
        xMLStreamWriter.writeAttribute("state", JMSService.getStateName(this.state));
        xMLStreamWriter.writeAttribute("creationTime", String.valueOf(this.getCreationTime()));
        xMLStreamWriter.writeAttribute("kernelDestinationName", this.destination.getName());
    }

    public synchronized void removeProducer(JMSID jMSID) {
        this.producers.remove(jMSID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPermission(Request request) throws JMSSecurityException {
        JMSID jMSID = null;
        if (request instanceof BEProducerSendRequest) {
            jMSID = ((BEProducerSendRequest)request).getProducerId();
        }
        if (jMSID == null) {
            this.verify((BEForwardRequest)request);
            return;
        }
        if (!JMSService.getJMSService().isSecurityCheckerStop()) {
            BEProducerSecurityParticipantImpl bEProducerSecurityParticipantImpl;
            BEDestinationImpl bEDestinationImpl = this;
            synchronized (bEDestinationImpl) {
                bEProducerSecurityParticipantImpl = this.producers.get(jMSID);
            }
            bEDestinationImpl = JMSSecurityHelper.getCurrentSubject();
            if (bEProducerSecurityParticipantImpl == null) {
                this.getJMSDestinationSecurity().checkSendPermission((AuthenticatedSubject)bEDestinationImpl);
                bEProducerSecurityParticipantImpl = new BEProducerSecurityParticipantImpl(jMSID, this, 5, (AuthenticatedSubject)bEDestinationImpl);
                BEDestinationImpl bEDestinationImpl2 = this;
                synchronized (bEDestinationImpl2) {
                    this.producers.put(bEProducerSecurityParticipantImpl.getProducerId(), bEProducerSecurityParticipantImpl);
                }
                JMSService.getJMSService().registerSecurityParticipant(this.getJMSDestinationSecurity().getJMSResourceForSend(), bEProducerSecurityParticipantImpl);
            } else if (!(bEProducerSecurityParticipantImpl.getSubject() == bEDestinationImpl || bEProducerSecurityParticipantImpl.getSubject() != null && bEProducerSecurityParticipantImpl.getSubject().equals((Object)bEDestinationImpl))) {
                this.getJMSDestinationSecurity().checkSendPermission((AuthenticatedSubject)bEDestinationImpl);
                bEProducerSecurityParticipantImpl.setSubject((AuthenticatedSubject)bEDestinationImpl);
            }
        } else {
            this.getJMSDestinationSecurity().checkSendPermission();
        }
    }

    private boolean checkMember(int n) {
        boolean bl;
        int n2 = 16;
        while (!(bl = DDManager.handlerHasSecurityModeByMemberName(this.getDestinationImpl().getName(), n)) && --n2 != 0) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verify(BEForwardRequest bEForwardRequest) throws JMSSecurityException {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Verifying forward request: securityMode= " + bEForwardRequest.getSecurityMode() + " current user= " + JMSSecurityHelper.getSimpleAuthenticatedName());
        }
        String string = null;
        String string2 = "";
        try {
            switch (bEForwardRequest.getSecurityMode()) {
                case 15: {
                    string2 = "LOCAL_KERNELID";
                    if (!WLSPrincipals.isKernelUsername((String)JMSSecurityHelper.getSimpleAuthenticatedName())) {
                        string = "Access denied for local user, user=" + JMSSecurityHelper.getSimpleAuthenticatedName();
                    }
                    break;
                }
                case 14: {
                    string2 = "REMOTE_KERNELID";
                    if (!this.checkMember(14)) {
                        string = "Not initialized for remote user, will retry later.";
                        break;
                    }
                    if (!WLSPrincipals.isKernelUsername((String)JMSSecurityHelper.getSimpleAuthenticatedName())) {
                        string = "Access denied for remote user, user=" + JMSSecurityHelper.getSimpleAuthenticatedName();
                    }
                    break;
                }
                case 11: 
                case 13: {
                    string2 = "REMOTE_SIGNED";
                    if (bEForwardRequest.verify(this.signatureSecret)) break;
                    string = "Verification failed.";
                    break;
                }
                case 12: {
                    string2 = "REMOTE_UNSIGNED";
                    if (!this.checkMember(12)) {
                        string = "Not initialized for perf mode, will retry later.";
                    }
                    break;
                }
                default: {
                    string2 = "default";
                    string = "Unexpected mode.";
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (string != null && (string = JMSExceptionLogger.logDDForwardRequestDeniedLoggable((String)string, (String)this.getName()).getMessage()) == null) {
                string = "Access denied.";
            }
            if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
                System.out.println("CHECKING FOR " + string2 + ", " + bEForwardRequest.getSecurityMode() + ", " + JMSSecurityHelper.getSimpleAuthenticatedName() + ", exc=" + string);
            }
            if (string != null) {
                throw new JMSSecurityException(string);
            }
            throw throwable;
        }
        if (string != null && (string = JMSExceptionLogger.logDDForwardRequestDeniedLoggable((String)string, (String)this.getName()).getMessage()) == null) {
            string = "Access denied.";
        }
        if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
            System.out.println("CHECKING FOR " + string2 + ", " + bEForwardRequest.getSecurityMode() + ", " + JMSSecurityHelper.getSimpleAuthenticatedName() + ", exc=" + string);
        }
        if (string != null) {
            throw new JMSSecurityException(string);
        }
    }

    public void prepareSignature() {
        String string;
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        String string2 = runtimeAccess.getDomainName();
        String string3 = string = runtimeAccess.getServer().getCluster() != null ? runtimeAccess.getServer().getCluster().getName() : null;
        if (string != null) {
            this.signatureSecret = JMSServerUtilities.generateSecret(string2 + string + this.getName() + this.destinationImpl.getId());
        }
    }
}

