/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import weblogic.application.ModuleException;
import weblogic.j2ee.descriptor.wl.DestinationKeyBean;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.common.MessageImpl;

public class BEDestinationKey {
    private static final int KEY_TYPE_JMS_MESSAGEID = 0;
    private static final int KEY_TYPE_JMS_TIMESTAMP = 1;
    private static final int KEY_TYPE_JMS_CORRELATIONID = 2;
    private static final int KEY_TYPE_JMS_PRIORITY = 3;
    private static final int KEY_TYPE_JMS_EXPIRATION = 4;
    private static final int KEY_TYPE_JMS_TYPE = 5;
    private static final int KEY_TYPE_JMS_REDELIVERED = 6;
    private static final int KEY_TYPE_JMS_DELIVERY_TIME = 7;
    private static final int KEY_TYPE_JMS_BEA_SIZE = 8;
    private static final int KEY_TYPE_JMS_BEA_UNITOFORDER = 9;
    private static final int KEY_TYPE_BOOLEAN = 15;
    private static final int KEY_TYPE_BYTE = 16;
    private static final int KEY_TYPE_SHORT = 17;
    private static final int KEY_TYPE_INT = 18;
    private static final int KEY_TYPE_LONG = 19;
    private static final int KEY_TYPE_FLOAT = 20;
    private static final int KEY_TYPE_DOUBLE = 21;
    private static final int KEY_TYPE_STRING = 22;
    static final String JMS_MESSAGE_ID = "JMSMessageID";
    private static final Integer DEFAULT_INTEGER = new Integer(Integer.MIN_VALUE);
    private static final Short DEFAULT_SHORT = new Short(Short.MIN_VALUE);
    private static final Long DEFAULT_LONG = new Long(Long.MIN_VALUE);
    private static final Float DEFAULT_FLOAT = new Float(Float.MIN_VALUE);
    private static final Byte DEFAULT_BYTE = new Byte(-128);
    private static final Double DEFAULT_DOUBLE = new Double(Double.MIN_VALUE);
    private static final String DEFAULT_STRING = new String();
    private static final Boolean DEFAULT_BOOLEAN = new Boolean(true);
    protected static final int KEY_DIRECTION_ASCENDING = 0;
    private static final int KEY_DIRECTION_DESCENDING = 1;
    private static final int HEADER_PROPERTY = 0;
    private static final int USER_PROPERTY = 1;
    private BEDestinationImpl destination;
    private final String name;
    protected final String property;
    private int propType = 0;
    protected int keyType = -2;
    protected int direction = 0;

    public BEDestinationKey(BEDestinationImpl bEDestinationImpl, DestinationKeyBean destinationKeyBean) throws ModuleException {
        this.property = destinationKeyBean.getProperty();
        this.name = destinationKeyBean.getName();
        this.destination = bEDestinationImpl;
        String string = destinationKeyBean.getSortOrder();
        if (string.equalsIgnoreCase("Descending")) {
            this.direction = 1;
        }
        String string2 = destinationKeyBean.getKeyType();
        if (this.property.equalsIgnoreCase(JMS_MESSAGE_ID)) {
            this.keyType = 0;
        } else if (this.property.equalsIgnoreCase("JMSTimestamp")) {
            this.keyType = 1;
        } else if (this.property.equalsIgnoreCase("JMSCorrelationID")) {
            this.keyType = 2;
        } else if (this.property.equalsIgnoreCase("JMSPriority")) {
            this.keyType = 3;
        } else if (this.property.equalsIgnoreCase("JMSExpiration")) {
            this.keyType = 4;
        } else if (this.property.equalsIgnoreCase("JMSType")) {
            this.keyType = 5;
        } else if (this.property.equalsIgnoreCase("JMSRedelivered")) {
            this.keyType = 6;
        } else if (this.property.equalsIgnoreCase("JMSDeliveryTime")) {
            this.keyType = 7;
        } else if (this.property.equalsIgnoreCase("JMS_BEA_Size")) {
            this.keyType = 8;
        } else if (this.property.equalsIgnoreCase("JMS_BEA_UnitOfOrder")) {
            this.keyType = 9;
        } else if (string2.equalsIgnoreCase("Boolean")) {
            this.keyType = 15;
            this.propType = 1;
        } else if (string2.equalsIgnoreCase("Byte")) {
            this.keyType = 16;
            this.propType = 1;
        } else if (string2.equalsIgnoreCase("Short")) {
            this.keyType = 17;
            this.propType = 1;
        } else if (string2.equalsIgnoreCase("Int")) {
            this.keyType = 18;
            this.propType = 1;
        } else if (string2.equalsIgnoreCase("Long")) {
            this.keyType = 19;
            this.propType = 1;
        } else if (string2.equalsIgnoreCase("Float")) {
            this.keyType = 20;
            this.propType = 1;
        } else if (string2.equalsIgnoreCase("Double")) {
            this.keyType = 21;
            this.propType = 1;
        } else if (string2.equalsIgnoreCase("String")) {
            this.keyType = 22;
            this.propType = 1;
        } else {
            throw new ModuleException("JMS: One or more missing attributes for destination key '" + this.name + "'");
        }
    }

    public BEDestinationKey(BEDestinationImpl bEDestinationImpl) {
        this.property = JMS_MESSAGE_ID;
        this.name = JMS_MESSAGE_ID;
        this.direction = 0;
        this.keyType = 0;
        this.destination = bEDestinationImpl;
    }

    boolean isDefault() {
        return this.direction == 0 && this.keyType == 0 && (this.property == null || this.property == JMS_MESSAGE_ID || this.property != null && this.property.equalsIgnoreCase(JMS_MESSAGE_ID)) && (this.name == null || this.name == JMS_MESSAGE_ID || this.name != null && this.name.equalsIgnoreCase(JMS_MESSAGE_ID));
    }

    long compareKey(MessageImpl messageImpl, MessageImpl messageImpl2, boolean bl) {
        long l = 0L;
        if (this.propType == 0) {
            switch (this.keyType) {
                case 0: {
                    l = messageImpl.getId().compare(messageImpl2.getId());
                    break;
                }
                case 1: {
                    l = messageImpl.getJMSTimestamp() - messageImpl2.getJMSTimestamp();
                    break;
                }
                case 2: {
                    if (messageImpl.getJMSCorrelationID() != null && messageImpl2.getJMSCorrelationID() != null) {
                        l = messageImpl.getJMSCorrelationID().compareTo(messageImpl2.getJMSCorrelationID());
                        break;
                    }
                    if (messageImpl.getJMSCorrelationID() != null) {
                        l = 1L;
                        break;
                    }
                    if (messageImpl2.getJMSCorrelationID() != null) {
                        l = -1L;
                        break;
                    }
                    l = 0L;
                    break;
                }
                case 3: {
                    l = messageImpl.getJMSPriority() - messageImpl2.getJMSPriority();
                    break;
                }
                case 4: {
                    l = messageImpl.getJMSExpiration() - messageImpl2.getJMSExpiration();
                    break;
                }
                case 7: {
                    l = messageImpl.getDeliveryTime() - messageImpl2.getDeliveryTime();
                    break;
                }
                case 5: {
                    if (messageImpl.getJMSType() != null && messageImpl2.getJMSType() != null) {
                        l = messageImpl.getJMSType().compareTo(messageImpl2.getJMSType());
                        break;
                    }
                    if (messageImpl.getJMSType() != null) {
                        l = 1L;
                        break;
                    }
                    if (messageImpl2.getJMSType() != null) {
                        l = -1L;
                        break;
                    }
                    l = 0L;
                    break;
                }
                case 6: {
                    if (messageImpl.getJMSRedelivered() && !messageImpl2.getJMSRedelivered()) {
                        l = 1L;
                        break;
                    }
                    if (messageImpl.getJMSRedelivered() || !messageImpl2.getJMSRedelivered()) break;
                    l = -1L;
                    break;
                }
                case 8: {
                    l = messageImpl.size() - messageImpl2.size();
                    break;
                }
                case 9: {
                    l = messageImpl.getUnitOfOrder() != null && messageImpl2.getUnitOfOrder() != null ? (long)messageImpl.getUnitOfOrder().compareTo(messageImpl2.getUnitOfOrder()) : (messageImpl.getUnitOfOrder() != null ? 1L : (messageImpl2.getUnitOfOrder() != null ? -1L : 0L));
                }
            }
        } else {
            Object object;
            Object object2;
            try {
                object2 = messageImpl.getObjectProperty(this.property);
                object = messageImpl2.getObjectProperty(this.property);
                if (object2 == null && object == null) {
                    return l;
                }
            }
            catch (Throwable throwable) {
                return l;
            }
            boolean bl2 = false;
            switch (this.keyType) {
                case 15: {
                    if (!(object2 instanceof Boolean)) {
                        object2 = DEFAULT_BOOLEAN;
                    }
                    if (!(object instanceof Boolean)) {
                        object = DEFAULT_BOOLEAN;
                    }
                    if (((Boolean)object2).booleanValue() && !((Boolean)object).booleanValue()) {
                        l = 1L;
                    } else if (!((Boolean)object2).booleanValue() && ((Boolean)object).booleanValue()) {
                        l = -1L;
                    }
                    bl2 = true;
                    break;
                }
                case 16: {
                    if (!(object2 instanceof Byte)) {
                        object2 = DEFAULT_BYTE;
                    }
                    if (object instanceof Byte) break;
                    object = DEFAULT_BYTE;
                    break;
                }
                case 17: {
                    if (!(object2 instanceof Short)) {
                        object2 = DEFAULT_SHORT;
                    }
                    if (object instanceof Short) break;
                    object = DEFAULT_SHORT;
                    break;
                }
                case 18: {
                    if (!(object2 instanceof Integer)) {
                        object2 = DEFAULT_INTEGER;
                    }
                    if (object instanceof Integer) break;
                    object = DEFAULT_INTEGER;
                    break;
                }
                case 19: {
                    if (!(object2 instanceof Long)) {
                        object2 = DEFAULT_LONG;
                    }
                    if (object instanceof Long) break;
                    object = DEFAULT_LONG;
                    break;
                }
                case 20: {
                    if (!(object2 instanceof Float)) {
                        object2 = DEFAULT_FLOAT;
                    }
                    if (object instanceof Float) break;
                    object = DEFAULT_FLOAT;
                    break;
                }
                case 21: {
                    if (!(object2 instanceof Double)) {
                        object2 = DEFAULT_DOUBLE;
                    }
                    if (object instanceof Double) break;
                    object = DEFAULT_DOUBLE;
                    break;
                }
                case 22: {
                    if (!(object2 instanceof String)) {
                        object2 = DEFAULT_STRING;
                    }
                    if (object instanceof String) break;
                    object = DEFAULT_STRING;
                }
            }
            if (!bl2) {
                l = ((Comparable)object2).compareTo(object);
            }
        }
        if (bl) {
            if (this.direction == 0) {
                return -l;
            }
            return l;
        }
        if (this.direction == 0) {
            return l;
        }
        return -l;
    }

    public String toString() {
        return "BEDestinationKey  propType=" + this.propType + ", keyType=" + this.keyType + ", direction=" + this.direction + ", name=" + this.name + ", property=" + this.property + " Dest=" + this.destination;
    }
}

