/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import javax.naming.Context;
import weblogic.application.ModuleException;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.DestinationBean;
import weblogic.j2ee.descriptor.wl.DestinationKeyBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.QueueBean;
import weblogic.j2ee.descriptor.wl.QuotaBean;
import weblogic.jms.JMSExceptionLogger;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BEDestinationKey;
import weblogic.jms.backend.BEDestinationRuntimeMBeanImpl;
import weblogic.jms.backend.BEQuota;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.EntityName;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.ModuleName;
import weblogic.jms.module.JMSBeanHelper;
import weblogic.jms.module.JMSModuleManagedEntity;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.utils.GenericBeanListener;

public abstract class BEDestinationRuntimeDelegate
implements JMSModuleManagedEntity {
    protected EntityName entityName;
    private Context applicationContext;
    protected BackEnd backEnd;
    private JMSBean wholeModule;
    protected DestinationBean specificBean;
    protected boolean temporary;
    private ModuleName auxiliaryModuleName;
    private BEQuota beQuota;
    private GenericBeanListener destinationListener;
    private GenericBeanListener localDestinationListener;
    private GenericBeanListener localDeliveryFailureListener;
    private GenericBeanListener thresholdListener;
    private GenericBeanListener deliveryOverridesListener;
    private GenericBeanListener deliveryFailureListener;
    private GenericBeanListener messageLoggingListener;
    private BEDestinationImpl managedDestination;
    private BEDestinationRuntimeMBeanImpl runtimeMBean;

    protected BEDestinationRuntimeDelegate(EntityName entityName, Context context, BackEnd backEnd, JMSBean jMSBean, DestinationBean destinationBean, boolean bl, ModuleName moduleName) {
        this.entityName = entityName;
        this.applicationContext = context;
        this.backEnd = backEnd;
        this.wholeModule = jMSBean;
        this.specificBean = destinationBean;
        this.temporary = bl;
        this.auxiliaryModuleName = moduleName;
    }

    BEDestinationRuntimeMBeanImpl getRuntimeMBean() {
        return this.runtimeMBean;
    }

    protected void initialize(int n) throws ModuleException {
        this.managedDestination.setDuration(n);
        try {
            this.initializeListeners();
        }
        catch (ManagementException managementException) {
            throw new ModuleException("Could not initialize the destination " + this.entityName.toString(), managementException);
        }
        try {
            this.managedDestination.valJNDIName(this.specificBean.getJNDIName());
            this.managedDestination.valLocalJNDIName(this.specificBean.getLocalJNDIName());
        }
        catch (BeanUpdateRejectedException beanUpdateRejectedException) {
            throw new ModuleException(beanUpdateRejectedException.getMessage(), beanUpdateRejectedException);
        }
        String[] stringArray = this.specificBean.getDestinationKeys();
        LinkedList<BEDestinationKey> linkedList = new LinkedList<BEDestinationKey>();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            DestinationKeyBean destinationKeyBean = this.wholeModule.lookupDestinationKey(stringArray[i]);
            BEDestinationKey bEDestinationKey = new BEDestinationKey(this.managedDestination, destinationKeyBean);
            linkedList.add(bEDestinationKey);
            if (!destinationKeyBean.getProperty().equals("JMSMessageID")) continue;
            bl = true;
        }
        if (!bl) {
            linkedList.add(new BEDestinationKey(this.managedDestination));
        }
        this.managedDestination.setDestinationKeysList(linkedList);
        DestinationImpl destinationImpl = new DestinationImpl(this.managedDestination.getDestinationTypeIndicator(), this.backEnd.getName(), this.backEnd.getPersistentStore() != null ? this.backEnd.getPersistentStore().getName() : null, this.managedDestination.getName(), this.entityName.getApplicationName(), this.entityName.getEARModuleName(), this.backEnd.getJMSServerId(), this.managedDestination.getJMSID(), this.managedDestination.getCreationTime(), this.managedDestination.getSAFExportPolicy());
        this.managedDestination.setDestinationImpl(destinationImpl);
        try {
            this.setQuota(this.specificBean.getQuota(), false);
        }
        catch (BeanUpdateFailedException beanUpdateFailedException) {
            throw new ModuleException(beanUpdateFailedException.getMessage(), beanUpdateFailedException);
        }
        this.setErrorDestination(this.specificBean.getDeliveryFailureParams().getErrorDestination());
        try {
            this.managedDestination.open();
        }
        catch (JMSException jMSException) {
            throw new ModuleException(jMSException);
        }
    }

    void setManagedDestination(BEDestinationImpl bEDestinationImpl) throws ManagementException {
        this.managedDestination = bEDestinationImpl;
        this.runtimeMBean = new BEDestinationRuntimeMBeanImpl(this.entityName.toString(), (RuntimeMBean)this.backEnd, false, bEDestinationImpl);
        this.managedDestination.setRuntimeMBean(this.runtimeMBean);
        this.managedDestination.setModuleName(this.entityName.getFullyQualifiedModuleName());
    }

    public BEDestinationImpl getManagedDestination() {
        return this.managedDestination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws ModuleException {
        this.initialize(this.temporary ? 0 : 1);
        BEDestinationImpl bEDestinationImpl = this.managedDestination;
        synchronized (bEDestinationImpl) {
            this.managedDestination.setStateValue(1);
        }
        try {
            this.backEnd.addDestination(this.managedDestination);
        }
        catch (JMSException jMSException) {
            throw new ModuleException("ERROR: Unable to add destination " + this.entityName + " to the back end " + this.backEnd.getName(), jMSException);
        }
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Destination " + this.entityName + " successfully prepared");
        }
    }

    public void activate(JMSBean jMSBean) throws ModuleException {
        if (jMSBean != null) {
            this.wholeModule = jMSBean;
            this.specificBean = this.specificBean instanceof QueueBean ? this.wholeModule.lookupQueue(this.getEntityName()) : this.wholeModule.lookupTopic(this.getEntityName());
            this.closeListeners();
        }
        this.openListeners();
        if (this.beQuota != null) {
            QuotaBean quotaBean = this.specificBean.getQuota();
            this.beQuota.setQuotaBean(quotaBean);
        }
        this.managedDestination.setApplicationJNDIName(this.constructApplicationJNDIName());
        this.managedDestination.setApplicationContext(this.applicationContext);
        try {
            this.managedDestination.start();
        }
        catch (JMSException jMSException) {
            throw new ModuleException("ERROR: Could not activate " + this.managedDestination.getName(), jMSException);
        }
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Destination " + this.entityName + " successfully activated");
        }
    }

    public void deactivate() throws ModuleException {
        this.managedDestination.unAdvertise();
        if (this.beQuota != null) {
            if (this.beQuota.close()) {
                this.backEnd.removeBEQuota(this.beQuota.getName());
            }
            this.beQuota = null;
        }
        this.closeListeners();
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Destination " + this.entityName + " successfully deactivated");
        }
    }

    public void unprepare() throws ModuleException {
        this.backEnd.removeDestination(this.managedDestination);
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Destination " + this.entityName + " successfully unprepared");
        }
    }

    public void remove() throws ModuleException {
        if (this.managedDestination != null) {
            this.managedDestination.adminDeletion();
        }
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Destination " + this.entityName + " successfully removed");
        }
    }

    public void destroy() throws ModuleException {
        if (JMSDebug.JMSConfig.isDebugEnabled()) {
            JMSDebug.JMSConfig.debug("Destination " + this.entityName + " successfully destroyed");
        }
    }

    public String getEntityName() {
        return this.specificBean.getName();
    }

    public void prepareChangeOfTargets(List list, DomainMBean domainMBean) throws ModuleException {
        TargetMBean targetMBean = (TargetMBean)list.get(0);
        throw new ModuleException(JMSExceptionLogger.logInvalidTargetChangeLoggable((String)this.entityName.toString(), (String)this.backEnd.getName(), (String)targetMBean.getName()).getMessage());
    }

    public void activateChangeOfTargets() {
    }

    public void rollbackChangeOfTargets() {
    }

    private void initializeListeners() throws ManagementException {
        DescriptorBean descriptorBean = (DescriptorBean)this.specificBean;
        this.destinationListener = new GenericBeanListener(descriptorBean, (Object)this.managedDestination, (Map)JMSBeanHelper.destinationBeanSignatures, false);
        this.destinationListener.initialize();
        descriptorBean = (DescriptorBean)this.specificBean.getThresholds();
        this.thresholdListener = new GenericBeanListener(descriptorBean, (Object)this.managedDestination, (Map)JMSBeanHelper.thresholdBeanSignatures, false);
        this.thresholdListener.initialize();
        descriptorBean = (DescriptorBean)this.specificBean.getDeliveryParamsOverrides();
        this.deliveryOverridesListener = new GenericBeanListener(descriptorBean, (Object)this.managedDestination, (Map)JMSBeanHelper.deliveryOverridesSignatures, false);
        this.deliveryOverridesListener.initialize();
        descriptorBean = (DescriptorBean)this.specificBean.getDeliveryFailureParams();
        this.deliveryFailureListener = new GenericBeanListener(descriptorBean, (Object)this.managedDestination, (Map)JMSBeanHelper.deliveryFailureSignatures, false);
        this.deliveryFailureListener.initialize();
        descriptorBean = (DescriptorBean)this.specificBean.getMessageLoggingParams();
        this.messageLoggingListener = new GenericBeanListener(descriptorBean, (Object)this.managedDestination, (Map)JMSBeanHelper.messageLoggingSignatures, false);
        this.messageLoggingListener.initialize();
    }

    private void openListeners() {
        DescriptorBean descriptorBean;
        if (this.destinationListener != null) {
            this.destinationListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.specificBean;
            this.destinationListener = new GenericBeanListener(descriptorBean, this.managedDestination, JMSBeanHelper.destinationBeanSignatures);
        }
        if (this.localDestinationListener != null) {
            this.localDestinationListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.specificBean;
            this.localDestinationListener = new GenericBeanListener(descriptorBean, this, JMSBeanHelper.localDestinationBeanSignatures);
        }
        if (this.localDeliveryFailureListener != null) {
            this.localDestinationListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.specificBean.getDeliveryFailureParams();
            this.localDeliveryFailureListener = new GenericBeanListener(descriptorBean, this, JMSBeanHelper.localDeliveryFailureSignatures);
        }
        if (this.thresholdListener != null) {
            this.thresholdListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.specificBean.getThresholds();
            this.thresholdListener = new GenericBeanListener(descriptorBean, this.managedDestination, JMSBeanHelper.thresholdBeanSignatures);
        }
        if (this.deliveryOverridesListener != null) {
            this.deliveryOverridesListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.specificBean.getDeliveryParamsOverrides();
            this.deliveryOverridesListener = new GenericBeanListener(descriptorBean, this.managedDestination, JMSBeanHelper.deliveryOverridesSignatures);
        }
        if (this.deliveryFailureListener != null) {
            this.deliveryFailureListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.specificBean.getDeliveryFailureParams();
            this.deliveryFailureListener = new GenericBeanListener(descriptorBean, this.managedDestination, JMSBeanHelper.deliveryFailureSignatures);
        }
        if (this.messageLoggingListener != null) {
            this.messageLoggingListener.open();
        } else {
            descriptorBean = (DescriptorBean)this.specificBean.getMessageLoggingParams();
            this.messageLoggingListener = new GenericBeanListener(descriptorBean, this.managedDestination, JMSBeanHelper.messageLoggingSignatures);
        }
    }

    private void closeListeners() {
        if (this.messageLoggingListener != null) {
            this.messageLoggingListener.close();
            this.messageLoggingListener = null;
        }
        if (this.deliveryFailureListener != null) {
            this.deliveryFailureListener.close();
            this.deliveryFailureListener = null;
        }
        if (this.deliveryOverridesListener != null) {
            this.deliveryOverridesListener.close();
            this.deliveryOverridesListener = null;
        }
        if (this.thresholdListener != null) {
            this.thresholdListener.close();
            this.thresholdListener = null;
        }
        if (this.localDeliveryFailureListener != null) {
            this.localDeliveryFailureListener.close();
            this.localDeliveryFailureListener = null;
        }
        if (this.localDestinationListener != null) {
            this.localDestinationListener.close();
            this.localDestinationListener = null;
        }
        if (this.destinationListener != null) {
            this.destinationListener.close();
            this.destinationListener = null;
        }
    }

    public void setErrorDestination(DestinationBean destinationBean) {
        EntityName entityName = destinationBean == null ? null : new EntityName(this.auxiliaryModuleName, destinationBean.getName());
        this.managedDestination.setErrorDestination(entityName);
    }

    public void setQuota(QuotaBean quotaBean) throws BeanUpdateFailedException {
        this.setQuota(quotaBean, true);
    }

    private void setQuota(QuotaBean quotaBean, boolean bl) throws BeanUpdateFailedException {
        if (this.beQuota != null) {
            if (this.beQuota.close()) {
                this.backEnd.removeBEQuota(this.beQuota.getName());
            }
            this.beQuota = null;
        }
        if (quotaBean == null) {
            this.managedDestination.setQuota(this.backEnd.getQuota());
        } else {
            if (quotaBean.isShared()) {
                String string = JMSBeanHelper.getDecoratedName(this.auxiliaryModuleName.getFullyQualifiedModuleName(), quotaBean.getName());
                this.beQuota = this.backEnd.findBEQuota(string);
                if (this.beQuota == null) {
                    this.beQuota = this.backEnd.createBEQuota(string, quotaBean);
                }
            } else {
                String string = JMSBeanHelper.getDecoratedName(this.entityName.toString(), quotaBean.getName());
                this.beQuota = this.backEnd.createBEQuota(string, quotaBean);
            }
            this.managedDestination.setQuota(this.beQuota.getQuota());
            if (bl) {
                this.beQuota.setQuotaBean(quotaBean);
            }
        }
    }

    private String constructApplicationJNDIName() {
        if (this.entityName.getEARModuleName() == null || this.entityName.getEARModuleName().length() <= 0) {
            return null;
        }
        return this.entityName.getEARModuleName() + "#" + this.specificBean.getName();
    }
}

