/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import weblogic.jms.common.EntityName;
import weblogic.jms.common.JMSDestinationSecurity;
import weblogic.jms.common.JMSSecurityException;
import weblogic.jms.common.JMSSecurityHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.JMSResource;

public class BEDestinationSecurityImpl
implements JMSDestinationSecurity {
    private JMSResource jmsResource_send = null;
    private JMSResource jmsResource_receive = null;
    private JMSResource jmsResource_browse = null;

    public BEDestinationSecurityImpl(EntityName entityName, String string) {
        if (entityName == null) {
            return;
        }
        String string2 = entityName.getApplicationName();
        String string3 = entityName.getEntityName();
        if (string2 != null && string2.equals("interop-jms")) {
            string2 = null;
        }
        if (string3 != null && string3.indexOf("@") >= 0) {
            string3 = string3.substring(string3.indexOf("@") + 1);
        }
        if (string2 != null && string2.equals("interop-jms")) {
            string2 = null;
        }
        this.jmsResource_send = new JMSResource(string2, entityName.getEARModuleName(), string, string3, "send");
        this.jmsResource_receive = new JMSResource(string2, entityName.getEARModuleName(), string, string3, "receive");
        this.jmsResource_browse = new JMSResource(string2, entityName.getEARModuleName(), string, string3, "browse");
    }

    public void checkSendPermission(AuthenticatedSubject authenticatedSubject) throws JMSSecurityException {
        JMSSecurityHelper.checkPermission(this.jmsResource_send, authenticatedSubject);
    }

    public void checkSendPermission() throws JMSSecurityException {
        JMSSecurityHelper.checkPermission(this.jmsResource_send);
    }

    public void checkReceivePermission(AuthenticatedSubject authenticatedSubject) throws JMSSecurityException {
        JMSSecurityHelper.checkPermission(this.jmsResource_receive, authenticatedSubject);
    }

    public void checkReceivePermission() throws JMSSecurityException {
        JMSSecurityHelper.checkPermission(this.jmsResource_receive);
    }

    public void checkBrowsePermission(AuthenticatedSubject authenticatedSubject) throws JMSSecurityException {
        JMSSecurityHelper.checkPermission(this.jmsResource_browse, authenticatedSubject);
    }

    public void checkBrowsePermission() throws JMSSecurityException {
        JMSSecurityHelper.checkPermission(this.jmsResource_browse);
    }

    public JMSResource getJMSResourceForSend() {
        return this.jmsResource_send;
    }

    public JMSResource getJMSResourceForReceive() {
        return this.jmsResource_receive;
    }

    public JMSResource getJMSResourceForBrowse() {
        return this.jmsResource_browse;
    }
}

