/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import javax.jms.JMSException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import weblogic.jms.backend.BEConsumerCommon;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BEMessageManagementRuntimeDelegate;
import weblogic.jms.common.DurableSubscription;
import weblogic.jms.common.JMSConstants;
import weblogic.jms.extensions.DestinationInfo;
import weblogic.jms.extensions.WLDestination;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JMSDestinationRuntimeMBean;
import weblogic.management.runtime.JMSDurableSubscriberRuntimeMBean;

public final class BEDurableSubscriberRuntimeMBeanImpl
extends BEMessageManagementRuntimeDelegate
implements JMSDurableSubscriberRuntimeMBean {
    static final long serialVersionUID = -8042739557848839705L;
    private final BEConsumerCommon consumer;
    private final BEDestinationImpl destination;
    private final DurableSubscription subscription;

    public BEDurableSubscriberRuntimeMBeanImpl(String string, BEDestinationImpl bEDestinationImpl, BEConsumerCommon bEConsumerCommon) throws ManagementException {
        super(string, bEDestinationImpl.getRuntimeMBean());
        this.consumer = bEConsumerCommon;
        this.destination = bEDestinationImpl;
        this.subscription = (DurableSubscription)((BEConsumerImpl)bEConsumerCommon).getSubscription();
    }

    public String getClientID() {
        return this.consumer.getClientID();
    }

    public String getClientIDPolicy() {
        if (this.consumer.getClientIdPolicy() == 1) {
            return JMSConstants.CLIENT_ID_POLICY_UNRESTRICTED_STRING;
        }
        return JMSConstants.CLIENT_ID_POLICY_RESTRICTED_STRING;
    }

    public String getSubscriptionName() {
        return this.consumer.getSubscriptionName();
    }

    public String getSelector() {
        return this.consumer.getSelector();
    }

    public boolean isNoLocal() {
        return this.consumer.getNoLocal();
    }

    public boolean isActive() {
        return this.consumer.isUsed();
    }

    public String getSubscriptionSharingPolicy() {
        return BEDurableSubscriberRuntimeMBeanImpl.getSubscriptionSharingPolicyAsString(this.consumer.getSubscriptionSharingPolicy());
    }

    public int getSubscribersTotalCount() {
        return this.subscription.getSubscribersTotalCount();
    }

    public int getSubscribersHighCount() {
        return this.subscription.getSubscribersHighCount();
    }

    public int getSubscribersCurrentCount() {
        return this.subscription.getSubscribersCount();
    }

    public static String getSubscriptionSharingPolicyAsString(int n) {
        switch (n) {
            case 0: {
                return JMSConstants.SUBSCRIPTION_EXCLUSIVE;
            }
            case 1: {
                return JMSConstants.SUBSCRIPTION_SHARABLE;
            }
        }
        throw new IllegalArgumentException("Unrecognized SubscriptionSharingPolicy " + n);
    }

    public long getMessagesPendingCount() {
        return this.consumer.getMessagesUnackedCount();
    }

    public long getBytesPendingCount() {
        return this.consumer.getBytesUnackedCount();
    }

    public long getMessagesCurrentCount() {
        return this.consumer.getSize();
    }

    public long getMessagesHighCount() {
        return this.consumer.getHighSize();
    }

    public long getMessagesReceivedCount() {
        return this.consumer.getMessagesReceivedCount();
    }

    public long getBytesCurrentCount() {
        return this.consumer.getBytesCurrentCount();
    }

    public long getLastMessagesReceivedTime() {
        return this.consumer.getLastMessagesReceivedTime();
    }

    public void purge() {
        try {
            this.deleteMessages(null);
        }
        catch (ManagementException managementException) {
            throw new RuntimeException(managementException.getMessage() + ".  Cause " + managementException.getCause().toString());
        }
    }

    public JMSDestinationRuntimeMBean getDestinationRuntime() {
        return this.destination.getRuntimeMBean();
    }

    public CompositeData getCurrentConsumerInfo() throws OpenDataException {
        if (this.consumer == null) {
            return null;
        }
        return this.consumer.getCompositeData();
    }

    public void destroy() throws JMSException {
        if (this.consumer.getDurableSubscriberMbean() == null) {
            return;
        }
        if (this.destination.isShutdownOrSuspended()) {
            return;
        }
        this.subscription.delete();
    }

    public CompositeData getDestinationInfo() throws OpenDataException {
        if (this.destination == null) {
            return null;
        }
        WLDestination wLDestination = (WLDestination)this.destination.getDestination();
        if (wLDestination == null) {
            return null;
        }
        DestinationInfo destinationInfo = new DestinationInfo(wLDestination);
        return destinationInfo.toCompositeData();
    }
}

