/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import weblogic.jms.backend.BETopicImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSSQLExpression;
import weblogic.store.PersistentHandle;
import weblogic.store.PersistentStoreConnection;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreRecord;
import weblogic.store.PersistentStoreTransaction;
import weblogic.store.xa.PersistentStoreXA;

public class BEDurableSubscriptionStore {
    private static final String CONN_PREFIX = "weblogic.messaging.";
    private static final String CONN_SUFFIX = ".durablesubs";
    private PersistentStoreXA store;
    private PersistentStoreConnection storeConnection;
    private Map topicMap;

    public BEDurableSubscriptionStore(String string, PersistentStoreXA persistentStoreXA) throws JMSException {
        this.store = persistentStoreXA;
        this.topicMap = new HashMap();
        try {
            this.storeConnection = persistentStoreXA.createConnection(CONN_PREFIX + string + CONN_SUFFIX);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new weblogic.jms.common.JMSException("Error opening persistent store for durable subscriptions", (Throwable)persistentStoreException);
        }
    }

    public void close() {
        this.storeConnection.close();
    }

    public PersistentHandle createSubscription(String string, String string2, String string3, JMSSQLExpression jMSSQLExpression) throws JMSException {
        return this.createSubscription(string, string2, 0, string3, jMSSQLExpression);
    }

    public PersistentHandle createSubscription(String string, String string2, int n, String string3, JMSSQLExpression jMSSQLExpression) throws JMSException {
        SubscriptionRecord subscriptionRecord = new SubscriptionRecord(string, string2, n, string3, jMSSQLExpression);
        PersistentStoreTransaction persistentStoreTransaction = this.store.begin();
        PersistentHandle persistentHandle = this.storeConnection.create(persistentStoreTransaction, (Object)subscriptionRecord, 0);
        try {
            persistentStoreTransaction.commit();
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new weblogic.jms.common.JMSException("Error persisting a durable subscriber record", (Throwable)persistentStoreException);
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Persisted a record for durable subscription " + subscriptionRecord);
        }
        return persistentHandle;
    }

    void deleteSubscription(PersistentHandle persistentHandle) throws JMSException {
        PersistentStoreTransaction persistentStoreTransaction = this.store.begin();
        this.storeConnection.delete(persistentStoreTransaction, persistentHandle, 0);
        try {
            persistentStoreTransaction.commit();
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new weblogic.jms.common.JMSException("Error deleting a durable subscriber record", (Throwable)persistentStoreException);
        }
        JMSDebug.JMSBackEnd.debug("Deleted a persistent durable subscription record");
    }

    void recover() throws JMSException {
        try {
            PersistentStoreRecord persistentStoreRecord;
            PersistentStoreConnection.Cursor cursor = this.storeConnection.createCursor(0);
            while ((persistentStoreRecord = cursor.next()) != null) {
                SubscriptionRecord subscriptionRecord = (SubscriptionRecord)persistentStoreRecord.getData();
                subscriptionRecord.setHandle(persistentStoreRecord.getHandle());
                ArrayList<SubscriptionRecord> arrayList = (ArrayList<SubscriptionRecord>)this.topicMap.get(subscriptionRecord.getDestinationName());
                if (arrayList == null) {
                    arrayList = new ArrayList<SubscriptionRecord>();
                    this.topicMap.put(subscriptionRecord.getDestinationName(), arrayList);
                }
                arrayList.add(subscriptionRecord);
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new weblogic.jms.common.JMSException("Error recovering durable subscriber records", (Throwable)persistentStoreException);
        }
    }

    synchronized void restoreSubscriptions(BETopicImpl bETopicImpl) throws JMSException {
        List list = (List)this.topicMap.get(bETopicImpl.getName());
        if (list != null) {
            for (SubscriptionRecord subscriptionRecord : list) {
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    JMSDebug.JMSBackEnd.debug("Restoring durable subscription " + subscriptionRecord);
                }
                bETopicImpl.recoverDurableSubscription(subscriptionRecord.getHandle(), subscriptionRecord.getClientId(), subscriptionRecord.getClientIdPolicy(), subscriptionRecord.getSubscriptionName(), subscriptionRecord.getExpression());
            }
            this.topicMap.remove(bETopicImpl.getName());
        }
    }

    synchronized void deleteOrphanedSubscriptions() throws JMSException {
        JMSException jMSException = null;
        for (List list : this.topicMap.values()) {
            for (SubscriptionRecord subscriptionRecord : list) {
                try {
                    this.deleteSubscription(subscriptionRecord.getHandle());
                }
                catch (JMSException jMSException2) {
                    jMSException = jMSException2;
                }
            }
        }
        this.topicMap.clear();
        if (jMSException != null) {
            throw jMSException;
        }
    }

    public static final class SubscriptionRecord
    implements Externalizable {
        public static final long serialVersionUID = 5570891599555644794L;
        private static final int EXTERNAL_VERSION1 = 1;
        private static final int EXTERNAL_VERSION2 = 2;
        private static final int EXTERNAL_VERSION = 2;
        private String destinationName;
        private String clientId;
        private int clientIdPolicy = 0;
        private String subscriptionName;
        private JMSSQLExpression selector;
        private transient PersistentHandle handle;

        SubscriptionRecord(String string, String string2, int n, String string3, JMSSQLExpression jMSSQLExpression) {
            this.destinationName = string;
            this.clientId = string2;
            this.clientIdPolicy = n;
            this.subscriptionName = string3;
            this.selector = jMSSQLExpression;
        }

        public SubscriptionRecord() {
        }

        String getDestinationName() {
            return this.destinationName;
        }

        String getClientId() {
            return this.clientId;
        }

        int getClientIdPolicy() {
            return this.clientIdPolicy;
        }

        String getSubscriptionName() {
            return this.subscriptionName;
        }

        JMSSQLExpression getExpression() {
            return this.selector;
        }

        PersistentHandle getHandle() {
            return this.handle;
        }

        void setHandle(PersistentHandle persistentHandle) {
            this.handle = persistentHandle;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(2);
            objectOutput.writeUTF(this.destinationName);
            objectOutput.writeUTF(this.clientId);
            objectOutput.writeUTF(this.subscriptionName);
            this.selector.writeExternal(objectOutput);
            objectOutput.writeInt(this.clientIdPolicy);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            int n = objectInput.readInt();
            if (n != 1 && n != 2) {
                throw new IOException("External version mismatch");
            }
            this.destinationName = objectInput.readUTF();
            this.clientId = objectInput.readUTF();
            this.subscriptionName = objectInput.readUTF();
            this.selector = new JMSSQLExpression();
            this.selector.readExternal(objectInput);
            if (n == 2) {
                this.clientIdPolicy = objectInput.readInt();
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[ name = ");
            stringBuffer.append(this.subscriptionName);
            stringBuffer.append(" topic = ");
            stringBuffer.append(this.destinationName);
            stringBuffer.append(" client ID = ");
            stringBuffer.append(this.clientId);
            if (this.selector != null) {
                stringBuffer.append(" selector = ");
                stringBuffer.append(this.selector);
            }
            stringBuffer.append(" ]");
            return stringBuffer.toString();
        }
    }
}

