/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import javax.jms.JMSException;
import weblogic.jms.backend.BEBrowserImpl;
import weblogic.jms.backend.BEEnumerationNextElementRequest;
import weblogic.jms.common.JMSEnumerationNextElementResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.Invocable;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;
import weblogic.messaging.kernel.Cursor;
import weblogic.messaging.kernel.Expression;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.Queue;

final class BEEnumerationImpl
implements Invocable {
    private boolean closed;
    private BEBrowserImpl browser;
    private JMSID enumerationId;
    private InvocableMonitor invocableMonitor;
    private Cursor cursor;

    BEEnumerationImpl(BEBrowserImpl bEBrowserImpl, JMSID jMSID, Queue queue, Expression expression) throws JMSException {
        this.browser = bEBrowserImpl;
        this.enumerationId = jMSID;
        this.invocableMonitor = bEBrowserImpl.getInvocableMonitor();
        try {
            this.cursor = queue.createCursor(true, expression, 1);
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        BEEnumerationImpl bEEnumerationImpl = this;
        synchronized (bEEnumerationImpl) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.cursor.close();
        this.browser.enumerationRemove(this.enumerationId);
    }

    private int nextElement(BEEnumerationNextElementRequest bEEnumerationNextElementRequest) throws JMSException {
        MessageElement messageElement;
        this.browser.checkShutdownOrSuspended("next element");
        try {
            messageElement = this.cursor.next();
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
        MessageImpl messageImpl = (MessageImpl)(messageElement == null ? null : messageElement.getMessage());
        if (messageImpl != null) {
            if (messageElement.getDeliveryCount() > 0) {
                messageImpl = messageImpl.cloneit();
                messageImpl.setDeliveryCount(messageElement.getDeliveryCount());
            }
        } else {
            this.close();
        }
        bEEnumerationNextElementRequest.setResult(new JMSEnumerationNextElementResponse(messageImpl));
        bEEnumerationNextElementRequest.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    public JMSID getJMSID() {
        return this.enumerationId;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public int invoke(Request request) throws JMSException {
        if (request.getMethodId() == 11795) {
            return this.nextElement((BEEnumerationNextElementRequest)request);
        }
        throw new weblogic.jms.common.JMSException("No such method " + this.getClass().getName() + "." + request.getMethodId());
    }
}

