/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecureRandom;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import javax.jms.JMSException;
import weblogic.jms.backend.BEForwardingConsumer;
import weblogic.jms.backend.BEProducerSendRequest;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSProducerSendResponse;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.utils.Hex;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkedInputStream;
import weblogic.utils.io.ChunkedObjectInputStream;
import weblogic.utils.io.ChunkedObjectOutputStream;
import weblogic.utils.io.ChunkedOutputStream;

public final class BEForwardRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -3794283731017311093L;
    private static final int EXTVERSION = 1;
    private static final int EXTVERSION2 = 2;
    private static final int VERSION_MASK = 255;
    private BEProducerSendRequest[] requests;
    private int size;
    private transient int position;
    private byte[] signature;
    private transient byte[] signedData;
    private int securityMode;
    private byte[] signatureSecret;
    private long signedChecksum;
    private long calculatedChecksum;
    private static long requestNum = new SecureRandom().nextLong();
    String debugStr = null;

    public BEForwardRequest(JMSID jMSID, BEProducerSendRequest[] bEProducerSendRequestArray, byte[] byArray) {
        super(jMSID, 17684);
        this.requests = bEProducerSendRequestArray;
        this.size = bEProducerSendRequestArray.length;
        this.signatureSecret = byArray;
    }

    BEProducerSendRequest[] getRequests() {
        return this.requests;
    }

    BEProducerSendRequest getCurrentRequest() {
        return this.requests[this.position];
    }

    int getSize() {
        return this.size;
    }

    int getPosition() {
        return this.position;
    }

    void incrementPosition() {
        ++this.position;
    }

    public int remoteSignature() {
        return 35;
    }

    public Response createResponse() {
        return new JMSProducerSendResponse();
    }

    void setSecurityMode(int n) {
        this.securityMode = n;
    }

    int getSecurityMode() {
        return this.securityMode;
    }

    boolean verify(byte[] byArray) {
        boolean bl;
        if (byArray == null || this.signature == null || this.signedData == null) {
            return false;
        }
        boolean bl2 = JMSServerUtilities.verifySignature(this.signature, this.signedData, byArray);
        boolean bl3 = bl = this.signedChecksum == this.calculatedChecksum;
        if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
            System.out.println("verify sig=" + bl2);
            System.out.println("verify cksum=" + bl);
            this.dump(this.signedData, this.signature, this.signedChecksum, this.calculatedChecksum);
        }
        return bl2 && bl;
    }

    public BEForwardRequest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.debugStr = null;
        int n = 0;
        switch (this.securityMode) {
            case 14: {
                n = 1;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                n = 2;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        objectOutput.writeInt(n);
        ChunkedObjectOutputStream chunkedObjectOutputStream = (ChunkedObjectOutputStream)objectOutput;
        int n2 = chunkedObjectOutputStream.getPosition();
        if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
            this.debugStr = this.debugStr + "\n BEForwardingConsumer.DD_FORWARDING_DEBUG writeExternal: coosStart = " + n2;
        }
        ChunkListReader chunkListReader = new ChunkListReader((ChunkedOutputStream)chunkedObjectOutputStream);
        super.writeExternal((ObjectOutput)chunkedObjectOutputStream);
        chunkedObjectOutputStream.writeInt(this.size);
        if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
            this.debugStr = this.debugStr + "\n writeExternal: before requests position = " + chunkedObjectOutputStream.getPosition();
        }
        for (int i = 0; i < this.size; ++i) {
            this.requests[i].writeExternal((ObjectOutput)chunkedObjectOutputStream);
            if (!BEForwardingConsumer.DD_FORWARDING_DEBUG) continue;
            this.debugStr = this.debugStr + "\n writeExternal: position(" + i + ") = " + chunkedObjectOutputStream.getPosition();
        }
        if (n != 2) {
            return;
        }
        chunkedObjectOutputStream.writeInt(this.securityMode);
        if (this.securityMode == 12) {
            return;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            chunkedObjectOutputStream.writeLong(requestNum++);
        }
        if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
            this.debugStr = this.debugStr + "\n writeExternal: security mode = " + this.securityMode + " requestNum =" + requestNum + " position = " + chunkedObjectOutputStream.getPosition();
        }
        int n3 = chunkedObjectOutputStream.getPosition() - n2;
        this.signedChecksum = this.calculatedChecksum = chunkListReader.getChecksum(n3);
        chunkedObjectOutputStream.writeLong(this.calculatedChecksum);
        n3 += 8;
        if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
            this.debugStr = this.debugStr + "\n writeExternal: len = " + n3 + " checksum =" + this.calculatedChecksum + " position = " + chunkedObjectOutputStream.getPosition();
        }
        byte[] byArray = chunkListReader.getSignedData(n3, this.securityMode);
        byte[] byArray2 = JMSServerUtilities.digest(byArray, this.signatureSecret);
        chunkedObjectOutputStream.writeInt(byArray2.length);
        chunkedObjectOutputStream.write(byArray2);
        if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
            this.debugStr = this.debugStr + "\n writeExternal: after signature position = " + chunkedObjectOutputStream.getPosition();
            System.out.println(this.debugStr + "\n" + "writeExternal() len = " + n3 + " securityMode = " + this.securityMode + " version = " + n);
            this.dump(byArray, byArray2, this.signedChecksum, this.calculatedChecksum);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        this.debugStr = null;
        int n2 = objectInput.readInt();
        int n3 = n2 & 0xFF;
        if (n3 != 1 && n3 != 2) {
            throw JMSUtilities.versionIOException(n3, 1, 2);
        }
        ChunkedObjectInputStream chunkedObjectInputStream = (ChunkedObjectInputStream)objectInput;
        int n4 = chunkedObjectInputStream.pos();
        ChunkListReader chunkListReader = new ChunkListReader((ChunkedInputStream)chunkedObjectInputStream);
        if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
            this.debugStr = this.debugStr + "\n BEForwardingConsumer.DD_FORWARDING_DEBUG readExternal: coisStart = " + n4;
        }
        boolean bl = false;
        if (!chunkedObjectInputStream.isMarked() && n3 != 1) {
            chunkedObjectInputStream.mark(Integer.MAX_VALUE);
            bl = true;
        }
        super.readExternal((ObjectInput)chunkedObjectInputStream);
        this.size = chunkedObjectInputStream.readInt();
        this.requests = new BEProducerSendRequest[this.size];
        if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
            this.debugStr = this.debugStr + "\n readExternal: before requests position = " + chunkedObjectInputStream.pos();
        }
        for (int i = 0; i < this.size; ++i) {
            this.requests[i] = new BEProducerSendRequest();
            this.requests[i].readExternal((ObjectInput)chunkedObjectInputStream);
            if (!BEForwardingConsumer.DD_FORWARDING_DEBUG) continue;
            this.debugStr = this.debugStr + "\n readExternal: position(" + i + ") = " + chunkedObjectInputStream.pos();
        }
        this.securityMode = 14;
        if (n3 != 2) {
            return;
        }
        this.securityMode = chunkedObjectInputStream.readInt();
        if (this.securityMode == 15) {
            this.securityMode = 14;
        }
        if (this.securityMode != 12) {
            long l = chunkedObjectInputStream.readLong();
            if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
                this.debugStr = this.debugStr + "\n readExternal: security mode = " + this.securityMode + " requestNum =" + l + " position = " + chunkedObjectInputStream.pos();
            }
            n = chunkedObjectInputStream.pos() - n4;
            if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
                try {
                    String string = (String)this.requests[0].getMessage().getObjectProperty("CORRUPT");
                    if (string != null) {
                        System.out.println("  **** INSTR CORRUPT " + string);
                        if (string.equals("first")) {
                            chunkListReader.corrupt(0);
                        } else if (string.equals("middle")) {
                            chunkListReader.corrupt(n / 2);
                        } else if (string.equals("last")) {
                            chunkListReader.corrupt(n + 4);
                        }
                    }
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            this.calculatedChecksum = chunkListReader.getChecksum(n);
            this.signedChecksum = chunkedObjectInputStream.readLong();
            n += 8;
            if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
                this.debugStr = this.debugStr + "\n readExternal: len = " + n + " calculatedChecksum =" + this.calculatedChecksum + " position = " + chunkedObjectInputStream.pos();
            }
            this.signedData = chunkListReader.getSignedData(n, this.securityMode);
            int n5 = chunkedObjectInputStream.readInt();
            this.signature = new byte[n5];
            chunkedObjectInputStream.readFully(this.signature);
            if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
                this.debugStr = this.debugStr + "\n readExternal: after signature position = " + chunkedObjectInputStream.pos();
                System.out.println(this.debugStr);
                try {
                    String string = (String)this.requests[0].getMessage().getObjectProperty("CORRUPT");
                    if (string != null && string.equals("sig")) {
                        System.out.println("explicit test increments sig[0] on request=" + l);
                        this.signature[0] = (byte)(this.signature[0] + 1);
                    }
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
        }
        if (bl) {
            n = chunkedObjectInputStream.pos() - n4;
            chunkedObjectInputStream.reset();
            chunkedObjectInputStream.skip((long)n);
        }
    }

    private void dump(byte[] byArray, byte[] byArray2, long l, long l2) {
        System.out.println("\nsd=\n" + Hex.asHex((byte[])byArray) + "\nsg=\n" + Hex.asHex((byte[])byArray2) + "\nck_signed=" + l + "\nck_calc=" + l2);
    }

    static /* synthetic */ byte[] access$002(BEForwardRequest bEForwardRequest, byte[] byArray) {
        bEForwardRequest.signedData = byArray;
        return byArray;
    }

    private class ChunkListReader {
        private Chunk head;
        private Chunk headMark;
        private int chunkPos;
        private int chunkPosMark;
        private static final int READ = 1;
        private static final int SKIP = 2;
        private static final int CHECKSUM = 3;
        private static final int CORRUPT = 4;

        ChunkListReader(ChunkedInputStream chunkedInputStream) {
            this.head = this.headMark = chunkedInputStream.getChunks();
            this.chunkPos = this.chunkPosMark = chunkedInputStream.getChunkPos();
        }

        ChunkListReader(ChunkedOutputStream chunkedOutputStream) {
            this.head = this.headMark = chunkedOutputStream.getCurrentChunk();
            this.chunkPos = this.chunkPosMark = chunkedOutputStream.getChunkPos();
        }

        long getChecksum(long l) {
            Adler32 adler32 = new Adler32();
            long l2 = this.checksum(adler32, l);
            this.reset();
            if (l2 != l) {
                throw new AssertionError((Object)(l2 + "," + l));
            }
            return adler32.getValue();
        }

        byte[] getSignedData(int n, int n2) {
            if (n2 == 13) {
                BEForwardRequest.access$002(BEForwardRequest.this, new byte[n]);
                this.read(BEForwardRequest.this.signedData, 0, n);
                this.reset();
                return BEForwardRequest.this.signedData;
            }
            if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
                BEForwardRequest.this.debugStr = BEForwardRequest.this.debugStr + "\n getSignedData: len = " + n;
            }
            int n3 = 128;
            BEForwardRequest.access$002(BEForwardRequest.this, new byte[n3 * 2]);
            this.read(BEForwardRequest.this.signedData, 0, Math.min(n3, n));
            this.reset();
            if (n > n3) {
                this.skip(n - n3);
            }
            if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
                BEForwardRequest.this.debugStr = BEForwardRequest.this.debugStr + "\n getSignedData: len = " + n;
            }
            this.read(BEForwardRequest.this.signedData, n3, Math.min(n3, n));
            this.reset();
            return BEForwardRequest.this.signedData;
        }

        void corrupt(int n) {
            this.corruptInternal(n);
            this.reset();
        }

        public void reset() {
            this.head = this.headMark;
            this.chunkPos = this.chunkPosMark;
        }

        private int read(byte[] byArray, int n, int n2) {
            return (int)this.scanOp(byArray, n, n2, null, 1);
        }

        private long checksum(Checksum checksum, long l) {
            return this.scanOp(null, -1, l, checksum, 3);
        }

        private long skip(long l) {
            return (int)this.scanOp(null, -1, l, null, 2);
        }

        private long corruptInternal(long l) {
            return this.scanOp(null, -1, l + 1L, null, 4);
        }

        private long scanOp(byte[] byArray, int n, long l, Checksum checksum, int n2) {
            if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
                BEForwardRequest.this.debugStr = BEForwardRequest.this.debugStr + "\n scanOp: mode = " + n2 + " len = " + l;
            }
            long l2 = l;
            while (l > 0L) {
                if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
                    BEForwardRequest.this.debugStr = BEForwardRequest.this.debugStr + "\n scanOp: chunkPos = " + this.chunkPos + " head.end = " + this.head.end + " head.next is null? " + (this.head.next == null) + " len = " + l;
                }
                if (this.chunkPos == this.head.end && this.head.next != null) {
                    this.chunkPos = 0;
                    this.head = this.head.next;
                }
                int n3 = (int)Math.min((long)(this.head.end - this.chunkPos), l);
                if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
                    BEForwardRequest.this.debugStr = BEForwardRequest.this.debugStr + "\n scanOp: copyLen = " + n3 + " head.end = " + this.head.end + " head.next is null? " + (this.head.next == null) + " len = " + l;
                }
                if (this.head.next == null && (long)n3 < l) {
                    n3 = (int)l;
                }
                if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
                    BEForwardRequest.this.debugStr = BEForwardRequest.this.debugStr + "\n scanOp: real copyLen = " + n3;
                }
                switch (n2) {
                    case 1: {
                        System.arraycopy(this.head.buf, this.chunkPos, byArray, n, n3);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        checksum.update(this.head.buf, this.chunkPos, n3);
                        break;
                    }
                    case 4: {
                        int n4 = this.chunkPos + n3 - 1;
                        this.head.buf[n4] = (byte)(this.head.buf[n4] + 1);
                    }
                }
                this.chunkPos += n3;
                n += n3;
                l -= (long)n3;
            }
            if (BEForwardingConsumer.DD_FORWARDING_DEBUG) {
                BEForwardRequest.this.debugStr = BEForwardRequest.this.debugStr + "\n scanOp: chunkPos = " + this.chunkPos;
            }
            return l2;
        }
    }
}

