/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.jms.JMSException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEDeliveryList;
import weblogic.jms.backend.BEForwardRequest;
import weblogic.jms.backend.BEProducerSendRequest;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.backend.ForwardingStatusListener;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageId;
import weblogic.jms.common.JMSPeerGoneListener;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.dispatcher.Request;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.Dispatcher;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.ListenRequest;
import weblogic.messaging.kernel.Listener;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.Queue;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.timers.NakedTimerListener;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;

final class BEForwardingConsumer
extends BEDeliveryList
implements Listener,
JMSPeerGoneListener {
    private static final int DEFAULT_WINDOW_SIZE;
    private static final int DEFAULT_TRAN_TIMEOUT_SECONDS = 180;
    private static final long DEFAULT_FAILURE_DELAY_MILLIS = 18000L;
    private static final String TRAN_NAME = "weblogic.jms.backend.BEForwardingConsumer";
    static final boolean DD_FORWARDING_DEBUG;
    private String name;
    private Queue queue;
    private BackEnd backEnd;
    private JMSID id;
    private ListenRequest listenRequest;
    private DestinationImpl forwardingDest;
    private JMSDispatcher dispatcher;
    private ForwardingStatusListener statusListener;
    private TransactionManager tranManager;
    private int refCount;
    private boolean started;
    static final TimeComparator TIME_COMPARATOR;
    private byte[] signatureSecret;
    private String memberName;
    private int memberSecurityMode;
    private boolean resetDeliveryCount;
    private static final AuthenticatedSubject kernelId;

    BEForwardingConsumer(BackEnd backEnd, String string, JMSID jMSID, Queue queue) {
        super(backEnd);
        this.backEnd = backEnd;
        this.name = string;
        this.id = jMSID;
        this.queue = queue;
        this.resetDeliveryCount = true;
        this.tranManager = TxHelper.getTransactionManager();
    }

    BEForwardingConsumer(BackEnd backEnd, String string, JMSID jMSID, Queue queue, boolean bl) {
        super(backEnd);
        this.backEnd = backEnd;
        this.name = string;
        this.id = jMSID;
        this.queue = queue;
        this.resetDeliveryCount = bl;
        this.tranManager = TxHelper.getTransactionManager();
    }

    Queue getQueue() {
        return this.queue;
    }

    void setStatusListener(ForwardingStatusListener forwardingStatusListener) {
        this.statusListener = forwardingStatusListener;
    }

    synchronized void start(DestinationImpl destinationImpl, String string, int n) throws JMSException {
        String string2;
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Starting forwarding consumer for " + destinationImpl);
        }
        this.memberName = string;
        if (this.forwardingDest != destinationImpl) {
            this.stop();
            this.forwardingDest = destinationImpl;
        }
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        String string3 = runtimeAccess.getDomainName();
        String string4 = string2 = runtimeAccess.getServer().getCluster() != null ? runtimeAccess.getServer().getCluster().getName() : null;
        if (string2 != null) {
            this.signatureSecret = JMSServerUtilities.generateSecret(string3 + string2 + string + this.forwardingDest.getId());
        }
        if (this.started) {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Forwarding consumer already started for " + destinationImpl);
            }
            return;
        }
        try {
            this.dispatcher = JMSDispatcherManager.dispatcherFindOrCreate(destinationImpl.getDispatcherId());
            this.memberSecurityMode = this.dispatcher.isLocal() ? 15 : n;
            this.dispatcher.addDispatcherPeerGoneListener(this);
        }
        catch (DispatcherException dispatcherException) {
            String string5 = destinationImpl.isQueue() ? "Error contacting dispatcher for distributed queue member" : "Error contacting dispatcher for distributed topic member";
            throw new weblogic.jms.common.JMSException(string5, (Throwable)dispatcherException);
        }
        try {
            this.setWorkManager(this.backEnd.getAsyncPushWorkManager());
            this.listenRequest = this.queue.listen(null, DEFAULT_WINDOW_SIZE, false, (Object)this, (Listener)this, null, this.backEnd.getAsyncPushWorkManager());
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException("Error creating consumer on kernel queue", (Throwable)kernelException);
        }
        this.started = true;
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Started forwarding to dist dest member " + JMSService.getDestinationName(this.forwardingDest) + " from " + this.queue.getName());
        }
    }

    synchronized void stop() {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Stopping forwarding consumer ");
        }
        if (this.dispatcher != null) {
            this.dispatcher.removeDispatcherPeerGoneListener(this);
        }
        if (this.listenRequest != null) {
            this.listenRequest.stopAndWait();
        }
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatcherPeerGone(Exception exception, Dispatcher dispatcher) {
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("Received a peer gone while DD forwarding: " + exception + " statusListener " + this.statusListener);
        }
        this.stop();
        if (this.statusListener != null) {
            ForwardingStatusListener forwardingStatusListener = this.statusListener;
            synchronized (forwardingStatusListener) {
                BEForwardingConsumer bEForwardingConsumer = this;
                synchronized (bEForwardingConsumer) {
                    this.statusListener.forwardingFailed(this);
                }
            }
        }
    }

    public synchronized int incrementRefCount() {
        return ++this.refCount;
    }

    public synchronized int decrementRefCount() {
        return --this.refCount;
    }

    public ID getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushMessages(List list) {
        ListenRequest listenRequest;
        BEForwardingConsumer bEForwardingConsumer = this;
        synchronized (bEForwardingConsumer) {
            listenRequest = this.listenRequest;
        }
        try {
            SecurityManager.pushSubject((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId);
            try {
                this.processMessages(list);
                Object var6_11 = null;
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                SecurityManager.popSubject((AuthenticatedSubject)kernelId);
                throw throwable;
            }
            SecurityManager.popSubject((AuthenticatedSubject)kernelId);
            try {
                listenRequest.incrementCount(list.size());
            }
            catch (KernelException kernelException) {
                JMSDebug.JMSDistTopic.debug("Error requesting more messages from messaging kernel", (Throwable)kernelException);
            }
        }
        catch (JMSException jMSException) {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Scheduling increment of consumer window in 18000");
            }
            this.backEnd.getTimerManager().schedule((TimerListener)new RestartListener(list.size()), 18000L);
        }
        catch (Exception exception) {
            block18: {
                try {
                    JMSLogger.logDDForwardingError((String)this.name, (String)exception.toString(), (Throwable)exception);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (!JMSDebug.JMSDistTopic.isDebugEnabled()) break block18;
                    JMSDebug.JMSDistTopic.debug("Received an ArrayIndexOutOfBoundsException attempting in logDDForwardingError " + arrayIndexOutOfBoundsException);
                }
            }
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("UNEXPECTED Exception " + exception);
                exception.printStackTrace();
                JMSDebug.JMSDistTopic.debug("Scheduling increment of consumer window in 18000");
            }
            this.backEnd.getTimerManager().schedule((TimerListener)new RestartListener(list.size()), 18000L);
        }
        catch (Throwable throwable) {
            block19: {
                try {
                    JMSLogger.logDDForwardingError((String)this.name, (String)throwable.toString(), (Throwable)throwable);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (!JMSDebug.JMSDistTopic.isDebugEnabled()) break block19;
                    JMSDebug.JMSDistTopic.debug("Received an ArrayIndexOutOfBoundsException attempting in logDDForwardingError " + arrayIndexOutOfBoundsException);
                }
            }
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("UNEXPECTED Throwable Exception " + throwable);
                throwable.printStackTrace();
                JMSDebug.JMSDistTopic.debug("Scheduling increment of consumer window in 18000");
            }
            this.backEnd.getTimerManager().schedule((TimerListener)new RestartListener(list.size()), 18000L);
        }
    }

    private void processMessages(List list) throws JMSException {
        MessageImpl messageImpl;
        Object object2;
        int n = list.size();
        BEProducerSendRequest[] bEProducerSendRequestArray = new BEProducerSendRequest[n];
        int n2 = 0;
        if (this.queue.getComparator() == null) {
            Collections.sort(list, TIME_COMPARATOR);
        } else {
            Collections.sort(list, new UserComparator(this.queue.getComparator()));
        }
        for (Object object2 : list) {
            messageImpl = (MessageImpl)object2.getMessage();
            if (this.dispatcher.isLocal()) {
                messageImpl = messageImpl.cloneit();
            }
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug(n2 + 1 + "/" + n + " Forwarding message: " + messageImpl.getJMSMessageID() + " to " + this.memberName + " orig deliveryCount " + object2.getDeliveryCount() + " new deliveryCount " + messageImpl.getDeliveryCount() + " resetDeliveryCount " + this.resetDeliveryCount);
            }
            if (!this.resetDeliveryCount && object2.getDeliveryCount() > 1) {
                messageImpl.setDeliveryCount(object2.getDeliveryCount() - 1);
                if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                    JMSDebug.JMSBackEnd.debug("!!!BEForwardinConsumer.processMessage override deliveryCount " + messageImpl.getDeliveryCount());
                }
            } else if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("!!!BEForwardingConsumer.processMessage delivery count RESET (default) " + messageImpl.getDeliveryCount());
            }
            bEProducerSendRequestArray[n2] = new BEProducerSendRequest(this.forwardingDest.getId(), messageImpl, null, 0L, null);
            ++n2;
        }
        object2 = new BEForwardRequest(this.forwardingDest.getId(), bEProducerSendRequestArray, this.signatureSecret);
        messageImpl = null;
        try {
            this.tranManager.begin(TRAN_NAME, 180);
            messageImpl = this.tranManager.getTransaction();
            this.queue.associate(list, null);
        }
        catch (NotSupportedException notSupportedException) {
            this.handleTransactionFailure((Exception)((Object)notSupportedException), list, (Transaction)messageImpl);
        }
        catch (SystemException systemException) {
            this.handleTransactionFailure((Exception)((Object)systemException), list, (Transaction)messageImpl);
        }
        catch (KernelException kernelException) {
            this.handleTransactionFailure((Exception)((Object)kernelException), list, (Transaction)messageImpl);
        }
        catch (Exception exception) {
            this.handleTransactionFailure(exception, list, (Transaction)messageImpl);
        }
        try {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("About to forward DD msgs, s-mode=" + this.memberSecurityMode);
            }
            ((BEForwardRequest)object2).setSecurityMode(this.memberSecurityMode);
            switch (this.memberSecurityMode) {
                case 15: {
                    if (!this.dispatcher.isLocal()) {
                        throw new weblogic.jms.common.JMSException("unexpected fwd mode 1");
                    }
                    this.dispatcher.dispatchAsync((weblogic.messaging.dispatcher.Request)object2);
                    break;
                }
                case 14: {
                    if (this.dispatcher.isLocal()) {
                        throw new weblogic.jms.common.JMSException("unexpected fwd mode 2");
                    }
                    this.dispatcher.dispatchAsync((weblogic.messaging.dispatcher.Request)object2);
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    try {
                        SubjectManager.getSubjectManager().getAnonymousSubject().doAs((AbstractSubject)kernelId, new PrivilegedExceptionAction((BEForwardRequest)object2){
                            final /* synthetic */ BEForwardRequest val$request;
                            {
                                this.val$request = bEForwardRequest;
                            }

                            public Object run() throws JMSException, DispatcherException {
                                BEForwardingConsumer.this.dispatcher.dispatchAsync(this.val$request);
                                return null;
                            }
                        });
                        break;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof JMSException) {
                            throw (JMSException)((Object)exception);
                        }
                        if (!(exception instanceof DispatcherException)) break;
                        throw (DispatcherException)exception;
                    }
                }
                default: {
                    throw new weblogic.jms.common.JMSException("unexpected fwd mode 3");
                }
            }
            ((Request)object2).getResult();
            messageImpl.commit();
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Successfully forwarded " + n + " messages to " + JMSService.getDestinationName(this.forwardingDest));
            }
        }
        catch (SystemException systemException) {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("SystemException during processMessages() " + (Object)((Object)systemException));
            }
            this.handleForwardingFailure((Exception)((Object)systemException), (Transaction)messageImpl);
        }
        catch (RollbackException rollbackException) {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("RollbackException during processMessages() " + (Object)((Object)rollbackException));
            }
            this.handleForwardingFailure((Exception)((Object)rollbackException), (Transaction)messageImpl);
        }
        catch (HeuristicMixedException heuristicMixedException) {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("HeuristicMixedException during processMessages() " + (Object)((Object)heuristicMixedException));
            }
            this.handleForwardingFailure((Exception)((Object)heuristicMixedException), (Transaction)messageImpl);
        }
        catch (HeuristicRollbackException heuristicRollbackException) {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("HeuristicRollbackException during processMessages() " + (Object)((Object)heuristicRollbackException));
            }
            this.handleForwardingFailure((Exception)((Object)heuristicRollbackException), (Transaction)messageImpl);
        }
        catch (JMSException jMSException) {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("JMSException during processMessages() " + (Object)((Object)jMSException));
            }
            this.handleForwardingFailure((Exception)((Object)jMSException), (Transaction)messageImpl);
        }
        catch (DispatcherException dispatcherException) {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("DispatcherException during processMessages() " + dispatcherException);
            }
            this.handleForwardingFailure(dispatcherException, (Transaction)messageImpl);
        }
        catch (Exception exception) {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Unexpected Exception during processMessages() " + exception);
            }
            this.handleForwardingFailure(exception, (Transaction)messageImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTransactionFailure(Exception exception, List list, Transaction transaction) throws JMSException {
        block19: {
            block18: {
                if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                    JMSDebug.JMSDistTopic.debug("BEForwardingConsumer.handleTransactionFailure() " + exception.toString());
                }
                try {
                    JMSLogger.logDDForwardingError((String)this.name, (String)exception.toString(), (Throwable)exception);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (!JMSDebug.JMSDistTopic.isDebugEnabled()) break block18;
                    JMSDebug.JMSDistTopic.debug("BEForwardingConsumer.handleTransactionFailure() Received an ArrayIndexOutOfBoundsException attempting in logDDForwardingError " + arrayIndexOutOfBoundsException);
                }
            }
            if (transaction != null) {
                try {
                    transaction.rollback();
                }
                catch (SystemException systemException) {
                    if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                        JMSDebug.JMSDistTopic.debug("Error forwarding & rollback transaction, distributed destination", (Throwable)systemException);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    if (!JMSDebug.JMSDistTopic.isDebugEnabled()) break block19;
                    JMSDebug.JMSDistTopic.debug("Error forwarding & rollback transaction, distributed destination", (Throwable)illegalStateException);
                }
            }
        }
        try {
            BEForwardingConsumer bEForwardingConsumer = this;
            synchronized (bEForwardingConsumer) {
                this.stop();
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            block21: {
                Object var7_10 = null;
                try {
                    KernelRequest kernelRequest = new KernelRequest();
                    this.queue.negativeAcknowledge(list, 0L, kernelRequest);
                    kernelRequest.getResult();
                }
                catch (KernelException kernelException) {
                    if (!JMSDebug.JMSDistTopic.isDebugEnabled()) break block21;
                    JMSDebug.JMSDistTopic.debug("Error NACKing kernel messages: " + (Object)((Object)kernelException), (Throwable)kernelException);
                }
            }
            throw throwable;
        }
        try {
            KernelRequest kernelRequest = new KernelRequest();
            this.queue.negativeAcknowledge(list, 0L, kernelRequest);
            kernelRequest.getResult();
        }
        catch (KernelException kernelException) {
            if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                JMSDebug.JMSDistTopic.debug("Error NACKing kernel messages: " + (Object)((Object)kernelException), (Throwable)kernelException);
            }
        }
        if (this.statusListener != null) {
            this.statusListener.forwardingFailed(this);
        }
        throw new weblogic.jms.common.JMSException(exception);
    }

    private void handleForwardingFailure(Exception exception, Transaction transaction) throws JMSException {
        block11: {
            block10: {
                if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                    JMSDebug.JMSDistTopic.debug("BEForwardingConsumer.handleForwardingFailure() " + exception.toString() + " tran: " + transaction);
                }
                try {
                    JMSLogger.logDDForwardingError((String)this.name, (String)exception.toString(), (Throwable)exception);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (!JMSDebug.JMSDistTopic.isDebugEnabled()) break block10;
                    JMSDebug.JMSDistTopic.debug("BEForwardingConsumer.handleForwardingFailure() Received an ArrayIndexOutOfBoundsException attempting in logDDForwardingError " + arrayIndexOutOfBoundsException);
                }
            }
            if (transaction != null) {
                try {
                    if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                        JMSDebug.JMSDistTopic.debug("BEForwardingConsumer.handleForwardingFailure() rollback transaction " + transaction);
                    }
                    transaction.rollback();
                }
                catch (SystemException systemException) {
                    if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
                        JMSDebug.JMSDistTopic.debug("Error forwarding & rollback transaction, distributed destination", (Throwable)systemException);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    if (!JMSDebug.JMSDistTopic.isDebugEnabled()) break block11;
                    JMSDebug.JMSDistTopic.debug("Error forwarding & rollback transaction, distributed destination", (Throwable)illegalStateException);
                }
            }
        }
        if (JMSDebug.JMSDistTopic.isDebugEnabled()) {
            JMSDebug.JMSDistTopic.debug("BEForwardingConsumer.handleForwardingFailure() throw JMSException for " + exception.toString());
        }
        throw new weblogic.jms.common.JMSException(exception);
    }

    static {
        int n = 64;
        String string = System.getProperty("weblogic.jms.DDWindowSize", "64");
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        DEFAULT_WINDOW_SIZE = n;
        String string2 = System.getProperty("weblogic.jms.DDForwardingDebug", "");
        string2 = string2.toLowerCase(Locale.ENGLISH).trim();
        DD_FORWARDING_DEBUG = string2.equals("true");
        TIME_COMPARATOR = new TimeComparator();
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private final class RestartListener
    implements NakedTimerListener {
        private int incrementSize;

        RestartListener(int n) {
            this.incrementSize = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timerExpired(Timer timer) {
            BEForwardingConsumer bEForwardingConsumer = BEForwardingConsumer.this;
            synchronized (bEForwardingConsumer) {
                if (BEForwardingConsumer.this.started) {
                    try {
                        BEForwardingConsumer.this.listenRequest.incrementCount(this.incrementSize);
                    }
                    catch (KernelException kernelException) {
                        JMSDebug.JMSDistTopic.debug("Error requesting more messages from messaging kernel", (Throwable)kernelException);
                    }
                }
            }
        }
    }

    static final class UserComparator
    implements Comparator {
        private final Comparator userComparator;

        UserComparator(Comparator comparator) {
            this.userComparator = comparator;
        }

        public int compare(Object object, Object object2) {
            if (this.userComparator == null) {
                return 0;
            }
            return this.userComparator.compare(((MessageElement)object).getMessage(), ((MessageElement)object2).getMessage());
        }

        public boolean equals(Object object) {
            return object instanceof UserComparator;
        }

        public int hashCode() {
            return 0;
        }
    }

    static final class TimeComparator
    implements Comparator {
        TimeComparator() {
        }

        public int compare(Object object, Object object2) {
            JMSMessageId jMSMessageId = ((MessageImpl)((MessageElement)object).getMessage()).getId();
            JMSMessageId jMSMessageId2 = ((MessageImpl)((MessageElement)object2).getMessage()).getId();
            return jMSMessageId.compareTime(jMSMessageId2);
        }

        public boolean equals(Object object) {
            return object instanceof TimeComparator;
        }

        public int hashCode() {
            return 0;
        }
    }
}

