/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.HashMap;
import java.util.Iterator;
import javax.jms.JMSException;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEBrowser;
import weblogic.jms.backend.BEBrowserCreateRequest;
import weblogic.jms.backend.BEConnection;
import weblogic.jms.backend.BEConnectionConsumerCreateRequest;
import weblogic.jms.backend.BEConnectionConsumerImpl;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BEOrderUpdateParentRequest;
import weblogic.jms.backend.BERemoveSubscriptionRequest;
import weblogic.jms.backend.BESession;
import weblogic.jms.backend.BESessionCreateRequest;
import weblogic.jms.backend.BESessionImpl;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.DurableSubscription;
import weblogic.jms.common.InvalidDestinationException;
import weblogic.jms.common.JMSBrowserCreateResponse;
import weblogic.jms.common.JMSConnectionConsumerCreateResponse;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSID;
import weblogic.jms.dispatcher.Invocable;
import weblogic.jms.dispatcher.InvocableManagerDelegate;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.ID;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.InvocableMonitor;
import weblogic.messaging.dispatcher.Request;

public final class BEManager
implements Invocable {
    private static BEManager beManager;
    private final InvocableMonitor invocableMonitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BEManager(InvocableMonitor invocableMonitor) {
        Class<BEManager> clazz = BEManager.class;
        synchronized (BEManager.class) {
            if (beManager == null) {
                beManager = this;
            }
            this.invocableMonitor = invocableMonitor;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static BEConnection connectionFindOrCreate(JMSID jMSID, JMSDispatcher jMSDispatcher, boolean bl, long l, String string) {
        BEConnection bEConnection;
        do {
            try {
                bEConnection = (BEConnection)InvocableManagerDelegate.delegate.invocableFind(15, jMSID);
                if (bEConnection.getDispatcher() != jMSDispatcher && bEConnection.getDispatcher() != null) {
                    bEConnection.setDispatcher(jMSDispatcher);
                }
                if (l <= bEConnection.getStartStopSequenceNumber()) continue;
                if (bl) {
                    bEConnection.stop(l, false);
                    continue;
                }
                bEConnection.start(l);
            }
            catch (JMSException jMSException) {
                bEConnection = new BEConnection(jMSDispatcher, jMSID, bl, string);
                bEConnection.setStartStopSequenceNumber(l);
                try {
                    InvocableManagerDelegate.delegate.invocableAdd(15, bEConnection);
                }
                catch (JMSException jMSException2) {
                    bEConnection = null;
                }
            }
        } while (bEConnection == null);
        return bEConnection;
    }

    private static int browserCreate(Request request) throws JMSException {
        BEBrowserCreateRequest bEBrowserCreateRequest = (BEBrowserCreateRequest)request;
        BEDestinationImpl bEDestinationImpl = (BEDestinationImpl)InvocableManagerDelegate.delegate.invocableFind(20, bEBrowserCreateRequest.getDestinationId());
        bEDestinationImpl.checkShutdownOrSuspendedNeedLock("create browser");
        BEBrowser bEBrowser = bEDestinationImpl.createBrowser(null, bEBrowserCreateRequest.getSelector());
        InvocableManagerDelegate.delegate.invocableAdd(18, bEBrowser);
        bEBrowserCreateRequest.setResult(new JMSBrowserCreateResponse(bEBrowser.getJMSID()));
        bEBrowserCreateRequest.setState(Integer.MAX_VALUE);
        return bEBrowserCreateRequest.getState();
    }

    private void sessionCreate(Request request) throws JMSException {
        JMSDispatcher jMSDispatcher;
        BESessionCreateRequest bESessionCreateRequest = (BESessionCreateRequest)request;
        JMSID jMSID = bESessionCreateRequest.getSessionId();
        try {
            jMSDispatcher = JMSDispatcherManager.dispatcherFindOrCreate(bESessionCreateRequest.getFEDispatcherId());
        }
        catch (DispatcherException dispatcherException) {
            throw new weblogic.jms.common.JMSException(dispatcherException.getMessage(), (Throwable)dispatcherException);
        }
        BEConnection bEConnection = BEManager.connectionFindOrCreate(bESessionCreateRequest.getConnectionId(), jMSDispatcher, bESessionCreateRequest.getIsStopped(), bESessionCreateRequest.getStartStopSequenceNumber(), bESessionCreateRequest.getConnectionAddress());
        bEConnection.checkShutdownOrSuspendedNeedLock("create session");
        try {
            BESession bESession = (BESession)InvocableManagerDelegate.delegate.invocableFind(16, jMSID);
        }
        catch (JMSException jMSException) {
            BESessionImpl bESessionImpl = new BESessionImpl(bEConnection, jMSID, bESessionCreateRequest.getSequencerId(), bESessionCreateRequest.getTransacted(), bESessionCreateRequest.getXASession(), bESessionCreateRequest.getAcknowledgeMode(), bESessionCreateRequest.getClientVersion(), bESessionCreateRequest.getPushWorkManager());
            bEConnection.sessionAdd(bESessionImpl);
        }
    }

    private static int connectionConsumerCreate(BEConnectionConsumerCreateRequest bEConnectionConsumerCreateRequest) throws JMSException {
        BackEnd backEnd = JMSService.getJMSService().getBEDeployer().findBackEnd(bEConnectionConsumerCreateRequest.getBackEndId());
        backEnd.checkShutdownNeedLock("create connection consumer");
        BEDestinationImpl bEDestinationImpl = (BEDestinationImpl)InvocableManagerDelegate.delegate.invocableFind(20, bEConnectionConsumerCreateRequest.getDestinationId());
        JMSID jMSID = JMSService.getJMSService().getNextId();
        boolean bl = true;
        if (bEConnectionConsumerCreateRequest.getConnection() != null && bEConnectionConsumerCreateRequest.getConnection().isStopped()) {
            bl = false;
        }
        BEConnectionConsumerImpl bEConnectionConsumerImpl = bEDestinationImpl.createConnectionConsumer(jMSID, bEConnectionConsumerCreateRequest.getServerSessionPool(), null, null, bEConnectionConsumerCreateRequest.getMessageSelector(), false, bEConnectionConsumerCreateRequest.getMessagesMaximum(), -1L, bEConnectionConsumerCreateRequest.isDurable(), bl);
        BEConnection bEConnection = BEManager.connectionFindOrCreate(bEConnectionConsumerCreateRequest.getConnectionId(), JMSDispatcherManager.getLocalDispatcher(), bEConnectionConsumerCreateRequest.isStopped(), bEConnectionConsumerCreateRequest.getStartStopSequenceNumber(), null);
        if (bEConnectionConsumerCreateRequest.isDurable()) {
            DurableSubscription durableSubscription = backEnd.getDurableSubscription(bEConnectionConsumerImpl.getName());
            durableSubscription.addSubscriber(bEConnectionConsumerImpl);
            backEnd.addDurableSubscription(bEConnectionConsumerImpl.getName(), durableSubscription);
        }
        bEConnection.connectionConsumerAdd(bEConnectionConsumerImpl);
        bEConnectionConsumerCreateRequest.setResult(new JMSConnectionConsumerCreateResponse(bEConnectionConsumerImpl));
        bEConnectionConsumerCreateRequest.setState(Integer.MAX_VALUE);
        return Integer.MAX_VALUE;
    }

    private static int removeSubscription(Request request) throws JMSException {
        BackEnd backEnd;
        BERemoveSubscriptionRequest bERemoveSubscriptionRequest = (BERemoveSubscriptionRequest)request;
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("BEManager removes Subscription: " + bERemoveSubscriptionRequest.getName() + " client id = " + bERemoveSubscriptionRequest.getClientId());
        }
        if ((backEnd = JMSService.getJMSService().getBEDeployer().findBackEnd(bERemoveSubscriptionRequest.getBackEndId())) == null) {
            throw new InvalidDestinationException("JMS Destination referenced by the request is not found");
        }
        backEnd.checkShutdownOrSuspendedNeedLock("remove subscription");
        String string = BEConsumerImpl.clientIdPlusName(bERemoveSubscriptionRequest.getClientId(), bERemoveSubscriptionRequest.getName(), bERemoveSubscriptionRequest.getClientIdPolicy(), bERemoveSubscriptionRequest.getDestinationName(), backEnd.getName());
        DurableSubscription durableSubscription = backEnd.getDurableSubscription(string);
        if (durableSubscription == null) {
            throw new InvalidDestinationException("Subscription " + string + " not found");
        }
        durableSubscription.getConsumer().delete(false, true, false);
        bERemoveSubscriptionRequest.setResult(new VoidResponse());
        bERemoveSubscriptionRequest.setState(Integer.MAX_VALUE);
        return bERemoveSubscriptionRequest.getState();
    }

    private static int completeUpdateParentRequest(Request request) {
        BEOrderUpdateParentRequest bEOrderUpdateParentRequest = (BEOrderUpdateParentRequest)request;
        try {
            bEOrderUpdateParentRequest.setResult(bEOrderUpdateParentRequest.getOrderUpdate().getResult());
            bEOrderUpdateParentRequest.setState(Integer.MAX_VALUE);
        }
        catch (Throwable throwable) {
            bEOrderUpdateParentRequest.getCompletionRequest().setResult((Object)throwable);
            return Integer.MAX_VALUE;
        }
        bEOrderUpdateParentRequest.getCompletionRequest().setResult((Object)Boolean.TRUE);
        return Integer.MAX_VALUE;
    }

    public static BEManager getBEManager() {
        return beManager;
    }

    public JMSID getJMSID() {
        return null;
    }

    public ID getId() {
        return this.getJMSID();
    }

    public InvocableMonitor getInvocableMonitor() {
        return this.invocableMonitor;
    }

    public int invoke(Request request) throws JMSException {
        switch (request.getMethodId()) {
            case 14850: {
                return BEManager.removeSubscription(request);
            }
            case 13570: {
                this.sessionCreate(request);
                request.setResult(new VoidResponse());
                request.setState(Integer.MAX_VALUE);
                return Integer.MAX_VALUE;
            }
            case 9218: {
                return BEManager.connectionConsumerCreate((BEConnectionConsumerCreateRequest)request);
            }
            case 8450: {
                return BEManager.browserCreate(request);
            }
            case 18178: {
                return BEManager.completeUpdateParentRequest(request);
            }
        }
        throw new weblogic.jms.common.JMSException("No such method " + request.getMethodId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BEConnection[] getBEConnections() {
        HashMap hashMap;
        HashMap hashMap2 = hashMap = InvocableManagerDelegate.delegate.getInvocableMap(15);
        synchronized (hashMap2) {
            BEConnection[] bEConnectionArray = new BEConnection[hashMap.size()];
            Iterator iterator = hashMap.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                bEConnectionArray[n++] = (BEConnection)iterator.next();
            }
            return bEConnectionArray;
        }
    }
}

