/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.JMSMessageCursorDelegate;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSMessageOpenDataConverter;
import weblogic.jms.common.JMSSQLExpression;
import weblogic.jms.common.JMSSQLFilter;
import weblogic.jms.common.JMSSecurityException;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.extensions.DestinationInfo;
import weblogic.jms.extensions.JMSForwardHelper;
import weblogic.jms.extensions.JMSMessageInfo;
import weblogic.jms.extensions.WLMessageProducer;
import weblogic.management.ManagementException;
import weblogic.messaging.kernel.Cursor;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.QuotaException;
import weblogic.messaging.runtime.CursorRuntimeImpl;
import weblogic.messaging.runtime.OpenDataConverter;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;

final class BEMessageManagementImpl {
    private final String name;
    private long messagesDeletedCurrentCount;
    private long messagesMovedCurrentCount;
    private final Queue queue;
    private final BEDestinationImpl destination;
    private final JMSSQLFilter filter;
    private final CursorRuntimeImpl cursorRuntime;
    private final OpenDataConverter messageHeaderConverter;
    private final OpenDataConverter messageBodyConverter;
    private final TransactionManager tm;

    BEMessageManagementImpl(String string, Queue queue, BEDestinationImpl bEDestinationImpl, CursorRuntimeImpl cursorRuntimeImpl) {
        this.name = string;
        this.queue = queue;
        this.destination = bEDestinationImpl;
        this.filter = new JMSSQLFilter(queue.getKernel());
        this.cursorRuntime = cursorRuntimeImpl;
        this.messageHeaderConverter = new JMSMessageOpenDataConverter(false);
        this.messageBodyConverter = new JMSMessageOpenDataConverter(true);
        this.tm = (TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager();
    }

    Long getMessagesMovedCurrentCount() {
        return new Long(this.messagesMovedCurrentCount);
    }

    Long getMessagesDeletedCurrentCount() {
        return new Long(this.messagesDeletedCurrentCount);
    }

    String getMessages(String string, Integer n) throws ManagementException {
        return this.getMessages(string, n, new Integer(Integer.MAX_VALUE));
    }

    String getMessages(String string, Integer n, Integer n2) throws ManagementException {
        try {
            this.destination.getJMSDestinationSecurity().checkBrowsePermission();
        }
        catch (JMSSecurityException jMSSecurityException) {
            this.throwManagementException("Authorization failure.", (Throwable)((Object)jMSSecurityException));
        }
        Cursor cursor = null;
        try {
            cursor = this.queue.createCursor(true, this.filter.createExpression(new JMSSQLExpression(string)), n2.intValue());
        }
        catch (KernelException kernelException) {
            this.throwManagementException("Error creating message cursor for " + this.name, kernelException);
        }
        JMSMessageCursorDelegate jMSMessageCursorDelegate = new JMSMessageCursorDelegate(this.cursorRuntime, this.messageHeaderConverter, cursor, this.messageBodyConverter, this.destination, n);
        this.cursorRuntime.addCursorDelegate(jMSMessageCursorDelegate);
        return jMSMessageCursorDelegate.getHandle();
    }

    Integer moveMessages(String string, CompositeData compositeData) throws ManagementException {
        return this.moveMessages(string, compositeData, new Integer(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer moveMessages(String string, CompositeData compositeData, Integer n) throws ManagementException {
        Serializable serializable;
        DestinationInfo destinationInfo;
        if (compositeData == null) {
            this.throwManagementException("moveMessages operation failed. The target destination is null.");
        }
        if (n == null) {
            this.throwManagementException("moveMessages operation failed.  The timeout value is null.");
        }
        DestinationImpl destinationImpl = null;
        try {
            destinationInfo = new DestinationInfo(compositeData);
            destinationImpl = (DestinationImpl)destinationInfo.getDestination();
        }
        catch (OpenDataException openDataException) {
            this.throwManagementException("moveMessages operation failed.", openDataException);
        }
        try {
            this.destination.getJMSDestinationSecurity().checkBrowsePermission();
        }
        catch (JMSSecurityException jMSSecurityException) {
            this.throwManagementException("Authorization failure.", (Throwable)((Object)jMSSecurityException));
        }
        try {
            this.destination.getJMSDestinationSecurity().checkReceivePermission();
        }
        catch (JMSSecurityException jMSSecurityException) {
            this.throwManagementException("Authorization failure.", (Throwable)((Object)jMSSecurityException));
        }
        destinationInfo = this.suspendTransaction();
        int n2 = 0;
        Cursor cursor = null;
        ConnectionFactory connectionFactory = null;
        Connection connection = null;
        Session session = null;
        WLMessageProducer wLMessageProducer = null;
        try {
            connectionFactory = JMSServerUtilities.getXAConnectionFactory();
            try {
                connection = connectionFactory.createConnection();
                session = connection.createSession(false, 2);
                wLMessageProducer = (WLMessageProducer)session.createProducer((Destination)destinationImpl);
            }
            catch (JMSException jMSException) {
                this.moveError(this.name, destinationImpl.getName(), jMSException);
            }
            try {
                this.tm.begin("JMS Move Messages", n.intValue());
            }
            catch (NotSupportedException notSupportedException) {
                this.moveError(this.name, destinationImpl.getName(), notSupportedException);
            }
            catch (SystemException systemException) {
                this.moveError(this.name, destinationImpl.getName(), systemException);
            }
            MessageElement messageElement = null;
            try {
                cursor = this.queue.createCursor(true, this.filter.createExpression(new JMSSQLExpression(string)), 1073);
                n2 = cursor.size();
                while ((messageElement = cursor.next()) != null) {
                    serializable = (MessageImpl)messageElement.getMessage();
                    ((MessageImpl)serializable).setForward(true);
                    JMSForwardHelper.ForwardFromMessage(wLMessageProducer, (Message)serializable, true);
                    KernelRequest kernelRequest = this.queue.delete(messageElement);
                    if (kernelRequest == null) continue;
                    kernelRequest.getResult();
                }
            }
            catch (KernelException kernelException) {
                this.moveError(this.name, destinationImpl.getName(), kernelException);
            }
            catch (JMSException jMSException) {
                this.moveError(this.name, destinationImpl.getName(), jMSException);
            }
            try {
                this.tm.commit();
            }
            catch (SecurityException securityException) {
                this.moveError(this.name, destinationImpl.getName(), securityException);
            }
            catch (IllegalStateException illegalStateException) {
                this.moveError(this.name, destinationImpl.getName(), illegalStateException);
            }
            catch (RollbackException rollbackException) {
                this.moveError(this.name, destinationImpl.getName(), rollbackException);
            }
            catch (HeuristicMixedException heuristicMixedException) {
                this.moveError(this.name, destinationImpl.getName(), heuristicMixedException);
            }
            catch (HeuristicRollbackException heuristicRollbackException) {
                this.moveError(this.name, destinationImpl.getName(), heuristicRollbackException);
            }
            catch (SystemException systemException) {
                this.moveError(this.name, destinationImpl.getName(), systemException);
            }
            this.incrementMessagesMovedCurrentCount(n2);
            serializable = new Integer(n2);
            Object var16_29 = null;
        }
        catch (Throwable throwable) {
            block58: {
                Object var16_30 = null;
                try {
                    if (this.tm.getTransaction() != null) {
                        this.tm.rollback();
                    }
                }
                catch (IllegalStateException throwable2) {
                    this.debug("Error rolling back move messages transaction", throwable2);
                }
                catch (SecurityException throwable2) {
                    this.debug("Error rolling back move messages transaction", throwable2);
                }
                catch (SystemException throwable2) {
                    this.debug("Error rolling back move messages transaction", throwable2);
                }
                if (wLMessageProducer != null) {
                    try {
                        wLMessageProducer.close();
                    }
                    catch (JMSException throwable2) {
                        this.debug("Unable to close move messages producer", throwable2);
                    }
                }
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (JMSException throwable2) {
                        this.debug("Unable to close move messages session", throwable2);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (JMSException throwable2) {
                        this.debug("Unable to close move messages connection", throwable2);
                    }
                }
                if (cursor != null) {
                    cursor.close();
                }
                if (destinationInfo == null) break block58;
                this.resumeTransaction((Transaction)destinationInfo);
            }
            throw throwable;
        }
        try {
            if (this.tm.getTransaction() != null) {
                this.tm.rollback();
            }
        }
        catch (IllegalStateException throwable) {
            this.debug("Error rolling back move messages transaction", throwable);
        }
        catch (SecurityException throwable) {
            this.debug("Error rolling back move messages transaction", throwable);
        }
        catch (SystemException throwable) {
            this.debug("Error rolling back move messages transaction", throwable);
        }
        if (wLMessageProducer != null) {
            try {
                wLMessageProducer.close();
            }
            catch (JMSException throwable) {
                this.debug("Unable to close move messages producer", throwable);
            }
        }
        if (session != null) {
            try {
                session.close();
            }
            catch (JMSException throwable) {
                this.debug("Unable to close move messages session", throwable);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (JMSException throwable) {
                this.debug("Unable to close move messages connection", throwable);
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        if (destinationInfo != null) {
            this.resumeTransaction((Transaction)destinationInfo);
        }
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    CompositeData getMessage(String string) throws ManagementException {
        Cursor cursor;
        CompositeData compositeData;
        block11: {
            CompositeData compositeData2;
            block10: {
                try {
                    this.destination.getJMSDestinationSecurity().checkBrowsePermission();
                }
                catch (JMSSecurityException jMSSecurityException) {
                    this.throwManagementException("Authorization failure.", (Throwable)((Object)jMSSecurityException));
                }
                compositeData = null;
                cursor = null;
                try {
                    try {
                        cursor = this.queue.createCursor(true, this.filter.createExpression(new JMSSQLExpression("JMSMessageID = '" + string + "'")), 1);
                        if (cursor.size() == 0) {
                            compositeData2 = null;
                            Object var6_9 = null;
                            if (cursor == null) return compositeData2;
                            break block10;
                        }
                        if (cursor.size() > 1) {
                            this.throwManagementException("Multiple messages exist for messageID " + string);
                        }
                        MessageElement messageElement = cursor.next();
                        compositeData = this.messageBodyConverter.createCompositeData(messageElement);
                        break block11;
                    }
                    catch (OpenDataException openDataException) {
                        this.throwManagementException("Failed to convert message with message ID " + string + " to open data representation.", openDataException);
                        Object var6_11 = null;
                        if (cursor == null) return compositeData;
                        cursor.close();
                        return compositeData;
                    }
                    catch (KernelException kernelException) {
                        this.throwManagementException("Failed to get message with message ID " + string, kernelException);
                        Object var6_12 = null;
                        if (cursor == null) return compositeData;
                        cursor.close();
                        return compositeData;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_13 = null;
                    if (cursor == null) throw throwable;
                    cursor.close();
                    throw throwable;
                }
            }
            cursor.close();
            return compositeData2;
        }
        Object var6_10 = null;
        if (cursor == null) return compositeData;
        cursor.close();
        return compositeData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Integer deleteMessages(String string) throws ManagementException {
        int n;
        Transaction transaction;
        block11: {
            try {
                this.destination.getJMSDestinationSecurity().checkReceivePermission();
            }
            catch (JMSSecurityException jMSSecurityException) {
                this.throwManagementException("Authorization failure.", (Throwable)((Object)jMSSecurityException));
            }
            transaction = this.suspendTransaction();
            Cursor cursor = null;
            n = 0;
            try {
                try {
                    cursor = this.queue.createCursor(true, this.filter.createExpression(new JMSSQLExpression(string)), 1073);
                    MessageElement messageElement = null;
                    while ((messageElement = cursor.next()) != null) {
                        KernelRequest kernelRequest = this.queue.delete(messageElement);
                        if (kernelRequest != null) {
                            kernelRequest.getResult();
                        }
                        ++n;
                    }
                    this.incrementMessagesDeletedCurrentCount(n);
                }
                catch (KernelException kernelException) {
                    this.throwManagementException("Error while deleting messages", kernelException);
                    Object var8_10 = null;
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (transaction == null) return new Integer(n);
                    this.resumeTransaction(transaction);
                    return new Integer(n);
                }
                Object var8_9 = null;
                if (cursor == null) break block11;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (cursor != null) {
                    cursor.close();
                }
                if (transaction == null) throw throwable;
                this.resumeTransaction(transaction);
                throw throwable;
            }
            cursor.close();
        }
        if (transaction == null) return new Integer(n);
        this.resumeTransaction(transaction);
        return new Integer(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Void importMessages(CompositeData[] compositeDataArray, Boolean bl) throws ManagementException {
        if (bl.booleanValue()) {
            String string = "importMessages operation not supported with replaceOnly=true";
            this.debug(string);
            throw new UnsupportedOperationException(string);
        }
        if (compositeDataArray == null || compositeDataArray.length == 0) {
            return null;
        }
        try {
            this.destination.getJMSDestinationSecurity().checkSendPermission();
        }
        catch (JMSSecurityException jMSSecurityException) {
            this.throwManagementException("Authorization failure.", (Throwable)((Object)jMSSecurityException));
        }
        Transaction transaction = this.suspendTransaction();
        try {
            for (int i = 0; i < compositeDataArray.length; ++i) {
                JMSMessageInfo jMSMessageInfo;
                if (compositeDataArray[i] == null) continue;
                MessageImpl messageImpl = null;
                try {
                    jMSMessageInfo = new JMSMessageInfo(compositeDataArray[i]);
                    messageImpl = (MessageImpl)jMSMessageInfo.getMessage();
                }
                catch (OpenDataException openDataException) {
                    this.throwManagementException("Unable to convert Open Data type to Message", openDataException);
                }
                if (messageImpl.getDeliveryCount() < 0) {
                    throw new ManagementException("Import of message " + messageImpl.getJMSMessageID() + " to destination " + this.name + " failed due to an invalid delivery count of " + messageImpl.getDeliveryCount());
                }
                if (messageImpl.getAdjustedDeliveryMode() == 2) {
                    if (this.destination.isTemporary()) {
                        this.downgradeMessage(messageImpl);
                    } else if (!this.destination.getBackEnd().isStoreEnabled()) {
                        if (this.destination.getBackEnd().isAllowsPersistentDowngrade()) {
                            this.downgradeMessage(messageImpl);
                        } else {
                            this.throwManagementException("Unable to downgrade message " + messageImpl.getJMSMessageID() + " while importing to destination " + this.name + " because persistence downgrade is not supported.");
                        }
                    }
                }
                if (!bl.booleanValue()) {
                    messageImpl.setId(JMSService.getJMSService().getNextMessageId());
                }
                try {
                    jMSMessageInfo = this.queue.send((weblogic.messaging.Message)messageImpl, this.destination.createSendOptions(0L, null, messageImpl));
                    if (jMSMessageInfo == null) continue;
                    jMSMessageInfo.getResult();
                    continue;
                }
                catch (QuotaException quotaException) {
                    this.throwManagementException("Quota exceeded on target", quotaException);
                    continue;
                }
                catch (weblogic.messaging.kernel.IllegalStateException illegalStateException) {
                    this.throwManagementException("Destination " + this.name + " state does not allow message production", illegalStateException);
                    continue;
                }
                catch (KernelException kernelException) {
                    this.throwManagementException("Internal error during import operation", kernelException);
                }
            }
            Object var8_13 = null;
            if (transaction != null) {
                this.resumeTransaction(transaction);
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (transaction != null) {
                this.resumeTransaction(transaction);
            }
            throw throwable;
        }
        return null;
    }

    private synchronized void incrementMessagesDeletedCurrentCount(int n) {
        this.messagesDeletedCurrentCount += (long)n;
    }

    private synchronized void incrementMessagesMovedCurrentCount(int n) {
        this.messagesMovedCurrentCount += (long)n;
    }

    private Transaction suspendTransaction() throws ManagementException {
        try {
            return this.tm.suspend();
        }
        catch (SystemException systemException) {
            throw new ManagementException("Unable to suspend existing transaction.", (Throwable)systemException);
        }
    }

    private void resumeTransaction(Transaction transaction) {
        try {
            this.tm.resume(transaction);
        }
        catch (SystemException systemException) {
            this.debug("Error restoring transaction context.", systemException);
        }
        catch (InvalidTransactionException invalidTransactionException) {
            this.debug("Error restoring transaction context.", invalidTransactionException);
        }
        catch (IllegalStateException illegalStateException) {
            this.debug("Error restoring transaction context.", illegalStateException);
        }
    }

    private void downgradeMessage(MessageImpl messageImpl) throws ManagementException {
        messageImpl.setAdjustedDeliveryMode(1);
        try {
            messageImpl.setJMSDeliveryMode(1);
        }
        catch (JMSException jMSException) {
            this.throwManagementException("Unable to downgrade message.", jMSException);
        }
    }

    private void moveError(String string, String string2, Throwable throwable) throws ManagementException {
        String string3 = "Error occurred while processing the requested move operation from source " + this.name + " to destination " + string2;
        this.throwManagementException(string3, throwable);
    }

    private void throwManagementException(String string) throws ManagementException {
        this.debug(string);
        throw new ManagementException(string);
    }

    private void throwManagementException(String string, Throwable throwable) throws ManagementException {
        this.debug(string, throwable);
        throw new ManagementException(string, throwable);
    }

    private void debug(String string) {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug(string);
        }
    }

    private void debug(String string, Throwable throwable) {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug(string, throwable);
        }
    }
}

