/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import weblogic.jms.JMSLogger;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.backend.BESessionImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSPushEntry;
import weblogic.jms.common.JMSPushRequest;
import weblogic.jms.common.JMSSecurityException;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.messaging.Message;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.MultiListener;

final class BEMultiSender
implements MultiListener {
    private static final boolean debug = false;

    BEMultiSender() {
    }

    public void multiDeliver(Message message, List list) {
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Pushing message " + ((MessageImpl)message).getJMSMessageID() + " to " + list.size() + " consumers");
        }
        Iterator iterator = list.iterator();
        HashMap<JMSDispatcher, JMSPushRequest> hashMap = new HashMap<JMSDispatcher, JMSPushRequest>(4);
        while (iterator.hasNext()) {
            MultiListener.DeliveryInfo deliveryInfo = (MultiListener.DeliveryInfo)iterator.next();
            BEConsumerImpl object = (BEConsumerImpl)deliveryInfo.getListener();
            try {
                object.checkPermission(true, false);
            }
            catch (JMSSecurityException jMSSecurityException) {
                continue;
            }
            MessageElement jMSException = deliveryInfo.getMessageElement();
            MessageImpl messageImpl = (MessageImpl)message;
            BESessionImpl bESessionImpl = object.getSession();
            jMSException.setUserSequenceNum(bESessionImpl.getNextSequenceNumber());
            jMSException.setUserData((Object)object);
            boolean bl = object.allowsImplicitAcknowledge();
            boolean bl2 = bl || bESessionImpl.getAcknowledgeMode() == 4;
            JMSPushEntry jMSPushEntry = object.createPushEntry(jMSException, bl, bl2);
            JMSDispatcher jMSDispatcher = bESessionImpl.getConnection().getDispatcher();
            JMSPushRequest jMSPushRequest = (JMSPushRequest)hashMap.get(jMSDispatcher);
            if (jMSPushRequest == null) {
                jMSPushRequest = new JMSPushRequest(13, bESessionImpl.getSequencerId(), messageImpl, jMSPushEntry);
                hashMap.put(jMSDispatcher, jMSPushRequest);
            } else {
                jMSPushRequest.setInvocableType(1);
                jMSPushRequest.addPushEntry(jMSPushEntry);
            }
            if (!bl2) {
                object.adjustUnackedCount(1);
                bESessionImpl.addPendingMessage(jMSException, object);
            }
            if (!bl2 || object.isKernelAutoAcknowledge()) continue;
            try {
                KernelRequest kernelRequest = object.getKernelQueue().acknowledge(jMSException);
                if (kernelRequest == null) continue;
                kernelRequest.getResult();
            }
            catch (KernelException kernelException) {
                if (!JMSDebug.JMSBackEnd.isDebugEnabled()) continue;
                JMSDebug.JMSBackEnd.debug("Unexpected exception while implicitly acknowledging: " + (Object)((Object)kernelException), (Throwable)kernelException);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                JMSDebug.JMSBackEnd.debug("Pushing entries to dispatcher " + entry.getKey());
            }
            try {
                JMSServerUtilities.anonDispatchNoReply((JMSPushRequest)entry.getValue(), (JMSDispatcher)entry.getKey());
            }
            catch (JMSException jMSException) {
                JMSLogger.logErrorPushingMessage((String)jMSException.toString(), (Throwable)jMSException);
            }
        }
    }
}

