/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import javax.jms.JMSException;
import weblogic.jms.backend.BEDeliveryList;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.DestinationImpl;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.multicast.JMSTMSocket;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.ListenRequest;
import weblogic.messaging.kernel.Listener;
import weblogic.messaging.kernel.MessageElement;
import weblogic.messaging.kernel.Queue;

final class BEMulticastConsumer
extends BEDeliveryList
implements Listener {
    private static final int DEFAULT_WINDOW_SIZE = 256;
    private final DestinationImpl destination;
    private final Queue queue;
    private final int port;
    private final byte ttl;
    private final InetAddress group;
    private long sequenceNum;
    private final JMSTMSocket socket;
    private ListenRequest listenRequest;
    private boolean started;

    BEMulticastConsumer(BackEnd backEnd, Queue queue, DestinationImpl destinationImpl, InetAddress inetAddress, int n, byte by, JMSTMSocket jMSTMSocket) {
        super(backEnd);
        this.setWorkManager(backEnd.getWorkManager());
        this.queue = queue;
        this.destination = destinationImpl;
        this.group = inetAddress;
        this.port = n;
        this.ttl = by;
        this.socket = jMSTMSocket;
    }

    Queue getQueue() {
        return this.queue;
    }

    synchronized void stop() {
        if (!this.started) {
            return;
        }
        if (this.listenRequest != null) {
            this.listenRequest.stop();
        }
        this.started = false;
    }

    synchronized void start() throws JMSException {
        if (this.started) {
            return;
        }
        try {
            this.setWorkManager(this.getBackEnd().getWorkManager());
            this.listenRequest = this.queue.listen(null, 256, true, (Object)this, (Listener)this, null, this.getBackEnd().getWorkManager());
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException("Error creating consumer on kernel queue", (Throwable)kernelException);
        }
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushMessages(List list) {
        ListenRequest listenRequest;
        Object object = this;
        synchronized (object) {
            listenRequest = this.listenRequest;
        }
        object = list.iterator();
        while (object.hasNext()) {
            MessageImpl messageImpl = (MessageImpl)((MessageElement)object.next()).getMessage();
            try {
                JMSTMSocket jMSTMSocket = this.socket;
                synchronized (jMSTMSocket) {
                    this.socket.send(messageImpl, this.destination, messageImpl.getConnectionId(), this.group, this.port, this.ttl, this.sequenceNum++);
                }
            }
            catch (IOException iOException) {
                JMSDebug.JMSBackEnd.debug("Error forwarding multicast message", (Throwable)iOException);
            }
            try {
                listenRequest.incrementCount(1);
            }
            catch (KernelException kernelException) {
                JMSDebug.JMSBackEnd.debug("Error incrementing window for multicast request", (Throwable)kernelException);
            }
        }
    }
}

