/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.backend.BEUOOMember;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;
import weblogic.messaging.path.helper.KeyString;

public final class BEOrderUpdateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 6686162300621162069L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private KeyString key;
    private BEUOOMember oldMember;
    private BEUOOMember newMember;

    public BEOrderUpdateRequest(JMSID jMSID, KeyString keyString, BEUOOMember bEUOOMember, BEUOOMember bEUOOMember2) {
        super(jMSID, 17940);
        this.key = keyString;
        this.oldMember = bEUOOMember;
        this.newMember = bEUOOMember2;
    }

    KeyString getKey() {
        return this.key;
    }

    BEUOOMember getOldMember() {
        return this.oldMember;
    }

    BEUOOMember getNewMember() {
        return this.newMember;
    }

    public int remoteSignature() {
        return 34;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public BEOrderUpdateRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        this.key.writeExternal(objectOutput);
        this.oldMember.writeExternal(objectOutput);
        this.newMember.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.key = new KeyString();
        this.key.readExternal(objectInput);
        this.oldMember = new BEUOOMember();
        this.oldMember.readExternal(objectInput);
        this.newMember = new BEUOOMember();
        this.newMember.readExternal(objectInput);
    }
}

