/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.HashSet;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.TimedSecurityParticipant;
import weblogic.security.acl.internal.AuthenticatedSubject;

class BEProducerSecurityParticipantImpl
implements TimedSecurityParticipant {
    private final int hashcode;
    private JMSID producerId;
    private BEDestinationImpl destination;
    private int lifeCount;
    private AuthenticatedSubject authenticatedSubject;

    BEProducerSecurityParticipantImpl(JMSID jMSID, BEDestinationImpl bEDestinationImpl, int n, AuthenticatedSubject authenticatedSubject) {
        this.producerId = jMSID;
        this.destination = bEDestinationImpl;
        this.lifeCount = n;
        this.authenticatedSubject = authenticatedSubject;
        int n2 = 19;
        n2 = 31 * n2 + (jMSID != null ? jMSID.hashCode() : 0);
        this.hashcode = n2 = 31 * n2 + (bEDestinationImpl != null ? bEDestinationImpl.hashCode() : 0);
    }

    JMSID getProducerId() {
        return this.producerId;
    }

    public synchronized AuthenticatedSubject getSubject() {
        return this.authenticatedSubject;
    }

    synchronized void setSubject(AuthenticatedSubject authenticatedSubject) {
        if (authenticatedSubject != null) {
            this.authenticatedSubject = authenticatedSubject;
        }
    }

    public void securityLapsed() {
        this.destination.removeProducer(this.producerId);
    }

    public boolean isClosed() {
        --this.lifeCount;
        if (this.lifeCount <= 0) {
            this.destination.removeProducer(this.producerId);
            return true;
        }
        return false;
    }

    public HashSet getAcceptedDestinations() {
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof BEProducerSecurityParticipantImpl) {
            BEProducerSecurityParticipantImpl bEProducerSecurityParticipantImpl = (BEProducerSecurityParticipantImpl)object;
            return (bEProducerSecurityParticipantImpl.producerId != null ? bEProducerSecurityParticipantImpl.producerId.equals(this.producerId) : bEProducerSecurityParticipantImpl.producerId == this.producerId) && (bEProducerSecurityParticipantImpl.destination != null ? bEProducerSecurityParticipantImpl.destination.equals(this.destination) : bEProducerSecurityParticipantImpl.destination == this.destination);
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }
}

