/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.CompletionListener;
import weblogic.common.CompletionRequest;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.backend.BEUOOMember;
import weblogic.jms.backend.BEUOOState;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSProducerSendResponse;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.common.MessageImpl;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;
import weblogic.messaging.kernel.KernelRequest;
import weblogic.messaging.kernel.Sequence;
import weblogic.messaging.path.helper.KeyString;
import weblogic.work.InheritableThreadContext;

public final class BEProducerSendRequest
extends Request
implements Externalizable,
CompletionListener {
    static final long serialVersionUID = -3794283731017311093L;
    private static final int VERSION61 = 1;
    private static final int VERSION81 = 2;
    private static final int VERSION902 = 4;
    private static final int EXTVERSION = 4;
    private static final int VERSION_MASK = 255;
    private static final int MESSAGE_TYPE_MASK = 65280;
    private static final int CONNECTION_ID_MASK = 65536;
    private static final int TIMEOUT_MASK = 131072;
    private static final int PRODUCER_ID_MASK = 262144;
    public static final int CHECK_UNIT_OF_ORDER = 0x200000;
    private static final int MESSAGE_TYPE_SHIFT = 8;
    private long sendTimeout;
    static final int SEND_RUNNING_WITHOUT_BLOCKING = 500;
    static final int SEND_BLOCKED_WAITING_FOR_QUOTA = 501;
    static final int SEND_QUOTA_GRANTED = 502;
    static final int SEND_TIMED_OUT_WAITING_FOR_QUOTA = 503;
    static final int SEND_UNIT_OF_ORDER_PATH_SERVICE = 504;
    private MessageImpl message;
    private JMSID connectionId;
    private int checkUnitOfOrder;
    private JMSID producerId = null;
    private transient KeyString uooKey;
    private transient BEUOOMember uooMember;
    private transient CompletionRequest completionRequest;
    private transient KernelRequest kernelSendRequest;
    private transient BEUOOState.State uooState;
    private transient InheritableThreadContext context;
    private transient Sequence sequence;

    public BEProducerSendRequest(JMSID jMSID, MessageImpl messageImpl, JMSID jMSID2, long l, JMSID jMSID3) {
        super(jMSID, 12052);
        this.producerId = jMSID3;
        this.message = messageImpl;
        this.connectionId = jMSID2;
        this.sendTimeout = l;
    }

    MessageImpl getMessage() {
        return this.message;
    }

    JMSID getConnectionId() {
        return this.connectionId;
    }

    JMSID getProducerId() {
        return this.producerId;
    }

    public int remoteSignature() {
        return 35;
    }

    public Response createResponse() {
        return new JMSProducerSendResponse();
    }

    public void setCheckUOO(int n) {
        this.checkUnitOfOrder = n;
    }

    int getCheckUOO() {
        return this.checkUnitOfOrder;
    }

    public void setUOOInfo(KeyString keyString, BEUOOMember bEUOOMember, CompletionRequest completionRequest) {
        this.uooKey = keyString;
        this.uooMember = bEUOOMember;
        this.completionRequest = completionRequest;
    }

    public KeyString getUOOKey() {
        return this.uooKey;
    }

    public BEUOOMember getUOOMember() {
        return this.uooMember;
    }

    public CompletionRequest getCompletionRequest() {
        return this.completionRequest;
    }

    public void onCompletion(CompletionRequest completionRequest, Object object) {
        this.resumeExecution(false);
    }

    public void onException(CompletionRequest completionRequest, Throwable throwable) {
        this.resumeRequest(throwable, false);
    }

    Sequence getSequence() {
        return this.sequence;
    }

    void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public BEProducerSendRequest() {
    }

    private byte getVersion(Object object) throws IOException {
        if (object instanceof PeerInfoable) {
            PeerInfo peerInfo = ((PeerInfoable)object).getPeerInfo();
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_61) < 0) {
                throw JMSUtilities.versionIOException(0, 1, 2);
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_81) < 0) {
                return 1;
            }
            if (peerInfo.compareTo((Object)PeerInfo.VERSION_901) < 0) {
                return 2;
            }
        }
        return 4;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        int n2 = n = this.getVersion(objectOutput);
        byte by = this.message.getType();
        if (by != 0) {
            n2 |= by << 8;
        }
        if (this.connectionId != null) {
            n2 |= 0x10000;
        }
        if (this.producerId != null) {
            n2 |= 0x40000;
        }
        if (n >= 2 && this.sendTimeout != 10L) {
            n2 |= 0x20000;
        }
        objectOutput.writeInt(n2 |= this.checkUnitOfOrder);
        super.writeExternal(objectOutput);
        this.message.writeExternal(objectOutput);
        if (this.connectionId != null) {
            this.connectionId.writeExternal(objectOutput);
        }
        if ((n2 & 0x20000) != 0) {
            objectOutput.writeLong(this.sendTimeout);
        }
        if ((n2 & 0x40000) != 0) {
            this.producerId.writeExternal(objectOutput);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 4) {
            throw JMSUtilities.versionIOException(n2, 4, 4);
        }
        super.readExternal(objectInput);
        byte by = (byte)((n & 0xFF00) >> 8);
        this.message = MessageImpl.createMessageImpl(by);
        this.message.readExternal(objectInput);
        if ((n & 0x10000) != 0) {
            this.connectionId = new JMSID();
            this.connectionId.readExternal(objectInput);
        }
        this.sendTimeout = (n & 0x20000) != 0 ? objectInput.readLong() : 10L;
        this.checkUnitOfOrder = n & 0x200000;
        if ((n & 0x40000) != 0) {
            this.producerId = new JMSID();
            this.producerId.readExternal(objectInput);
        }
    }

    long getSendTimeout() {
        return this.sendTimeout;
    }

    void setKernelRequest(KernelRequest kernelRequest) {
        this.kernelSendRequest = kernelRequest;
    }

    KernelRequest getKernelRequest() {
        return this.kernelSendRequest;
    }

    BEUOOState.State getUooState() {
        return this.uooState;
    }

    void setUooState(BEUOOState.State state) {
        this.uooState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreResources(boolean bl) {
        BEUOOState.State state = this.uooState;
        if (state == null) {
            return;
        }
        BEProducerSendRequest bEProducerSendRequest = this;
        synchronized (bEProducerSendRequest) {
            if (!this.hasResults()) {
                return;
            }
        }
        state.removeReference(this, bl);
    }

    void rememberThreadContext() {
        if (this.context == null) {
            this.context = InheritableThreadContext.getContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.context != null) {
            this.context.push();
        }
        try {
            super.run();
            Object var2_1 = null;
            if (this.context != null) {
                this.context.pop();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.context != null) {
                this.context.pop();
            }
            throw throwable;
        }
    }

    JMSProducerSendResponse setupSendResponse() {
        JMSProducerSendResponse jMSProducerSendResponse = new JMSProducerSendResponse(this.message.getId());
        this.setResult(jMSProducerSendResponse);
        return jMSProducerSendResponse;
    }
}

