/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.jms.backend.BEBrowser;
import weblogic.jms.backend.BEBrowserImpl;
import weblogic.jms.backend.BEConnection;
import weblogic.jms.backend.BEConnectionConsumerImpl;
import weblogic.jms.backend.BEConsumerCreateRequest;
import weblogic.jms.backend.BEConsumerImpl;
import weblogic.jms.backend.BEDestinationImpl;
import weblogic.jms.backend.BEExtension;
import weblogic.jms.backend.BESession;
import weblogic.jms.backend.BESessionImpl;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDestinationSecurity;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSMessageEventLogListener;
import weblogic.jms.common.JMSMessageLogHelper;
import weblogic.jms.common.JMSPushExceptionRequest;
import weblogic.jms.common.JMSSQLExpression;
import weblogic.jms.common.JMSSQLFilter;
import weblogic.jms.common.JMSServerUtilities;
import weblogic.jms.extensions.ConsumerClosedException;
import weblogic.logging.jms.JMSMessageLogger;
import weblogic.messaging.kernel.Destination;
import weblogic.messaging.kernel.Event;
import weblogic.messaging.kernel.EventListener;
import weblogic.messaging.kernel.Expression;
import weblogic.messaging.kernel.Filter;
import weblogic.messaging.kernel.GroupAddEvent;
import weblogic.messaging.kernel.GroupRemoveEvent;
import weblogic.messaging.kernel.InvalidExpressionException;
import weblogic.messaging.kernel.KernelException;
import weblogic.messaging.kernel.MessageAddEvent;
import weblogic.messaging.kernel.MessageEvent;
import weblogic.messaging.kernel.MessageExpirationEvent;
import weblogic.messaging.kernel.MessageReceiveEvent;
import weblogic.messaging.kernel.MessageRedeliveryLimitEvent;
import weblogic.messaging.kernel.MessageRemoveEvent;
import weblogic.messaging.kernel.MessageSendEvent;
import weblogic.messaging.kernel.Queue;
import weblogic.messaging.kernel.Quota;
import weblogic.messaging.kernel.UnitOfWorkEvent;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;

public class BEQueueImpl
extends BEDestinationImpl
implements JMSMessageEventLogListener,
EventListener {
    private Queue queue;
    private Filter sqlFilter;
    private final Map browsers = new HashMap();
    private boolean isNewlyCreated;

    public BEQueueImpl(BackEnd backEnd, String string, boolean bl, JMSDestinationSecurity jMSDestinationSecurity) throws JMSException {
        super(backEnd, string, bl, jMSDestinationSecurity);
        Queue queue = backEnd.findKernelQueue(string);
        if (queue == null) {
            queue = backEnd.createKernelQueue(string, null);
            this.isNewlyCreated = true;
        }
        this.setKernel(queue);
    }

    protected void setKernel(Queue queue) throws JMSException {
        super.setKernel((Destination)queue);
        this.queue = queue;
    }

    public void open() throws JMSException {
        BEExtension bEExtension;
        super.open();
        this.sqlFilter = new JMSSQLFilter(this.queue.getKernel());
        this.queue.setFilter(this.sqlFilter);
        this.queue.setComparator((Comparator)this.comparator);
        try {
            this.queue.setProperty("RedirectionListener", (Object)this);
        }
        catch (KernelException kernelException) {
            throw new weblogic.jms.common.JMSException(kernelException);
        }
        this.queue.addListener((EventListener)this);
        if (this.isMessageLoggingEnabled() && !this.backEnd.isMemoryLow()) {
            this.resumeMessageLogging();
        }
        if ((bEExtension = this.getExtension()) != null) {
            bEExtension.restorePersistentState((Destination)this.queue);
            BEQueueImpl.addPropertyFlags((Destination)this.queue, "Logging", 16);
        }
    }

    public int getDestinationTypeIndicator() {
        return this.isTemporary() ? 4 : 1;
    }

    public synchronized void setDestinationKeysList(List list) {
        super.setDestinationKeysList(list);
        if (this.queue != null) {
            this.queue.setComparator((Comparator)this.comparator);
        }
    }

    private Expression createFilterExpression(String string) throws JMSException {
        if (string != null) {
            try {
                return this.sqlFilter.createExpression((Object)new JMSSQLExpression(string));
            }
            catch (InvalidExpressionException invalidExpressionException) {
                throw new InvalidSelectorException(invalidExpressionException.toString());
            }
            catch (KernelException kernelException) {
                throw new weblogic.jms.common.JMSException(kernelException);
            }
        }
        return null;
    }

    protected BEConsumerImpl createConsumer(BESessionImpl bESessionImpl, boolean bl, BEConsumerCreateRequest bEConsumerCreateRequest) throws JMSException {
        if (bEConsumerCreateRequest.getName() != null) {
            throw new weblogic.jms.common.JMSException("Durable consumers are not supported on queues");
        }
        this.checkShutdownOrSuspendedNeedLock("create consumer");
        BEConsumerImpl bEConsumerImpl = new BEConsumerImpl(bESessionImpl, this, this.queue, this.createFilterExpression(bEConsumerCreateRequest.getSelector()), 0, false, bEConsumerCreateRequest);
        this.addConsumer(bEConsumerImpl);
        if (bl) {
            bEConsumerImpl.start();
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Created a new consumer with ID " + bEConsumerCreateRequest.getConsumerId() + " on queue " + this.name);
        }
        return bEConsumerImpl;
    }

    protected BEConnectionConsumerImpl createConnectionConsumer(JMSID jMSID, ServerSessionPool serverSessionPool, String string, String string2, String string3, boolean bl, int n, long l, boolean bl2, boolean bl3) throws JMSException {
        if (bl2) {
            throw new weblogic.jms.common.JMSException("Durable consumers are not supported on queues");
        }
        this.checkShutdownOrSuspendedNeedLock("create connection consumer");
        BEConnectionConsumerImpl bEConnectionConsumerImpl = new BEConnectionConsumerImpl(jMSID, this, serverSessionPool, this.queue, this.createFilterExpression(string3), string3, n, l, 0);
        this.addConsumer(bEConnectionConsumerImpl);
        if (bl3) {
            bEConnectionConsumerImpl.start();
        }
        if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
            JMSDebug.JMSBackEnd.debug("Created a new ConnectionConsumer with ID " + jMSID + " on queue " + this.name);
        }
        return bEConnectionConsumerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BEBrowser createBrowser(BESession bESession, String string) throws JMSException {
        this.checkShutdownOrSuspendedNeedLock("create browser");
        BEBrowserImpl bEBrowserImpl = new BEBrowserImpl(bESession, this, this.queue, string);
        BEQueueImpl bEQueueImpl = this;
        synchronized (bEQueueImpl) {
            this.browsers.put(bEBrowserImpl.getJMSID(), bEBrowserImpl);
        }
        return bEBrowserImpl;
    }

    synchronized void removeBrowser(JMSID jMSID) {
        this.browsers.remove(jMSID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllBrowsers(String string) {
        ArrayList arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList(this.browsers.values());
            this.browsers.clear();
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            try {
                BEConnection bEConnection;
                BEBrowserImpl bEBrowserImpl = (BEBrowserImpl)object.next();
                BESession bESession = bEBrowserImpl.getSession();
                bEBrowserImpl.close();
                if (bESession == null || (bEConnection = bESession.getConnection()) == null) continue;
                JMSServerUtilities.anonDispatchNoReply(new JMSPushExceptionRequest(11, bEBrowserImpl.getJMSID(), new ConsumerClosedException(null, string)), bEConnection.getDispatcher());
            }
            catch (JMSException jMSException) {}
        }
    }

    public Queue getKernelQueue() {
        return this.queue;
    }

    public final void setMessageLoggingEnabled(boolean bl) {
        if (super.isMessageLoggingEnabled() && bl || !super.isMessageLoggingEnabled() && !bl) {
            return;
        }
        super.setMessageLoggingEnabled(bl);
        try {
            if (super.isMessageLoggingEnabled() && !this.backEnd.isMemoryLow()) {
                this.resumeMessageLogging();
            } else if (!bl) {
                this.suspendMessageLogging();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public JMSMessageLogger getJMSMessageLogger() {
        return this.backEnd.getJMSMessageLogger();
    }

    public void onEvent(Event event) {
        if (event instanceof MessageSendEvent) {
            this.onMessageEvent((MessageEvent)event);
        } else if (event instanceof MessageAddEvent) {
            this.onMessageEvent((MessageEvent)event);
        } else if (event instanceof MessageReceiveEvent) {
            this.onMessageEvent((MessageEvent)event);
        } else if (event instanceof MessageExpirationEvent) {
            this.onMessageEvent((MessageEvent)event);
        } else if (event instanceof MessageRedeliveryLimitEvent) {
            this.onMessageEvent((MessageEvent)event);
        } else if (event instanceof MessageRemoveEvent) {
            this.onMessageEvent((MessageEvent)event);
        } else if (event instanceof UnitOfWorkEvent) {
            if (this.getExtension() != null) {
                UnitOfWorkEvent unitOfWorkEvent = (UnitOfWorkEvent)event;
                if (unitOfWorkEvent.isAdd()) {
                    this.getExtension().unitOfWorkAddEvent(unitOfWorkEvent.getUnitOfWork());
                } else {
                    this.getExtension().unitOfWorkRemoveEvent(unitOfWorkEvent.getUnitOfWork());
                }
            }
        } else if (event instanceof GroupRemoveEvent) {
            if (this.getExtension() != null) {
                this.getExtension().groupRemoveEvent(((GroupRemoveEvent)event).getGroup().getName());
            }
        } else if (event instanceof GroupAddEvent && this.getExtension() != null) {
            this.getExtension().groupAddEvent(((GroupAddEvent)event).getGroup().getName());
        }
    }

    private final void onMessageEvent(MessageEvent messageEvent) {
        JMSMessageLogHelper.logMessageEvent(this, (Event)messageEvent);
    }

    public void resumeMessageLogging() throws JMSException {
        if (this.destination == null) {
            return;
        }
        BEQueueImpl.addPropertyFlags(this.destination, "Logging", 15);
    }

    public void suspendMessageLogging() throws JMSException {
        if (this.destination == null) {
            return;
        }
        BEQueueImpl.removePropertyFlags(this.destination, "Logging", 15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMessageLogging() {
        if (this.destination == null) {
            return false;
        }
        Destination destination = this.destination;
        synchronized (destination) {
            Integer n = (Integer)this.destination.getProperty("Logging");
            if (n == null) {
                return false;
            }
            int n2 = n;
            boolean bl = (n2 & 0xF) == 15;
            return bl;
        }
    }

    public void setQuota(Quota quota) throws BeanUpdateFailedException {
        HashMap<String, Quota> hashMap = new HashMap<String, Quota>();
        try {
            hashMap.put("Quota", quota);
            this.destination.setProperties(hashMap);
        }
        catch (KernelException kernelException) {
            throw new BeanUpdateFailedException("Messaging Kernel failed to act on the quota", (Throwable)kernelException);
        }
    }

    public boolean isNewlyCreated() {
        return this.isNewlyCreated;
    }

    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("Queue");
        super.dump(jMSDiagnosticImageSource, xMLStreamWriter);
        xMLStreamWriter.writeEndElement();
    }
}

