/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.util.HashMap;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.QuotaBean;
import weblogic.management.utils.GenericBeanListener;
import weblogic.messaging.kernel.Quota;
import weblogic.messaging.kernel.QuotaPolicy;

public final class BEQuota {
    private static final HashMap quotaSignature = new HashMap();
    private String name;
    private Quota quota;
    private int references = 0;
    private GenericBeanListener listener;

    BEQuota(String string, Quota quota) {
        this.name = string;
        this.quota = quota;
    }

    String getName() {
        return this.name;
    }

    void setQuotaBean(QuotaBean quotaBean) {
        if (this.listener == null) {
            DescriptorBean descriptorBean = (DescriptorBean)quotaBean;
            this.listener = new GenericBeanListener(descriptorBean, this, quotaSignature);
        }
        ++this.references;
    }

    boolean close() {
        --this.references;
        if (this.references <= 0 && this.listener != null) {
            this.listener.close();
            this.listener = null;
            this.references = 0;
            return true;
        }
        return false;
    }

    Quota getQuota() {
        return this.quota;
    }

    public synchronized void setBytesMaximum(long l) {
        this.quota.setBytesMaximum(l);
    }

    public synchronized void setMessagesMaximum(long l) {
        int n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        this.quota.setMessagesMaximum(n);
    }

    public synchronized void setPolicy(String string) {
        this.quota.setPolicy(this.findPolicy(string));
    }

    private QuotaPolicy findPolicy(String string) {
        if (string == null) {
            return QuotaPolicy.FIFO;
        }
        if (string.equalsIgnoreCase("FIFO")) {
            return QuotaPolicy.FIFO;
        }
        if (string.equalsIgnoreCase("Preemptive")) {
            return QuotaPolicy.PREEMPTIVE;
        }
        throw new AssertionError((Object)("Invalid quota policy " + string));
    }

    static {
        quotaSignature.put("BytesMaximum", Long.TYPE);
        quotaSignature.put("MessagesMaximum", Long.TYPE);
        quotaSignature.put("Policy", String.class);
    }
}

