/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class BERemoveSubscriptionRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -2710563626585921758L;
    private String clientId;
    private String name;
    private int clientIdPolicy;
    private JMSServerId backEndId;
    private String destinationName;
    private static final int EXTVERSION_PRE_1033 = 1;
    private static final int EXTVERSION_1033 = 2;
    private static final int EXTVERSION = 2;
    private static final int VERSION_MASK = 255;
    private static final int HAS_DESTINATION_NAME = 256;

    public BERemoveSubscriptionRequest(JMSServerId jMSServerId, String string, String string2, int n, String string3) {
        super(null, 14850);
        this.backEndId = jMSServerId;
        this.destinationName = string;
        this.clientId = string2;
        this.clientIdPolicy = n;
        this.name = string3;
    }

    public JMSServerId getBackEndId() {
        return this.backEndId;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public int getClientIdPolicy() {
        return this.clientIdPolicy;
    }

    public String getName() {
        return this.name;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public BERemoveSubscriptionRequest() {
    }

    private byte getVersion(Object object) throws IOException {
        PeerInfo peerInfo;
        if (object instanceof PeerInfoable && (peerInfo = ((PeerInfoable)object).getPeerInfo()).compareTo((Object)PeerInfo.VERSION_1033) < 0) {
            return 1;
        }
        return 2;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        int n2 = n = this.getVersion(objectOutput);
        if (n >= 2 && this.destinationName != null) {
            n2 |= 0x100;
        }
        objectOutput.writeInt(n2);
        super.writeExternal(objectOutput);
        this.backEndId.writeExternal(objectOutput);
        objectOutput.writeUTF(this.clientId);
        objectOutput.writeUTF(this.name);
        if (n >= 2) {
            objectOutput.writeInt(this.clientIdPolicy);
            if (this.destinationName != null) {
                objectOutput.writeUTF(this.destinationName);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1 && n2 != 2) {
            throw JMSUtilities.versionIOException(n2, 1, 2);
        }
        super.readExternal(objectInput);
        this.backEndId = new JMSServerId();
        this.backEndId.readExternal(objectInput);
        this.clientId = objectInput.readUTF();
        this.name = objectInput.readUTF();
        if (n2 >= 2) {
            this.clientIdPolicy = objectInput.readInt();
            if ((n & 0x100) != 0) {
                this.destinationName = objectInput.readUTF();
            }
        }
    }
}

