/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.Session;
import weblogic.jms.backend.BEServerSessionPool;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSUtilities;
import weblogic.rmi.extensions.PortableRemoteObject;
import weblogic.work.WorkAdapter;

public final class BEServerSession
extends WorkAdapter
implements ServerSession,
Externalizable {
    static final long serialVersionUID = 7855664711553219989L;
    private static final byte EXTVERSION = 1;
    private Connection connection;
    private Session session;
    private BEServerSessionPool serverSessionPool;
    private BEServerSession next;

    BEServerSession(Connection connection, Session session, BEServerSessionPool bEServerSessionPool) {
        this.connection = connection;
        this.session = session;
        this.serverSessionPool = bEServerSessionPool;
    }

    public BEServerSession() {
    }

    public BEServerSession getNext() {
        return this.next;
    }

    public void setNext(BEServerSession bEServerSession) {
        this.next = bEServerSession;
    }

    void close() throws JMSException {
        this.session.close();
    }

    void goBackInPool() {
        this.serverSessionPool.serverSessionPut(this);
    }

    public Session getSession() throws JMSException {
        return this.session;
    }

    public void start() {
        this.serverSessionPool.getBackEnd().getWorkManager().schedule((Runnable)((Object)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        try {
            block6: {
                try {
                    if (this.session != null) {
                        this.session.run();
                        break block6;
                    }
                    if (!JMSDebug.JMSBackEnd.isDebugEnabled()) break block6;
                    JMSDebug.JMSBackEnd.debug("Error running session for connection consumer");
                }
                catch (Exception exception) {
                    if (JMSDebug.JMSBackEnd.isDebugEnabled()) {
                        JMSDebug.JMSBackEnd.debug("Error running session for connection consumer" + exception.toString());
                    }
                    Object var3_2 = null;
                    this.goBackInPool();
                }
            }
            Object var3_1 = null;
            this.goBackInPool();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.goBackInPool();
            throw throwable;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        objectOutput.writeObject(this.serverSessionPool);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        this.serverSessionPool = (BEServerSessionPool)PortableRemoteObject.narrow((Object)objectInput.readObject(), BEServerSessionPool.class);
    }
}

