/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.jms.backend.BEServerSessionGetResponse;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public final class BEServerSessionGetRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -5838190690108762415L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private JMSID serverSessionPoolId;

    public BEServerSessionGetRequest(JMSID jMSID, JMSID jMSID2) {
        super(jMSID, 12302);
        this.serverSessionPoolId = jMSID2;
    }

    public final JMSID getServerSessionPoolId() {
        return this.serverSessionPoolId;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return new BEServerSessionGetResponse();
    }

    public BEServerSessionGetRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        this.serverSessionPoolId.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.serverSessionPoolId = new JMSID();
        this.serverSessionPoolId.readExternal(objectInput);
    }
}

