/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.Context;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.jms.JMSLogger;
import weblogic.jms.JMSService;
import weblogic.jms.backend.BEConnectionConsumerCommon;
import weblogic.jms.backend.BEConnectionConsumerImpl;
import weblogic.jms.backend.BEServerSession;
import weblogic.jms.backend.BEServerSessionPoolRemote;
import weblogic.jms.backend.BackEnd;
import weblogic.jms.client.ConnectionInternal;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.jms.client.JMSServerSessionPool;
import weblogic.jms.common.ConfigurationException;
import weblogic.jms.common.JMSDebug;
import weblogic.jms.common.JMSDiagnosticImageSource;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.extensions.ServerSessionPoolListener;
import weblogic.management.ManagementException;
import weblogic.management.configuration.JMSConnectionConsumerMBean;
import weblogic.management.configuration.JMSSessionPoolMBean;
import weblogic.management.runtime.JMSConsumerRuntimeMBean;
import weblogic.management.runtime.JMSServerRuntimeMBean;
import weblogic.management.runtime.JMSSessionPoolRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.utils.GenericBeanListener;
import weblogic.messaging.common.PrivilegedActionUtilities;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.runtime.DiagnosticImageTimeoutException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class BEServerSessionPool
extends RuntimeMBeanDelegate
implements BEServerSessionPoolRemote,
JMSSessionPoolRuntimeMBean {
    static final long serialVersionUID = -6384515684489802143L;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private JMSServerSessionPool remoteWrapper;
    private JMSID serverSessionPoolId;
    private BackEnd backEnd;
    private long serverSessionsMaximum;
    private int acknowledgeMode;
    private boolean transacted;
    private boolean createdFromMBean;
    private String listenerName;
    private Class listenerClass;
    private Constructor listenerConstructor;
    private Object[] listenerParameters;
    private Serializable clientData;
    private int waiters;
    private Connection connection;
    private ConnectionFactory connectionFactory;
    private BEServerSession firstServerSession;
    private long serverSessionsCurrent;
    private final HashMap connectionConsumers;
    private long connectionConsumersCurrentCount;
    private long connectionConsumersHighCount;
    private long connectionConsumersTotalCount;
    private JMSSessionPoolMBean mbean;
    private int state;
    private boolean validConnectionFactory;
    private boolean validListener;
    private Throwable savedCreationThrowable;
    private static final HashMap sessionPoolSignatures = new HashMap();
    private static final HashMap sessionPoolAdditions = new HashMap();
    private GenericBeanListener sessionPoolListener;

    public BEServerSessionPool(String string, JMSID jMSID, BackEnd backEnd, ConnectionFactory connectionFactory, int n, int n2, boolean bl, String string2, Serializable serializable) throws JMSException, ManagementException {
        super(string, (RuntimeMBean)backEnd);
        this.connectionConsumers = new HashMap();
        this.state = 0;
        this.serverSessionPoolId = jMSID;
        this.backEnd = backEnd;
        this.connectionFactory = connectionFactory;
        this.serverSessionsMaximum = n;
        this.acknowledgeMode = n2;
        this.transacted = bl;
        this.listenerName = string2;
        this.clientData = serializable;
        this.initialize();
    }

    public BEServerSessionPool(String string, JMSID jMSID, BackEnd backEnd, JMSSessionPoolMBean jMSSessionPoolMBean) throws JMSException, ManagementException {
        block7: {
            super(string, (RuntimeMBean)backEnd);
            this.connectionConsumers = new HashMap();
            this.state = 0;
            try {
                this.createdFromMBean = true;
                this.serverSessionPoolId = jMSID;
                this.backEnd = backEnd;
                this.mbean = jMSSessionPoolMBean;
                String string2 = jMSSessionPoolMBean.getConnectionFactory();
                if (string2 == null) {
                    string2 = "weblogic.jms.ConnectionFactory";
                }
                this.setConnectionFactory(string2);
                this.setAcknowledgeMode(jMSSessionPoolMBean.getAcknowledgeMode());
                this.serverSessionsMaximum = jMSSessionPoolMBean.getSessionsMaximum();
                if (this.serverSessionsMaximum == -1L) {
                    this.serverSessionsMaximum = 10L;
                }
                this.transacted = jMSSessionPoolMBean.isTransacted();
                this.listenerName = jMSSessionPoolMBean.getListenerClass();
                this.initialize();
                JMSConnectionConsumerMBean[] jMSConnectionConsumerMBeanArray = jMSSessionPoolMBean.getJMSConnectionConsumers();
                for (int i = 0; i < jMSConnectionConsumerMBeanArray.length; ++i) {
                    try {
                        ConnectionConsumer connectionConsumer = this.connectionConsumerCreate(jMSConnectionConsumerMBeanArray[i]);
                        this.connectionConsumerAdd(jMSConnectionConsumerMBeanArray[i].getName(), connectionConsumer);
                        continue;
                    }
                    catch (ConfigurationException configurationException) {
                        JMSLogger.logErrorCreateCC((String)backEnd.getName(), (String)jMSConnectionConsumerMBeanArray[i].getName(), (Exception)((Object)configurationException));
                        throw configurationException;
                    }
                }
                this.state = 1;
            }
            catch (Throwable throwable) {
                this.cleanup();
                this.savedCreationThrowable = throwable;
                JMSLogger.logAddedSessionPoolToBeRemoved((String)backEnd.getName(), (String)string, (Throwable)throwable);
                if (!JMSDebug.JMSConfig.isDebugEnabled()) break block7;
                JMSDebug.JMSConfig.debug("Failed to start the new server session pool");
            }
        }
    }

    private void initialize() throws JMSException, ConfigurationException {
        this.setListener(this.listenerName);
        if (this.connectionFactory instanceof QueueConnectionFactory) {
            this.connection = ((QueueConnectionFactory)this.connectionFactory).createQueueConnection();
        } else if (this.connectionFactory instanceof TopicConnectionFactory) {
            this.connection = ((TopicConnectionFactory)this.connectionFactory).createTopicConnection();
        }
        this.remoteWrapper = new JMSServerSessionPool(this.backEnd.getJMSServerId(), this.serverSessionPoolId);
    }

    private void setListener(String string) throws JMSException, ConfigurationException {
        try {
            if (string == null || string.length() == 0) {
                throw new ConfigurationException("Listener class for ServerSessionPool " + this.name + " is null");
            }
            this.listenerClass = Class.forName(string);
            Constructor<?>[] constructorArray = this.listenerClass.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                Class<?>[] classArray = constructorArray[i].getParameterTypes();
                if (classArray.length == 0) {
                    this.listenerConstructor = constructorArray[i];
                    this.listenerParameters = new Object[0];
                    continue;
                }
                if (classArray.length != 1 || !classArray[0].isAssignableFrom(Session.class)) continue;
                this.listenerConstructor = constructorArray[i];
                this.listenerParameters = new Object[1];
                break;
            }
            if (this.listenerConstructor == null) {
                throw new weblogic.jms.common.JMSException("No constructor for MessageListener", (Throwable)new NoSuchMethodException("expected one of\n\t" + string + ".<init>(), or\n\t" + string + ".<init>(javax.jms.Session)"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationException("Listener class, " + string + ", not found");
        }
        this.validListener = true;
    }

    private void setConnectionFactory(String string) throws ConfigurationException {
        try {
            Context context = JMSService.getContext();
            this.connectionFactory = (ConnectionFactory)context.lookup(string);
        }
        catch (Throwable throwable) {
            throw new ConfigurationException("ConnectionFactory " + string + " for ServerSessionPool " + this.name + " not found", throwable);
        }
        if (this.connectionFactory instanceof JMSConnectionFactory) {
            // empty if block
        }
        this.validConnectionFactory = true;
    }

    private void setAcknowledgeMode(String string) throws ConfigurationException {
        if (string == null) {
            this.acknowledgeMode = 1;
        } else if (string.equalsIgnoreCase("Auto")) {
            this.acknowledgeMode = 1;
        } else if (string.equalsIgnoreCase("Client")) {
            this.acknowledgeMode = 2;
        } else if (string.equalsIgnoreCase("Dups-Ok")) {
            this.acknowledgeMode = 3;
        } else if (string.equalsIgnoreCase("None")) {
            this.acknowledgeMode = 4;
        } else {
            throw new ConfigurationException("Invalid acknowledgeMode for ServerSessionPool " + this.name + ", " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws JMSException {
        this.checkShutdown();
        BEServerSessionPool bEServerSessionPool = this;
        synchronized (bEServerSessionPool) {
            if ((this.state & 4) != 0) {
                return;
            }
            if ((this.state & 1) != 0) {
                this.sessionPoolListener = new GenericBeanListener((DescriptorBean)this.mbean, (Object)this, (Map)sessionPoolSignatures, sessionPoolAdditions);
            }
            for (BEConnectionConsumerCommon bEConnectionConsumerCommon : this.connectionConsumers.values()) {
                bEConnectionConsumerCommon.start();
            }
            this.state = 4;
        }
    }

    void cleanup() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Iterator iterator = null;
        Object object = null;
        Object object2 = this;
        synchronized (object2) {
            if ((this.state & 0x10) != 0) {
                return;
            }
            if ((this.state & 8) == 0) {
                this.markShuttingDown();
            }
            iterator = ((HashMap)this.connectionConsumers.clone()).values().iterator();
            object = this.firstServerSession;
            this.firstServerSession = null;
        }
        if (this.sessionPoolListener != null) {
            this.sessionPoolListener.close();
        }
        try {
            PrivilegedActionUtilities.unregister(this, kernelId);
            if (this.savedCreationThrowable != null) {
                this.state = 16;
                return;
            }
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
        while (iterator.hasNext()) {
            object2 = (BEConnectionConsumerCommon)iterator.next();
            try {
                object2.close();
            }
            catch (JMSException jMSException) {}
        }
        while (object != null) {
            object2 = ((BEServerSession)object).getNext();
            try {
                ((BEServerSession)object).close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            object = object2;
        }
        try {
            this.connection.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        object2 = this;
        synchronized (object2) {
            this.state = 16;
            this.connectionConsumers.clear();
            this.connectionConsumersCurrentCount = 0L;
            this.connectionConsumersHighCount = 0L;
            this.connectionConsumersTotalCount = 0L;
        }
    }

    private boolean isShutdown() {
        return (this.state & 0x18) != 0;
    }

    private synchronized void checkShutdown() throws JMSException {
        if (this.isShutdown()) {
            throw new weblogic.jms.common.JMSException("JMS server session pool is shutdown");
        }
    }

    synchronized void markShuttingDown() {
        if ((this.state & 0x10) != 0) {
            return;
        }
        this.state = 8;
    }

    public JMSID getId() {
        return this.serverSessionPoolId;
    }

    public JMSServerId getBackEndId() {
        return this.backEnd.getJMSServerId();
    }

    public BackEnd getBackEnd() {
        return this.backEnd;
    }

    public Object getRemoteWrapper() {
        return this.remoteWrapper;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public long getServerSessionsMaximum() {
        return this.serverSessionsMaximum;
    }

    public String getListenerName() {
        return this.listenerName;
    }

    boolean isCreatedFromMBean() {
        return this.createdFromMBean;
    }

    private ConnectionConsumer connectionConsumerCreate(JMSConnectionConsumerMBean jMSConnectionConsumerMBean) throws JMSException, ConfigurationException {
        Destination destination;
        String string = jMSConnectionConsumerMBean.getName();
        String string2 = jMSConnectionConsumerMBean.getDestination();
        if (string2 == null) {
            throw new ConfigurationException("Null destination for ConnectionConsumer " + string);
        }
        try {
            destination = (Destination)JMSService.getContext().lookup(string2);
        }
        catch (Exception exception) {
            throw new ConfigurationException("Error finding destination " + string2 + " for ConnectionConsumer " + string, (Throwable)exception);
        }
        if (destination == null) {
            throw new ConfigurationException("Destination " + string2 + " for ConnectionConsumer " + string + " not found");
        }
        String string3 = jMSConnectionConsumerMBean.getSelector();
        int n = jMSConnectionConsumerMBean.getMessagesMaximum();
        if (n <= 0) {
            n = 10;
        }
        if (destination instanceof Queue) {
            ConnectionConsumer connectionConsumer = ((ConnectionInternal)this.connection).createConnectionConsumer((Queue)destination, string3, (ServerSessionPool)this.getRemoteWrapper(), n);
            if (connectionConsumer instanceof BEConnectionConsumerCommon) {
                ((BEConnectionConsumerCommon)connectionConsumer).initialize(jMSConnectionConsumerMBean);
            }
            return connectionConsumer;
        }
        if (destination instanceof Topic) {
            ConnectionConsumer connectionConsumer = ((ConnectionInternal)this.connection).createConnectionConsumer((Topic)destination, string3, (ServerSessionPool)this.getRemoteWrapper(), n);
            if (connectionConsumer instanceof BEConnectionConsumerCommon) {
                ((BEConnectionConsumerCommon)connectionConsumer).initialize(jMSConnectionConsumerMBean);
            }
            return connectionConsumer;
        }
        throw new ConfigurationException("Invalid destination type for ConnectionConsumer " + string);
    }

    private synchronized void connectionConsumerAdd(String string, ConnectionConsumer connectionConsumer) throws JMSException {
        this.checkShutdown();
        if (this.connectionConsumers.put(string, connectionConsumer) == null) {
            if (++this.connectionConsumersCurrentCount > this.connectionConsumersHighCount) {
                this.connectionConsumersHighCount = this.connectionConsumersCurrentCount;
            }
            ++this.connectionConsumersTotalCount;
        }
    }

    private synchronized ConnectionConsumer connectionConsumerRemove(String string) throws JMSException {
        ConnectionConsumer connectionConsumer = (ConnectionConsumer)this.connectionConsumers.remove(string);
        if (connectionConsumer == null) {
            throw new weblogic.jms.common.JMSException("ConnectionConsumer not found");
        }
        --this.connectionConsumersCurrentCount;
        return connectionConsumer;
    }

    private synchronized BEServerSession serverSessionCreate() throws JMSException {
        Object object = this.connection instanceof QueueConnection ? ((QueueConnection)this.connection).createQueueSession(this.transacted, this.acknowledgeMode) : ((TopicConnection)this.connection).createTopicSession(this.transacted, this.acknowledgeMode);
        if (this.listenerParameters.length > 0) {
            this.listenerParameters[0] = object;
        }
        try {
            MessageListener messageListener = (MessageListener)this.listenerConstructor.newInstance(this.listenerParameters);
            if (messageListener instanceof ServerSessionPoolListener) {
                ((ServerSessionPoolListener)messageListener).initialize(this.clientData);
            }
            object.setMessageListener(messageListener);
        }
        catch (Exception exception) {
            throw new weblogic.jms.common.JMSException("Error instantiating message listener", (Throwable)exception);
        }
        return new BEServerSession(this.connection, (Session)object, this);
    }

    synchronized void serverSessionPut(BEServerSession bEServerSession) {
        if (this.isShutdown()) {
            try {
                bEServerSession.close();
            }
            catch (JMSException jMSException) {}
        } else {
            bEServerSession.setNext(this.firstServerSession);
            this.firstServerSession = bEServerSession;
        }
        if (this.waiters > 0) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ServerSession getServerSession(DispatcherId dispatcherId) throws JMSException {
        BEServerSession bEServerSession;
        if (!JMSDispatcherManager.getLocalDispatcher().getId().equals(dispatcherId)) {
            throw new weblogic.jms.common.JMSException("Cannot invoke getServerSession() remotely");
        }
        while ((bEServerSession = this.firstServerSession) == null) {
            this.checkShutdown();
            if (this.serverSessionsCurrent >= this.serverSessionsMaximum) {
                Object var5_4;
                try {
                    try {
                        ++this.waiters;
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        var5_4 = null;
                        --this.waiters;
                        continue;
                    }
                    var5_4 = null;
                    --this.waiters;
                    continue;
                }
                catch (Throwable throwable) {
                    var5_4 = null;
                    --this.waiters;
                    throw throwable;
                }
            }
            this.firstServerSession = this.serverSessionCreate();
            ++this.serverSessionsCurrent;
        }
        this.firstServerSession = bEServerSession.getNext();
        return bEServerSession;
    }

    public JMSServerRuntimeMBean getJMSServer() {
        return this.backEnd;
    }

    public synchronized JMSConsumerRuntimeMBean[] getConnectionConsumers() {
        return null;
    }

    public synchronized long getConnectionConsumersCurrentCount() {
        return this.connectionConsumersCurrentCount;
    }

    public synchronized long getConnectionConsumersHighCount() {
        return this.connectionConsumersHighCount;
    }

    public synchronized long getConnectionConsumersTotalCount() {
        return this.connectionConsumersTotalCount;
    }

    public void setSessionsMaximum(int n) {
        this.serverSessionsMaximum = n;
    }

    public void startAddConnectionConsumers(JMSConnectionConsumerMBean jMSConnectionConsumerMBean) throws BeanUpdateRejectedException {
        try {
            ConnectionConsumer connectionConsumer = this.connectionConsumerCreate(jMSConnectionConsumerMBean);
            this.connectionConsumerAdd(jMSConnectionConsumerMBean.getName(), connectionConsumer);
        }
        catch (JMSException jMSException) {
            throw new BeanUpdateRejectedException(jMSException.getMessage(), (Throwable)jMSException);
        }
    }

    public void finishAddConnectionConsumers(JMSConnectionConsumerMBean jMSConnectionConsumerMBean, boolean bl) {
        if (bl) {
            return;
        }
        try {
            ConnectionConsumer connectionConsumer = this.connectionConsumerRemove(jMSConnectionConsumerMBean.getName());
            connectionConsumer.close();
        }
        catch (JMSException jMSException) {
            JMSLogger.logErrorRollingBackConnectionConsumer((String)jMSConnectionConsumerMBean.getName(), (String)jMSException.toString());
        }
    }

    public void startRemoveConnectionConsumers(JMSConnectionConsumerMBean jMSConnectionConsumerMBean) throws BeanUpdateRejectedException {
    }

    public void finishRemoveConnectionConsumers(JMSConnectionConsumerMBean jMSConnectionConsumerMBean, boolean bl) {
        if (!bl) {
            return;
        }
        try {
            ConnectionConsumer connectionConsumer = this.connectionConsumerRemove(jMSConnectionConsumerMBean.getName());
            connectionConsumer.close();
        }
        catch (JMSException jMSException) {
            JMSLogger.logErrorRemovingConnectionConsumer((String)jMSConnectionConsumerMBean.getName(), (String)jMSException.toString());
        }
    }

    public void close() throws JMSException {
    }

    public void dump(JMSDiagnosticImageSource jMSDiagnosticImageSource, XMLStreamWriter xMLStreamWriter) throws XMLStreamException, DiagnosticImageTimeoutException {
        jMSDiagnosticImageSource.checkTimeout();
        xMLStreamWriter.writeStartElement("ServerSessionPool");
        xMLStreamWriter.writeAttribute("id", this.serverSessionPoolId != null ? this.serverSessionPoolId.toString() : "");
        xMLStreamWriter.writeAttribute("serverSessionsMaximum", String.valueOf(this.serverSessionsMaximum));
        xMLStreamWriter.writeAttribute("acknowledgeMode", String.valueOf(this.acknowledgeMode));
        xMLStreamWriter.writeAttribute("transacted", String.valueOf(this.transacted));
        xMLStreamWriter.writeAttribute("listenerName", this.listenerName != null ? this.listenerName : "");
        xMLStreamWriter.writeAttribute("listenerClassName", this.listenerClass != null ? this.listenerClass.getName() : "");
        xMLStreamWriter.writeAttribute("state", JMSService.getStateName(this.state));
        xMLStreamWriter.writeAttribute("serverSessionsCurrentCount", String.valueOf(this.serverSessionsCurrent));
        xMLStreamWriter.writeAttribute("connectionConsumersCurrentCount", String.valueOf(this.connectionConsumersCurrentCount));
        xMLStreamWriter.writeAttribute("connectionConsumersHighCount", String.valueOf(this.connectionConsumersHighCount));
        xMLStreamWriter.writeAttribute("connectionConsumersTotalCount", String.valueOf(this.connectionConsumersTotalCount));
        xMLStreamWriter.writeStartElement("ConnectionConsumers");
        HashMap hashMap = (HashMap)this.connectionConsumers.clone();
        for (BEConnectionConsumerImpl bEConnectionConsumerImpl : hashMap.values()) {
            bEConnectionConsumerImpl.dumpRef(jMSDiagnosticImageSource, xMLStreamWriter);
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    static {
        sessionPoolSignatures.put("SessionsMaximum", Integer.TYPE);
        sessionPoolAdditions.put("ConnectionConsumers", JMSConnectionConsumerMBean.class);
    }
}

