/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import weblogic.jms.client.JMSConnectionFactory;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerSessionPoolCreateResponse;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.messaging.dispatcher.Response;

public final class BEServerSessionPoolCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 4148932257093406234L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int TRANSACTED_MASK = 256;
    private JMSConnectionFactory connectionFactory;
    private int sessionsMaximum;
    private int acknowledgeMode;
    private boolean transacted;
    private String messageListenerClass;
    private Serializable clientData;

    public BEServerSessionPoolCreateRequest(JMSID jMSID, JMSConnectionFactory jMSConnectionFactory, int n, int n2, boolean bl, String string, Serializable serializable) {
        super(jMSID, 12814);
        this.connectionFactory = jMSConnectionFactory;
        this.sessionsMaximum = n;
        this.acknowledgeMode = n2;
        this.transacted = bl;
        this.messageListenerClass = string;
        this.clientData = serializable;
    }

    public final JMSConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public final int getSessionsMaximum() {
        return this.sessionsMaximum;
    }

    public final int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public final boolean isTransacted() {
        return this.transacted;
    }

    public final String getMessageListenerClass() {
        return this.messageListenerClass;
    }

    public final Serializable getClientData() {
        return this.clientData;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return new JMSServerSessionPoolCreateResponse();
    }

    public BEServerSessionPoolCreateRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1;
        if (this.transacted) {
            n |= 0x100;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        this.connectionFactory.writeExternal(objectOutput);
        objectOutput.writeInt(this.sessionsMaximum);
        objectOutput.writeInt(this.acknowledgeMode);
        objectOutput.writeUTF(this.messageListenerClass);
        objectOutput.writeObject(this.clientData);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.connectionFactory = new JMSConnectionFactory();
        this.connectionFactory.readExternal(objectInput);
        this.sessionsMaximum = objectInput.readInt();
        this.messageListenerClass = objectInput.readUTF();
        this.clientData = (Serializable)objectInput.readObject();
        this.transacted = (n & 0x100) != 0;
    }
}

