/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.ServerSessionPool;
import javax.jms.TopicConnection;
import weblogic.jms.client.ConnectionInternal;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSServerId;
import weblogic.jms.common.JMSServerSessionPoolCreateResponse;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.JMSDispatcher;
import weblogic.jms.dispatcher.JMSDispatcherManager;
import weblogic.jms.extensions.ServerSessionPoolFactory;
import weblogic.jms.frontend.FEServerSessionPoolCreateRequest;
import weblogic.messaging.dispatcher.DispatcherException;
import weblogic.messaging.dispatcher.Response;

public final class BEServerSessionPoolFactory
implements ServerSessionPoolFactory,
Externalizable {
    private static final byte EXTVERSION = 1;
    static final long serialVersionUID = -5270077330309148361L;
    private JMSServerId backEndId;

    public BEServerSessionPoolFactory(JMSServerId jMSServerId) {
        this.backEndId = jMSServerId;
    }

    public ServerSessionPool getServerSessionPool(QueueConnection queueConnection, int n, boolean bl, int n2, String string) throws JMSException {
        return this.createServerSessionPool((Connection)queueConnection, n, n2, bl, string, null);
    }

    public ServerSessionPool getServerSessionPool(TopicConnection topicConnection, int n, boolean bl, int n2, String string) throws JMSException {
        return this.createServerSessionPool((Connection)topicConnection, n, n2, bl, string, null);
    }

    public ServerSessionPool createServerSessionPool(Connection connection, int n, int n2, boolean bl, String string, Serializable serializable) throws JMSException {
        Response response;
        if (!(connection instanceof ConnectionInternal)) {
            throw new weblogic.jms.common.JMSException("Connection is foreign");
        }
        JMSID jMSID = ((ConnectionInternal)connection).getJMSID();
        if (jMSID.getTimestamp() != this.backEndId.getTimestamp() || jMSID.getSeed() != this.backEndId.getSeed()) {
            throw new weblogic.jms.common.JMSException("Connection is remote");
        }
        try {
            JMSDispatcher jMSDispatcher = ((ConnectionInternal)connection).getFrontEndDispatcher();
            if (!jMSDispatcher.isLocal()) {
                jMSDispatcher = JMSDispatcherManager.dispatcherFindOrCreate(jMSDispatcher.getId());
            }
            response = jMSDispatcher.dispatchSync(new FEServerSessionPoolCreateRequest(jMSID, this.backEndId, n, n2, bl, string, serializable));
        }
        catch (DispatcherException dispatcherException) {
            throw new weblogic.jms.common.JMSException("Error creating server session pool", (Throwable)dispatcherException);
        }
        return ((JMSServerSessionPoolCreateResponse)response).getServerSessionPool();
    }

    public BEServerSessionPoolFactory() {
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        byte by = objectInput.readByte();
        if (by != 1) {
            throw JMSUtilities.versionIOException(by, 1, 1);
        }
        this.backEndId = new JMSServerId();
        this.backEndId.readExternal(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(1);
        this.backEndId.writeExternal(objectOutput);
    }
}

