/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ListIterator;
import javax.transaction.Transaction;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;
import weblogic.messaging.kernel.KernelRequest;

public final class BESessionAcknowledgeRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = -496965679629368939L;
    private static final int EXTVERSION = 1;
    private static final int VERSION_MASK = 255;
    private static final int ACKNOWLEDGE_POLICY_MASK = 65280;
    private static final int ACKNOWLEDGE_POLICY_SHIFT = 8;
    public static final int ACK_IN_PROGRESS = 11000;
    public static final int ACK_COMPLETED = 11001;
    private int acknowledgePolicy;
    private long lastSequenceNumber;
    private transient KernelRequest kernelRequest;
    private transient Transaction transaction;
    private transient ListIterator iterator;

    public BESessionAcknowledgeRequest(JMSID jMSID, long l) {
        super(jMSID, 13072);
        this.lastSequenceNumber = l;
    }

    long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    public int remoteSignature() {
        return 35;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    void setIterator(ListIterator listIterator) {
        this.iterator = listIterator;
    }

    ListIterator getIterator() {
        return this.iterator;
    }

    void setKernelRequest(KernelRequest kernelRequest) {
        this.kernelRequest = kernelRequest;
    }

    KernelRequest getKernelRequest() {
        return this.kernelRequest;
    }

    Transaction getTransaction() {
        return this.transaction;
    }

    void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    boolean isTransactional() {
        return this.transaction != null;
    }

    public BESessionAcknowledgeRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = 1 | this.acknowledgePolicy << 8;
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.lastSequenceNumber);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1) {
            throw JMSUtilities.versionIOException(n2, 1, 1);
        }
        super.readExternal(objectInput);
        this.lastSequenceNumber = objectInput.readLong();
        this.acknowledgePolicy = (n & 0xFF00) >>> 8;
    }
}

