/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.Response;

public final class BESessionCloseRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 2830831915495832371L;
    private static final int EXTVERSION61 = 1;
    private static final int EXTVERSION92 = 2;
    private static final int VERSION_MASK = 255;
    private static final int HAS_ALLOW_DELAY_CLOSE = 256;
    private static final int EXTVERSION = 2;
    private long lastSequenceNumber;
    private boolean allowDelayClose;

    public BESessionCloseRequest(boolean bl, JMSID jMSID, long l) {
        super(jMSID, 13328);
        this.lastSequenceNumber = l;
        this.allowDelayClose = bl;
    }

    public final long getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    boolean allowDelayClose() {
        return this.allowDelayClose;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public BESessionCloseRequest() {
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n;
        if (objectOutput instanceof PeerInfoable && ((PeerInfoable)objectOutput).getPeerInfo().compareTo((Object)PeerInfo.VERSION_920) < 0) {
            n = 1;
        } else {
            n = 2;
            if (this.allowDelayClose) {
                n |= 0x100;
            }
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        objectOutput.writeLong(this.lastSequenceNumber);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 < 1 || 2 < n2) {
            throw JMSUtilities.versionIOException(n2, 1, 2);
        }
        super.readExternal(objectInput);
        this.lastSequenceNumber = objectInput.readLong();
        this.allowDelayClose = (0x100 & n) != 0;
    }
}

