/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jms.backend;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jms.common.JMSID;
import weblogic.jms.common.JMSUtilities;
import weblogic.jms.dispatcher.Request;
import weblogic.jms.dispatcher.VoidResponse;
import weblogic.messaging.dispatcher.DispatcherId;
import weblogic.messaging.dispatcher.Response;

public final class BESessionCreateRequest
extends Request
implements Externalizable {
    static final long serialVersionUID = 1492850028849803175L;
    private static final int EXTVERSION62 = 1;
    private static final int EXTVERSION70 = 2;
    private static final int EXTVERSION90 = 3;
    private static final int EXTVERSION = 3;
    private static final int VERSION_MASK = 255;
    private static final int TRANSACTED_MASK = 256;
    private static final int STOPPED_MASK = 1024;
    private static final int XA_SESSION_MASK = 2048;
    private static final int ACKNOWLEDGE_MODE_MASK = 0xFF00000;
    private static final int ACKNOWLEDGE_MODE_SHIFT = 20;
    private DispatcherId feDispatcherId;
    private JMSID connectionId;
    private JMSID sessionId;
    private JMSID sequencerId;
    private boolean transacted;
    private boolean xaSession;
    private int acknowledgeMode;
    private boolean isStopped;
    private long startStopSequenceNumber;
    private String connectionAddress = null;
    private transient String pushWorkManager;
    private byte clientVersion = 1;

    public BESessionCreateRequest(DispatcherId dispatcherId, JMSID jMSID, JMSID jMSID2, JMSID jMSID3, boolean bl, boolean bl2, int n, boolean bl3, long l, byte by, String string, String string2) {
        super(null, 13570);
        this.feDispatcherId = dispatcherId;
        this.connectionId = jMSID;
        this.sessionId = jMSID2;
        this.sequencerId = jMSID3;
        this.transacted = bl;
        this.xaSession = bl2;
        this.acknowledgeMode = n;
        this.isStopped = bl3;
        this.startStopSequenceNumber = l;
        this.clientVersion = by;
        this.connectionAddress = string;
        this.pushWorkManager = string2;
    }

    public final DispatcherId getFEDispatcherId() {
        return this.feDispatcherId;
    }

    public final JMSID getConnectionId() {
        return this.connectionId;
    }

    public final JMSID getSessionId() {
        return this.sessionId;
    }

    public final String getConnectionAddress() {
        return this.connectionAddress;
    }

    public final JMSID getSequencerId() {
        return this.sequencerId;
    }

    public final boolean getTransacted() {
        return this.transacted;
    }

    public final boolean getXASession() {
        return this.xaSession;
    }

    public final int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public final boolean getIsStopped() {
        return this.isStopped;
    }

    public final long getStartStopSequenceNumber() {
        return this.startStopSequenceNumber;
    }

    public String getPushWorkManager() {
        return this.pushWorkManager;
    }

    public final byte getClientVersion() {
        return this.clientVersion;
    }

    public int remoteSignature() {
        return 18;
    }

    public Response createResponse() {
        return VoidResponse.THE_ONE;
    }

    public BESessionCreateRequest() {
    }

    private byte getVersion(Object object) {
        PeerInfo peerInfo;
        if (object instanceof PeerInfoable && (peerInfo = ((PeerInfoable)object).getPeerInfo()).compareTo((Object)PeerInfo.VERSION_70) < 0) {
            return 1;
        }
        return 3;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        byte by = this.getVersion(objectOutput);
        int n = by | this.acknowledgeMode << 20;
        if (this.transacted) {
            n |= 0x100;
        }
        if (this.xaSession) {
            n |= 0x800;
        }
        if (this.isStopped) {
            n |= 0x400;
        }
        objectOutput.writeInt(n);
        super.writeExternal(objectOutput);
        this.feDispatcherId.writeExternal(objectOutput);
        this.connectionId.writeExternal(objectOutput);
        this.sessionId.writeExternal(objectOutput);
        this.sequencerId.writeExternal(objectOutput);
        objectOutput.writeLong(this.startStopSequenceNumber);
        if (by >= 2) {
            objectOutput.writeByte(this.clientVersion);
        }
        if (by >= 3) {
            objectOutput.writeUTF(this.connectionAddress);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        int n2 = n & 0xFF;
        if (n2 != 1 && n2 != 2 && n2 != 3) {
            throw JMSUtilities.versionIOException(n2, 1, 3);
        }
        super.readExternal(objectInput);
        this.feDispatcherId = new DispatcherId();
        this.feDispatcherId.readExternal(objectInput);
        this.connectionId = new JMSID();
        this.connectionId.readExternal(objectInput);
        this.sessionId = new JMSID();
        this.sessionId.readExternal(objectInput);
        this.sequencerId = new JMSID();
        this.sequencerId.readExternal(objectInput);
        this.startStopSequenceNumber = objectInput.readLong();
        if (n2 >= 2) {
            this.clientVersion = objectInput.readByte();
        }
        if (n2 >= 3) {
            this.connectionAddress = objectInput.readUTF();
        }
        this.acknowledgeMode = n >> 20;
        this.transacted = (n & 0x100) != 0;
        this.xaSession = (n & 0x800) != 0;
        this.isStopped = (n & 0x400) != 0;
    }
}

